/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.dmg.pmml.neural_network;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sparkproject.dmg.pmml.Extension;
import org.sparkproject.dmg.pmml.HasExtensions;
import org.sparkproject.dmg.pmml.PMMLObject;
import org.sparkproject.dmg.pmml.Version;
import org.sparkproject.dmg.pmml.Visitor;
import org.sparkproject.dmg.pmml.VisitorAction;
import org.sparkproject.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.sparkproject.dmg.pmml.adapters.RealNumberAdapter;
import org.sparkproject.dmg.pmml.neural_network.HasActivationFunction;
import org.sparkproject.dmg.pmml.neural_network.HasNormalizationMethod;
import org.sparkproject.dmg.pmml.neural_network.NeuralNetwork;
import org.sparkproject.dmg.pmml.neural_network.Neuron;
import org.sparkproject.dmg.pmml.neural_network.PMMLElements;
import org.sparkproject.jpmml.model.MissingElementException;
import org.sparkproject.jpmml.model.annotations.Added;
import org.sparkproject.jpmml.model.annotations.CollectionElementType;
import org.sparkproject.jpmml.model.annotations.CollectionSize;
import org.sparkproject.jpmml.model.annotations.Property;
import org.sparkproject.jpmml.model.annotations.Since;
import org.sparkproject.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="NeuralLayer", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "neurons"})
@JsonRootName(value="NeuralLayer")
@JsonPropertyOrder(value={"numberOfNeurons", "activationFunction", "threshold", "leakage", "width", "altitude", "normalizationMethod", "extensions", "neurons"})
public class NeuralLayer
extends PMMLObject
implements HasExtensions<NeuralLayer>,
HasActivationFunction<NeuralLayer>,
HasNormalizationMethod<NeuralLayer> {
    @XmlAttribute(name="numberOfNeurons")
    @XmlJavaTypeAdapter(value=NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name="nonNegativeInteger")
    @JsonProperty(value="numberOfNeurons")
    @CollectionSize(value="neurons")
    private Integer numberOfNeurons;
    @XmlAttribute(name="activationFunction")
    @JsonProperty(value="activationFunction")
    private NeuralNetwork.ActivationFunction activationFunction;
    @XmlAttribute(name="threshold")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="threshold")
    private Number threshold;
    @XmlAttribute(name="x-leakage")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="x-leakage")
    @Added(value=Version.XPMML)
    @Since(value="1.5.2")
    private Number leakage;
    @XmlAttribute(name="width")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="width")
    private Number width;
    @XmlAttribute(name="altitude")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="altitude")
    private Number altitude;
    @XmlAttribute(name="normalizationMethod")
    @JsonProperty(value="normalizationMethod")
    private NeuralNetwork.NormalizationMethod normalizationMethod;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    @XmlElement(name="Neuron", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="Neuron")
    @CollectionElementType(value=Neuron.class)
    private List<Neuron> neurons;
    private static final long serialVersionUID = 67371272L;

    public NeuralLayer() {
    }

    @ValueConstructor
    public NeuralLayer(@Property(value="neurons") List<Neuron> neurons) {
        this.neurons = neurons;
    }

    public Integer getNumberOfNeurons() {
        return this.numberOfNeurons;
    }

    public NeuralLayer setNumberOfNeurons(@Property(value="numberOfNeurons") Integer numberOfNeurons) {
        this.numberOfNeurons = numberOfNeurons;
        return this;
    }

    @Override
    public NeuralNetwork.ActivationFunction getActivationFunction() {
        return this.activationFunction;
    }

    @Override
    public NeuralLayer setActivationFunction(@Property(value="activationFunction") NeuralNetwork.ActivationFunction activationFunction) {
        this.activationFunction = activationFunction;
        return this;
    }

    @Override
    public Number getThreshold() {
        return this.threshold;
    }

    @Override
    public NeuralLayer setThreshold(@Property(value="threshold") Number threshold) {
        this.threshold = threshold;
        return this;
    }

    @Override
    public Number getLeakage() {
        return this.leakage;
    }

    @Override
    public NeuralLayer setLeakage(@Property(value="leakage") Number leakage) {
        this.leakage = leakage;
        return this;
    }

    @Override
    public Number getWidth() {
        return this.width;
    }

    @Override
    public NeuralLayer setWidth(@Property(value="width") Number width) {
        this.width = width;
        return this;
    }

    @Override
    public Number getAltitude() {
        return this.altitude;
    }

    @Override
    public NeuralLayer setAltitude(@Property(value="altitude") Number altitude) {
        this.altitude = altitude;
        return this;
    }

    @Override
    public NeuralNetwork.NormalizationMethod getNormalizationMethod() {
        return this.normalizationMethod;
    }

    @Override
    public NeuralLayer setNormalizationMethod(@Property(value="normalizationMethod") NeuralNetwork.NormalizationMethod normalizationMethod) {
        this.normalizationMethod = normalizationMethod;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public NeuralLayer addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasNeurons() {
        return this.neurons != null && !this.neurons.isEmpty();
    }

    public List<Neuron> requireNeurons() {
        if (this.neurons == null || this.neurons.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.NEURALLAYER_NEURONS);
        }
        return this.neurons;
    }

    public List<Neuron> getNeurons() {
        if (this.neurons == null) {
            this.neurons = new ArrayList<Neuron>();
        }
        return this.neurons;
    }

    public NeuralLayer addNeurons(Neuron ... neurons) {
        this.getNeurons().addAll(Arrays.asList(neurons));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasNeurons()) {
                status = PMMLObject.traverse(visitor, this.getNeurons());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

