/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.LBFGSB;
import breeze.optimize.LBFGSB$;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.ml.classification.LogisticRegression$;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.InstanceBlock;
import org.apache.spark.ml.feature.InstanceBlock$;
import org.apache.spark.ml.feature.StandardScalerModel$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseMatrix$;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.BinaryLogisticBlockAggregator;
import org.apache.spark.ml.optim.aggregator.MultinomialLogisticBlockAggregator;
import org.apache.spark.ml.optim.loss.L2Regularization;
import org.apache.spark.ml.optim.loss.RDDLossFunction;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasElasticNetParam;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasThreshold;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.stat.MultiClassSummarizer;
import org.apache.spark.ml.stat.Summarizer$;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\r%d\u0001\u0002\u0017.\u0001aB\u0001B\u0016\u0001\u0003\u0006\u0004%\te\u0016\u0005\t]\u0002\u0011\t\u0011)A\u00051\")\u0001\u000f\u0001C\u0001c\")\u0001\u000f\u0001C\u0001o\")\u0011\u0010\u0001C\u0001u\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!a\r\u0001\t\u0003\t)\u0004C\u0004\u0002@\u0001!\t!!\u0011\t\u000f\u0005-\u0003\u0001\"\u0011\u0002N!9\u00111\u000b\u0001\u0005B\u0005U\u0003bBA-\u0001\u0011\u0005\u00111\f\u0005\b\u0003K\u0002A\u0011IA4\u0011\u001d\t\u0019\b\u0001C!\u0003kBq!!\u001f\u0001\t\u0003\tY\bC\u0004\u0002\u0002\u0002!\t!a!\t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\"9\u00111\u0014\u0001\u0005\u0002\u0005u\u0005bBAR\u0001\u0011\u0005\u0011Q\u0015\u0005\b\u0003W\u0003A\u0011AAW\u0011\u001d\t9\f\u0001C\u0005\u0003sC\u0011\"!3\u0001\u0001\u0004%I!a3\t\u0013\u0005M\u0007\u00011A\u0005\n\u0005U\u0007\u0002CAn\u0001\u0001\u0006K!!4\t\u000f\u0005u\u0007\u0001\"\u0001\u0002`\"A\u00111\u001e\u0001\u0005\u0012E\ni\u000fC\u0004\u0003\u0018\u0001!IA!\u0007\t\u000f\t}\u0001\u0001\"\u0003\u0003\"!9!Q\b\u0001\u0005\n\t}\u0002b\u0002B(\u0001\u0011%!\u0011\u000b\u0005\b\u0005\u0003\u0003A\u0011\u0002BB\u0011\u001d\u0011\u0019\u000b\u0001C\u0005\u0005KC\u0001B!<\u0001\t\u0003\n$q\u001e\u0005\b\u0007\u0007\u0001A\u0011IB\u0003\u000f\u001d\u0019Y\"\fE\u0001\u0007;1a\u0001L\u0017\t\u0002\r}\u0001B\u00029'\t\u0003\u0019i\u0004C\u0004\u0004@\u0019\"\te!\u0011\t\u0015\r%cE1A\u0005\u00025\u001aY\u0005\u0003\u0005\u0004Z\u0019\u0002\u000b\u0011BB'\u0011%\u0019YFJA\u0001\n\u0013\u0019iF\u0001\nM_\u001eL7\u000f^5d%\u0016<'/Z:tS>t'B\u0001\u00180\u00039\u0019G.Y:tS\u001aL7-\u0019;j_:T!\u0001M\u0019\u0002\u00055d'B\u0001\u001a4\u0003\u0015\u0019\b/\u0019:l\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\u0004\u0001M)\u0001!O$K!B)!hO\u001fD\t6\tQ&\u0003\u0002=[\t9\u0002K]8cC\nLG.[:uS\u000e\u001cE.Y:tS\u001aLWM\u001d\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001>\na\u0001\\5oC2<\u0017B\u0001\"@\u0005\u00191Vm\u0019;peB\u0011!\b\u0001\t\u0003u\u0015K!AR\u0017\u0003/1{w-[:uS\u000e\u0014Vm\u001a:fgNLwN\\'pI\u0016d\u0007C\u0001\u001eI\u0013\tIUF\u0001\rM_\u001eL7\u000f^5d%\u0016<'/Z:tS>t\u0007+\u0019:b[N\u0004\"a\u0013(\u000e\u00031S!!T\u0018\u0002\tU$\u0018\u000e\\\u0005\u0003\u001f2\u0013Q\u0003R3gCVdG\u000fU1sC6\u001cxK]5uC\ndW\r\u0005\u0002R)6\t!K\u0003\u0002Tc\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002V%\n9Aj\\4hS:<\u0017aA;jIV\t\u0001\f\u0005\u0002ZE:\u0011!\f\u0019\t\u00037zk\u0011\u0001\u0018\u0006\u0003;^\na\u0001\u0010:p_Rt$\"A0\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005t\u0016A\u0002)sK\u0012,g-\u0003\u0002dI\n11\u000b\u001e:j]\u001eT!!\u00190)\u0007\u00051G\u000e\u0005\u0002hU6\t\u0001N\u0003\u0002jc\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005-D'!B*j]\u000e,\u0017%A7\u0002\u000bErCG\f\u0019\u0002\tULG\r\t\u0015\u0004\u0005\u0019d\u0017A\u0002\u001fj]&$h\b\u0006\u0002De\")ak\u0001a\u00011\"\u001a!O\u001a7)\u0007\r1W/I\u0001w\u0003\u0015\tdF\r\u00181)\u0005\u0019\u0005f\u0001\u0003gY\u0006Y1/\u001a;SK\u001e\u0004\u0016M]1n)\tYH0D\u0001\u0001\u0011\u0015iX\u00011\u0001\u007f\u0003\u00151\u0018\r\\;f!\ry\u0018\u0011A\u0007\u0002=&\u0019\u00111\u00010\u0003\r\u0011{WO\u00197fQ\r)a-^\u0001\u0013g\u0016$X\t\\1ti&\u001cg*\u001a;QCJ\fW\u000eF\u0002|\u0003\u0017AQ! \u0004A\u0002yD3A\u00024m\u0003)\u0019X\r^'bq&#XM\u001d\u000b\u0004w\u0006M\u0001BB?\b\u0001\u0004\t)\u0002E\u0002\u0000\u0003/I1!!\u0007_\u0005\rIe\u000e\u001e\u0015\u0004\u000f\u0019,\u0018AB:fiR{G\u000eF\u0002|\u0003CAQ! \u0005A\u0002yD3\u0001\u00034m\u0003=\u0019X\r\u001e$ji&sG/\u001a:dKB$HcA>\u0002*!1Q0\u0003a\u0001\u0003W\u00012a`A\u0017\u0013\r\tyC\u0018\u0002\b\u0005>|G.Z1oQ\rIa\r\\\u0001\ng\u0016$h)Y7jYf$2a_A\u001c\u0011\u0015i(\u00021\u0001YQ\u0011Qa-a\u000f\"\u0005\u0005u\u0012!\u0002\u001a/c9\u0002\u0014AE:fiN#\u0018M\u001c3be\u0012L'0\u0019;j_:$2a_A\"\u0011\u0019i8\u00021\u0001\u0002,!\"1BZA$C\t\tI%A\u00032]Ur\u0003'\u0001\u0007tKR$\u0006N]3tQ>dG\rF\u0002|\u0003\u001fBQ! \u0007A\u0002yDC\u0001\u00044\u0002H\u0005aq-\u001a;UQJ,7\u000f[8mIV\ta\u0010\u000b\u0003\u000eM\u0006\u001d\u0013\u0001D:fi^+\u0017n\u001a5u\u0007>dGcA>\u0002^!)QP\u0004a\u00011\"\"aBZA1C\t\t\u0019'A\u00032]Yr\u0003'A\u0007tKR$\u0006N]3tQ>dGm\u001d\u000b\u0004w\u0006%\u0004BB?\u0010\u0001\u0004\tY\u0007\u0005\u0003\u0000\u0003[r\u0018bAA8=\n)\u0011I\u001d:bs\"\"qBZA$\u000359W\r\u001e+ie\u0016\u001c\bn\u001c7egV\u0011\u00111\u000e\u0015\u0005!\u0019\f9%A\ntKR\fum\u001a:fO\u0006$\u0018n\u001c8EKB$\b\u000eF\u0002|\u0003{Ba!`\tA\u0002\u0005U\u0001\u0006B\tg\u0003w\tAd]3u\u0019><XM\u001d\"pk:$7o\u00148D_\u00164g-[2jK:$8\u000fF\u0002|\u0003\u000bCa! \nA\u0002\u0005\u001d\u0005c\u0001 \u0002\n&\u0019\u00111R \u0003\r5\u000bGO]5yQ\u0011\u0011b-a$\"\u0005\u0005E\u0015!\u0002\u001a/e9\u0002\u0014\u0001H:fiV\u0003\b/\u001a:C_VtGm](o\u0007>,gMZ5dS\u0016tGo\u001d\u000b\u0004w\u0006]\u0005BB?\u0014\u0001\u0004\t9\t\u000b\u0003\u0014M\u0006=\u0015AG:fi2{w/\u001a:C_VtGm](o\u0013:$XM]2faR\u001cHcA>\u0002 \")Q\u0010\u0006a\u0001{!\"ACZAH\u0003i\u0019X\r^+qa\u0016\u0014(i\\;oIN|e.\u00138uKJ\u001cW\r\u001d;t)\rY\u0018q\u0015\u0005\u0006{V\u0001\r!\u0010\u0015\u0005+\u0019\fy)A\ntKRl\u0015\r\u001f\"m_\u000e\\7+\u001b>f\u0013:l%\tF\u0002|\u0003_CQ! \fA\u0002yDCA\u00064\u00024\u0006\u0012\u0011QW\u0001\u0006g9\nd\u0006M\u0001.CN\u001cXM\u001d;C_VtGmQ8ogR\u0014\u0018-\u001b8fI>\u0003H/[7ju\u0006$\u0018n\u001c8QCJ\fWn\u001d,bY&$GCBA^\u0003\u0003\f)\rE\u0002\u0000\u0003{K1!a0_\u0005\u0011)f.\u001b;\t\u000f\u0005\rw\u00031\u0001\u0002\u0016\u0005\u0011b.^7D_\u00164g-[2jK:$8+\u001a;t\u0011\u001d\t9m\u0006a\u0001\u0003+\t1B\\;n\r\u0016\fG/\u001e:fg\u0006yq\u000e\u001d;J]&$\u0018.\u00197N_\u0012,G.\u0006\u0002\u0002NB!q0a4E\u0013\r\t\tN\u0018\u0002\u0007\u001fB$\u0018n\u001c8\u0002'=\u0004H/\u00138ji&\fG.T8eK2|F%Z9\u0015\t\u0005m\u0016q\u001b\u0005\n\u00033L\u0012\u0011!a\u0001\u0003\u001b\f1\u0001\u001f\u00132\u0003Ay\u0007\u000f^%oSRL\u0017\r\\'pI\u0016d\u0007%A\btKRLe.\u001b;jC2lu\u000eZ3m)\rY\u0018\u0011\u001d\u0005\u0007\u0003G\\\u0002\u0019\u0001#\u0002\u000b5|G-\u001a7)\tm1\u0017q]\u0011\u0003\u0003S\fQa\r\u00184]A\nQ\u0001\u001e:bS:$2\u0001RAx\u0011\u001d\t\t\u0010\ba\u0001\u0003g\fq\u0001Z1uCN,G\u000f\r\u0003\u0002v\n\u0015\u0001CBA|\u0003{\u0014\t!\u0004\u0002\u0002z*\u0019\u00111`\u0019\u0002\u0007M\fH.\u0003\u0003\u0002\u0000\u0006e(a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0005\u0007\u0011)\u0001\u0004\u0001\u0005\u0019\t\u001d\u0011q^A\u0001\u0002\u0003\u0015\tA!\u0003\u0003\u0007}#\u0013'\u0005\u0003\u0003\f\tE\u0001cA@\u0003\u000e%\u0019!q\u00020\u0003\u000f9{G\u000f[5oOB\u0019qPa\u0005\n\u0007\tUaLA\u0002B]f\f\u0001c\u00195fG.lU\u000f\u001c;j]>l\u0017.\u00197\u0015\t\u0005-\"1\u0004\u0005\b\u0005;i\u0002\u0019AA\u000b\u0003)qW/\\\"mCN\u001cXm]\u0001\fGJ,\u0017\r^3N_\u0012,G\u000eF\u0006E\u0005G\u0011yC!\r\u00036\te\u0002bBAy=\u0001\u0007!Q\u0005\u0019\u0005\u0005O\u0011Y\u0003\u0005\u0004\u0002x\u0006u(\u0011\u0006\t\u0005\u0005\u0007\u0011Y\u0003\u0002\u0007\u0003.\t\r\u0012\u0011!A\u0001\u0006\u0003\u0011IAA\u0002`IIBqA!\b\u001f\u0001\u0004\t)\u0002C\u0004\u00034y\u0001\r!a\"\u0002#\r|WM\u001a4jG&,g\u000e^'biJL\u0007\u0010\u0003\u0004\u00038y\u0001\r!P\u0001\u0010S:$XM]2faR4Vm\u0019;pe\"9!1\b\u0010A\u0002\u0005-\u0014\u0001E8cU\u0016\u001cG/\u001b<f\u0011&\u001cHo\u001c:z\u00031\u0019'/Z1uK\n{WO\u001c3t)!\u0011\tEa\u0012\u0003J\t-\u0003cB@\u0003D\u0005-\u00141N\u0005\u0004\u0005\u000br&A\u0002+va2,'\u0007C\u0004\u0003\u001e}\u0001\r!!\u0006\t\u000f\u0005\u001dw\u00041\u0001\u0002\u0016!9!QJ\u0010A\u0002\u0005-\u0014a\u00034fCR,(/Z:Ti\u0012\fqb\u0019:fCR,w\n\u001d;j[&TXM\u001d\u000b\r\u0005'\u0012\u0019H!\u001e\u0003x\te$Q\u0010\t\t\u0005+\u0012yFa\u0019\u0003n5\u0011!q\u000b\u0006\u0005\u00053\u0012Y&\u0001\u0005paRLW.\u001b>f\u0015\t\u0011i&\u0001\u0004ce\u0016,'0Z\u0005\u0005\u0005C\u00129FA\nGSJ\u001cHo\u0014:eKJl\u0015N\\5nSj,'\u000fE\u0003\u0003f\t%d0\u0004\u0002\u0003h)\u0019\u0001Ia\u0017\n\t\t-$q\r\u0002\f\t\u0016t7/\u001a,fGR|'\u000f\u0005\u0004\u0003V\t=$1M\u0005\u0005\u0005c\u00129F\u0001\u0007ES\u001a4g)\u001e8di&|g\u000eC\u0004\u0003\u001e\u0001\u0002\r!!\u0006\t\u000f\u0005\u001d\u0007\u00051\u0001\u0002\u0016!9!Q\n\u0011A\u0002\u0005-\u0004b\u0002B>A\u0001\u0007\u00111N\u0001\fY><XM\u001d\"pk:$7\u000fC\u0004\u0003\u0000\u0001\u0002\r!a\u001b\u0002\u0017U\u0004\b/\u001a:C_VtGm]\u0001\u0016GJ,\u0017\r^3J]&$\u0018.\u00197T_2,H/[8o)A\u0011)Ia#\u0003\u000e\n=%1\u0013BK\u0005/\u0013I\nE\u0002?\u0005\u000fK1A!#@\u0005-!UM\\:f\u001b\u0006$(/\u001b=\t\u000f\tu\u0011\u00051\u0001\u0002\u0016!9\u0011qY\u0011A\u0002\u0005U\u0001b\u0002BIC\u0001\u0007\u00111N\u0001\nQ&\u001cHo\\4sC6DqA!\u0014\"\u0001\u0004\tY\u0007C\u0004\u0003|\u0005\u0002\r!a\u001b\t\u000f\t}\u0014\u00051\u0001\u0002l!9!1T\u0011A\u0002\tu\u0015!B5ogR\u0014\bcA&\u0003 &\u0019!\u0011\u0015'\u0003\u001f%s7\u000f\u001e:v[\u0016tG/\u0019;j_:\f\u0011\u0002\u001e:bS:LU\u000e\u001d7\u0015%\t\u0005#q\u0015Bb\u0005\u000f\u0014IM!4\u0003P\nM'\u0011\u001e\u0005\b\u0005S\u0013\u0003\u0019\u0001BV\u0003%Ign\u001d;b]\u000e,7\u000f\u0005\u0004\u0003.\nM&qW\u0007\u0003\u0005_S1A!-2\u0003\r\u0011H\rZ\u0005\u0005\u0005k\u0013yKA\u0002S\t\u0012\u0003BA!/\u0003@6\u0011!1\u0018\u0006\u0004\u0005{{\u0013a\u00024fCR,(/Z\u0005\u0005\u0005\u0003\u0014YL\u0001\u0005J]N$\u0018M\\2f\u0011\u0019\u0011)M\ta\u0001}\u0006\u0019\u0012m\u0019;vC2\u0014En\\2l'&TX-\u00138N\u0005\"9!Q\n\u0012A\u0002\u0005-\u0004b\u0002BfE\u0001\u0007\u00111N\u0001\rM\u0016\fG/\u001e:fg6+\u0017M\u001c\u0005\b\u0005;\u0011\u0003\u0019AA\u000b\u0011\u001d\u0011\tN\ta\u0001\u0003W\nq\"\u001b8ji&\fGnU8mkRLwN\u001c\u0005\b\u0005+\u0014\u0003\u0019\u0001Bl\u00039\u0011XmZ;mCJL'0\u0019;j_:\u0004Ra`Ah\u00053\u0004BAa7\u0003f6\u0011!Q\u001c\u0006\u0005\u0005?\u0014\t/\u0001\u0003m_N\u001c(b\u0001Br_\u0005)q\u000e\u001d;j[&!!q\u001dBo\u0005Aa%GU3hk2\f'/\u001b>bi&|g\u000eC\u0004\u0003l\n\u0002\rAa\u0015\u0002\u0013=\u0004H/[7ju\u0016\u0014\u0018!E3ti&l\u0017\r^3N_\u0012,GnU5{KR!!\u0011\u001fB|!\ry(1_\u0005\u0004\u0005kt&\u0001\u0002'p]\u001eDq!!=$\u0001\u0004\u0011I\u0010\r\u0003\u0003|\n}\bCBA|\u0003{\u0014i\u0010\u0005\u0003\u0003\u0004\t}H\u0001DB\u0001\u0005o\f\t\u0011!A\u0003\u0002\t%!aA0%g\u0005!1m\u001c9z)\r\u00195q\u0001\u0005\b\u0007\u0013!\u0003\u0019AB\u0006\u0003\u0015)\u0007\u0010\u001e:b!\u0011\u0019iaa\u0005\u000e\u0005\r=!bAB\t_\u0005)\u0001/\u0019:b[&!1QCB\b\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\bf\u0001\u0013gY\"\u001a\u0001AZ;\u0002%1{w-[:uS\u000e\u0014Vm\u001a:fgNLwN\u001c\t\u0003u\u0019\u001arAJB\u0011\u0007O\u0019i\u0003E\u0002\u0000\u0007GI1a!\n_\u0005\u0019\te.\u001f*fMB!1j!\u000bD\u0013\r\u0019Y\u0003\u0014\u0002\u0016\t\u00164\u0017-\u001e7u!\u0006\u0014\u0018-\\:SK\u0006$\u0017M\u00197f!\u0011\u0019yc!\u000f\u000e\u0005\rE\"\u0002BB\u001a\u0007k\t!![8\u000b\u0005\r]\u0012\u0001\u00026bm\u0006LAaa\u000f\u00042\ta1+\u001a:jC2L'0\u00192mKR\u00111QD\u0001\u0005Y>\fG\rF\u0002D\u0007\u0007Baa!\u0012)\u0001\u0004A\u0016\u0001\u00029bi\"DC\u0001\u000b4\u0002b\u0005!2/\u001e9q_J$X\r\u001a$b[&d\u0017PT1nKN,\"a!\u0014\u0011\u000b}\figa\u0014\u0011\t\rE3qK\u0007\u0003\u0007'RAa!\u0016\u00046\u0005!A.\u00198h\u0013\r\u001971K\u0001\u0016gV\u0004\bo\u001c:uK\u00124\u0015-\\5ms:\u000bW.Z:!\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0019y\u0006\u0005\u0003\u0004R\r\u0005\u0014\u0002BB2\u0007'\u0012aa\u00142kK\u000e$\b\u0006\u0002\u0014g\u0003CBC!\n4\u0002b\u0001")
public class LogisticRegression
extends ProbabilisticClassifier<Vector, LogisticRegression, LogisticRegressionModel>
implements LogisticRegressionParams,
DefaultParamsWritable {
    private final String uid;
    private Option<LogisticRegressionModel> optInitialModel;
    private Param<String> family;
    private Param<Matrix> lowerBoundsOnCoefficients;
    private Param<Matrix> upperBoundsOnCoefficients;
    private Param<Vector> lowerBoundsOnIntercepts;
    private Param<Vector> upperBoundsOnIntercepts;
    private DoubleParam maxBlockSizeInMB;
    private IntParam aggregationDepth;
    private DoubleParam threshold;
    private Param<String> weightCol;
    private BooleanParam standardization;
    private DoubleParam tol;
    private BooleanParam fitIntercept;
    private IntParam maxIter;
    private DoubleParam elasticNetParam;
    private DoubleParam regParam;

    public static LogisticRegression load(String path) {
        return LogisticRegression$.MODULE$.load(path);
    }

    public static MLReader<LogisticRegression> read() {
        return LogisticRegression$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$classification$LogisticRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public String getFamily() {
        return LogisticRegressionParams.getFamily$(this);
    }

    @Override
    public void checkThresholdConsistency() {
        LogisticRegressionParams.checkThresholdConsistency$(this);
    }

    @Override
    public Matrix getLowerBoundsOnCoefficients() {
        return LogisticRegressionParams.getLowerBoundsOnCoefficients$(this);
    }

    @Override
    public Matrix getUpperBoundsOnCoefficients() {
        return LogisticRegressionParams.getUpperBoundsOnCoefficients$(this);
    }

    @Override
    public Vector getLowerBoundsOnIntercepts() {
        return LogisticRegressionParams.getLowerBoundsOnIntercepts$(this);
    }

    @Override
    public Vector getUpperBoundsOnIntercepts() {
        return LogisticRegressionParams.getUpperBoundsOnIntercepts$(this);
    }

    @Override
    public boolean usingBoundConstrainedOptimization() {
        return LogisticRegressionParams.usingBoundConstrainedOptimization$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LogisticRegressionParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam.getElasticNetParam$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final Param<String> family() {
        return this.family;
    }

    @Override
    public Param<Matrix> lowerBoundsOnCoefficients() {
        return this.lowerBoundsOnCoefficients;
    }

    @Override
    public Param<Matrix> upperBoundsOnCoefficients() {
        return this.upperBoundsOnCoefficients;
    }

    @Override
    public Param<Vector> lowerBoundsOnIntercepts() {
        return this.lowerBoundsOnIntercepts;
    }

    @Override
    public Param<Vector> upperBoundsOnIntercepts() {
        return this.upperBoundsOnIntercepts;
    }

    @Override
    public final void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$family_$eq(Param<String> x$1) {
        this.family = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.lowerBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.upperBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.lowerBoundsOnIntercepts = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.upperBoundsOnIntercepts = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public LogisticRegression setRegParam(double value) {
        return (LogisticRegression)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setElasticNetParam(double value) {
        return (LogisticRegression)this.set(this.elasticNetParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setMaxIter(int value) {
        return (LogisticRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LogisticRegression setTol(double value) {
        return (LogisticRegression)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setFitIntercept(boolean value) {
        return (LogisticRegression)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LogisticRegression setFamily(String value) {
        return (LogisticRegression)this.set(this.family(), value);
    }

    public LogisticRegression setStandardization(boolean value) {
        return (LogisticRegression)this.set(this.standardization(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    @Override
    public LogisticRegression setThreshold(double value) {
        return (LogisticRegression)LogisticRegressionParams.setThreshold$(this, value);
    }

    @Override
    public double getThreshold() {
        return LogisticRegressionParams.getThreshold$(this);
    }

    public LogisticRegression setWeightCol(String value) {
        return (LogisticRegression)this.set(this.weightCol(), value);
    }

    @Override
    public LogisticRegression setThresholds(double[] value) {
        return (LogisticRegression)LogisticRegressionParams.setThresholds$(this, value);
    }

    @Override
    public double[] getThresholds() {
        return LogisticRegressionParams.getThresholds$(this);
    }

    public LogisticRegression setAggregationDepth(int value) {
        return (LogisticRegression)this.set(this.aggregationDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    public LogisticRegression setLowerBoundsOnCoefficients(Matrix value) {
        return (LogisticRegression)this.set(this.lowerBoundsOnCoefficients(), value);
    }

    public LogisticRegression setUpperBoundsOnCoefficients(Matrix value) {
        return (LogisticRegression)this.set(this.upperBoundsOnCoefficients(), value);
    }

    public LogisticRegression setLowerBoundsOnIntercepts(Vector value) {
        return (LogisticRegression)this.set(this.lowerBoundsOnIntercepts(), value);
    }

    public LogisticRegression setUpperBoundsOnIntercepts(Vector value) {
        return (LogisticRegression)this.set(this.upperBoundsOnIntercepts(), value);
    }

    public LogisticRegression setMaxBlockSizeInMB(double value) {
        return (LogisticRegression)this.set(this.maxBlockSizeInMB(), BoxesRunTime.boxToDouble((double)value));
    }

    private void assertBoundConstrainedOptimizationParamsValid(int numCoefficientSets, int numFeatures) {
        if (this.isSet(this.lowerBoundsOnCoefficients())) {
            Predef$.MODULE$.require(this.$(this.lowerBoundsOnCoefficients()).numRows() == numCoefficientSets && this.$(this.lowerBoundsOnCoefficients()).numCols() == numFeatures, (Function0 & Serializable)() -> "The shape of LowerBoundsOnCoefficients must be compatible with (1, number of features) for binomial regression, or (number of classes, number of features) for multinomial regression, but found: (" + this.getLowerBoundsOnCoefficients().numRows() + ", " + this.getLowerBoundsOnCoefficients().numCols() + ").");
        }
        if (this.isSet(this.upperBoundsOnCoefficients())) {
            Predef$.MODULE$.require(this.$(this.upperBoundsOnCoefficients()).numRows() == numCoefficientSets && this.$(this.upperBoundsOnCoefficients()).numCols() == numFeatures, (Function0 & Serializable)() -> "The shape of upperBoundsOnCoefficients must be compatible with (1, number of features) for binomial regression, or (number of classes, number of features) for multinomial regression, but found: (" + this.getUpperBoundsOnCoefficients().numRows() + ", " + this.getUpperBoundsOnCoefficients().numCols() + ").");
        }
        if (this.isSet(this.lowerBoundsOnIntercepts())) {
            Predef$.MODULE$.require(this.$(this.lowerBoundsOnIntercepts()).size() == numCoefficientSets, (Function0 & Serializable)() -> "The size of lowerBoundsOnIntercepts must be equal to 1 for binomial regression, or the number of classes for multinomial regression, but found: " + this.getLowerBoundsOnIntercepts().size() + ".");
        }
        if (this.isSet(this.upperBoundsOnIntercepts())) {
            Predef$.MODULE$.require(this.$(this.upperBoundsOnIntercepts()).size() == numCoefficientSets, (Function0 & Serializable)() -> "The size of upperBoundsOnIntercepts must be equal to 1 for binomial regression, or the number of classes for multinomial regression, but found: " + this.getUpperBoundsOnIntercepts().size() + ".");
        }
        if (this.isSet(this.lowerBoundsOnCoefficients()) && this.isSet(this.upperBoundsOnCoefficients())) {
            Predef$.MODULE$.require(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.doubleArrayOps(this.$(this.lowerBoundsOnCoefficients()).toArray()), (IterableOnce)Predef$.MODULE$.wrapDoubleArray(this.$(this.upperBoundsOnCoefficients()).toArray()))), (Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)LogisticRegression.$anonfun$assertBoundConstrainedOptimizationParamsValid$5(x))), (Function0 & Serializable)() -> "LowerBoundsOnCoefficients should always be less than or equal to upperBoundsOnCoefficients, but found: lowerBoundsOnCoefficients = " + this.getLowerBoundsOnCoefficients() + ", upperBoundsOnCoefficients = " + this.getUpperBoundsOnCoefficients() + ".");
        }
        if (this.isSet(this.lowerBoundsOnIntercepts()) && this.isSet(this.upperBoundsOnIntercepts())) {
            Predef$.MODULE$.require(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.doubleArrayOps(this.$(this.lowerBoundsOnIntercepts()).toArray()), (IterableOnce)Predef$.MODULE$.wrapDoubleArray(this.$(this.upperBoundsOnIntercepts()).toArray()))), (Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)LogisticRegression.$anonfun$assertBoundConstrainedOptimizationParamsValid$7(x))), (Function0 & Serializable)() -> "LowerBoundsOnIntercepts should always be less than or equal to upperBoundsOnIntercepts, but found: lowerBoundsOnIntercepts = " + this.getLowerBoundsOnIntercepts() + ", upperBoundsOnIntercepts = " + this.getUpperBoundsOnIntercepts() + ".");
            return;
        }
    }

    private Option<LogisticRegressionModel> optInitialModel() {
        return this.optInitialModel;
    }

    private void optInitialModel_$eq(Option<LogisticRegressionModel> x$1) {
        this.optInitialModel = x$1;
    }

    public LogisticRegression setInitialModel(LogisticRegressionModel model) {
        this.optInitialModel_$eq((Option<LogisticRegressionModel>)new Some((Object)model));
        return this;
    }

    @Override
    public LogisticRegressionModel train(Dataset<?> dataset) {
        LogisticRegressionModel logisticRegressionModel;
        Object object = new Object();
        try {
            logisticRegressionModel = (LogisticRegressionModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable)instr -> {
                None$ none$;
                double regParamL2;
                boolean isConstantLabel;
                boolean isMultinomial;
                int numCoefficientSets;
                int numClasses;
                RDD instances;
                Tuple2<SummarizerBuffer, MultiClassSummarizer> tuple2;
                instr.logPipelineStage(this);
                instr.logDataset(dataset);
                instr.logParams(this, (Seq<Param<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Param[]{this.labelCol(), this.weightCol(), this.featuresCol(), this.predictionCol(), this.rawPredictionCol(), this.probabilityCol(), this.regParam(), this.elasticNetParam(), this.standardization(), this.threshold(), this.thresholds(), this.maxIter(), this.tol(), this.fitIntercept(), this.maxBlockSizeInMB()}));
                StorageLevel storageLevel = dataset.storageLevel();
                StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
                if (storageLevel == null ? storageLevel2 != null : !storageLevel.equals(storageLevel2)) {
                    instr.logWarning((Function0<String>)(Function0 & Serializable)() -> "Input instances will be standardized, blockified to blocks, and then cached during training. Be careful of double caching!");
                }
                if ((tuple2 = Summarizer$.MODULE$.getClassificationSummarizers((RDD<Instance>)(instances = dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.checkClassificationLabels(this.$(this.labelCol()), (Option<Object>)None$.MODULE$), DatasetUtils$.MODULE$.checkNonNegativeWeights(this.get(this.weightCol())), DatasetUtils$.MODULE$.checkNonNanVectors(this.$(this.featuresCol()))})).rdd().map((Function1 & Serializable)x0$1 -> {
                    Some some;
                    Row row = x0$1;
                    if (row != null && !(some = Row$.MODULE$.unapplySeq(row)).isEmpty() && some.get() != null && ((SeqOps)some.get()).lengthCompare(3) == 0) {
                        Object l = ((SeqOps)some.get()).apply(0);
                        Object w = ((SeqOps)some.get()).apply(1);
                        Object v = ((SeqOps)some.get()).apply(2);
                        if (l instanceof Double) {
                            double d = BoxesRunTime.unboxToDouble((Object)l);
                            if (w instanceof Double) {
                                double d2 = BoxesRunTime.unboxToDouble((Object)w);
                                if (v instanceof Vector) {
                                    Vector vector = (Vector)v;
                                    return new Instance(d, d2, vector);
                                }
                            }
                        }
                    }
                    throw new MatchError((Object)row);
                }, ClassTag$.MODULE$.apply(Instance.class)).setName("training instances")), BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), (Seq<String>)new .colon.colon((Object)"mean", (List)new .colon.colon((Object)"std", (List)new .colon.colon((Object)"count", (List)Nil$.MODULE$))))) == null) {
                    throw new MatchError(tuple2);
                }
                SummarizerBuffer summarizer = (SummarizerBuffer)tuple2._1();
                MultiClassSummarizer labelSummarizer = (MultiClassSummarizer)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)summarizer, (Object)labelSummarizer);
                SummarizerBuffer summarizer2 = (SummarizerBuffer)tuple22._1();
                MultiClassSummarizer labelSummarizer2 = (MultiClassSummarizer)tuple22._2();
                int numFeatures = summarizer2.mean().size();
                double[] histogram = labelSummarizer2.histogram();
                long numInvalid = labelSummarizer2.countInvalid();
                int numFeaturesPlusIntercept = this.getFitIntercept() ? numFeatures + 1 : numFeatures;
                Option<Object> option = MetadataUtils$.MODULE$.getNumClasses(dataset.schema().apply(this.$(this.labelCol())));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    int n = BoxesRunTime.unboxToInt((Object)some.value());
                    int n2 = n;
                    Predef$.MODULE$.require(n2 >= histogram.length, (Function0 & Serializable)() -> "Specified number of classes " + n2 + " was less than the number of unique labels " + histogram.length + ".");
                    v1 = n2;
                } else {
                    if (!None$.MODULE$.equals(option)) {
                        throw new MatchError(option);
                    }
                    v1 = numClasses = histogram.length;
                }
                if (numInvalid != 0L) {
                    MessageWithContext msg = this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Classification labels should be in "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ". "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.RANGE$.MODULE$, (Object)("[0 to " + (numClasses - 1) + "]"))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " invalid labels."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.COUNT$.MODULE$, (Object)BoxesRunTime.boxToLong((long)numInvalid))})));
                    instr.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> msg));
                    throw new SparkException(msg.message());
                }
                instr.logNumClasses(numClasses);
                instr.logNumFeatures(numFeatures);
                instr.logNumExamples(summarizer2.count());
                instr.logNamedValue("lowestLabelWeight", Predef$.MODULE$.wrapDoubleArray(labelSummarizer2.histogram()).min((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$).toString());
                instr.logNamedValue("highestLabelWeight", Predef$.MODULE$.wrapDoubleArray(labelSummarizer2.histogram()).max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$).toString());
                instr.logSumOfWeights(summarizer2.weightSum());
                double actualBlockSizeInMB = BoxesRunTime.unboxToDouble((Object)this.$(this.maxBlockSizeInMB()));
                if (actualBlockSizeInMB == 0.0) {
                    actualBlockSizeInMB = InstanceBlock$.MODULE$.DefaultBlockSizeInMB();
                    Predef$.MODULE$.require(actualBlockSizeInMB > 0.0, (Function0 & Serializable)() -> "inferred actual BlockSizeInMB must > 0");
                    instr.logNamedValue("actualBlockSizeInMB", Double.toString(actualBlockSizeInMB));
                }
                int n = numCoefficientSets = (isMultinomial = this.checkMultinomial(numClasses)) ? numClasses : 1;
                if (this.usingBoundConstrainedOptimization()) {
                    this.assertBoundConstrainedOptimizationParamsValid(numCoefficientSets, numFeatures);
                }
                if (this.isDefined(this.thresholds())) {
                    Predef$.MODULE$.require(this.$(this.thresholds()).length == numClasses, (Function0 & Serializable)() -> this.getClass().getSimpleName() + ".train() called with non-matching numClasses and thresholds.length. numClasses=" + numClasses + ", but thresholds has length " + this.$(this.thresholds()).length);
                }
                boolean bl = isConstantLabel = ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.doubleArrayOps(histogram), (Function1)(JFunction1.mcZD.sp & Serializable)x$2 -> x$2 != 0.0) == 1;
                if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isConstantLabel && !this.usingBoundConstrainedOptimization()) {
                    instr.logWarning((Function0<String>)(Function0 & Serializable)() -> "All labels are the same value and fitIntercept=true, so the coefficients will be zeros. Training is not needed.");
                    int constantLabelIndex = Vectors$.MODULE$.dense(histogram).argmax();
                    Matrix coefMatrix = new SparseMatrix(numCoefficientSets, numFeatures, new int[numCoefficientSets + 1], Array$.MODULE$.emptyIntArray(), Array$.MODULE$.emptyDoubleArray(), true).compressed();
                    Vector interceptVec = isMultinomial ? Vectors$.MODULE$.sparse(numClasses, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(constantLabelIndex, Double.POSITIVE_INFINITY), (List)Nil$.MODULE$)) : Vectors$.MODULE$.dense(numClasses == 2 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY, (Seq)Nil$.MODULE$);
                    throw new NonLocalReturnControl(object, (Object)this.createModel(dataset, numClasses, coefMatrix, interceptVec, new double[]{0.0}));
                }
                if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isConstantLabel) {
                    instr.logWarning((Function0<String>)(Function0 & Serializable)() -> "All labels belong to a single class and fitIntercept=false. It's a dangerous ground, so the algorithm may not converge.");
                }
                double[] featuresMean = summarizer2.mean().toArray();
                double[] featuresStd = summarizer2.std().toArray();
                if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numFeatures).exists((Function1)(JFunction1.mcZI.sp & Serializable)i -> featuresStd[i] == 0.0 && featuresMean[i] != 0.0)) {
                    instr.logWarning((Function0<String>)(Function0 & Serializable)() -> "Fitting LogisticRegressionModel without intercept on dataset with constant nonzero column, Spark MLlib outputs zero coefficients for constant nonzero columns. This behavior is the same as R glmnet but different from LIBSVM.");
                }
                if ((regParamL2 = (1.0 - BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam()))) * BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()))) != 0.0) {
                    JFunction1.mcDI.sp & Serializable getFeaturesStd = (JFunction1.mcDI.sp & Serializable)j -> {
                        if (j >= 0 && j < numCoefficientSets * numFeatures) {
                            return featuresStd[j / numCoefficientSets];
                        }
                        return 0.0;
                    };
                    JFunction1.mcZI.sp & Serializable shouldApply = (JFunction1.mcZI.sp & Serializable)idx -> idx >= 0 && idx < numFeatures * numCoefficientSets;
                    none$ = new Some((Object)new L2Regularization(regParamL2, (Function1<Object, Object>)shouldApply, (Option<Function1<Object, Object>>)(BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())) ? None$.MODULE$ : new Some((Object)getFeaturesStd))));
                } else {
                    none$ = None$.MODULE$;
                }
                None$ regularization = none$;
                Tuple2<double[], double[]> tuple23 = this.createBounds(numClasses, numFeatures, featuresStd);
                if (tuple23 == null) {
                    throw new MatchError(tuple23);
                }
                double[] lowerBounds = (double[])tuple23._1();
                double[] upperBounds = (double[])tuple23._2();
                Tuple2 tuple24 = new Tuple2((Object)lowerBounds, (Object)upperBounds);
                double[] lowerBounds2 = (double[])tuple24._1();
                double[] upperBounds2 = (double[])tuple24._2();
                FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> optimizer = this.createOptimizer(numClasses, numFeatures, featuresStd, lowerBounds2, upperBounds2);
                DenseMatrix initialSolution = this.createInitialSolution(numClasses, numFeatures, histogram, featuresStd, lowerBounds2, upperBounds2, (Instrumentation)instr);
                Tuple2<double[], double[]> tuple25 = this.trainImpl((RDD<Instance>)instances, actualBlockSizeInMB, featuresStd, featuresMean, numClasses, initialSolution.toArray(), (Option<L2Regularization>)regularization, optimizer);
                if (tuple25 == null) {
                    throw new MatchError(tuple25);
                }
                double[] allCoefficients = (double[])tuple25._1();
                double[] objectiveHistory = (double[])tuple25._2();
                Tuple2 tuple26 = new Tuple2((Object)allCoefficients, (Object)objectiveHistory);
                double[] allCoefficients2 = (double[])tuple26._1();
                double[] objectiveHistory2 = (double[])tuple26._2();
                if (allCoefficients2 == null) {
                    MLUtils$.MODULE$.optimizerFailed((Instrumentation)instr, optimizer.getClass());
                }
                DenseMatrix allCoefMatrix = new DenseMatrix(numCoefficientSets, numFeaturesPlusIntercept, allCoefficients2);
                DenseMatrix denseCoefficientMatrix = new DenseMatrix(numCoefficientSets, numFeatures, new double[numCoefficientSets * numFeatures], true);
                Vector interceptVec = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) || !isMultinomial ? Vectors$.MODULE$.zeros(numCoefficientSets) : Vectors$.MODULE$.sparse(numCoefficientSets, (Seq)scala.package$.MODULE$.Seq().empty());
                allCoefMatrix.foreachActive((Function3 & Serializable)(classIndex, featureIndex, value) -> {
                    LogisticRegression.$anonfun$train$15(this, numFeatures, featuresStd, denseCoefficientMatrix, interceptVec, BoxesRunTime.unboxToInt((Object)classIndex), BoxesRunTime.unboxToInt((Object)featureIndex), BoxesRunTime.unboxToDouble((Object)value));
                    return BoxedUnit.UNIT;
                });
                if (BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) == 0.0 && isMultinomial && !this.usingBoundConstrainedOptimization()) {
                    double[] centers = (double[])Array$.MODULE$.ofDim(numFeatures, (ClassTag)ClassTag$.MODULE$.Double());
                    denseCoefficientMatrix.foreachActive((Function3 & Serializable)(x0$2, x1$1, x2$1) -> {
                        LogisticRegression.$anonfun$train$16(centers, BoxesRunTime.unboxToInt((Object)x0$2), BoxesRunTime.unboxToInt((Object)x1$1), BoxesRunTime.unboxToDouble((Object)x2$1));
                        return BoxedUnit.UNIT;
                    });
                    ArrayOps$.MODULE$.mapInPlace$extension(Predef$.MODULE$.doubleArrayOps(centers), (Function1)(JFunction1.mcDD.sp & Serializable)x$5 -> x$5 / (double)numCoefficientSets);
                    denseCoefficientMatrix.foreachActive((Function3 & Serializable)(x0$3, x1$2, x2$2) -> {
                        LogisticRegression.$anonfun$train$18(denseCoefficientMatrix, centers, BoxesRunTime.unboxToInt((Object)x0$3), BoxesRunTime.unboxToInt((Object)x1$2), BoxesRunTime.unboxToDouble((Object)x2$2));
                        return BoxedUnit.UNIT;
                    });
                }
                if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isMultinomial && !this.usingBoundConstrainedOptimization()) {
                    double[] interceptArray = interceptVec.toArray();
                    double interceptMean = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(interceptArray).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)interceptArray.length;
                    RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), interceptVec.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                        interceptArray$1[i] = interceptArray[i] - interceptMean;
                    });
                }
                throw new NonLocalReturnControl(object, (Object)this.createModel(dataset, numClasses, denseCoefficientMatrix.compressed(), interceptVec.compressed(), objectiveHistory2));
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                logisticRegressionModel = (LogisticRegressionModel)ex.value();
            }
            throw ex;
        }
        return logisticRegressionModel;
    }

    private boolean checkMultinomial(int numClasses) {
        String string = this.$(this.family()).toLowerCase(Locale.ROOT);
        switch (string == null ? 0 : string.hashCode()) {
            case 3005871: {
                if (!"auto".equals(string)) break;
                return numClasses > 2;
            }
            case 508210817: {
                if (!"multinomial".equals(string)) break;
                return true;
            }
            case 950395663: {
                if (!"binomial".equals(string)) break;
                Predef$.MODULE$.require(numClasses == 1 || numClasses == 2, (Function0 & Serializable)() -> "Binomial family only supports 1 or 2 outcome classes but found " + numClasses + ".");
                return false;
            }
        }
        throw new IllegalArgumentException("Unsupported family: " + string);
    }

    private LogisticRegressionModel createModel(Dataset<?> dataset, int numClasses, Matrix coefficientMatrix, Vector interceptVector, double[] objectiveHistory) {
        LogisticRegressionModel model = this.copyValues(new LogisticRegressionModel(this.uid(), coefficientMatrix, interceptVector, numClasses, this.checkMultinomial(numClasses)), this.copyValues$default$2());
        model.createSummary(dataset, objectiveHistory);
        return model;
    }

    private Tuple2<double[], double[]> createBounds(int numClasses, int numFeatures, double[] featuresStd) {
        boolean isMultinomial = this.checkMultinomial(numClasses);
        int numFeaturesPlusIntercept = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? numFeatures + 1 : numFeatures;
        int numCoefficientSets = isMultinomial ? numClasses : 1;
        int numCoeffsPlusIntercepts = numFeaturesPlusIntercept * numCoefficientSets;
        if (this.usingBoundConstrainedOptimization()) {
            double[] lowerBounds = (double[])Array$.MODULE$.fill(numCoeffsPlusIntercepts, (Function0)(JFunction0.mcD.sp & Serializable)() -> Double.NEGATIVE_INFINITY, (ClassTag)ClassTag$.MODULE$.Double());
            double[] upperBounds = (double[])Array$.MODULE$.fill(numCoeffsPlusIntercepts, (Function0)(JFunction0.mcD.sp & Serializable)() -> Double.POSITIVE_INFINITY, (ClassTag)ClassTag$.MODULE$.Double());
            boolean isSetLowerBoundsOnCoefficients = this.isSet(this.lowerBoundsOnCoefficients());
            boolean isSetUpperBoundsOnCoefficients = this.isSet(this.upperBoundsOnCoefficients());
            boolean isSetLowerBoundsOnIntercepts = this.isSet(this.lowerBoundsOnIntercepts());
            boolean isSetUpperBoundsOnIntercepts = this.isSet(this.upperBoundsOnIntercepts());
            for (int i = 0; i < numCoeffsPlusIntercepts; ++i) {
                int coefficientSetIndex = i % numCoefficientSets;
                int featureIndex = i / numCoefficientSets;
                if (featureIndex < numFeatures) {
                    if (isSetLowerBoundsOnCoefficients) {
                        lowerBounds[i] = this.$(this.lowerBoundsOnCoefficients()).apply(coefficientSetIndex, featureIndex) * featuresStd[featureIndex];
                    }
                    if (!isSetUpperBoundsOnCoefficients) continue;
                    upperBounds[i] = this.$(this.upperBoundsOnCoefficients()).apply(coefficientSetIndex, featureIndex) * featuresStd[featureIndex];
                    continue;
                }
                if (isSetLowerBoundsOnIntercepts) {
                    lowerBounds[i] = this.$(this.lowerBoundsOnIntercepts()).apply(coefficientSetIndex);
                }
                if (!isSetUpperBoundsOnIntercepts) continue;
                upperBounds[i] = this.$(this.upperBoundsOnIntercepts()).apply(coefficientSetIndex);
            }
            return new Tuple2((Object)lowerBounds, (Object)upperBounds);
        }
        return new Tuple2(null, null);
    }

    private FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> createOptimizer(int numClasses, int numFeatures, double[] featuresStd, double[] lowerBounds, double[] upperBounds) {
        int numCoefficientSets;
        boolean isMultinomial = this.checkMultinomial(numClasses);
        double regParamL1 = BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) * BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
        int n = numCoefficientSets = isMultinomial ? numClasses : 1;
        if (BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) == 0.0 || BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) == 0.0) {
            if (lowerBounds != null && upperBounds != null) {
                return new LBFGSB(DenseVector$.MODULE$.apply((Object)lowerBounds), DenseVector$.MODULE$.apply((Object)upperBounds), BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), LBFGSB$.MODULE$.$lessinit$greater$default$6(), LBFGSB$.MODULE$.$lessinit$greater$default$7());
            }
            return new LBFGS(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableInnerProductModule)DenseVector$.MODULE$.space_Double());
        }
        boolean standardizationParam = BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization()));
        return new OWLQN(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, this.regParamL1Fun$1(numFeatures, numCoefficientSets, standardizationParam, regParamL1, featuresStd), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space_Double());
    }

    private DenseMatrix createInitialSolution(int numClasses, int numFeatures, double[] histogram, double[] featuresStd, double[] lowerBounds, double[] upperBounds, Instrumentation instr) {
        boolean bl;
        boolean isMultinomial = this.checkMultinomial(numClasses);
        int numFeaturesPlusIntercept = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? numFeatures + 1 : numFeatures;
        int numCoefficientSets = isMultinomial ? numClasses : 1;
        int numCoeffsPlusIntercepts = numFeaturesPlusIntercept * numCoefficientSets;
        DenseMatrix initialCoefWithInterceptMatrix = DenseMatrix$.MODULE$.zeros(numCoefficientSets, numFeaturesPlusIntercept);
        Option<LogisticRegressionModel> option = this.optInitialModel();
        if (option instanceof Some) {
            boolean modelIsValid;
            Some some = (Some)option;
            LogisticRegressionModel _initialModel = (LogisticRegressionModel)some.value();
            Matrix providedCoefs = _initialModel.coefficientMatrix();
            boolean bl2 = modelIsValid = providedCoefs.numRows() == numCoefficientSets && providedCoefs.numCols() == numFeatures && _initialModel.interceptVector().size() == numCoefficientSets && _initialModel.getFitIntercept() == BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()));
            if (!modelIsValid) {
                instr.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Initial coefficients will be ignored! Its dimensions "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(", "}, "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_ROWS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)providedCoefs.numRows()))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ") did not match the "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_COLUMNS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)providedCoefs.numCols()))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"expected size (", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_COEFFICIENTS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)numCoefficientSets))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ")"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_FEATURES$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)numFeatures))})))));
            }
            bl = modelIsValid;
        } else if (None$.MODULE$.equals(option)) {
            bl = false;
        } else {
            throw new MatchError(option);
        }
        boolean initialModelIsValid = bl;
        if (initialModelIsValid) {
            Matrix providedCoef = ((LogisticRegressionModel)this.optInitialModel().get()).coefficientMatrix();
            providedCoef.foreachActive((Function3 & Serializable)(classIndex, featureIndex, value) -> {
                initialCoefWithInterceptMatrix.update(BoxesRunTime.unboxToInt((Object)classIndex), BoxesRunTime.unboxToInt((Object)featureIndex), BoxesRunTime.unboxToDouble((Object)value) * featuresStd[BoxesRunTime.unboxToInt((Object)featureIndex)]);
                return BoxedUnit.UNIT;
            });
            if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
                ((LogisticRegressionModel)this.optInitialModel().get()).interceptVector().foreachNonZero((Function2)(JFunction2.mcVID.sp & Serializable)(classIndex, value) -> initialCoefWithInterceptMatrix.update(classIndex, numFeatures, value));
            }
        } else if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isMultinomial) {
            double[] rawIntercepts = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(histogram), (Function1)(JFunction1.mcDD.sp & Serializable)x -> package$.MODULE$.log1p(x), (ClassTag)ClassTag$.MODULE$.Double());
            double rawMean = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(rawIntercepts).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)rawIntercepts.length;
            ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.doubleArrayOps(rawIntercepts)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> initialCoefWithInterceptMatrix.update(i, numFeatures, rawIntercepts[i] - rawMean));
        } else if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
            initialCoefWithInterceptMatrix.update(0, numFeatures, package$.MODULE$.log(histogram[1] / histogram[0]));
        }
        if (this.usingBoundConstrainedOptimization()) {
            for (int i2 = 0; i2 < numCoeffsPlusIntercepts; ++i2) {
                int coefficientSetIndex = i2 % numCoefficientSets;
                int featureIndex2 = i2 / numCoefficientSets;
                if (initialCoefWithInterceptMatrix.apply(coefficientSetIndex, featureIndex2) < lowerBounds[i2]) {
                    initialCoefWithInterceptMatrix.update(coefficientSetIndex, featureIndex2, lowerBounds[i2]);
                    continue;
                }
                if (!(initialCoefWithInterceptMatrix.apply(coefficientSetIndex, featureIndex2) > upperBounds[i2])) continue;
                initialCoefWithInterceptMatrix.update(coefficientSetIndex, featureIndex2, upperBounds[i2]);
            }
        }
        return initialCoefWithInterceptMatrix;
    }

    private Tuple2<double[], double[]> trainImpl(RDD<Instance> instances, double actualBlockSizeInMB, double[] featuresStd, double[] featuresMean, int numClasses, double[] initialSolution, Option<L2Regularization> regularization, FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> optimizer) {
        double[] solution;
        RDDLossFunction costFun;
        boolean multinomial = this.checkMultinomial(numClasses);
        boolean fitWithMean = !(!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) || this.isSet(this.lowerBoundsOnIntercepts()) && !ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.doubleArrayOps(this.$(this.lowerBoundsOnIntercepts()).toArray()), (Function1)(JFunction1.mcZD.sp & Serializable)x$6 -> RichDouble$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.doubleWrapper(x$6))) || this.isSet(this.upperBoundsOnIntercepts()) && !ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.doubleArrayOps(this.$(this.upperBoundsOnIntercepts()).toArray()), (Function1)(JFunction1.mcZD.sp & Serializable)x$7 -> RichDouble$.MODULE$.isPosInfinity$extension(Predef$.MODULE$.doubleWrapper(x$7))));
        int numFeatures = featuresStd.length;
        double[] inverseStd = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(featuresStd), (Function1)(JFunction1.mcDD.sp & Serializable)std -> {
            if (std != 0.0) {
                return 1.0 / std;
            }
            return 0.0;
        }, (ClassTag)ClassTag$.MODULE$.Double());
        double[] scaledMean = (double[])Array$.MODULE$.tabulate(numFeatures, (Function1)(JFunction1.mcDI.sp & Serializable)i -> inverseStd[i] * featuresMean[i], (ClassTag)ClassTag$.MODULE$.Double());
        Broadcast bcInverseStd = instances.context().broadcast((Object)inverseStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast bcScaledMean = instances.context().broadcast((Object)scaledMean, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        RDD scaled = instances.mapPartitions((Function1 & Serializable)iter -> {
            Function1<Vector, Vector> func = StandardScalerModel$.MODULE$.getTransformFunc((double[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Double()), (double[])bcInverseStd.value(), false, true);
            return iter.map((Function1 & Serializable)x0$1 -> {
                Instance instance = x0$1;
                if (instance != null) {
                    double label = instance.label();
                    double weight = instance.weight();
                    Vector vec = instance.features();
                    return new Instance(label, weight, (Vector)func.apply((Object)vec));
                }
                throw new MatchError((Object)instance);
            });
        }, instances.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Instance.class));
        long maxMemUsage = (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(actualBlockSizeInMB * (double)1024L * (double)1024L));
        RDD blocks = InstanceBlock$.MODULE$.blokifyWithMaxMemUsage((RDD<Instance>)scaled, maxMemUsage).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()).setName(this.uid() + ": training blocks (blockSizeInMB=" + actualBlockSizeInMB + ")");
        if (multinomial) {
            Function1 & Serializable getAggregatorFunc = (Function1 & Serializable)x$8 -> new MultinomialLogisticBlockAggregator((Broadcast<double[]>)bcInverseStd, (Broadcast<double[]>)bcScaledMean, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), fitWithMean, (Broadcast<Vector>)x$8);
            v0 = new RDDLossFunction(blocks, getAggregatorFunc, regularization, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(InstanceBlock.class), ClassTag$.MODULE$.apply(MultinomialLogisticBlockAggregator.class));
        } else {
            Function1 & Serializable getAggregatorFunc = (Function1 & Serializable)x$9 -> new BinaryLogisticBlockAggregator((Broadcast<double[]>)bcInverseStd, (Broadcast<double[]>)bcScaledMean, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), fitWithMean, (Broadcast<Vector>)x$9);
            v0 = costFun = new RDDLossFunction(blocks, getAggregatorFunc, regularization, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(InstanceBlock.class), ClassTag$.MODULE$.apply(BinaryLogisticBlockAggregator.class));
        }
        if (fitWithMean) {
            if (multinomial) {
                double[] adapt = (double[])Array$.MODULE$.ofDim(numClasses, (ClassTag)ClassTag$.MODULE$.Double());
                BLAS$.MODULE$.javaBLAS().dgemv("N", numClasses, numFeatures, 1.0, initialSolution, numClasses, scaledMean, 1, 0.0, adapt, 1);
                BLAS$.MODULE$.javaBLAS().daxpy(numClasses, 1.0, adapt, 0, 1, initialSolution, numClasses * numFeatures, 1);
            } else {
                double adapt = BLAS$.MODULE$.javaBLAS().ddot(numFeatures, initialSolution, 1, scaledMean, 1);
                initialSolution[numFeatures] = initialSolution[numFeatures] + adapt;
            }
        }
        Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction(costFun, DenseVector$.MODULE$.canCopyDenseVector((ClassTag)ClassTag$.MODULE$.Double())), (Object)new DenseVector.mcD.sp(initialSolution));
        ArrayBuilder arrayBuilder = ArrayBuilder$.MODULE$.make((ClassTag)ClassTag$.MODULE$.Double());
        FirstOrderMinimizer.State state = null;
        while (states.hasNext()) {
            state = (FirstOrderMinimizer.State)states.next();
            arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
        }
        blocks.unpersist(blocks.unpersist$default$1());
        bcInverseStd.destroy();
        bcScaledMean.destroy();
        double[] dArray = solution = state == null ? null : ((DenseVector)state.x()).toArray$mcD$sp((ClassTag)ClassTag$.MODULE$.Double());
        if (fitWithMean && solution != null) {
            if (multinomial) {
                double[] adapt = (double[])Array$.MODULE$.ofDim(numClasses, (ClassTag)ClassTag$.MODULE$.Double());
                BLAS$.MODULE$.javaBLAS().dgemv("N", numClasses, numFeatures, 1.0, solution, numClasses, scaledMean, 1, 0.0, adapt, 1);
                BLAS$.MODULE$.javaBLAS().daxpy(numClasses, -1.0, adapt, 0, 1, solution, numClasses * numFeatures, 1);
            } else {
                double adapt = BLAS$.MODULE$.javaBLAS().ddot(numFeatures, solution, 1, scaledMean, 1);
                solution[numFeatures] = solution[numFeatures] - adapt;
            }
        }
        return new Tuple2((Object)solution, arrayBuilder.result());
    }

    @Override
    public long estimateModelSize(Dataset<?> dataset) {
        int numClasses = DatasetUtils$.MODULE$.getNumClasses(dataset, this.$(this.labelCol()), DatasetUtils$.MODULE$.getNumClasses$default$3());
        int numFeatures = DatasetUtils$.MODULE$.getNumFeatures(dataset, this.$(this.featuresCol()));
        long size = this.estimateMatadataSize();
        if (this.checkMultinomial(numClasses)) {
            size += Matrices$.MODULE$.getDenseSize((long)numFeatures, (long)numClasses);
            size += Vectors$.MODULE$.getDenseSize((long)numClasses);
        } else {
            size += Matrices$.MODULE$.getDenseSize((long)numFeatures, 1L);
            size += Vectors$.MODULE$.getDenseSize(1L);
        }
        return size;
    }

    @Override
    public LogisticRegression copy(ParamMap extra) {
        return (LogisticRegression)this.defaultCopy(extra);
    }

    public static final /* synthetic */ boolean $anonfun$assertBoundConstrainedOptimizationParamsValid$5(Tuple2 x) {
        return x._1$mcD$sp() <= x._2$mcD$sp();
    }

    public static final /* synthetic */ boolean $anonfun$assertBoundConstrainedOptimizationParamsValid$7(Tuple2 x) {
        return x._1$mcD$sp() <= x._2$mcD$sp();
    }

    public static final /* synthetic */ void $anonfun$train$15(LogisticRegression $this, int numFeatures$1, double[] featuresStd$1, DenseMatrix denseCoefficientMatrix$1, Vector interceptVec$1, int classIndex, int featureIndex, double value) {
        boolean isIntercept;
        boolean bl = isIntercept = BoxesRunTime.unboxToBoolean((Object)$this.$($this.fitIntercept())) && featureIndex == numFeatures$1;
        if (!isIntercept && featuresStd$1[featureIndex] != 0.0) {
            denseCoefficientMatrix$1.update(classIndex, featureIndex, value / featuresStd$1[featureIndex]);
        }
        if (isIntercept) {
            interceptVec$1.toArray()[classIndex] = value;
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$train$16(double[] centers$1, int x0$2, int x1$1, double x2$1) {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)x0$2), (Object)BoxesRunTime.boxToInteger((int)x1$1), (Object)BoxesRunTime.boxToDouble((double)x2$1));
        if (tuple3 != null) {
            int j = BoxesRunTime.unboxToInt((Object)tuple3._2());
            double v = BoxesRunTime.unboxToDouble((Object)tuple3._3());
            centers$1[j] = centers$1[j] + v;
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ void $anonfun$train$18(DenseMatrix denseCoefficientMatrix$1, double[] centers$1, int x0$3, int x1$2, double x2$2) {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)x0$3), (Object)BoxesRunTime.boxToInteger((int)x1$2), (Object)BoxesRunTime.boxToDouble((double)x2$2));
        if (tuple3 != null) {
            int i = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int j = BoxesRunTime.unboxToInt((Object)tuple3._2());
            double v = BoxesRunTime.unboxToDouble((Object)tuple3._3());
            denseCoefficientMatrix$1.update(i, j, v - centers$1[j]);
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    private final Function1 regParamL1Fun$1(int numFeatures$2, int numCoefficientSets$2, boolean standardizationParam$1, double regParamL1$1, double[] featuresStd$2) {
        return (JFunction1.mcDI.sp & Serializable)index -> {
            boolean isIntercept;
            boolean bl = isIntercept = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && index >= numFeatures$2 * numCoefficientSets$2;
            if (isIntercept) {
                return 0.0;
            }
            if (standardizationParam$1) {
                return regParamL1$1;
            }
            int featureIndex = index / numCoefficientSets$2;
            if (featuresStd$2[featureIndex] != 0.0) {
                return regParamL1$1 / featuresStd$2[featureIndex];
            }
            return 0.0;
        };
    }

    public LogisticRegression(String uid) {
        this.uid = uid;
        HasRegParam.$init$(this);
        HasElasticNetParam.$init$(this);
        HasMaxIter.$init$(this);
        HasFitIntercept.$init$(this);
        HasTol.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasThreshold.$init$(this);
        HasAggregationDepth.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        LogisticRegressionParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        this.optInitialModel = None$.MODULE$;
        Statics.releaseFence();
    }

    public LogisticRegression() {
        this(Identifiable$.MODULE$.randomUID("logreg"));
    }
}

