/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.quantilescommon.IncludeMinMax;
import org.apache.datasketches.quantilescommon.InequalitySearch;
import org.apache.datasketches.quantilescommon.LongsSortedView;
import org.apache.datasketches.quantilescommon.LongsSortedViewIterator;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesLongsAPI;
import org.apache.datasketches.quantilescommon.QuantilesUtil;

public final class LongsSketchSortedView
implements LongsSortedView {
    private final long[] quantiles;
    private final long[] cumWeights;
    private final long totalN;

    public LongsSketchSortedView(long[] quantiles, long[] cumWeights, QuantilesLongsAPI sk) {
        IncludeMinMax.LongsPair dPair = IncludeMinMax.includeLongsMinMax(quantiles, cumWeights, sk.getMaxItem(), sk.getMinItem());
        this.quantiles = dPair.quantiles;
        this.cumWeights = dPair.cumWeights;
        this.totalN = sk.getN();
    }

    LongsSketchSortedView(long[] quantiles, long[] cumWeights, long totalN, long maxItem, long minItem) {
        IncludeMinMax.LongsPair dPair = IncludeMinMax.includeLongsMinMax(quantiles, cumWeights, maxItem, minItem);
        this.quantiles = dPair.quantiles;
        this.cumWeights = dPair.cumWeights;
        this.totalN = totalN;
    }

    @Override
    public long[] getCumulativeWeights() {
        return (long[])this.cumWeights.clone();
    }

    @Override
    public long getMaxItem() {
        int top = this.quantiles.length - 1;
        return this.quantiles[top];
    }

    @Override
    public long getMinItem() {
        return this.quantiles[0];
    }

    @Override
    public long getN() {
        return this.totalN;
    }

    @Override
    public int getNumRetained() {
        return this.quantiles.length;
    }

    @Override
    public long getQuantile(double rank, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        QuantilesUtil.checkNormalizedRankBounds(rank);
        int len = this.cumWeights.length;
        double naturalRank = QuantilesUtil.getNaturalRank(rank, this.totalN, searchCrit);
        InequalitySearch crit = searchCrit == QuantileSearchCriteria.INCLUSIVE ? InequalitySearch.GE : InequalitySearch.GT;
        int index = InequalitySearch.find(this.cumWeights, 0, len - 1, naturalRank, crit);
        if (index == -1) {
            return this.quantiles[len - 1];
        }
        return this.quantiles[index];
    }

    @Override
    public long[] getQuantiles() {
        return (long[])this.quantiles.clone();
    }

    @Override
    public double getRank(long quantile, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        int len = this.quantiles.length;
        InequalitySearch crit = searchCrit == QuantileSearchCriteria.INCLUSIVE ? InequalitySearch.LE : InequalitySearch.LT;
        int index = InequalitySearch.find(this.quantiles, 0, len - 1, quantile, crit);
        if (index == -1) {
            return 0.0;
        }
        return (double)this.cumWeights[index] / (double)this.totalN;
    }

    @Override
    public boolean isEmpty() {
        return this.totalN == 0L;
    }

    @Override
    public LongsSortedViewIterator iterator() {
        return new LongsSortedViewIterator(this.quantiles, this.cumWeights);
    }
}

