#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import pyspark.sql.connect.proto.relations_pb2
import pyspark.sql.connect.proto.types_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _DatasetType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DatasetTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DatasetType.ValueType],
    builtins.type,
):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    DATASET_TYPE_UNSPECIFIED: _DatasetType.ValueType  # 0
    """Safe default value. Should not be used."""
    MATERIALIZED_VIEW: _DatasetType.ValueType  # 1
    """A materialized view dataset which is published to the catalog"""
    TABLE: _DatasetType.ValueType  # 2
    """A table which is published to the catalog"""
    TEMPORARY_VIEW: _DatasetType.ValueType  # 3
    """A view which is not published to the catalog"""

class DatasetType(_DatasetType, metaclass=_DatasetTypeEnumTypeWrapper):
    """The type of dataset."""

DATASET_TYPE_UNSPECIFIED: DatasetType.ValueType  # 0
"""Safe default value. Should not be used."""
MATERIALIZED_VIEW: DatasetType.ValueType  # 1
"""A materialized view dataset which is published to the catalog"""
TABLE: DatasetType.ValueType  # 2
"""A table which is published to the catalog"""
TEMPORARY_VIEW: DatasetType.ValueType  # 3
"""A view which is not published to the catalog"""
global___DatasetType = DatasetType

class PipelineCommand(google.protobuf.message.Message):
    """Dispatch object for pipelines commands. See each individual command for documentation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class CreateDataflowGraph(google.protobuf.message.Message):
        """Request to create a new dataflow graph."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class SqlConfEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: builtins.str
            value: builtins.str
            def __init__(
                self,
                *,
                key: builtins.str = ...,
                value: builtins.str = ...,
            ) -> None: ...
            def ClearField(
                self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]
            ) -> None: ...

        class Response(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            DATAFLOW_GRAPH_ID_FIELD_NUMBER: builtins.int
            dataflow_graph_id: builtins.str
            """The ID of the created graph."""
            def __init__(
                self,
                *,
                dataflow_graph_id: builtins.str | None = ...,
            ) -> None: ...
            def HasField(
                self,
                field_name: typing_extensions.Literal[
                    "_dataflow_graph_id",
                    b"_dataflow_graph_id",
                    "dataflow_graph_id",
                    b"dataflow_graph_id",
                ],
            ) -> builtins.bool: ...
            def ClearField(
                self,
                field_name: typing_extensions.Literal[
                    "_dataflow_graph_id",
                    b"_dataflow_graph_id",
                    "dataflow_graph_id",
                    b"dataflow_graph_id",
                ],
            ) -> None: ...
            def WhichOneof(
                self,
                oneof_group: typing_extensions.Literal["_dataflow_graph_id", b"_dataflow_graph_id"],
            ) -> typing_extensions.Literal["dataflow_graph_id"] | None: ...

        DEFAULT_CATALOG_FIELD_NUMBER: builtins.int
        DEFAULT_DATABASE_FIELD_NUMBER: builtins.int
        SQL_CONF_FIELD_NUMBER: builtins.int
        default_catalog: builtins.str
        """The default catalog."""
        default_database: builtins.str
        """The default database."""
        @property
        def sql_conf(
            self,
        ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
            """SQL configurations for all flows in this graph."""
        def __init__(
            self,
            *,
            default_catalog: builtins.str | None = ...,
            default_database: builtins.str | None = ...,
            sql_conf: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        ) -> None: ...
        def HasField(
            self,
            field_name: typing_extensions.Literal[
                "_default_catalog",
                b"_default_catalog",
                "_default_database",
                b"_default_database",
                "default_catalog",
                b"default_catalog",
                "default_database",
                b"default_database",
            ],
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal[
                "_default_catalog",
                b"_default_catalog",
                "_default_database",
                b"_default_database",
                "default_catalog",
                b"default_catalog",
                "default_database",
                b"default_database",
                "sql_conf",
                b"sql_conf",
            ],
        ) -> None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_default_catalog", b"_default_catalog"]
        ) -> typing_extensions.Literal["default_catalog"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_default_database", b"_default_database"]
        ) -> typing_extensions.Literal["default_database"] | None: ...

    class DropDataflowGraph(google.protobuf.message.Message):
        """Drops the graph and stops any running attached flows."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DATAFLOW_GRAPH_ID_FIELD_NUMBER: builtins.int
        dataflow_graph_id: builtins.str
        """The graph to drop."""
        def __init__(
            self,
            *,
            dataflow_graph_id: builtins.str | None = ...,
        ) -> None: ...
        def HasField(
            self,
            field_name: typing_extensions.Literal[
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "dataflow_graph_id",
                b"dataflow_graph_id",
            ],
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal[
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "dataflow_graph_id",
                b"dataflow_graph_id",
            ],
        ) -> None: ...
        def WhichOneof(
            self,
            oneof_group: typing_extensions.Literal["_dataflow_graph_id", b"_dataflow_graph_id"],
        ) -> typing_extensions.Literal["dataflow_graph_id"] | None: ...

    class DefineDataset(google.protobuf.message.Message):
        """Request to define a dataset: a table, a materialized view, or a temporary view."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class TablePropertiesEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: builtins.str
            value: builtins.str
            def __init__(
                self,
                *,
                key: builtins.str = ...,
                value: builtins.str = ...,
            ) -> None: ...
            def ClearField(
                self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]
            ) -> None: ...

        DATAFLOW_GRAPH_ID_FIELD_NUMBER: builtins.int
        DATASET_NAME_FIELD_NUMBER: builtins.int
        DATASET_TYPE_FIELD_NUMBER: builtins.int
        COMMENT_FIELD_NUMBER: builtins.int
        TABLE_PROPERTIES_FIELD_NUMBER: builtins.int
        PARTITION_COLS_FIELD_NUMBER: builtins.int
        SCHEMA_FIELD_NUMBER: builtins.int
        FORMAT_FIELD_NUMBER: builtins.int
        dataflow_graph_id: builtins.str
        """The graph to attach this dataset to."""
        dataset_name: builtins.str
        """Name of the dataset. Can be partially or fully qualified."""
        dataset_type: global___DatasetType.ValueType
        """The type of the dataset."""
        comment: builtins.str
        """Optional comment for the dataset."""
        @property
        def table_properties(
            self,
        ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
            """Optional table properties. Only applies to dataset_type == TABLE and dataset_type == MATERIALIZED_VIEW."""
        @property
        def partition_cols(
            self,
        ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """Optional partition columns for the dataset. Only applies to dataset_type == TABLE and
            dataset_type == MATERIALIZED_VIEW.
            """
        @property
        def schema(self) -> pyspark.sql.connect.proto.types_pb2.DataType:
            """Schema for the dataset. If unset, this will be inferred from incoming flows."""
        format: builtins.str
        """The output table format of the dataset. Only applies to dataset_type == TABLE and
        dataset_type == MATERIALIZED_VIEW.
        """
        def __init__(
            self,
            *,
            dataflow_graph_id: builtins.str | None = ...,
            dataset_name: builtins.str | None = ...,
            dataset_type: global___DatasetType.ValueType | None = ...,
            comment: builtins.str | None = ...,
            table_properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
            partition_cols: collections.abc.Iterable[builtins.str] | None = ...,
            schema: pyspark.sql.connect.proto.types_pb2.DataType | None = ...,
            format: builtins.str | None = ...,
        ) -> None: ...
        def HasField(
            self,
            field_name: typing_extensions.Literal[
                "_comment",
                b"_comment",
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "_dataset_name",
                b"_dataset_name",
                "_dataset_type",
                b"_dataset_type",
                "_format",
                b"_format",
                "_schema",
                b"_schema",
                "comment",
                b"comment",
                "dataflow_graph_id",
                b"dataflow_graph_id",
                "dataset_name",
                b"dataset_name",
                "dataset_type",
                b"dataset_type",
                "format",
                b"format",
                "schema",
                b"schema",
            ],
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal[
                "_comment",
                b"_comment",
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "_dataset_name",
                b"_dataset_name",
                "_dataset_type",
                b"_dataset_type",
                "_format",
                b"_format",
                "_schema",
                b"_schema",
                "comment",
                b"comment",
                "dataflow_graph_id",
                b"dataflow_graph_id",
                "dataset_name",
                b"dataset_name",
                "dataset_type",
                b"dataset_type",
                "format",
                b"format",
                "partition_cols",
                b"partition_cols",
                "schema",
                b"schema",
                "table_properties",
                b"table_properties",
            ],
        ) -> None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_comment", b"_comment"]
        ) -> typing_extensions.Literal["comment"] | None: ...
        @typing.overload
        def WhichOneof(
            self,
            oneof_group: typing_extensions.Literal["_dataflow_graph_id", b"_dataflow_graph_id"],
        ) -> typing_extensions.Literal["dataflow_graph_id"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_dataset_name", b"_dataset_name"]
        ) -> typing_extensions.Literal["dataset_name"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_dataset_type", b"_dataset_type"]
        ) -> typing_extensions.Literal["dataset_type"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_format", b"_format"]
        ) -> typing_extensions.Literal["format"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_schema", b"_schema"]
        ) -> typing_extensions.Literal["schema"] | None: ...

    class DefineFlow(google.protobuf.message.Message):
        """Request to define a flow targeting a dataset."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class SqlConfEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: builtins.str
            value: builtins.str
            def __init__(
                self,
                *,
                key: builtins.str = ...,
                value: builtins.str = ...,
            ) -> None: ...
            def ClearField(
                self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]
            ) -> None: ...

        DATAFLOW_GRAPH_ID_FIELD_NUMBER: builtins.int
        FLOW_NAME_FIELD_NUMBER: builtins.int
        TARGET_DATASET_NAME_FIELD_NUMBER: builtins.int
        PLAN_FIELD_NUMBER: builtins.int
        SQL_CONF_FIELD_NUMBER: builtins.int
        ONCE_FIELD_NUMBER: builtins.int
        dataflow_graph_id: builtins.str
        """The graph to attach this flow to."""
        flow_name: builtins.str
        """Name of the flow. For standalone flows, this must be a single-part name."""
        target_dataset_name: builtins.str
        """Name of the dataset this flow writes to. Can be partially or fully qualified."""
        @property
        def plan(self) -> pyspark.sql.connect.proto.relations_pb2.Relation:
            """An unresolved relation that defines the dataset's flow."""
        @property
        def sql_conf(
            self,
        ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
            """SQL configurations set when running this flow."""
        once: builtins.bool
        """If true, this flow will only be run once per full refresh."""
        def __init__(
            self,
            *,
            dataflow_graph_id: builtins.str | None = ...,
            flow_name: builtins.str | None = ...,
            target_dataset_name: builtins.str | None = ...,
            plan: pyspark.sql.connect.proto.relations_pb2.Relation | None = ...,
            sql_conf: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
            once: builtins.bool | None = ...,
        ) -> None: ...
        def HasField(
            self,
            field_name: typing_extensions.Literal[
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "_flow_name",
                b"_flow_name",
                "_once",
                b"_once",
                "_plan",
                b"_plan",
                "_target_dataset_name",
                b"_target_dataset_name",
                "dataflow_graph_id",
                b"dataflow_graph_id",
                "flow_name",
                b"flow_name",
                "once",
                b"once",
                "plan",
                b"plan",
                "target_dataset_name",
                b"target_dataset_name",
            ],
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal[
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "_flow_name",
                b"_flow_name",
                "_once",
                b"_once",
                "_plan",
                b"_plan",
                "_target_dataset_name",
                b"_target_dataset_name",
                "dataflow_graph_id",
                b"dataflow_graph_id",
                "flow_name",
                b"flow_name",
                "once",
                b"once",
                "plan",
                b"plan",
                "sql_conf",
                b"sql_conf",
                "target_dataset_name",
                b"target_dataset_name",
            ],
        ) -> None: ...
        @typing.overload
        def WhichOneof(
            self,
            oneof_group: typing_extensions.Literal["_dataflow_graph_id", b"_dataflow_graph_id"],
        ) -> typing_extensions.Literal["dataflow_graph_id"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_flow_name", b"_flow_name"]
        ) -> typing_extensions.Literal["flow_name"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_once", b"_once"]
        ) -> typing_extensions.Literal["once"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_plan", b"_plan"]
        ) -> typing_extensions.Literal["plan"] | None: ...
        @typing.overload
        def WhichOneof(
            self,
            oneof_group: typing_extensions.Literal["_target_dataset_name", b"_target_dataset_name"],
        ) -> typing_extensions.Literal["target_dataset_name"] | None: ...

    class StartRun(google.protobuf.message.Message):
        """Resolves all datasets and flows and start a pipeline update. Should be called after all
        graph elements are registered.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DATAFLOW_GRAPH_ID_FIELD_NUMBER: builtins.int
        dataflow_graph_id: builtins.str
        """The graph to start."""
        def __init__(
            self,
            *,
            dataflow_graph_id: builtins.str | None = ...,
        ) -> None: ...
        def HasField(
            self,
            field_name: typing_extensions.Literal[
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "dataflow_graph_id",
                b"dataflow_graph_id",
            ],
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal[
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "dataflow_graph_id",
                b"dataflow_graph_id",
            ],
        ) -> None: ...
        def WhichOneof(
            self,
            oneof_group: typing_extensions.Literal["_dataflow_graph_id", b"_dataflow_graph_id"],
        ) -> typing_extensions.Literal["dataflow_graph_id"] | None: ...

    class DefineSqlGraphElements(google.protobuf.message.Message):
        """Parses the SQL file and registers all datasets and flows."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DATAFLOW_GRAPH_ID_FIELD_NUMBER: builtins.int
        SQL_FILE_PATH_FIELD_NUMBER: builtins.int
        SQL_TEXT_FIELD_NUMBER: builtins.int
        dataflow_graph_id: builtins.str
        """The graph to attach this dataset to."""
        sql_file_path: builtins.str
        """The full path to the SQL file. Can be relative or absolute."""
        sql_text: builtins.str
        """The contents of the SQL file."""
        def __init__(
            self,
            *,
            dataflow_graph_id: builtins.str | None = ...,
            sql_file_path: builtins.str | None = ...,
            sql_text: builtins.str | None = ...,
        ) -> None: ...
        def HasField(
            self,
            field_name: typing_extensions.Literal[
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "_sql_file_path",
                b"_sql_file_path",
                "_sql_text",
                b"_sql_text",
                "dataflow_graph_id",
                b"dataflow_graph_id",
                "sql_file_path",
                b"sql_file_path",
                "sql_text",
                b"sql_text",
            ],
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal[
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "_sql_file_path",
                b"_sql_file_path",
                "_sql_text",
                b"_sql_text",
                "dataflow_graph_id",
                b"dataflow_graph_id",
                "sql_file_path",
                b"sql_file_path",
                "sql_text",
                b"sql_text",
            ],
        ) -> None: ...
        @typing.overload
        def WhichOneof(
            self,
            oneof_group: typing_extensions.Literal["_dataflow_graph_id", b"_dataflow_graph_id"],
        ) -> typing_extensions.Literal["dataflow_graph_id"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_sql_file_path", b"_sql_file_path"]
        ) -> typing_extensions.Literal["sql_file_path"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_sql_text", b"_sql_text"]
        ) -> typing_extensions.Literal["sql_text"] | None: ...

    CREATE_DATAFLOW_GRAPH_FIELD_NUMBER: builtins.int
    DEFINE_DATASET_FIELD_NUMBER: builtins.int
    DEFINE_FLOW_FIELD_NUMBER: builtins.int
    DROP_DATAFLOW_GRAPH_FIELD_NUMBER: builtins.int
    START_RUN_FIELD_NUMBER: builtins.int
    DEFINE_SQL_GRAPH_ELEMENTS_FIELD_NUMBER: builtins.int
    @property
    def create_dataflow_graph(self) -> global___PipelineCommand.CreateDataflowGraph: ...
    @property
    def define_dataset(self) -> global___PipelineCommand.DefineDataset: ...
    @property
    def define_flow(self) -> global___PipelineCommand.DefineFlow: ...
    @property
    def drop_dataflow_graph(self) -> global___PipelineCommand.DropDataflowGraph: ...
    @property
    def start_run(self) -> global___PipelineCommand.StartRun: ...
    @property
    def define_sql_graph_elements(self) -> global___PipelineCommand.DefineSqlGraphElements: ...
    def __init__(
        self,
        *,
        create_dataflow_graph: global___PipelineCommand.CreateDataflowGraph | None = ...,
        define_dataset: global___PipelineCommand.DefineDataset | None = ...,
        define_flow: global___PipelineCommand.DefineFlow | None = ...,
        drop_dataflow_graph: global___PipelineCommand.DropDataflowGraph | None = ...,
        start_run: global___PipelineCommand.StartRun | None = ...,
        define_sql_graph_elements: global___PipelineCommand.DefineSqlGraphElements | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "command_type",
            b"command_type",
            "create_dataflow_graph",
            b"create_dataflow_graph",
            "define_dataset",
            b"define_dataset",
            "define_flow",
            b"define_flow",
            "define_sql_graph_elements",
            b"define_sql_graph_elements",
            "drop_dataflow_graph",
            b"drop_dataflow_graph",
            "start_run",
            b"start_run",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "command_type",
            b"command_type",
            "create_dataflow_graph",
            b"create_dataflow_graph",
            "define_dataset",
            b"define_dataset",
            "define_flow",
            b"define_flow",
            "define_sql_graph_elements",
            b"define_sql_graph_elements",
            "drop_dataflow_graph",
            b"drop_dataflow_graph",
            "start_run",
            b"start_run",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["command_type", b"command_type"]
    ) -> (
        typing_extensions.Literal[
            "create_dataflow_graph",
            "define_dataset",
            "define_flow",
            "drop_dataflow_graph",
            "start_run",
            "define_sql_graph_elements",
        ]
        | None
    ): ...

global___PipelineCommand = PipelineCommand

class PipelineCommandResult(google.protobuf.message.Message):
    """Dispatch object for pipelines command results."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class CreateDataflowGraphResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DATAFLOW_GRAPH_ID_FIELD_NUMBER: builtins.int
        dataflow_graph_id: builtins.str
        """The ID of the created graph."""
        def __init__(
            self,
            *,
            dataflow_graph_id: builtins.str | None = ...,
        ) -> None: ...
        def HasField(
            self,
            field_name: typing_extensions.Literal[
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "dataflow_graph_id",
                b"dataflow_graph_id",
            ],
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal[
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "dataflow_graph_id",
                b"dataflow_graph_id",
            ],
        ) -> None: ...
        def WhichOneof(
            self,
            oneof_group: typing_extensions.Literal["_dataflow_graph_id", b"_dataflow_graph_id"],
        ) -> typing_extensions.Literal["dataflow_graph_id"] | None: ...

    CREATE_DATAFLOW_GRAPH_RESULT_FIELD_NUMBER: builtins.int
    @property
    def create_dataflow_graph_result(
        self,
    ) -> global___PipelineCommandResult.CreateDataflowGraphResult: ...
    def __init__(
        self,
        *,
        create_dataflow_graph_result: global___PipelineCommandResult.CreateDataflowGraphResult
        | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "create_dataflow_graph_result",
            b"create_dataflow_graph_result",
            "result_type",
            b"result_type",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "create_dataflow_graph_result",
            b"create_dataflow_graph_result",
            "result_type",
            b"result_type",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["result_type", b"result_type"]
    ) -> typing_extensions.Literal["create_dataflow_graph_result"] | None: ...

global___PipelineCommandResult = PipelineCommandResult

class PipelineEventResult(google.protobuf.message.Message):
    """A response containing an event emitted during the run of a pipeline."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EVENT_FIELD_NUMBER: builtins.int
    @property
    def event(self) -> global___PipelineEvent: ...
    def __init__(
        self,
        *,
        event: global___PipelineEvent | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["event", b"event"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["event", b"event"]) -> None: ...

global___PipelineEventResult = PipelineEventResult

class PipelineEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The timestamp corresponding to when the event occurred."""
    message: builtins.str
    """The message that should be displayed to users."""
    def __init__(
        self,
        *,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        message: builtins.str | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "_message", b"_message", "message", b"message", "timestamp", b"timestamp"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "_message", b"_message", "message", b"message", "timestamp", b"timestamp"
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_message", b"_message"]
    ) -> typing_extensions.Literal["message"] | None: ...

global___PipelineEvent = PipelineEvent
