/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.util;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.SparkException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.classification.ClassifierParams;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class DatasetUtils$
implements Logging {
    public static final DatasetUtils$ MODULE$ = new DatasetUtils$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Column checkNonNanValues(String colName, String displayed) {
        Column casted = functions$.MODULE$.col(colName).cast((DataType)DoubleType$.MODULE$);
        return functions$.MODULE$.when(casted.isNull().$bar$bar((Object)casted.isNaN()), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.lit((Object)(displayed + " MUST NOT be Null or NaN")))).when(casted.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY)).$bar$bar((Object)casted.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY))), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)(displayed + " MUST NOT be Infinity, but got ")), casted})))).otherwise((Object)casted);
    }

    public Column checkRegressionLabels(String labelCol) {
        return this.checkNonNanValues(labelCol, "Labels");
    }

    public Column checkClassificationLabels(String labelCol, Option<Object> numClasses) {
        Some some;
        int n;
        Column casted = functions$.MODULE$.col(labelCol).cast((DataType)DoubleType$.MODULE$);
        Option<Object> option = numClasses;
        if (option instanceof Some && 2 == (n = BoxesRunTime.unboxToInt((Object)(some = (Some)option).value()))) {
            return functions$.MODULE$.when(casted.isNull().$bar$bar((Object)casted.isNaN()), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.lit((Object)"Labels MUST NOT be Null or NaN"))).when(casted.$eq$bang$eq((Object)BoxesRunTime.boxToInteger((int)0)).$amp$amp((Object)casted.$eq$bang$eq((Object)BoxesRunTime.boxToInteger((int)1))), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"Labels MUST be in {0, 1}, but got "), casted})))).otherwise((Object)casted);
        }
        int n2 = BoxesRunTime.unboxToInt((Object)numClasses.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Integer.MAX_VALUE));
        Predef$.MODULE$.require(0 < n2 && n2 <= Integer.MAX_VALUE);
        return functions$.MODULE$.when(casted.isNull().$bar$bar((Object)casted.isNaN()), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.lit((Object)"Labels MUST NOT be Null or NaN"))).when(casted.$less((Object)BoxesRunTime.boxToInteger((int)0)).$bar$bar((Object)casted.$greater$eq((Object)BoxesRunTime.boxToInteger((int)n2))), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)("Labels MUST be in [0, " + n2 + "), but got ")), casted})))).when(casted.$eq$bang$eq((Object)casted.cast((DataType)IntegerType$.MODULE$)), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"Labels MUST be Integers, but got "), casted})))).otherwise((Object)casted);
    }

    public Column checkNonNegativeWeights(String weightCol) {
        Column casted = functions$.MODULE$.col(weightCol).cast((DataType)DoubleType$.MODULE$);
        return functions$.MODULE$.when(casted.isNull().$bar$bar((Object)casted.isNaN()), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.lit((Object)"Weights MUST NOT be Null or NaN"))).when(casted.$less((Object)BoxesRunTime.boxToInteger((int)0)).$bar$bar((Object)casted.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY))), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"Weights MUST NOT be Negative or Infinity, but got "), casted})))).otherwise((Object)casted);
    }

    public Column checkNonNegativeWeights(Option<String> weightCol) {
        Some some;
        String w;
        Option<String> option = weightCol;
        if (option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(w = (String)(some = (Some)option).value()))) {
            return this.checkNonNegativeWeights(w);
        }
        return functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0));
    }

    public Column checkNonNanVectors(Column vectorCol) {
        return functions$.MODULE$.when(vectorCol.isNull(), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.lit((Object)"Vectors MUST NOT be Null"))).when(functions$.MODULE$.exists(functions$.MODULE$.unwrap_udt(vectorCol).getField("values"), (Function1 & Serializable)v -> v.isNaN().$bar$bar((Object)v.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY))).$bar$bar((Object)v.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY)))), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"Vector values MUST NOT be NaN or Infinity, but got "), vectorCol.cast((DataType)StringType$.MODULE$)})))).otherwise((Object)vectorCol);
    }

    public Column checkNonNanVectors(String vectorCol) {
        return this.checkNonNanVectors(functions$.MODULE$.col(vectorCol));
    }

    public RDD<Instance> extractInstances(PredictorParams p, Dataset<?> df, Option<Object> numClasses) {
        Column column;
        Column column2;
        PredictorParams predictorParams = p;
        if (predictorParams instanceof ClassifierParams) {
            ClassifierParams classifierParams = (ClassifierParams)predictorParams;
            column2 = this.checkClassificationLabels(classifierParams.getLabelCol(), numClasses);
        } else {
            column2 = this.checkRegressionLabels(p.getLabelCol());
        }
        Column labelCol = column2;
        PredictorParams predictorParams2 = p;
        if (predictorParams2 instanceof HasWeightCol) {
            PredictorParams predictorParams3 = predictorParams2;
            column = this.checkNonNegativeWeights(predictorParams3.get(((HasWeightCol)((Object)predictorParams3)).weightCol()));
        } else {
            column = functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0));
        }
        Column weightCol = column;
        return df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{labelCol, weightCol, this.checkNonNanVectors(p.getFeaturesCol())})).rdd().map((Function1 & Serializable)x0$1 -> {
            Some some;
            Row row = x0$1;
            if (row != null && !(some = Row$.MODULE$.unapplySeq(row)).isEmpty() && some.get() != null && ((SeqOps)some.get()).lengthCompare(3) == 0) {
                Object l = ((SeqOps)some.get()).apply(0);
                Object w = ((SeqOps)some.get()).apply(1);
                Object v = ((SeqOps)some.get()).apply(2);
                if (l instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)l);
                    if (w instanceof Double) {
                        double d2 = BoxesRunTime.unboxToDouble((Object)w);
                        if (v instanceof org.apache.spark.ml.linalg.Vector) {
                            org.apache.spark.ml.linalg.Vector vector = (org.apache.spark.ml.linalg.Vector)v;
                            return new Instance(d, d2, vector);
                        }
                    }
                }
            }
            throw new MatchError((Object)row);
        }, ClassTag$.MODULE$.apply(Instance.class));
    }

    public Option<Object> extractInstances$default$3() {
        return None$.MODULE$;
    }

    public Column columnToVector(Dataset<?> dataset, String colName) {
        DataType columnDataType = dataset.schema().apply(colName).dataType();
        DataType dataType = columnDataType;
        if (dataType instanceof VectorUDT) {
            return functions$.MODULE$.col(colName);
        }
        if (dataType instanceof ArrayType) {
            UserDefinedFunction userDefinedFunction;
            ArrayType arrayType = (ArrayType)dataType;
            DataType dataType2 = arrayType.elementType();
            if (dataType2 instanceof FloatType) {
                public final class Org_apache_spark_ml_util_DatasetUtils$$typecreator2$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                    }

                    public Org_apache_spark_ml_util_DatasetUtils$$typecreator2$1() {
                    }
                }
                public final class Org_apache_spark_ml_util_DatasetUtils$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_util_DatasetUtils$$typecreator1$1() {
                    }
                }
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                userDefinedFunction = functions$.MODULE$.udf((Function1 & Serializable)vector -> {
                    double[] inputArray = (double[])Array$.MODULE$.ofDim(vector.size(), (ClassTag)ClassTag$.MODULE$.Double());
                    vector.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
                        inputArray$1[idx] = BoxesRunTime.unboxToFloat((Object)vector.apply(idx));
                    });
                    return org.apache.spark.ml.linalg.Vectors$.MODULE$.dense(inputArray);
                }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_util_DatasetUtils$$typecreator1$1()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_util_DatasetUtils$$typecreator2$1()));
            } else if (dataType2 instanceof DoubleType) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                JavaUniverse $u3 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                public final class Org_apache_spark_ml_util_DatasetUtils$$typecreator3$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_util_DatasetUtils$$typecreator3$1() {
                    }
                }
                public final class Org_apache_spark_ml_util_DatasetUtils$$typecreator4$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                    }

                    public Org_apache_spark_ml_util_DatasetUtils$$typecreator4$1() {
                    }
                }
                userDefinedFunction = functions$.MODULE$.udf((Function1 & Serializable)vector -> org.apache.spark.ml.linalg.Vectors$.MODULE$.dense((double[])vector.toArray((ClassTag)ClassTag$.MODULE$.Double())), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_util_DatasetUtils$$typecreator3$1()), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_util_DatasetUtils$$typecreator4$1()));
            } else {
                throw new IllegalArgumentException("Array[" + dataType2 + "] column cannot be cast to Vector");
            }
            UserDefinedFunction transferUDF = userDefinedFunction;
            return transferUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(colName)}));
        }
        throw new IllegalArgumentException(dataType + " column cannot be cast to Vector");
    }

    public RDD<Vector> columnToOldVector(Dataset<?> dataset, String colName) {
        return dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{this.columnToVector(dataset, colName)})).rdd().map((Function1 & Serializable)x0$1 -> {
            Object point;
            Some some;
            Row row = x0$1;
            if (row != null && !(some = Row$.MODULE$.unapplySeq(row)).isEmpty() && some.get() != null && ((SeqOps)some.get()).lengthCompare(1) == 0 && (point = ((SeqOps)some.get()).apply(0)) instanceof org.apache.spark.ml.linalg.Vector) {
                org.apache.spark.ml.linalg.Vector vector = (org.apache.spark.ml.linalg.Vector)point;
                return Vectors$.MODULE$.fromML(vector);
            }
            throw new MatchError((Object)row);
        }, ClassTag$.MODULE$.apply(Vector.class));
    }

    public int getNumClasses(Dataset<?> dataset, String labelCol, int maxNumClasses) {
        Option<Object> option = MetadataUtils$.MODULE$.getNumClasses(dataset.schema().apply(labelCol));
        if (option instanceof Some) {
            Some some = (Some)option;
            int n = BoxesRunTime.unboxToInt((Object)some.value());
            if (true) {
                int n2 = n;
                return n2;
            }
        }
        if (None$.MODULE$.equals(option)) {
            Row[] maxLabelRow = (Row[])dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max(this.checkClassificationLabels(labelCol, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)maxNumClasses))))})).take(1);
            if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])maxLabelRow)) || maxLabelRow[0].get(0) == null) {
                throw new SparkException("ML algorithm was given empty dataset.");
            }
            double maxDoubleLabel = ((Row)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])maxLabelRow))).getDouble(0);
            Predef$.MODULE$.require(RichDouble$.MODULE$.isValidInt$extension(Predef$.MODULE$.doubleWrapper(maxDoubleLabel + 1.0)), (Function0 & Serializable)() -> "Classifier found max label value = " + maxDoubleLabel + " but requires integers in range [0, ... " + Integer.MAX_VALUE + ")");
            int numClasses = (int)maxDoubleLabel + 1;
            Predef$.MODULE$.require(numClasses <= maxNumClasses, (Function0 & Serializable)() -> "Classifier inferred " + numClasses + " from label values in column " + labelCol + ", but this exceeded the max numClasses (" + maxNumClasses + ") allowed to be inferred from values.  To avoid this error for labels with > " + maxNumClasses + " classes, specify numClasses explicitly in the metadata; this can be done by applying StringIndexer to the label column.");
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " inferred ", " classes for labelCol=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CLASS_NAME$.MODULE$, (Object)MODULE$.getClass().getCanonicalName()), new MDC((LogKey)LogKeys.NUM_CLASSES$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)numClasses)), new MDC((LogKey)LogKeys.LABEL_COLUMN$.MODULE$, (Object)labelCol)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" since numClasses was not specified in the column metadata."}))).log((Seq)Nil$.MODULE$))));
            return numClasses;
        }
        throw new MatchError(option);
    }

    public int getNumClasses$default$3() {
        return 100;
    }

    public int getNumFeatures(Dataset<?> dataset, String vectorCol) {
        return BoxesRunTime.unboxToInt((Object)MetadataUtils$.MODULE$.getNumFeatures(dataset.schema().apply(vectorCol)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> ((org.apache.spark.ml.linalg.Vector)((Row)dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.columnToVector(dataset, vectorCol)})).head()).getAs(0)).size()));
    }

    private DatasetUtils$() {
    }
}

