/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.FMRegressionModel;
import org.apache.spark.ml.regression.FMRegressor$;
import org.apache.spark.ml.regression.FMRegressorParams;
import org.apache.spark.ml.regression.FactorizationMachines;
import org.apache.spark.ml.regression.FactorizationMachines$;
import org.apache.spark.ml.regression.FactorizationMachinesParams;
import org.apache.spark.ml.regression.Regressor;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Function1;
import scala.MatchError;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005eg\u0001\u0002\r\u001a\u0001\u0011B\u0001\"\u0012\u0001\u0003\u0006\u0004%\tE\u0012\u0005\t;\u0002\u0011\t\u0011)A\u0005\u000f\")q\f\u0001C\u0001A\")q\f\u0001C\u0001I\")a\r\u0001C\u0001O\")\u0001\u000f\u0001C\u0001c\")q\u000f\u0001C\u0001q\")1\u0010\u0001C\u0001y\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003+\u0001A\u0011AA\f\u0011\u001d\ti\u0002\u0001C\u0001\u0003?Aq!!\n\u0001\t\u0003\t9\u0003C\u0004\u0002.\u0001!\t!a\f\t\u000f\u0005U\u0002\u0001\"\u0001\u00028!9\u00111\t\u0001\u0005R\u0005\u0015\u0003bBA8\u0001\u0011\u0005\u0013\u0011\u000f\u0005\b\u0003\u000b\u0003A\u0011IAD\u000f\u001d\t9*\u0007E\u0001\u000333a\u0001G\r\t\u0002\u0005m\u0005BB0\u0015\t\u0003\tI\fC\u0004\u0002<R!\t%!0\t\u0013\u0005\u0015G#!A\u0005\n\u0005\u001d'a\u0003$N%\u0016<'/Z:t_JT!AG\u000e\u0002\u0015I,wM]3tg&|gN\u0003\u0002\u001d;\u0005\u0011Q\u000e\u001c\u0006\u0003=}\tQa\u001d9be.T!\u0001I\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0013aA8sO\u000e\u00011C\u0002\u0001&gYJt\bE\u0003'O%z\u0003'D\u0001\u001a\u0013\tA\u0013DA\u0005SK\u001e\u0014Xm]:peB\u0011!&L\u0007\u0002W)\u0011AfG\u0001\u0007Y&t\u0017\r\\4\n\u00059Z#A\u0002,fGR|'\u000f\u0005\u0002'\u0001A\u0011a%M\u0005\u0003ee\u0011\u0011CR'SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\t1C'\u0003\u000263\t)b)Y2u_JL'0\u0019;j_:l\u0015m\u00195j]\u0016\u001c\bC\u0001\u00148\u0013\tA\u0014DA\tG\u001bJ+wM]3tg>\u0014\b+\u0019:b[N\u0004\"AO\u001f\u000e\u0003mR!\u0001P\u000e\u0002\tU$\u0018\u000e\\\u0005\u0003}m\u0012Q\u0003R3gCVdG\u000fU1sC6\u001cxK]5uC\ndW\r\u0005\u0002A\u00076\t\u0011I\u0003\u0002C;\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002E\u0003\n9Aj\\4hS:<\u0017aA;jIV\tq\t\u0005\u0002I#:\u0011\u0011j\u0014\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019\u000e\na\u0001\u0010:p_Rt$\"\u0001(\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ak\u0015A\u0002)sK\u0012,g-\u0003\u0002S'\n11\u000b\u001e:j]\u001eT!\u0001U')\u0007\u0005)6\f\u0005\u0002W36\tqK\u0003\u0002Y;\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005i;&!B*j]\u000e,\u0017%\u0001/\u0002\u000bMr\u0003G\f\u0019\u0002\tULG\r\t\u0015\u0004\u0005U[\u0016A\u0002\u001fj]&$h\b\u0006\u00020C\")Qi\u0001a\u0001\u000f\"\u001a\u0011-V.)\u0007\r)6\fF\u00010Q\r!QkW\u0001\u000eg\u0016$h)Y2u_J\u001c\u0016N_3\u0015\u0005!LW\"\u0001\u0001\t\u000b),\u0001\u0019A6\u0002\u000bY\fG.^3\u0011\u00051lW\"A'\n\u00059l%aA%oi\"\u001aQ!V.\u0002\u001fM,GOR5u\u0013:$XM]2faR$\"\u0001\u001b:\t\u000b)4\u0001\u0019A:\u0011\u00051$\u0018BA;N\u0005\u001d\u0011un\u001c7fC:D3AB+\\\u00031\u0019X\r\u001e$ji2Kg.Z1s)\tA\u0017\u0010C\u0003k\u000f\u0001\u00071\u000fK\u0002\b+n\u000b1b]3u%\u0016<\u0007+\u0019:b[R\u0011\u0001. \u0005\u0006U\"\u0001\rA \t\u0003Y~L1!!\u0001N\u0005\u0019!u.\u001e2mK\"\u001a\u0001\"V.\u0002)M,G/T5oS\n\u000bGo\u00195Ge\u0006\u001cG/[8o)\rA\u0017\u0011\u0002\u0005\u0006U&\u0001\rA \u0015\u0004\u0013U[\u0016AC:fi&s\u0017\u000e^*uIR\u0019\u0001.!\u0005\t\u000b)T\u0001\u0019\u0001@)\u0007))6,\u0001\u0006tKRl\u0015\r_%uKJ$2\u0001[A\r\u0011\u0015Q7\u00021\u0001lQ\rYQkW\u0001\fg\u0016$8\u000b^3q'&TX\rF\u0002i\u0003CAQA\u001b\u0007A\u0002yD3\u0001D+\\\u0003\u0019\u0019X\r\u001e+pYR\u0019\u0001.!\u000b\t\u000b)l\u0001\u0019\u0001@)\u00075)6,A\u0005tKR\u001cv\u000e\u001c<feR\u0019\u0001.!\r\t\u000b)t\u0001\u0019A$)\u00079)6,A\u0004tKR\u001cV-\u001a3\u0015\u0007!\fI\u0004\u0003\u0004k\u001f\u0001\u0007\u00111\b\t\u0004Y\u0006u\u0012bAA \u001b\n!Aj\u001c8hQ\ryQkW\u0001\u0006iJ\f\u0017N\u001c\u000b\u0004a\u0005\u001d\u0003bBA%!\u0001\u0007\u00111J\u0001\bI\u0006$\u0018m]3ua\u0011\ti%!\u0018\u0011\r\u0005=\u0013QKA-\u001b\t\t\tFC\u0002\u0002Tu\t1a]9m\u0013\u0011\t9&!\u0015\u0003\u000f\u0011\u000bG/Y:fiB!\u00111LA/\u0019\u0001!A\"a\u0018\u0002H\u0005\u0005\t\u0011!B\u0001\u0003C\u00121a\u0018\u00132#\u0011\t\u0019'!\u001b\u0011\u00071\f)'C\u0002\u0002h5\u0013qAT8uQ&tw\rE\u0002m\u0003WJ1!!\u001cN\u0005\r\te._\u0001\u0005G>\u0004\u0018\u0010F\u00020\u0003gBq!!\u001e\u0012\u0001\u0004\t9(A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002z\u0005}TBAA>\u0015\r\tihG\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0003\u0003\u000bYH\u0001\u0005QCJ\fW.T1qQ\r\tRkW\u0001\u0012KN$\u0018.\\1uK6{G-\u001a7TSj,G\u0003BA\u001e\u0003\u0013Cq!!\u0013\u0013\u0001\u0004\tY\t\r\u0003\u0002\u000e\u0006E\u0005CBA(\u0003+\ny\t\u0005\u0003\u0002\\\u0005EE\u0001DAJ\u0003\u0013\u000b\t\u0011!A\u0003\u0002\u0005\u0005$aA0%e!\u001a\u0001!V.\u0002\u0017\u0019k%+Z4sKN\u001cxN\u001d\t\u0003MQ\u0019r\u0001FAO\u0003G\u000bI\u000bE\u0002m\u0003?K1!!)N\u0005\u0019\te.\u001f*fMB!!(!*0\u0013\r\t9k\u000f\u0002\u0016\t\u00164\u0017-\u001e7u!\u0006\u0014\u0018-\\:SK\u0006$\u0017M\u00197f!\u0011\tY+!.\u000e\u0005\u00055&\u0002BAX\u0003c\u000b!![8\u000b\u0005\u0005M\u0016\u0001\u00026bm\u0006LA!a.\u0002.\na1+\u001a:jC2L'0\u00192mKR\u0011\u0011\u0011T\u0001\u0005Y>\fG\rF\u00020\u0003\u007fCa!!1\u0017\u0001\u00049\u0015\u0001\u00029bi\"D3AF+\\\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\tI\r\u0005\u0003\u0002L\u0006EWBAAg\u0015\u0011\ty-!-\u0002\t1\fgnZ\u0005\u0005\u0003'\fiM\u0001\u0004PE*,7\r\u001e\u0015\u0004)U[\u0006fA\nV7\u0002")
public class FMRegressor
extends Regressor<org.apache.spark.ml.linalg.Vector, FMRegressor, FMRegressionModel>
implements FactorizationMachines,
FMRegressorParams,
DefaultParamsWritable {
    private final String uid;
    private IntParam factorSize;
    private BooleanParam fitLinear;
    private DoubleParam miniBatchFraction;
    private DoubleParam initStd;
    private Param<String> solver;
    private Param<String> weightCol;
    private DoubleParam regParam;
    private BooleanParam fitIntercept;
    private LongParam seed;
    private DoubleParam tol;
    private DoubleParam stepSize;
    private IntParam maxIter;

    public static FMRegressor load(String path) {
        return FMRegressor$.MODULE$.load(path);
    }

    public static MLReader<FMRegressor> read() {
        return FMRegressor$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public Vector initCoefficients(int numFeatures) {
        return FactorizationMachines.initCoefficients$(this, numFeatures);
    }

    @Override
    public Tuple2<org.apache.spark.ml.linalg.Vector, double[]> trainImpl(RDD<Tuple2<Object, Vector>> data, int numFeatures, String loss) {
        return FactorizationMachines.trainImpl$(this, data, numFeatures, loss);
    }

    @Override
    public final int getFactorSize() {
        return FactorizationMachinesParams.getFactorSize$(this);
    }

    @Override
    public final boolean getFitLinear() {
        return FactorizationMachinesParams.getFitLinear$(this);
    }

    @Override
    public final double getMiniBatchFraction() {
        return FactorizationMachinesParams.getMiniBatchFraction$(this);
    }

    @Override
    public final double getInitStd() {
        return FactorizationMachinesParams.getInitStd$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final IntParam factorSize() {
        return this.factorSize;
    }

    @Override
    public final BooleanParam fitLinear() {
        return this.fitLinear;
    }

    @Override
    public final DoubleParam miniBatchFraction() {
        return this.miniBatchFraction;
    }

    @Override
    public final DoubleParam initStd() {
        return this.initStd;
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$factorSize_$eq(IntParam x$1) {
        this.factorSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$fitLinear_$eq(BooleanParam x$1) {
        this.fitLinear = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$miniBatchFraction_$eq(DoubleParam x$1) {
        this.miniBatchFraction = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$initStd_$eq(DoubleParam x$1) {
        this.initStd = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public FMRegressor setFactorSize(int value) {
        return (FMRegressor)this.set(this.factorSize(), BoxesRunTime.boxToInteger((int)value));
    }

    public FMRegressor setFitIntercept(boolean value) {
        return (FMRegressor)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public FMRegressor setFitLinear(boolean value) {
        return (FMRegressor)this.set(this.fitLinear(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public FMRegressor setRegParam(double value) {
        return (FMRegressor)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMRegressor setMiniBatchFraction(double value) {
        return (FMRegressor)this.set(this.miniBatchFraction(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMRegressor setInitStd(double value) {
        return (FMRegressor)this.set(this.initStd(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMRegressor setMaxIter(int value) {
        return (FMRegressor)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public FMRegressor setStepSize(double value) {
        return (FMRegressor)this.set(this.stepSize(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMRegressor setTol(double value) {
        return (FMRegressor)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMRegressor setSolver(String value) {
        return (FMRegressor)this.set(this.solver(), value);
    }

    public FMRegressor setSeed(long value) {
        return (FMRegressor)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    @Override
    public FMRegressionModel train(Dataset<?> dataset) {
        return (FMRegressionModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable)instr -> {
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Param[]{this.factorSize(), this.fitIntercept(), this.fitLinear(), this.regParam(), this.miniBatchFraction(), this.initStd(), this.maxIter(), this.stepSize(), this.tol(), this.solver()}));
            int numFeatures = DatasetUtils$.MODULE$.getNumFeatures(dataset, this.$(this.featuresCol()));
            instr.logNumFeatures(numFeatures);
            StorageLevel storageLevel = dataset.storageLevel();
            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
            boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
            RDD data = dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.checkRegressionLabels(this.$(this.labelCol())), DatasetUtils$.MODULE$.checkNonNanVectors(this.$(this.featuresCol()))})).rdd().map((Function1 & Serializable)x0$1 -> {
                Some some;
                Row row = x0$1;
                if (row != null && !(some = Row$.MODULE$.unapplySeq(row)).isEmpty() && some.get() != null && ((SeqOps)some.get()).lengthCompare(2) == 0) {
                    Object l = ((SeqOps)some.get()).apply(0);
                    Object v = ((SeqOps)some.get()).apply(1);
                    if (l instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)l);
                        if (v instanceof org.apache.spark.ml.linalg.Vector) {
                            org.apache.spark.ml.linalg.Vector vector = (org.apache.spark.ml.linalg.Vector)v;
                            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)d), (Object)Vectors$.MODULE$.fromML(vector));
                        }
                    }
                }
                throw new MatchError((Object)row);
            }, ClassTag$.MODULE$.apply(Tuple2.class)).setName("training instances");
            Object object = handlePersistence ? data.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
            Tuple2<org.apache.spark.ml.linalg.Vector, double[]> tuple2 = this.trainImpl((RDD<Tuple2<Object, Vector>>)data, numFeatures, FactorizationMachines$.MODULE$.SquaredError());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            org.apache.spark.ml.linalg.Vector coefficients = (org.apache.spark.ml.linalg.Vector)tuple2._1();
            org.apache.spark.ml.linalg.Vector coefficients2 = coefficients;
            Tuple3<Object, org.apache.spark.ml.linalg.Vector, Matrix> tuple3 = FactorizationMachines$.MODULE$.splitCoefficients(coefficients2, numFeatures, BoxesRunTime.unboxToInt((Object)this.$(this.factorSize())), BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), BoxesRunTime.unboxToBoolean((Object)this.$(this.fitLinear())));
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            double intercept = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            org.apache.spark.ml.linalg.Vector linear = (org.apache.spark.ml.linalg.Vector)tuple3._2();
            Matrix factors = (Matrix)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)intercept), (Object)linear, (Object)factors);
            double intercept2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
            org.apache.spark.ml.linalg.Vector linear2 = (org.apache.spark.ml.linalg.Vector)tuple32._2();
            Matrix factors2 = (Matrix)tuple32._3();
            Object object2 = handlePersistence ? data.unpersist(data.unpersist$default$1()) : BoxedUnit.UNIT;
            return this.copyValues(new FMRegressionModel(this.uid(), intercept2, linear2, factors2), this.copyValues$default$2());
        });
    }

    @Override
    public FMRegressor copy(ParamMap extra) {
        return (FMRegressor)this.defaultCopy(extra);
    }

    @Override
    public long estimateModelSize(Dataset<?> dataset) {
        int numFeatures = DatasetUtils$.MODULE$.getNumFeatures(dataset, this.$(this.featuresCol()));
        long size = this.estimateMatadataSize();
        size += org.apache.spark.ml.linalg.Vectors$.MODULE$.getDenseSize((long)numFeatures);
        return size += Matrices$.MODULE$.getDenseSize((long)numFeatures, (long)BoxesRunTime.unboxToInt((Object)this.$(this.factorSize())));
    }

    public FMRegressor(String uid) {
        this.uid = uid;
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasTol.$init$(this);
        HasSolver.$init$(this);
        HasSeed.$init$(this);
        HasFitIntercept.$init$(this);
        HasRegParam.$init$(this);
        HasWeightCol.$init$(this);
        FactorizationMachinesParams.$init$(this);
        FactorizationMachines.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        Statics.releaseFence();
    }

    public FMRegressor() {
        this(Identifiable$.MODULE$.randomUID("fmr"));
    }
}

