/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.identity;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.datanucleus.exceptions.NucleusUserException;

public abstract class SingleFieldId<T>
implements Externalizable,
Comparable {
    protected static final String STRING_DELIMITER = ":";
    protected String targetClassName;
    protected int hashCode;

    protected SingleFieldId(Class pcClass) {
        if (pcClass == null) {
            throw new NullPointerException();
        }
        this.targetClassName = pcClass.getName();
    }

    public SingleFieldId() {
    }

    protected void assertKeyNotNull(Object key) {
        if (key == null) {
            throw new NucleusUserException("Cannot have an identity with null key");
        }
    }

    public String getTargetClassName() {
        return this.targetClassName;
    }

    public abstract T getKeyAsObject();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SingleFieldId other = (SingleFieldId)obj;
        return this.targetClassName.equals(other.targetClassName);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.targetClassName);
        out.writeInt(this.hashCode);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.targetClassName = (String)in.readObject();
        this.hashCode = in.readInt();
    }

    protected int compare(SingleFieldId o) {
        return this.targetClassName.compareTo(o.targetClassName);
    }
}

