/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.DynamicValue;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicValueDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

public class ExprNodeDynamicValueEvaluator
extends ExprNodeEvaluator<ExprNodeDynamicValueDesc> {
    transient ObjectInspector oi;

    public ExprNodeDynamicValueEvaluator(ExprNodeDynamicValueDesc expr, Configuration conf) {
        super(expr, conf);
        this.oi = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)expr.getWritableObjectInspector(), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
    }

    @Override
    public ObjectInspector initialize(ObjectInspector rowInspector) throws HiveException {
        return this.oi;
    }

    @Override
    protected Object _evaluate(Object row, int version) throws HiveException {
        DynamicValue dynamicValue = ((ExprNodeDynamicValueDesc)this.expr).getDynamicValue();
        dynamicValue.setConf(this.conf);
        return dynamicValue.getWritableValue();
    }
}

