/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.package$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.streaming.ListStateImpl;
import org.apache.spark.sql.execution.streaming.ListStateImplWithTTL;
import org.apache.spark.sql.execution.streaming.MapStateImpl;
import org.apache.spark.sql.execution.streaming.MapStateImplWithTTL;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution$;
import org.apache.spark.sql.execution.streaming.QueryInfoImpl;
import org.apache.spark.sql.execution.streaming.StatefulProcessorHandleImpl$;
import org.apache.spark.sql.execution.streaming.StatefulProcessorHandleImplBase;
import org.apache.spark.sql.execution.streaming.StatefulProcessorHandleState$;
import org.apache.spark.sql.execution.streaming.StreamExecution$;
import org.apache.spark.sql.execution.streaming.TTLState;
import org.apache.spark.sql.execution.streaming.TWSMetricsUtils$;
import org.apache.spark.sql.execution.streaming.TimerStateImpl;
import org.apache.spark.sql.execution.streaming.ValueStateImpl;
import org.apache.spark.sql.execution.streaming.ValueStateImplWithTTL;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.streaming.ListState;
import org.apache.spark.sql.streaming.MapState;
import org.apache.spark.sql.streaming.QueryInfo;
import org.apache.spark.sql.streaming.TTLConfig;
import org.apache.spark.sql.streaming.TimeMode;
import org.apache.spark.sql.streaming.ValueState;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t%f\u0001B\u0013'\u0001MB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"Aa\n\u0001B\u0001B\u0003%q\n\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003_\u0011!\u0019\u0007A!A!\u0002\u0013!\u0007\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011\u00025\t\u00119\u0004!\u0011!Q\u0001\n=Dq!a\u0002\u0001\t\u0003\tI\u0001\u0003\u0006\u0002\u001c\u0001\u0011\r\u0011\"\u0001+\u0003;A\u0001\"a\u000b\u0001A\u0003%\u0011q\u0004\u0005\n\u0003[\u0001!\u0019!C\u0005\u0003_A\u0001\"a\u000f\u0001A\u0003%\u0011\u0011\u0007\u0005\b\u0003{\u0001A\u0011BA \u0011)\t9\u0005\u0001EC\u0002\u0013%\u0011\u0011\n\u0005\b\u0003\u0017\u0002A\u0011IA \u0011)\ti\u0005\u0001EC\u0002\u0013%\u0011q\n\u0005\b\u0003/\u0002A\u0011IA-\u0011\u001d\t)\u0007\u0001C!\u0003OBq!a\u001b\u0001\t\u0003\ti\u0007C\u0004\u0002\n\u0002!\t!a#\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\"9\u00111\u0013\u0001\u0005B\u0005U\u0005bBAN\u0001\u0011\u0005\u0013Q\u0014\u0005\b\u00037\u0003A\u0011IAh\u0011\u001d\t)\u000f\u0001C!\u0003ODq!!:\u0001\t\u0003\ni\u0010C\u0004\u0003\u0014\u0001!\tE!\u0006\t\u000f\tM\u0001\u0001\"\u0011\u0003:!9!\u0011\f\u0001\u0005\n\tms!\u0003B1M\u0005\u0005\t\u0012\u0001B2\r!)c%!A\t\u0002\t\u0015\u0004bBA\u0004?\u0011\u0005!\u0011\u0010\u0005\n\u0005wz\u0012\u0013!C\u0001\u0005{B\u0011Ba% #\u0003%\tA!&\t\u0013\teu$%A\u0005\u0002\tm\u0005\"\u0003BP?\u0005\u0005I\u0011\u0002BQ\u0005m\u0019F/\u0019;fMVd\u0007K]8dKN\u001cxN\u001d%b]\u0012dW-S7qY*\u0011q\u0005K\u0001\ngR\u0014X-Y7j]\u001eT!!\u000b\u0016\u0002\u0013\u0015DXmY;uS>t'BA\u0016-\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003[9\nQa\u001d9be.T!a\f\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0014aA8sO\u000e\u00011c\u0001\u00015qA\u0011QGN\u0007\u0002M%\u0011qG\n\u0002 'R\fG/\u001a4vYB\u0013xnY3tg>\u0014\b*\u00198eY\u0016LU\u000e\u001d7CCN,\u0007CA\u001d=\u001b\u0005Q$BA\u001e-\u0003!Ig\u000e^3s]\u0006d\u0017BA\u001f;\u0005\u001daunZ4j]\u001e\fQa\u001d;pe\u0016\u0004\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0014\u0002\u000bM$\u0018\r^3\n\u0005\u0011\u000b%AC*uCR,7\u000b^8sK\u0006)!/\u001e8JIB\u0011q\tT\u0007\u0002\u0011*\u0011\u0011JS\u0001\u0005kRLGNC\u0001L\u0003\u0011Q\u0017M^1\n\u00055C%\u0001B+V\u0013\u0012\u000b!b[3z\u000b:\u001cw\u000eZ3s!\r\u0001VkV\u0007\u0002#*\u0011!kU\u0001\tK:\u001cw\u000eZ3sg*\u0011AKK\u0001\tG\u0006$\u0018\r\\=ti&\u0011a+\u0015\u0002\u0012\u000bb\u0004(/Z:tS>tWI\\2pI\u0016\u0014\bC\u0001-\\\u001b\u0005I&\"\u0001.\u0002\u000bM\u001c\u0017\r\\1\n\u0005qK&aA!os\u0006AA/[7f\u001b>$W\r\u0005\u0002`C6\t\u0001M\u0003\u0002(U%\u0011!\r\u0019\u0002\t)&lW-T8eK\u0006Y\u0011n]*ue\u0016\fW.\u001b8h!\tAV-\u0003\u0002g3\n9!i\\8mK\u0006t\u0017\u0001\u00052bi\u000eDG+[7fgR\fW\u000e]'t!\rA\u0016n[\u0005\u0003Uf\u0013aa\u00149uS>t\u0007C\u0001-m\u0013\ti\u0017L\u0001\u0003M_:<\u0017aB7fiJL7m\u001d\t\u0005a^TXP\u0004\u0002rkB\u0011!/W\u0007\u0002g*\u0011AOM\u0001\u0007yI|w\u000e\u001e \n\u0005YL\u0016A\u0002)sK\u0012,g-\u0003\u0002ys\n\u0019Q*\u00199\u000b\u0005YL\u0006C\u00019|\u0013\ta\u0018P\u0001\u0004TiJLgn\u001a\t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005\u0001&\u0001\u0004nKR\u0014\u0018nY\u0005\u0004\u0003\u000by(!C*R\u00196+GO]5d\u0003\u0019a\u0014N\\5u}Q\u0001\u00121BA\u0007\u0003\u001f\t\t\"a\u0005\u0002\u0016\u0005]\u0011\u0011\u0004\t\u0003k\u0001AQA\u0010\u0005A\u0002}BQ!\u0012\u0005A\u0002\u0019CQA\u0014\u0005A\u0002=CQ!\u0018\u0005A\u0002yCqa\u0019\u0005\u0011\u0002\u0003\u0007A\rC\u0004h\u0011A\u0005\t\u0019\u00015\t\u000f9D\u0001\u0013!a\u0001_\u0006IA\u000f\u001e7Ti\u0006$Xm]\u000b\u0003\u0003?\u0001RaRA\u0011\u0003KI1!a\tI\u0005\u0011a\u0015n\u001d;\u0011\u0007U\n9#C\u0002\u0002*\u0019\u0012\u0001\u0002\u0016+M'R\fG/Z\u0001\u000biRd7\u000b^1uKN\u0004\u0013A\u0004\"B)\u000eCu,U+F%f{\u0016\nR\u000b\u0003\u0003c\u0001B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003oQ\u0015\u0001\u00027b]\u001eL1\u0001`A\u001b\u0003=\u0011\u0015\tV\"I?F+VIU-`\u0013\u0012\u0003\u0013A\u00042vS2$\u0017+^3ss&sgm\u001c\u000b\u0003\u0003\u0003\u00022aXA\"\u0013\r\t)\u0005\u0019\u0002\n#V,'/_%oM>\fQbY;seF+XM]=J]\u001a|WCAA!\u000319W\r^)vKJL\u0018J\u001c4p\u0003)!\u0018.\\3s'R\fG/Z\u000b\u0003\u0003#\u00022!NA*\u0013\r\t)F\n\u0002\u000f)&lWM]*uCR,\u0017*\u001c9m\u00035\u0011XmZ5ti\u0016\u0014H+[7feR!\u00111LA1!\rA\u0016QL\u0005\u0004\u0003?J&\u0001B+oSRDa!a\u0019\u0012\u0001\u0004Y\u0017!E3ya&\u0014\u0018\u0010V5nKN$\u0018-\u001c9Ng\u0006YA-\u001a7fi\u0016$\u0016.\\3s)\u0011\tY&!\u001b\t\r\u0005\r$\u00031\u0001l\u0003A9W\r^#ya&\u0014X\r\u001a+j[\u0016\u00148\u000f\u0006\u0003\u0002p\u0005\u001d\u0005CBA9\u0003w\n\tI\u0004\u0003\u0002t\u0005]db\u0001:\u0002v%\t!,C\u0002\u0002ze\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002~\u0005}$\u0001C%uKJ\fGo\u001c:\u000b\u0007\u0005e\u0014\fE\u0003Y\u0003\u0007;6.C\u0002\u0002\u0006f\u0013a\u0001V;qY\u0016\u0014\u0004BBA2'\u0001\u00071.\u0001\u0006mSN$H+[7feN$\"!!$\u0011\u000b\u0005E\u00141P6\u0002\u0019\u0011|G\u000b\u001e7DY\u0016\fg.\u001e9\u0015\u0005\u0005m\u0013A\u00043fY\u0016$X-\u00134Fq&\u001cHo\u001d\u000b\u0005\u00037\n9\n\u0003\u0004\u0002\u001aZ\u0001\rA_\u0001\ngR\fG/\u001a(b[\u0016\fQbZ3u-\u0006dW/Z*uCR,W\u0003BAP\u0003W#\u0002\"!)\u00028\u0006e\u0016Q\u0019\t\u0006?\u0006\r\u0016qU\u0005\u0004\u0003K\u0003'A\u0003,bYV,7\u000b^1uKB!\u0011\u0011VAV\u0019\u0001!q!!,\u0018\u0005\u0004\tyKA\u0001U#\r\t\tl\u0016\t\u00041\u0006M\u0016bAA[3\n9aj\u001c;iS:<\u0007BBAM/\u0001\u0007!\u0010C\u0004\u0002<^\u0001\r!!0\u0002\u0015Y\fG.\u00128d_\u0012,'\u000f\u0005\u0004\u0002@\u0006\u0005\u0017qU\u0007\u0002U%\u0019\u00111\u0019\u0016\u0003\u000f\u0015s7m\u001c3fe\"9\u0011qY\fA\u0002\u0005%\u0017!\u0003;uY\u000e{gNZ5h!\ry\u00161Z\u0005\u0004\u0003\u001b\u0004'!\u0003+U\u0019\u000e{gNZ5h+\u0011\t\t.!7\u0015\r\u0005M\u0017\u0011]Ar)\u0011\t).a7\u0011\u000b}\u000b\u0019+a6\u0011\t\u0005%\u0016\u0011\u001c\u0003\b\u0003[C\"\u0019AAX\u0011%\ti\u000eGA\u0001\u0002\b\ty.\u0001\u0006fm&$WM\\2fIE\u0002b!a0\u0002B\u0006]\u0007BBAM1\u0001\u0007!\u0010C\u0004\u0002Hb\u0001\r!!3\u0002\u0019\u001d,G\u000fT5tiN#\u0018\r^3\u0016\t\u0005%\u00181\u001f\u000b\t\u0003W\f)0a>\u0002|B)q,!<\u0002r&\u0019\u0011q\u001e1\u0003\u00131K7\u000f^*uCR,\u0007\u0003BAU\u0003g$q!!,\u001a\u0005\u0004\ty\u000b\u0003\u0004\u0002\u001af\u0001\rA\u001f\u0005\b\u0003wK\u0002\u0019AA}!\u0019\ty,!1\u0002r\"9\u0011qY\rA\u0002\u0005%W\u0003BA\u0000\u0005\u000f!bA!\u0001\u0003\u0010\tEA\u0003\u0002B\u0002\u0005\u0013\u0001RaXAw\u0005\u000b\u0001B!!+\u0003\b\u00119\u0011Q\u0016\u000eC\u0002\u0005=\u0006\"\u0003B\u00065\u0005\u0005\t9\u0001B\u0007\u0003))g/\u001b3f]\u000e,GE\r\t\u0007\u0003\u007f\u000b\tM!\u0002\t\r\u0005e%\u00041\u0001{\u0011\u001d\t9M\u0007a\u0001\u0003\u0013\f1bZ3u\u001b\u0006\u00048\u000b^1uKV1!q\u0003B\u0011\u0005O!\"B!\u0007\u0003,\t5\"1\u0007B\u001c!\u001dy&1\u0004B\u0010\u0005KI1A!\ba\u0005!i\u0015\r]*uCR,\u0007\u0003BAU\u0005C!qAa\t\u001c\u0005\u0004\tyKA\u0001L!\u0011\tIKa\n\u0005\u000f\t%2D1\u0001\u00020\n\ta\u000b\u0003\u0004\u0002\u001an\u0001\rA\u001f\u0005\b\u0005_Y\u0002\u0019\u0001B\u0019\u0003))8/\u001a:LKf,en\u0019\t\u0007\u0003\u007f\u000b\tMa\b\t\u000f\u0005m6\u00041\u0001\u00036A1\u0011qXAa\u0005KAq!a2\u001c\u0001\u0004\tI-\u0006\u0004\u0003<\t\r#q\t\u000b\u0007\u0005{\u0011)Fa\u0016\u0015\r\t}\"\u0011\nB(!\u001dy&1\u0004B!\u0005\u000b\u0002B!!+\u0003D\u00119!1\u0005\u000fC\u0002\u0005=\u0006\u0003BAU\u0005\u000f\"qA!\u000b\u001d\u0005\u0004\ty\u000bC\u0005\u0003Lq\t\t\u0011q\u0001\u0003N\u0005QQM^5eK:\u001cW\rJ\u001a\u0011\r\u0005}\u0016\u0011\u0019B!\u0011%\u0011\t\u0006HA\u0001\u0002\b\u0011\u0019&\u0001\u0006fm&$WM\\2fIQ\u0002b!a0\u0002B\n\u0015\u0003BBAM9\u0001\u0007!\u0010C\u0004\u0002Hr\u0001\r!!3\u0002#Y\fG.\u001b3bi\u0016$F\u000bT\"p]\u001aLw\r\u0006\u0004\u0002\\\tu#q\f\u0005\b\u0003\u000fl\u0002\u0019AAe\u0011\u0019\tI*\ba\u0001u\u0006Y2\u000b^1uK\u001a,H\u000e\u0015:pG\u0016\u001c8o\u001c:IC:$G.Z%na2\u0004\"!N\u0010\u0014\u000b}\u00119G!\u001c\u0011\u0007a\u0013I'C\u0002\u0003le\u0013a!\u00118z%\u00164\u0007\u0003\u0002B8\u0005kj!A!\u001d\u000b\u0007\tM$*\u0001\u0002j_&!!q\u000fB9\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\u0011\u0019'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u0005\u007fR3\u0001\u001aBAW\t\u0011\u0019\t\u0005\u0003\u0003\u0006\n=UB\u0001BD\u0015\u0011\u0011IIa#\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BG3\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tE%q\u0011\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c'\u0006\u0002\u0003\u0018*\u001a\u0001N!!\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011iJK\u0002p\u0005\u0003\u000bAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa)\u0011\t\u0005M\"QU\u0005\u0005\u0005O\u000b)D\u0001\u0004PE*,7\r\u001e")
public class StatefulProcessorHandleImpl
extends StatefulProcessorHandleImplBase
implements Logging {
    private QueryInfo currQueryInfo;
    private TimerStateImpl timerState;
    private final StateStore store;
    private final UUID runId;
    private final ExpressionEncoder<Object> keyEncoder;
    private final TimeMode timeMode;
    private final boolean isStreaming;
    private final Option<Object> batchTimestampMs;
    private final scala.collection.immutable.Map<String, SQLMetric> metrics;
    private final List<TTLState> ttlStates;
    private final String BATCH_QUERY_ID;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static scala.collection.immutable.Map<String, SQLMetric> $lessinit$greater$default$7() {
        return StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<Object> $lessinit$greater$default$6() {
        return StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$6();
    }

    public static boolean $lessinit$greater$default$5() {
        return StatefulProcessorHandleImpl$.MODULE$.$lessinit$greater$default$5();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public List<TTLState> ttlStates() {
        return this.ttlStates;
    }

    private String BATCH_QUERY_ID() {
        return this.BATCH_QUERY_ID;
    }

    private QueryInfo buildQueryInfo() {
        Tuple2 tuple2;
        Option taskCtxOpt = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
        if (!this.isStreaming) {
            v0 = new Tuple2((Object)this.BATCH_QUERY_ID(), (Object)BoxesRunTime.boxToLong((long)0L));
        } else if (taskCtxOpt.isDefined()) {
            v0 = new Tuple2((Object)((TaskContext)taskCtxOpt.get()).getLocalProperty(StreamExecution$.MODULE$.QUERY_ID_KEY()), (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(((TaskContext)taskCtxOpt.get()).getLocalProperty(MicroBatchExecution$.MODULE$.BATCH_ID_KEY())))));
        } else {
            Predef$.MODULE$.assert(Utils$.MODULE$.isTesting(), (Function0 & Serializable)() -> "Failed to find query id/batch Id in task context");
            v0 = tuple2 = new Tuple2((Object)UUID.randomUUID().toString(), (Object)BoxesRunTime.boxToLong((long)0L));
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String queryId = (String)tuple2._1();
        long batchId = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)queryId, (Object)BoxesRunTime.boxToLong((long)batchId));
        String queryId2 = (String)tuple22._1();
        long batchId2 = tuple22._2$mcJ$sp();
        return new QueryInfoImpl(UUID.fromString(queryId2), this.runId, batchId2);
    }

    private QueryInfo currQueryInfo$lzycompute() {
        StatefulProcessorHandleImpl statefulProcessorHandleImpl = this;
        synchronized (statefulProcessorHandleImpl) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.currQueryInfo = this.buildQueryInfo();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.currQueryInfo;
    }

    private QueryInfo currQueryInfo() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.currQueryInfo$lzycompute();
        }
        return this.currQueryInfo;
    }

    public QueryInfo getQueryInfo() {
        return this.currQueryInfo();
    }

    private TimerStateImpl timerState$lzycompute() {
        StatefulProcessorHandleImpl statefulProcessorHandleImpl = this;
        synchronized (statefulProcessorHandleImpl) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.timerState = new TimerStateImpl(this.store, this.timeMode, this.keyEncoder);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.timerState;
    }

    private TimerStateImpl timerState() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.timerState$lzycompute();
        }
        return this.timerState;
    }

    public void registerTimer(long expiryTimestampMs) {
        this.verifyTimerOperations("register_timer");
        this.timerState().registerTimer(expiryTimestampMs);
        TWSMetricsUtils$.MODULE$.incrementMetric(this.metrics, "numRegisteredTimers", TWSMetricsUtils$.MODULE$.incrementMetric$default$3());
    }

    public void deleteTimer(long expiryTimestampMs) {
        this.verifyTimerOperations("delete_timer");
        this.timerState().deleteTimer(expiryTimestampMs);
        TWSMetricsUtils$.MODULE$.incrementMetric(this.metrics, "numDeletedTimers", TWSMetricsUtils$.MODULE$.incrementMetric$default$3());
    }

    public Iterator<Tuple2<Object, Object>> getExpiredTimers(long expiryTimestampMs) {
        this.verifyTimerOperations("get_expired_timers");
        return this.timerState().getExpiredTimers(expiryTimestampMs);
    }

    public Iterator<Object> listTimers() {
        this.verifyTimerOperations("list_timers");
        return this.timerState().listTimers();
    }

    public void doTtlCleanup() {
        SQLMetric numValuesRemovedDueToTTLExpiry = (SQLMetric)((Object)this.metrics.get((Object)"numValuesRemovedDueToTTLExpiry").get());
        this.ttlStates().forEach(s -> numValuesRemovedDueToTTLExpiry.$plus$eq(s.clearExpiredStateForAllKeys()));
    }

    public void deleteIfExists(String stateName) {
        this.verifyStateVarOperations("delete_if_exists", StatefulProcessorHandleState$.MODULE$.CREATED());
        if (this.store.removeColFamilyIfExists(stateName)) {
            TWSMetricsUtils$.MODULE$.incrementMetric(this.metrics, "numDeletedStateVars", TWSMetricsUtils$.MODULE$.incrementMetric$default$3());
            return;
        }
    }

    public <T> ValueState<T> getValueState(String stateName, Encoder<T> valEncoder, TTLConfig ttlConfig) {
        return this.getValueState(stateName, ttlConfig, valEncoder);
    }

    public <T> ValueState<T> getValueState(String stateName, TTLConfig ttlConfig, Encoder<T> evidence$1) {
        Object object;
        this.verifyStateVarOperations("get_value_state", StatefulProcessorHandleState$.MODULE$.CREATED());
        boolean ttlEnabled = ttlConfig.ttlDuration() == null || !ttlConfig.ttlDuration().isZero();
        ExpressionEncoder stateEncoder = package$.MODULE$.encoderFor(evidence$1);
        if (ttlEnabled) {
            this.validateTTLConfig(ttlConfig, stateName);
            Predef$.MODULE$.assert(this.batchTimestampMs.isDefined());
            ValueStateImplWithTTL valueStateWithTTL = new ValueStateImplWithTTL(this.store, stateName, this.keyEncoder, (ExpressionEncoder<Object>)stateEncoder, ttlConfig, BoxesRunTime.unboxToLong((Object)this.batchTimestampMs.get()), this.metrics);
            this.ttlStates().add(valueStateWithTTL);
            TWSMetricsUtils$.MODULE$.incrementMetric(this.metrics, "numValueStateWithTTLVars", TWSMetricsUtils$.MODULE$.incrementMetric$default$3());
            object = valueStateWithTTL;
        } else {
            ValueStateImpl valueStateWithoutTTL = new ValueStateImpl(this.store, stateName, this.keyEncoder, (ExpressionEncoder<Object>)stateEncoder, this.metrics);
            TWSMetricsUtils$.MODULE$.incrementMetric(this.metrics, "numValueStateVars", TWSMetricsUtils$.MODULE$.incrementMetric$default$3());
            object = valueStateWithoutTTL;
        }
        ValueStateImpl result = object;
        return result;
    }

    public <T> ListState<T> getListState(String stateName, Encoder<T> valEncoder, TTLConfig ttlConfig) {
        return this.getListState(stateName, ttlConfig, valEncoder);
    }

    public <T> ListState<T> getListState(String stateName, TTLConfig ttlConfig, Encoder<T> evidence$2) {
        Object object;
        this.verifyStateVarOperations("get_list_state", StatefulProcessorHandleState$.MODULE$.CREATED());
        boolean ttlEnabled = ttlConfig.ttlDuration() == null || !ttlConfig.ttlDuration().isZero();
        ExpressionEncoder stateEncoder = package$.MODULE$.encoderFor(evidence$2);
        if (ttlEnabled) {
            this.validateTTLConfig(ttlConfig, stateName);
            Predef$.MODULE$.assert(this.batchTimestampMs.isDefined());
            ListStateImplWithTTL listStateWithTTL = new ListStateImplWithTTL(this.store, stateName, this.keyEncoder, (ExpressionEncoder<Object>)stateEncoder, ttlConfig, BoxesRunTime.unboxToLong((Object)this.batchTimestampMs.get()), this.metrics);
            TWSMetricsUtils$.MODULE$.incrementMetric(this.metrics, "numListStateWithTTLVars", TWSMetricsUtils$.MODULE$.incrementMetric$default$3());
            this.ttlStates().add(listStateWithTTL);
            object = listStateWithTTL;
        } else {
            ListStateImpl listStateWithoutTTL = new ListStateImpl(this.store, stateName, this.keyEncoder, (ExpressionEncoder<Object>)stateEncoder, this.metrics);
            TWSMetricsUtils$.MODULE$.incrementMetric(this.metrics, "numListStateVars", TWSMetricsUtils$.MODULE$.incrementMetric$default$3());
            object = listStateWithoutTTL;
        }
        ListStateImpl result = object;
        return result;
    }

    public <K, V> MapState<K, V> getMapState(String stateName, Encoder<K> userKeyEnc, Encoder<V> valEncoder, TTLConfig ttlConfig) {
        return this.getMapState(stateName, ttlConfig, userKeyEnc, valEncoder);
    }

    public <K, V> MapState<K, V> getMapState(String stateName, TTLConfig ttlConfig, Encoder<K> evidence$3, Encoder<V> evidence$4) {
        Object object;
        this.verifyStateVarOperations("get_map_state", StatefulProcessorHandleState$.MODULE$.CREATED());
        boolean ttlEnabled = ttlConfig.ttlDuration() == null || !ttlConfig.ttlDuration().isZero();
        ExpressionEncoder userKeyEnc = package$.MODULE$.encoderFor(evidence$3);
        ExpressionEncoder valEncoder = package$.MODULE$.encoderFor(evidence$4);
        if (ttlEnabled) {
            this.validateTTLConfig(ttlConfig, stateName);
            Predef$.MODULE$.assert(this.batchTimestampMs.isDefined());
            MapStateImplWithTTL mapStateWithTTL = new MapStateImplWithTTL(this.store, stateName, this.keyEncoder, (ExpressionEncoder<Object>)userKeyEnc, (ExpressionEncoder<Object>)valEncoder, ttlConfig, BoxesRunTime.unboxToLong((Object)this.batchTimestampMs.get()), this.metrics);
            TWSMetricsUtils$.MODULE$.incrementMetric(this.metrics, "numMapStateWithTTLVars", TWSMetricsUtils$.MODULE$.incrementMetric$default$3());
            this.ttlStates().add(mapStateWithTTL);
            object = mapStateWithTTL;
        } else {
            MapStateImpl mapStateWithoutTTL = new MapStateImpl(this.store, stateName, this.keyEncoder, (ExpressionEncoder<Object>)userKeyEnc, (ExpressionEncoder<Object>)valEncoder, this.metrics);
            TWSMetricsUtils$.MODULE$.incrementMetric(this.metrics, "numMapStateVars", TWSMetricsUtils$.MODULE$.incrementMetric$default$3());
            object = mapStateWithoutTTL;
        }
        MapStateImpl result = object;
        return result;
    }

    private void validateTTLConfig(TTLConfig ttlConfig, String stateName) {
        Duration ttlDuration = ttlConfig.ttlDuration();
        TimeMode timeMode = this.timeMode;
        TimeMode timeMode2 = TimeMode.ProcessingTime();
        if (timeMode == null ? timeMode2 != null : !timeMode.equals(timeMode2)) {
            throw StateStoreErrors$.MODULE$.cannotProvideTTLConfigForTimeMode(stateName, this.timeMode.toString());
        }
        if (ttlDuration == null || ttlDuration.isNegative() || ttlDuration.isZero()) {
            throw StateStoreErrors$.MODULE$.ttlMustBePositive("update", stateName);
        }
    }

    public StatefulProcessorHandleImpl(StateStore store, UUID runId, ExpressionEncoder<Object> keyEncoder, TimeMode timeMode, boolean isStreaming, Option<Object> batchTimestampMs, scala.collection.immutable.Map<String, SQLMetric> metrics) {
        this.store = store;
        this.runId = runId;
        this.keyEncoder = keyEncoder;
        this.timeMode = timeMode;
        this.isStreaming = isStreaming;
        this.batchTimestampMs = batchTimestampMs;
        this.metrics = metrics;
        super(timeMode, keyEncoder);
        Logging.$init$((Logging)this);
        this.ttlStates = new ArrayList<TTLState>();
        this.BATCH_QUERY_ID = "00000000-0000-0000-0000-000000000000";
        this.currState_$eq(StatefulProcessorHandleState$.MODULE$.CREATED());
    }
}

