/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.binaryfile;

import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.binaryfile.BinaryFileFormat$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.SerializableConfiguration$;
import org.sparkproject.guava.io.ByteStreams;
import org.sparkproject.guava.io.Closeables;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\tEb\u0001\u0002\u0013&\u0001RBQ\u0001\u0016\u0001\u0005\u0002UCQ\u0001\u0017\u0001\u0005BeCq!a\u0002\u0001\t\u0003\nI\u0001C\u0004\u0002*\u0001!\t%a\u000b\t\u000f\u0005\u0005\u0003\u0001\"\u0011\u0002D!9\u0011Q\t\u0001\u0005R\u0005\u001d\u0003\u0002CAI\u0001\u0005\u0005I\u0011A+\t\u0013\u0005M\u0005!!A\u0005B\u0005U\u0005\"CAS\u0001\u0005\u0005I\u0011AAT\u0011%\ty\u000bAA\u0001\n\u0003\t\t\fC\u0005\u0002>\u0002\t\t\u0011\"\u0011\u0002@\"I\u00111\u001a\u0001\u0002\u0002\u0013\u0005\u0011Q\u001a\u0005\n\u0003#\u0004\u0011\u0011!C!\u0003'D\u0011\"a6\u0001\u0003\u0003%\t%!7\t\u0013\u0005m\u0007!!A\u0005B\u0005u\u0007\"CAp\u0001\u0005\u0005I\u0011IAq\u000f\u001d\t)/\nE\u0001\u0003O4a\u0001J\u0013\t\u0002\u0005%\bB\u0002+\u0013\t\u0003\t)\u0010\u0003\u0006\u0002xJ\u0011\r\u0011\"\u0001&\u0003+C\u0001\"!?\u0013A\u0003%\u0011q\u0013\u0005\u000b\u0003w\u0014\"\u0019!C\u0001K\u0005U\u0005\u0002CA\u007f%\u0001\u0006I!a&\t\u0015\u0005}(C1A\u0005\u0002\u0015\n)\n\u0003\u0005\u0003\u0002I\u0001\u000b\u0011BAL\u0011)\u0011\u0019A\u0005b\u0001\n\u0003)\u0013Q\u0013\u0005\t\u0005\u000b\u0011\u0002\u0015!\u0003\u0002\u0018\"Q!q\u0001\nC\u0002\u0013\u0005Q%!&\t\u0011\t%!\u0003)A\u0005\u0003/C\u0011Ba\u0003\u0013\u0005\u0004%\tA!\u0004\t\u000f\t=!\u0003)A\u0005;\"A!\u0011\u0003\n\u0005\u0002\u0015\u0012\u0019\u0002\u0003\u0005\u0003\u001eI\t\t\u0011\"!V\u0011%\u0011yBEA\u0001\n\u0003\u0013\t\u0003C\u0005\u0003(I\t\t\u0011\"\u0003\u0003*\t\u0001\")\u001b8bef4\u0015\u000e\\3G_Jl\u0017\r\u001e\u0006\u0003M\u001d\n!BY5oCJLh-\u001b7f\u0015\tA\u0013&A\u0006eCR\f7o\\;sG\u0016\u001c(B\u0001\u0016,\u0003%)\u00070Z2vi&|gN\u0003\u0002-[\u0005\u00191/\u001d7\u000b\u00059z\u0013!B:qCJ\\'B\u0001\u00192\u0003\u0019\t\u0007/Y2iK*\t!'A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001kmzT\t\u0013\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\u0005qjT\"A\u0014\n\u0005y:#A\u0003$jY\u00164uN]7biB\u0011\u0001iQ\u0007\u0002\u0003*\u0011!iK\u0001\bg>,(oY3t\u0013\t!\u0015I\u0001\nECR\f7k\\;sG\u0016\u0014VmZ5ti\u0016\u0014\bC\u0001\u001cG\u0013\t9uGA\u0004Qe>$Wo\u0019;\u0011\u0005%\u000bfB\u0001&P\u001d\tYe*D\u0001M\u0015\ti5'\u0001\u0004=e>|GOP\u0005\u0002q%\u0011\u0001kN\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00116K\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Qo\u00051A(\u001b8jiz\"\u0012A\u0016\t\u0003/\u0002i\u0011!J\u0001\fS:4WM]*dQ\u0016l\u0017\r\u0006\u0003[G&4\bc\u0001\u001c\\;&\u0011Al\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001\\\u0013!\u0002;za\u0016\u001c\u0018B\u00012`\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006I\n\u0001\r!Z\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003M\u001el\u0011aK\u0005\u0003Q.\u0012Ab\u00159be.\u001cVm]:j_:DQA\u001b\u0002A\u0002-\fqa\u001c9uS>t7\u000f\u0005\u0003maN\u001chBA7o!\tYu'\u0003\u0002po\u00051\u0001K]3eK\u001aL!!\u001d:\u0003\u00075\u000b\u0007O\u0003\u0002poA\u0011A\u000e^\u0005\u0003kJ\u0014aa\u0015;sS:<\u0007\"B<\u0003\u0001\u0004A\u0018!\u00024jY\u0016\u001c\bcA%zw&\u0011!p\u0015\u0002\u0004'\u0016\f\bc\u0001?\u0002\u00045\tQP\u0003\u0002\u007f\u007f\u0006\u0011am\u001d\u0006\u0004\u0003\u0003y\u0013A\u00025bI>|\u0007/C\u0002\u0002\u0006u\u0014!BR5mKN#\u0018\r^;t\u00031\u0001(/\u001a9be\u0016<&/\u001b;f))\tY!!\u0005\u0002\u0014\u0005\r\u0012Q\u0005\t\u0004y\u00055\u0011bAA\bO\t\u0019r*\u001e;qkR<&/\u001b;fe\u001a\u000b7\r^8ss\")Am\u0001a\u0001K\"9\u0011QC\u0002A\u0002\u0005]\u0011a\u00016pEB!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001e}\f\u0011\"\\1qe\u0016$WoY3\n\t\u0005\u0005\u00121\u0004\u0002\u0004\u0015>\u0014\u0007\"\u00026\u0004\u0001\u0004Y\u0007BBA\u0014\u0007\u0001\u0007Q,\u0001\u0006eCR\f7k\u00195f[\u0006\f1\"[:Ta2LG/\u00192mKRA\u0011QFA\u001a\u0003k\t9\u0004E\u00027\u0003_I1!!\r8\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u001a\u0003A\u0002\u0015DQA\u001b\u0003A\u0002-Dq!!\u000f\u0005\u0001\u0004\tY$\u0001\u0003qCRD\u0007c\u0001?\u0002>%\u0019\u0011qH?\u0003\tA\u000bG\u000f[\u0001\ng\"|'\u000f\u001e(b[\u0016$\u0012a]\u0001\fEVLG\u000e\u001a*fC\u0012,'\u000f\u0006\t\u0002J\u0005\u001d\u0014\u0011NA6\u0003_\n\u0019(a \u0002\u0002B9a'a\u0013\u0002P\u0005U\u0013bAA'o\tIa)\u001e8di&|g.\r\t\u0004y\u0005E\u0013bAA*O\ty\u0001+\u0019:uSRLwN\\3e\r&dW\rE\u0003J\u0003/\nY&C\u0002\u0002ZM\u0013\u0001\"\u0013;fe\u0006$xN\u001d\t\u0005\u0003;\n\u0019'\u0004\u0002\u0002`)\u0019\u0011\u0011M\u0016\u0002\u0011\r\fG/\u00197zgRLA!!\u001a\u0002`\tY\u0011J\u001c;fe:\fGNU8x\u0011\u0015!g\u00011\u0001f\u0011\u0019\t9C\u0002a\u0001;\"1\u0011Q\u000e\u0004A\u0002u\u000bq\u0002]1si&$\u0018n\u001c8TG\",W.\u0019\u0005\u0007\u0003c2\u0001\u0019A/\u0002\u001dI,\u0017/^5sK\u0012\u001c6\r[3nC\"9\u0011Q\u000f\u0004A\u0002\u0005]\u0014a\u00024jYR,'o\u001d\t\u0005\u0013f\fI\bE\u0002A\u0003wJ1!! B\u0005\u00191\u0015\u000e\u001c;fe\")!N\u0002a\u0001W\"9\u00111\u0011\u0004A\u0002\u0005\u0015\u0015A\u00035bI>|\u0007oQ8oMB!\u0011qQAG\u001b\t\tIIC\u0002\u0002\f~\fAaY8oM&!\u0011qRAE\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006!1m\u001c9z\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u0013\t\u0005\u00033\u000b\u0019+\u0004\u0002\u0002\u001c*!\u0011QTAP\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0016\u0001\u00026bm\u0006L1!^AN\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI\u000bE\u00027\u0003WK1!!,8\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019,!/\u0011\u0007Y\n),C\u0002\u00028^\u00121!\u00118z\u0011%\tYLCA\u0001\u0002\u0004\tI+A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0003\u0004b!a1\u0002J\u0006MVBAAc\u0015\r\t9mN\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA-\u0003\u000b\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003[\ty\rC\u0005\u0002<2\t\t\u00111\u0001\u00024\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t9*!6\t\u0013\u0005mV\"!AA\u0002\u0005%\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005%\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005]\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002.\u0005\r\b\"CA^!\u0005\u0005\t\u0019AAZ\u0003A\u0011\u0015N\\1ss\u001aKG.\u001a$pe6\fG\u000f\u0005\u0002X%M!!#NAv!\u0011\ti/a=\u000e\u0005\u0005=(\u0002BAy\u0003?\u000b!![8\n\u0007I\u000by\u000f\u0006\u0002\u0002h\u0006!\u0001+\u0011+I\u0003\u0015\u0001\u0016\t\u0016%!\u0003Eiu\nR%G\u0013\u000e\u000bE+S(O?RKU*R\u0001\u0013\u001b>#\u0015JR%D\u0003RKuJT0U\u00136+\u0005%\u0001\u0004M\u000b:;E\u000bS\u0001\b\u0019\u0016su\t\u0016%!\u0003\u001d\u0019uJ\u0014+F\u001dR\u000b\u0001bQ(O)\u0016sE\u000bI\u0001\f\u0005&s\u0015IU-`\r&cU)\u0001\u0007C\u0013:\u000b%+W0G\u00132+\u0005%\u0001\u0004tG\",W.Y\u000b\u0002;\u000691o\u00195f[\u0006\u0004\u0013\u0001F2sK\u0006$XMR5mi\u0016\u0014h)\u001e8di&|g\u000e\u0006\u0003\u0003\u0016\te\u0001\u0003\u0002\u001c\\\u0005/\u0001bANA&w\u00065\u0002b\u0002B\u000eA\u0001\u0007\u0011\u0011P\u0001\u0007M&dG/\u001a:\u0002\u000b\u0005\u0004\b\u000f\\=\u0002\u000fUt\u0017\r\u001d9msR!\u0011Q\u0006B\u0012\u0011!\u0011)CIA\u0001\u0002\u00041\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!1\u0006\t\u0005\u00033\u0013i#\u0003\u0003\u00030\u0005m%AB(cU\u0016\u001cG\u000f")
public class BinaryFileFormat
implements FileFormat,
DataSourceRegister,
Product,
Serializable {
    public static boolean unapply(BinaryFileFormat x$0) {
        return BinaryFileFormat$.MODULE$.unapply(x$0);
    }

    public static BinaryFileFormat apply() {
        return BinaryFileFormat$.MODULE$.apply();
    }

    public static StructType schema() {
        return BinaryFileFormat$.MODULE$.schema();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return FileFormat.supportBatch$(this, sparkSession, dataSchema);
    }

    @Override
    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.vectorTypes$(this, requiredSchema, partitionSchema, sqlConf);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReaderWithPartitionValues$(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    @Override
    public AttributeReference createFileMetadataCol() {
        return FileFormat.createFileMetadataCol$(this);
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        return FileFormat.supportDataType$(this, dataType);
    }

    @Override
    public boolean supportReadDataType(DataType dataType) {
        return FileFormat.supportReadDataType$(this, dataType);
    }

    @Override
    public boolean supportFieldName(String name) {
        return FileFormat.supportFieldName$(this, name);
    }

    @Override
    public boolean allowDuplicatedColumnNames() {
        return FileFormat.allowDuplicatedColumnNames$(this);
    }

    @Override
    public Seq<StructField> metadataSchemaFields() {
        return FileFormat.metadataSchemaFields$(this);
    }

    @Override
    public Map<String, Function1<PartitionedFile, Object>> fileConstantMetadataExtractors() {
        return FileFormat.fileConstantMetadataExtractors$(this);
    }

    @Override
    public SessionState sessionState(SparkSession sparkSession) {
        return FileFormat.sessionState$(this, sparkSession);
    }

    @Override
    public SQLConf sqlConf(SparkSession sparkSession) {
        return FileFormat.sqlConf$(this, sparkSession);
    }

    @Override
    public Configuration hadoopConf(SparkSession sparkSession, Map<String, String> options) {
        return FileFormat.hadoopConf$(this, sparkSession, options);
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return new Some((Object)BinaryFileFormat$.MODULE$.schema());
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        throw QueryExecutionErrors$.MODULE$.writeUnsupportedForBinaryFileDataSourceError();
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return false;
    }

    @Override
    public String shortName() {
        return BinaryFileFormat$.MODULE$.BINARY_FILE();
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Predef$.MODULE$.require(DataTypeUtils$.MODULE$.sameType((DataType)dataSchema, (DataType)BinaryFileFormat$.MODULE$.schema()), (Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |Binary file data source expects dataSchema: " + BinaryFileFormat$.MODULE$.schema() + ",\n         |but got: " + dataSchema + ".\n        ")));
        Broadcast broadcastedHadoopConf = SerializableConfiguration$.MODULE$.broadcast(sparkSession.sparkContext(), hadoopConf);
        Seq filterFuncs = (Seq)filters.flatMap((Function1 & Serializable)filter -> BinaryFileFormat$.MODULE$.createFilterFunction((Filter)filter));
        int maxLength = BoxesRunTime.unboxToInt((Object)sparkSession.sessionState().conf().getConf(SQLConf$.MODULE$.SOURCES_BINARY_FILE_MAX_LENGTH()));
        return (Function1 & Serializable)file -> {
            Path path = file.toPath();
            FileSystem fs = path.getFileSystem(((SerializableConfiguration)broadcastedHadoopConf.value()).value());
            FileStatus status = fs.getFileStatus(path);
            if (filterFuncs.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BinaryFileFormat.$anonfun$buildReader$4(status, x$1)))) {
                UnsafeRowWriter writer = new UnsafeRowWriter(requiredSchema.length());
                writer.resetRowWriter();
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fieldNames()))), (Function1 & Serializable)x0$1 -> {
                    BinaryFileFormat.$anonfun$buildReader$5(writer, status, maxLength, fs, x0$1);
                    return BoxedUnit.UNIT;
                });
                return package$.MODULE$.Iterator().single((Object)writer.getRow());
            }
            return package$.MODULE$.Iterator().empty();
        };
    }

    public BinaryFileFormat copy() {
        return new BinaryFileFormat();
    }

    public String productPrefix() {
        return "BinaryFileFormat";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BinaryFileFormat;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof BinaryFileFormat && ((BinaryFileFormat)x$1).canEqual(this);
    }

    public static final /* synthetic */ boolean $anonfun$buildReader$4(FileStatus status$1, Function1 x$1) {
        return BoxesRunTime.unboxToBoolean((Object)x$1.apply((Object)status$1));
    }

    public static final /* synthetic */ void $anonfun$buildReader$5(UnsafeRowWriter writer$1, FileStatus status$1, int maxLength$1, FileSystem fs$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            String string2 = BinaryFileFormat$.MODULE$.PATH();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                writer$1.write(i, UTF8String.fromString((String)status$1.getPath().toString()));
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            String string4 = BinaryFileFormat$.MODULE$.LENGTH();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                writer$1.write(i, status$1.getLen());
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            String string6 = BinaryFileFormat$.MODULE$.MODIFICATION_TIME();
            String string7 = string;
            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                writer$1.write(i, DateTimeUtils$.MODULE$.millisToMicros(status$1.getModificationTime()));
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            String string8 = BinaryFileFormat$.MODULE$.CONTENT();
            String string9 = string;
            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                if (status$1.getLen() > (long)maxLength$1) {
                    throw QueryExecutionErrors$.MODULE$.fileLengthExceedsMaxLengthError(status$1, maxLength$1);
                }
                FSDataInputStream stream = fs$1.open(status$1.getPath());
                try {
                    writer$1.write(i, ByteStreams.toByteArray((InputStream)stream));
                }
                finally {
                    Closeables.close((Closeable)stream, (boolean)true);
                }
                return;
            }
        }
        if (tuple2 != null) {
            String other = (String)tuple2._1();
            throw QueryExecutionErrors$.MODULE$.unsupportedFieldNameError(other);
        }
        throw new MatchError((Object)tuple2);
    }

    public BinaryFileFormat() {
        FileFormat.$init$(this);
        Product.$init$((Product)this);
    }
}

