/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.nio.ByteBuffer;
import org.apache.spark.unsafe.Platform;

public final class ByteBufferHelper$ {
    public static final ByteBufferHelper$ MODULE$ = new ByteBufferHelper$();

    public short getShort(ByteBuffer buffer) {
        int pos = buffer.position();
        buffer.position(pos + 2);
        return Platform.getShort((Object)buffer.array(), (long)(Platform.BYTE_ARRAY_OFFSET + pos));
    }

    public int getInt(ByteBuffer buffer) {
        int pos = buffer.position();
        buffer.position(pos + 4);
        return Platform.getInt((Object)buffer.array(), (long)(Platform.BYTE_ARRAY_OFFSET + pos));
    }

    public long getLong(ByteBuffer buffer) {
        int pos = buffer.position();
        buffer.position(pos + 8);
        return Platform.getLong((Object)buffer.array(), (long)(Platform.BYTE_ARRAY_OFFSET + pos));
    }

    public float getFloat(ByteBuffer buffer) {
        int pos = buffer.position();
        buffer.position(pos + 4);
        return Platform.getFloat((Object)buffer.array(), (long)(Platform.BYTE_ARRAY_OFFSET + pos));
    }

    public double getDouble(ByteBuffer buffer) {
        int pos = buffer.position();
        buffer.position(pos + 8);
        return Platform.getDouble((Object)buffer.array(), (long)(Platform.BYTE_ARRAY_OFFSET + pos));
    }

    public void putShort(ByteBuffer buffer, short value) {
        int pos = buffer.position();
        buffer.position(pos + 2);
        Platform.putShort((Object)buffer.array(), (long)(Platform.BYTE_ARRAY_OFFSET + pos), (short)value);
    }

    public void putInt(ByteBuffer buffer, int value) {
        int pos = buffer.position();
        buffer.position(pos + 4);
        Platform.putInt((Object)buffer.array(), (long)(Platform.BYTE_ARRAY_OFFSET + pos), (int)value);
    }

    public void putLong(ByteBuffer buffer, long value) {
        int pos = buffer.position();
        buffer.position(pos + 8);
        Platform.putLong((Object)buffer.array(), (long)(Platform.BYTE_ARRAY_OFFSET + pos), (long)value);
    }

    public void copyMemory(ByteBuffer src, ByteBuffer dst, int len) {
        int srcPos = src.position();
        int dstPos = dst.position();
        src.position(srcPos + len);
        dst.position(dstPos + len);
        Platform.copyMemory((Object)src.array(), (long)(Platform.BYTE_ARRAY_OFFSET + srcPos), (Object)dst.array(), (long)(Platform.BYTE_ARRAY_OFFSET + dstPos), (long)len);
    }

    private ByteBufferHelper$() {
    }
}

