/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog.procedures;

import javax.annotation.Nullable;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.connector.catalog.DefaultValue;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.internal.connector.ProcedureParameterImpl;
import org.apache.spark.sql.types.DataType;

@Evolving
public interface ProcedureParameter {
    public static final String BY_NAME_METADATA_KEY = "BY_NAME";

    public static Builder in(String name, DataType dataType) {
        return new Builder(Mode.IN, name, dataType);
    }

    public Mode mode();

    public String name();

    public DataType dataType();

    @Nullable
    public DefaultValue defaultValue();

    @Nullable
    public String comment();

    public static class Builder {
        private final Mode mode;
        private final String name;
        private final DataType dataType;
        private DefaultValue defaultValue;
        private String comment;

        private Builder(Mode mode, String name, DataType dataType) {
            this.mode = mode;
            this.name = name;
            this.dataType = dataType;
        }

        public Builder defaultValue(String sql2) {
            this.defaultValue = new DefaultValue(sql2);
            return this;
        }

        public Builder defaultValue(Expression expression) {
            this.defaultValue = new DefaultValue(expression);
            return this;
        }

        public Builder defaultValue(DefaultValue defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public ProcedureParameter build() {
            return new ProcedureParameterImpl(this.mode, this.name, this.dataType, this.defaultValue, this.comment);
        }
    }

    public static enum Mode {
        IN,
        INOUT,
        OUT;

    }
}

