/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.util.Map;
import org.apache.spark.sql.connector.catalog.CatalogV2Util;
import org.apache.spark.sql.connector.catalog.Column;
import org.apache.spark.sql.connector.catalog.constraints.Constraint;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;
import org.sparkproject.guava.base.Preconditions;
import org.sparkproject.guava.collect.Maps;

public class TableInfo {
    private final Column[] columns;
    private final Map<String, String> properties;
    private final Transform[] partitions;
    private final Constraint[] constraints;

    private TableInfo(Builder builder) {
        this.columns = builder.columns;
        this.properties = builder.properties;
        this.partitions = builder.partitions;
        this.constraints = builder.constraints;
    }

    public Column[] columns() {
        return this.columns;
    }

    public StructType schema() {
        return CatalogV2Util.v2ColumnsToStructType(this.columns);
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public Transform[] partitions() {
        return this.partitions;
    }

    public Constraint[] constraints() {
        return this.constraints;
    }

    public static class Builder {
        private Column[] columns;
        private Map<String, String> properties = Maps.newHashMap();
        private Transform[] partitions = new Transform[0];
        private Constraint[] constraints = new Constraint[0];

        public Builder withColumns(Column[] columns) {
            this.columns = columns;
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public Builder withPartitions(Transform[] partitions) {
            this.partitions = partitions;
            return this;
        }

        public Builder withConstraints(Constraint[] constraints) {
            this.constraints = constraints;
            return this;
        }

        public TableInfo build() {
            Preconditions.checkNotNull((Object)this.columns, (Object)"columns should not be null");
            return new TableInfo(this);
        }
    }
}

