/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.connector.catalog.CatalogV2Util;
import org.apache.spark.sql.connector.catalog.Column;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.constraints.Constraint;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;

@Evolving
public interface Table {
    public String name();

    @Deprecated(since="3.4.0")
    public StructType schema();

    default public Column[] columns() {
        return CatalogV2Util.structTypeToV2Columns(this.schema());
    }

    default public Transform[] partitioning() {
        return new Transform[0];
    }

    default public Map<String, String> properties() {
        return Collections.emptyMap();
    }

    public Set<TableCapability> capabilities();

    default public Constraint[] constraints() {
        return new Constraint[0];
    }

    default public String currentVersion() {
        return null;
    }
}

