/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.catalog.TempVariableManager;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.sql.connector.catalog.CatalogExtension;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.connector.catalog.CatalogNotFoundException;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Catalogs$;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u00055e!B\u0012%\u0001!\u0002\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u0011%\u0003!Q1A\u0005\u0002)C\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\u0006#\u0002!\tA\u0015\u0005\b-\u0002\u0011\r\u0011\"\u0003X\u0011\u0019Y\u0007\u0001)A\u00051\"9A\u000e\u0001b\u0001\n\u0003i\u0007BB9\u0001A\u0003%a\u000eC\u0003&\u0001\u0011\u0005!\u000fC\u0003v\u0001\u0011\u0005a\u000fC\u0003|\u0001\u0011%A\u0010\u0003\u0004~\u0001\u0011\u0005\u0001F \u0005\t\u007f\u0002\u0001\r\u0011\"\u0003\u0002\u0002!I\u0011q\u0002\u0001A\u0002\u0013%\u0011\u0011\u0003\u0005\t\u0003;\u0001\u0001\u0015)\u0003\u0002\u0004!9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0002bBA\u0012\u0001\u0011%\u0011Q\u0005\u0005\b\u0003W\u0001A\u0011AA\u0017\u0011%\t\t\u0004\u0001a\u0001\n\u0013\t\u0019\u0004C\u0005\u00028\u0001\u0001\r\u0011\"\u0003\u0002:!A\u0011Q\b\u0001!B\u0013\t)\u0004\u0003\u0004\u0002@\u0001!\tA \u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017B\u0001\"a\u0019\u0001\t\u0003A\u0013QM\u0004\t\u0003O\"\u0003\u0012\u0001\u0015\u0002j\u001991\u0005\nE\u0001Q\u0005-\u0004BB)\u001c\t\u0003\ti\u0007C\u0005\u0002pm\u0011\r\u0011\"\u0001\u0002r!9\u00111O\u000e!\u0002\u0013\u0001\u0007\"CA;7\t\u0007I\u0011AA<\u0011!\t9i\u0007Q\u0001\n\u0005e\u0004\"CAE7\t\u0007I\u0011AA<\u0011!\tYi\u0007Q\u0001\n\u0005e$AD\"bi\u0006dwnZ'b]\u0006<WM\u001d\u0006\u0003K\u0019\nqaY1uC2|wM\u0003\u0002(Q\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003S)\n1a]9m\u0015\tYC&A\u0003ta\u0006\u00148N\u0003\u0002.]\u00051\u0011\r]1dQ\u0016T\u0011aL\u0001\u0004_J<7\u0003\u0002\u00012ou\u0002\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012a!\u00118z%\u00164\u0007C\u0001\u001d<\u001b\u0005I$B\u0001\u001e)\u0003!\u0019\u0017\r^1msN$\u0018B\u0001\u001f:\u00055\u0019\u0016\u000bT\"p]\u001aDU\r\u001c9feB\u0011a(Q\u0007\u0002\u007f)\u0011\u0001IK\u0001\tS:$XM\u001d8bY&\u0011!i\u0010\u0002\b\u0019><w-\u001b8h\u0003U!WMZ1vYR\u001cVm]:j_:\u001c\u0015\r^1m_\u001e\u001c\u0001\u0001\u0005\u0002G\u000f6\tA%\u0003\u0002II\ti1)\u0019;bY><\u0007\u000b\\;hS:\f\u0001C^\u0019TKN\u001c\u0018n\u001c8DCR\fGn\\4\u0016\u0003-\u0003\"\u0001\u0014(\u000e\u00035S!!J\u001d\n\u0005=k%AD*fgNLwN\\\"bi\u0006dwnZ\u0001\u0012mF\u001aVm]:j_:\u001c\u0015\r^1m_\u001e\u0004\u0013A\u0002\u001fj]&$h\bF\u0002T)V\u0003\"A\u0012\u0001\t\u000b\r#\u0001\u0019A#\t\u000b%#\u0001\u0019A&\u0002\u0011\r\fG/\u00197pON,\u0012\u0001\u0017\t\u00053z\u0003W)D\u0001[\u0015\tYF,A\u0004nkR\f'\r\\3\u000b\u0005u\u001b\u0014AC2pY2,7\r^5p]&\u0011qL\u0017\u0002\b\u0011\u0006\u001c\b.T1q!\t\t\u0007N\u0004\u0002cMB\u00111mM\u0007\u0002I*\u0011Q\rR\u0001\u0007yI|w\u000e\u001e \n\u0005\u001d\u001c\u0014A\u0002)sK\u0012,g-\u0003\u0002jU\n11\u000b\u001e:j]\u001eT!aZ\u001a\u0002\u0013\r\fG/\u00197pON\u0004\u0013a\u0005;f[B4\u0016M]5bE2,W*\u00198bO\u0016\u0014X#\u00018\u0011\u00051{\u0017B\u00019N\u0005M!V-\u001c9WCJL\u0017M\u00197f\u001b\u0006t\u0017mZ3s\u0003Q!X-\u001c9WCJL\u0017M\u00197f\u001b\u0006t\u0017mZ3sAQ\u0011Qi\u001d\u0005\u0006i&\u0001\r\u0001Y\u0001\u0005]\u0006lW-A\njg\u000e\u000bG/\u00197pOJ+w-[:uKJ,G\r\u0006\u0002xuB\u0011!\u0007_\u0005\u0003sN\u0012qAQ8pY\u0016\fg\u000eC\u0003u\u0015\u0001\u0007\u0001-\u0001\u000bm_\u0006$gKM*fgNLwN\\\"bi\u0006dwn\u001a\u000b\u0002\u000b\u0006\u0001bOM*fgNLwN\\\"bi\u0006dwnZ\u000b\u0002\u000b\u0006\trlY;se\u0016tGOT1nKN\u0004\u0018mY3\u0016\u0005\u0005\r\u0001#\u0002\u001a\u0002\u0006\u0005%\u0011bAA\u0004g\t1q\n\u001d;j_:\u0004BAMA\u0006A&\u0019\u0011QB\u001a\u0003\u000b\u0005\u0013(/Y=\u0002+}\u001bWO\u001d:f]Rt\u0015-\\3ta\u0006\u001cWm\u0018\u0013fcR!\u00111CA\r!\r\u0011\u0014QC\u0005\u0004\u0003/\u0019$\u0001B+oSRD\u0011\"a\u0007\u000f\u0003\u0003\u0005\r!a\u0001\u0002\u0007a$\u0013'\u0001\n`GV\u0014(/\u001a8u\u001d\u0006lWm\u001d9bG\u0016\u0004\u0013\u0001E2veJ,g\u000e\u001e(b[\u0016\u001c\b/Y2f+\t\tI!\u0001\u000bbgN,'\u000f\u001e(b[\u0016\u001c\b/Y2f\u000bbL7\u000f\u001e\u000b\u0005\u0003'\t9\u0003C\u0004\u0002*E\u0001\r!!\u0003\u0002\u00139\fW.Z:qC\u000e,\u0017aE:fi\u000e+(O]3oi:\u000bW.Z:qC\u000e,G\u0003BA\n\u0003_Aq!!\u000b\u0013\u0001\u0004\tI!A\n`GV\u0014(/\u001a8u\u0007\u0006$\u0018\r\\8h\u001d\u0006lW-\u0006\u0002\u00026A!!'!\u0002a\u0003]y6-\u001e:sK:$8)\u0019;bY><g*Y7f?\u0012*\u0017\u000f\u0006\u0003\u0002\u0014\u0005m\u0002\"CA\u000e)\u0005\u0005\t\u0019AA\u001b\u0003Qy6-\u001e:sK:$8)\u0019;bY><g*Y7fA\u0005q1-\u001e:sK:$8)\u0019;bY><\u0017!E:fi\u000e+(O]3oi\u000e\u000bG/\u00197pOR!\u00111CA#\u0011\u0019\t9e\u0006a\u0001A\u0006Y1-\u0019;bY><g*Y7f\u00031a\u0017n\u001d;DCR\fGn\\4t)\u0011\ti%a\u0018\u0011\u000b\u0005=\u0013\u0011\f1\u000f\t\u0005E\u0013Q\u000b\b\u0004G\u0006M\u0013\"\u0001\u001b\n\u0007\u0005]3'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0013Q\f\u0002\u0004'\u0016\f(bAA,g!9\u0011\u0011\r\rA\u0002\u0005U\u0012a\u00029biR,'O\\\u0001\u0006e\u0016\u001cX\r\u001e\u000b\u0003\u0003'\tabQ1uC2|w-T1oC\u001e,'\u000f\u0005\u0002G7M\u00111$\r\u000b\u0003\u0003S\nAcU#T'&{ejX\"B)\u0006cujR0O\u00036+U#\u00011\u0002+M+5kU%P\u001d~\u001b\u0015\tV!M\u001f\u001e{f*Q'FA\u0005\u00192+W*U\u000b6{6)\u0011+B\u0019>;uLT!N\u000bV\u0011\u0011\u0011\u0010\t\u0005\u0003w\n))\u0004\u0002\u0002~)!\u0011qPAA\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\r\u0015\u0001\u00026bm\u0006L1![A?\u0003Q\u0019\u0016l\u0015+F\u001b~\u001b\u0015\tV!M\u001f\u001e{f*Q'FA\u0005\t2+R*T\u0013>suLT!N\u000bN\u0003\u0016iQ#\u0002%M+5kU%P\u001d~s\u0015)T#T!\u0006\u001bU\t\t")
public class CatalogManager
implements SQLConfHelper,
Logging {
    private final CatalogPlugin defaultSessionCatalog;
    private final SessionCatalog v1SessionCatalog;
    private final HashMap<String, CatalogPlugin> catalogs;
    private final TempVariableManager tempVariableManager;
    private Option<String[]> _currentNamespace;
    private Option<String> _currentCatalogName;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String SESSION_NAMESPACE() {
        return CatalogManager$.MODULE$.SESSION_NAMESPACE();
    }

    public static String SYSTEM_CATALOG_NAME() {
        return CatalogManager$.MODULE$.SYSTEM_CATALOG_NAME();
    }

    public static String SESSION_CATALOG_NAME() {
        return CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SessionCatalog v1SessionCatalog() {
        return this.v1SessionCatalog;
    }

    private HashMap<String, CatalogPlugin> catalogs() {
        return this.catalogs;
    }

    public TempVariableManager tempVariableManager() {
        return this.tempVariableManager;
    }

    public synchronized CatalogPlugin catalog(String name) {
        if (name.equalsIgnoreCase(CatalogManager$.MODULE$.SESSION_CATALOG_NAME())) {
            return this.v2SessionCatalog();
        }
        return (CatalogPlugin)this.catalogs().getOrElseUpdate((Object)name, (Function0 & Serializable)() -> Catalogs$.MODULE$.load(name, this.conf()));
    }

    public boolean isCatalogRegistered(String name) {
        boolean bl;
        try {
            this.catalog(name);
            bl = true;
        }
        catch (CatalogNotFoundException catalogNotFoundException) {
            bl = false;
        }
        return bl;
    }

    private CatalogPlugin loadV2SessionCatalog() {
        CatalogPlugin catalogPlugin = Catalogs$.MODULE$.load(CatalogManager$.MODULE$.SESSION_CATALOG_NAME(), this.conf());
        if (catalogPlugin instanceof CatalogExtension) {
            CatalogExtension catalogExtension = (CatalogExtension)catalogPlugin;
            catalogExtension.setDelegateCatalog(this.defaultSessionCatalog);
            return catalogExtension;
        }
        return catalogPlugin;
    }

    public CatalogPlugin v2SessionCatalog() {
        String string = this.conf().getConf(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION());
        switch (string == null ? 0 : string.hashCode()) {
            case 230960163: {
                if (!"builtin".equals(string)) break;
                return this.defaultSessionCatalog;
            }
        }
        return (CatalogPlugin)this.catalogs().getOrElseUpdate((Object)CatalogManager$.MODULE$.SESSION_CATALOG_NAME(), (Function0 & Serializable)() -> this.loadV2SessionCatalog());
    }

    private Option<String[]> _currentNamespace() {
        return this._currentNamespace;
    }

    private void _currentNamespace_$eq(Option<String[]> x$1) {
        this._currentNamespace = x$1;
    }

    public String[] currentNamespace() {
        String[] stringArray;
        String string = this.currentCatalog().name();
        String string2 = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
        String[] defaultNamespace = !(string != null ? !string.equals(string2) : string2 != null) ? (String[])((Object[])new String[]{this.v1SessionCatalog().getCurrentDatabase()}) : this.currentCatalog().defaultNamespace();
        CatalogManager catalogManager = this;
        synchronized (catalogManager) {
            stringArray = (String[])this._currentNamespace().getOrElse((Function0 & Serializable)() -> defaultNamespace);
        }
        return stringArray;
    }

    private void assertNamespaceExist(String[] namespace) {
        SupportsNamespaces supportsNamespaces;
        CatalogPlugin catalogPlugin = this.currentCatalog();
        if (catalogPlugin instanceof SupportsNamespaces && !(supportsNamespaces = (SupportsNamespaces)catalogPlugin).namespaceExists(namespace)) {
            String string = supportsNamespaces.name();
            throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError((String[])ArrayOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.refArrayOps((Object[])namespace), (Object)string, ClassTag$.MODULE$.apply(String.class)));
        }
    }

    public synchronized void setCurrentNamespace(String[] namespace) {
        if (CatalogV2Util$.MODULE$.isSessionCatalog(this.currentCatalog()) && namespace.length == 1) {
            this.v1SessionCatalog().setCurrentDatabaseWithNameCheck((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])namespace)), (Function1<String, BoxedUnit>)(Function1 & Serializable)x$1 -> {
                this.assertNamespaceExist(namespace);
                return BoxedUnit.UNIT;
            });
        } else {
            this.assertNamespaceExist(namespace);
        }
        this._currentNamespace_$eq((Option<String[]>)new Some((Object)namespace));
    }

    private Option<String> _currentCatalogName() {
        return this._currentCatalogName;
    }

    private void _currentCatalogName_$eq(Option<String> x$1) {
        this._currentCatalogName = x$1;
    }

    public synchronized CatalogPlugin currentCatalog() {
        return this.catalog((String)this._currentCatalogName().getOrElse((Function0 & Serializable)() -> this.conf().getConf(SQLConf$.MODULE$.DEFAULT_CATALOG())));
    }

    public synchronized void setCurrentCatalog(String catalogName) {
        String string = this.currentCatalog().name();
        String string2 = catalogName;
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.catalog(catalogName);
            this._currentCatalogName_$eq((Option<String>)new Some((Object)catalogName));
            this._currentNamespace_$eq((Option<String[]>)None$.MODULE$);
            this.v1SessionCatalog().setCurrentDatabase(this.conf().defaultDatabase());
            return;
        }
    }

    public Seq<String> listCatalogs(Option<String> pattern) {
        Seq seq;
        CatalogManager catalogManager = this;
        synchronized (catalogManager) {
            seq = this.catalogs().keys().toSeq();
        }
        Seq allCatalogs = (Seq)((SeqOps)((SeqOps)seq.$colon$plus((Object)CatalogManager$.MODULE$.SESSION_CATALOG_NAME())).distinct()).sorted((Ordering)Ordering.String$.MODULE$);
        return (Seq)pattern.map((Function1 & Serializable)x$2 -> StringUtils$.MODULE$.filterPattern((Seq<String>)allCatalogs, (String)x$2)).getOrElse((Function0 & Serializable)() -> allCatalogs);
    }

    public synchronized void reset() {
        this.catalogs().clear();
        this._currentNamespace_$eq((Option<String[]>)None$.MODULE$);
        this._currentCatalogName_$eq((Option<String>)None$.MODULE$);
        this.v1SessionCatalog().setCurrentDatabase(this.conf().defaultDatabase());
    }

    public CatalogManager(CatalogPlugin defaultSessionCatalog, SessionCatalog v1SessionCatalog) {
        this.defaultSessionCatalog = defaultSessionCatalog;
        this.v1SessionCatalog = v1SessionCatalog;
        SQLConfHelper.$init$(this);
        Logging.$init$((Logging)this);
        this.catalogs = HashMap$.MODULE$.empty();
        this.tempVariableManager = new TempVariableManager();
        this._currentNamespace = None$.MODULE$;
        this._currentCatalogName = None$.MODULE$;
    }
}

