/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.rules;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.rules.QueryExecutionMetrics;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.StringContext;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015a\u0001B\u0006\r\u0001eAQa\n\u0001\u0005\u0002!Bq!\u0011\u0001C\u0002\u0013%!\t\u0003\u0004L\u0001\u0001\u0006Ia\u0011\u0005\b\u0019\u0002\u0011\r\u0011\"\u0003N\u0011\u0019)\u0007\u0001)A\u0005\u001d\"9a\r\u0001b\u0001\n\u0013i\u0005BB4\u0001A\u0003%a\nC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0003t\u0001\u0011\u0005A\u000fC\u0003z\u0001\u0011\u0005!P\u0001\tQY\u0006t7\t[1oO\u0016dunZ4fe*\u0011QBD\u0001\u0006eVdWm\u001d\u0006\u0003\u001fA\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003#I\t1a]9m\u0015\t\u0019B#A\u0003ta\u0006\u00148N\u0003\u0002\u0016-\u00051\u0011\r]1dQ\u0016T\u0011aF\u0001\u0004_J<7\u0001A\u000b\u000355\u001a2\u0001A\u000e\"!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fMB\u0011!%J\u0007\u0002G)\u0011AEE\u0001\tS:$XM\u001d8bY&\u0011ae\t\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006E\u0002+\u0001-j\u0011\u0001\u0004\t\u0003Y5b\u0001\u0001B\u0003/\u0001\t\u0007qF\u0001\u0005Ue\u0016,G+\u001f9f#\t\u00014\u0007\u0005\u0002\u001dc%\u0011!'\b\u0002\b\u001d>$\b.\u001b8ha\t!4\bE\u00026qij\u0011A\u000e\u0006\u0003o9\tQ\u0001\u001e:fKNL!!\u000f\u001c\u0003\u0011Q\u0013X-\u001a(pI\u0016\u0004\"\u0001L\u001e\u0005\u0013qj\u0013\u0011!A\u0001\u0006\u0003i$aA0%cE\u0011\u0001G\u0010\t\u00039}J!\u0001Q\u000f\u0003\u0007\u0005s\u00170\u0001\u0005m_\u001edUM^3m+\u0005\u0019\u0005C\u0001#J\u001b\u0005)%B\u0001$H\u0003\u0015)g/\u001a8u\u0015\tAe#A\u0003tY\u001a$$.\u0003\u0002K\u000b\n)A*\u001a<fY\u0006IAn\\4MKZ,G\u000eI\u0001\tY><'+\u001e7fgV\ta\nE\u0002\u001d\u001fFK!\u0001U\u000f\u0003\r=\u0003H/[8o!\r\u0011&,\u0018\b\u0003'bs!\u0001V,\u000e\u0003US!A\u0016\r\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0012BA-\u001e\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0017/\u0003\u0007M+\u0017O\u0003\u0002Z;A\u0011aL\u0019\b\u0003?\u0002\u0004\"\u0001V\u000f\n\u0005\u0005l\u0012A\u0002)sK\u0012,g-\u0003\u0002dI\n11\u000b\u001e:j]\u001eT!!Y\u000f\u0002\u00131|wMU;mKN\u0004\u0013A\u00037pO\n\u000bGo\u00195fg\u0006YAn\\4CCR\u001c\u0007.Z:!\u0003\u001dawn\u001a*vY\u0016$BA[7pcB\u0011Ad[\u0005\u0003Yv\u0011A!\u00168ji\")a\u000e\u0003a\u0001;\u0006A!/\u001e7f\u001d\u0006lW\rC\u0003q\u0011\u0001\u00071&A\u0004pY\u0012\u0004F.\u00198\t\u000bID\u0001\u0019A\u0016\u0002\u000f9,w\u000f\u00157b]\u0006AAn\\4CCR\u001c\u0007\u000e\u0006\u0003kk^D\b\"\u0002<\n\u0001\u0004i\u0016!\u00032bi\u000eDg*Y7f\u0011\u0015\u0001\u0018\u00021\u0001,\u0011\u0015\u0011\u0018\u00021\u0001,\u0003)awnZ'fiJL7m\u001d\u000b\u0004Unl\b\"\u0002?\u000b\u0001\u0004i\u0016\u0001\u00028b[\u0016DQA \u0006A\u0002}\fq!\\3ue&\u001c7\u000fE\u0002+\u0003\u0003I1!a\u0001\r\u0005U\tV/\u001a:z\u000bb,7-\u001e;j_:lU\r\u001e:jGN\u0004")
public class PlanChangeLogger<TreeType extends TreeNode<?>>
implements Logging {
    private final Level logLevel;
    private final Option<Seq<String>> logRules;
    private final Option<Seq<String>> logBatches;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Level logLevel() {
        return this.logLevel;
    }

    private Option<Seq<String>> logRules() {
        return this.logRules;
    }

    private Option<Seq<String>> logBatches() {
        return this.logBatches;
    }

    public void logRule(String ruleName, TreeType oldPlan, TreeType newPlan) {
        if (!((TreeNode)newPlan).fastEquals((TreeNode<?>)oldPlan)) {
            if (this.logRules().isEmpty() || ((SeqOps)this.logRules().get()).contains((Object)ruleName)) {
                this.logBasedOnLevel(this.logLevel(), (Function0<MessageWithContext>)(Function0 & Serializable)() -> this.message$1((TreeNode)oldPlan, (TreeNode)newPlan, ruleName));
                return;
            }
            return;
        }
    }

    public void logBatch(String batchName, TreeType oldPlan, TreeType newPlan) {
        if (this.logBatches().isEmpty() || ((SeqOps)this.logBatches().get()).contains((Object)batchName)) {
            this.logBasedOnLevel(this.logLevel(), (Function0<MessageWithContext>)(Function0 & Serializable)() -> this.message$2((TreeNode)oldPlan, (TreeNode)newPlan, batchName));
            return;
        }
    }

    public void logMetrics(String name, QueryExecutionMetrics metrics) {
        double totalTime = (double)metrics.time() / 1000000.0;
        double totalTimeEffective = (double)metrics.timeEffective() / 1000000.0;
        MessageWithContext message = this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |=== Metrics of Executed Rules ", " ===\n         |Total number of runs: ", "\n         |Total time: ", " ms\n         |Total number of effective runs: ", "\n         |Total time of effective runs: ", " ms\n      "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.RULE_EXECUTOR_NAME$.MODULE$, (Object)name), new MDC((LogKey)LogKeys.NUM_RULE_OF_RUNS$.MODULE$, (Object)BoxesRunTime.boxToLong((long)metrics.numRuns())), new MDC((LogKey)LogKeys.TOTAL_TIME$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)totalTime)), new MDC((LogKey)LogKeys.NUM_EFFECTIVE_RULE_OF_RUNS$.MODULE$, (Object)BoxesRunTime.boxToLong((long)metrics.numEffectiveRuns())), new MDC((LogKey)LogKeys.TOTAL_EFFECTIVE_TIME$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)totalTimeEffective))})).stripMargin();
        this.logBasedOnLevel(this.logLevel(), (Function0<MessageWithContext>)(Function0 & Serializable)() -> message);
    }

    private final MessageWithContext message$1(TreeNode oldPlan$1, TreeNode newPlan$1, String ruleName$1) {
        boolean x$1 = false;
        boolean x$2 = true;
        boolean x$3 = oldPlan$1.treeString$default$2();
        int x$4 = oldPlan$1.treeString$default$3();
        boolean x$5 = oldPlan$1.treeString$default$4();
        String oldPlanStringWithOutput = oldPlan$1.treeString(false, x$3, x$4, x$5, true);
        boolean x$6 = false;
        boolean x$7 = true;
        boolean x$8 = newPlan$1.treeString$default$2();
        int x$9 = newPlan$1.treeString$default$3();
        boolean x$10 = newPlan$1.treeString$default$4();
        String newPlanStringWithOutput = newPlan$1.treeString(false, x$8, x$9, x$10, true);
        return this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |=== Applying Rule ", " ===\n             |", "\n             |\n             |Output Information:\n             |", "\n           "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.RULE_NAME$.MODULE$, (Object)ruleName$1), new MDC((LogKey)LogKeys.QUERY_PLAN$.MODULE$, (Object)package$.MODULE$.sideBySide(oldPlan$1.treeString(), newPlan$1.treeString()).mkString("\n")), new MDC((LogKey)LogKeys.QUERY_PLAN$.MODULE$, (Object)package$.MODULE$.sideBySide(oldPlanStringWithOutput, newPlanStringWithOutput).mkString("\n"))})).stripMargin();
    }

    private final MessageWithContext message$2(TreeNode oldPlan$2, TreeNode newPlan$2, String batchName$1) {
        if (!oldPlan$2.fastEquals(newPlan$2)) {
            boolean x$1 = false;
            boolean x$2 = true;
            boolean x$3 = oldPlan$2.treeString$default$2();
            int x$4 = oldPlan$2.treeString$default$3();
            boolean x$5 = oldPlan$2.treeString$default$4();
            String oldPlanStringWithOutput = oldPlan$2.treeString(false, x$3, x$4, x$5, true);
            boolean x$6 = false;
            boolean x$7 = true;
            boolean x$8 = newPlan$2.treeString$default$2();
            int x$9 = newPlan$2.treeString$default$3();
            boolean x$10 = newPlan$2.treeString$default$4();
            String newPlanStringWithOutput = newPlan$2.treeString(false, x$8, x$9, x$10, true);
            return this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |=== Result of Batch ", " ===\n             |", "\n             |\n             |Output Information:\n             |", "\n          "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.BATCH_NAME$.MODULE$, (Object)batchName$1), new MDC((LogKey)LogKeys.QUERY_PLAN$.MODULE$, (Object)package$.MODULE$.sideBySide(oldPlan$2.treeString(), newPlan$2.treeString()).mkString("\n")), new MDC((LogKey)LogKeys.QUERY_PLAN$.MODULE$, (Object)package$.MODULE$.sideBySide(oldPlanStringWithOutput, newPlanStringWithOutput).mkString("\n"))})).stripMargin();
        }
        return this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Batch ", " has no effect."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.BATCH_NAME$.MODULE$, (Object)batchName$1)}));
    }

    public PlanChangeLogger() {
        Logging.$init$((Logging)this);
        this.logLevel = SQLConf$.MODULE$.get().planChangeLogLevel();
        this.logRules = SQLConf$.MODULE$.get().planChangeRules().map((Function1 & Serializable)str -> Utils$.MODULE$.stringToSeq(str));
        this.logBatches = SQLConf$.MODULE$.get().planChangeBatches().map((Function1 & Serializable)str -> Utils$.MODULE$.stringToSeq(str));
    }
}

