/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.IntegerLiteral$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.NonNullLiteral$;
import org.apache.spark.sql.catalyst.expressions.TimeWindow;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class TimeWindow$
implements Serializable {
    public static final TimeWindow$ MODULE$ = new TimeWindow$();
    private static final String marker = "spark.timeWindow";

    public String marker() {
        return marker;
    }

    public long getIntervalInMicroSeconds(String interval) {
        CalendarInterval cal = IntervalUtils$.MODULE$.fromIntervalString(interval);
        if (cal.months != 0) {
            throw new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_3231", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"interval"), (Object)interval)})));
        }
        return Math.addExact(Math.multiplyExact((long)cal.days, 86400000000L), cal.microseconds);
    }

    public long parseExpression(Expression expr) {
        Option<Tuple2<Object, DataType>> option;
        Option<Object> option2;
        boolean bl = false;
        Literal literal = null;
        Expression expression = expr;
        if (expression instanceof Literal) {
            bl = true;
            literal = (Literal)expression;
            Option<Tuple2<Object, DataType>> option3 = NonNullLiteral$.MODULE$.unapply(literal);
            if (!option3.isEmpty()) {
                Object s = ((Tuple2)option3.get())._1();
                if (((Tuple2)option3.get())._2() instanceof StringType) {
                    return this.getIntervalInMicroSeconds(s.toString());
                }
            }
        }
        if (expression != null && !(option2 = IntegerLiteral$.MODULE$.unapply(expression)).isEmpty()) {
            int i = BoxesRunTime.unboxToInt((Object)option2.get());
            return i;
        }
        if (bl && !(option = NonNullLiteral$.MODULE$.unapply(literal)).isEmpty()) {
            Object l = ((Tuple2)option.get())._1();
            DataType dataType = (DataType)((Tuple2)option.get())._2();
            if (LongType$.MODULE$.equals(dataType)) {
                return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(l.toString()));
            }
        }
        throw QueryCompilationErrors$.MODULE$.invalidLiteralForWindowDurationError();
    }

    public TimeWindow apply(Expression timeColumn, String windowDuration, String slideDuration, String startTime) {
        return new TimeWindow(timeColumn, this.getIntervalInMicroSeconds(windowDuration), this.getIntervalInMicroSeconds(slideDuration), this.getIntervalInMicroSeconds(startTime));
    }

    public TimeWindow apply(Expression timeColumn, long windowDuration, long slideDuration, long startTime) {
        return new TimeWindow(timeColumn, windowDuration, slideDuration, startTime);
    }

    public Option<Tuple4<Expression, Object, Object, Object>> unapply(TimeWindow x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.timeColumn(), (Object)BoxesRunTime.boxToLong((long)x$0.windowDuration()), (Object)BoxesRunTime.boxToLong((long)x$0.slideDuration()), (Object)BoxesRunTime.boxToLong((long)x$0.startTime())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TimeWindow$.class);
    }

    private TimeWindow$() {
    }
}

