/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.MakeTimestampNTZExpressionBuilder$;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ExpressionDescription(usage="\n    _FUNC_(year, month, day, hour, min, sec) - Create local date-time from year, month, day, hour, min, sec fields. If the configuration `spark.sql.ansi.enabled` is false, the function returns NULL on invalid inputs. Otherwise, it will throw an error instead.\n\n    _FUNC_(date, time) - Create a local date-time from date and time fields.\n    ", arguments="\n    Arguments:\n      * year - the year to represent, from 1 to 9999\n      * month - the month-of-year to represent, from 1 (January) to 12 (December)\n      * day - the day-of-month to represent, from 1 to 31\n      * hour - the hour-of-day to represent, from 0 to 23\n      * min - the minute-of-hour to represent, from 0 to 59\n      * sec - the second-of-minute and its micro-fraction to represent, from\n              0 to 60. If the sec argument equals to 60, the seconds field is set\n              to 0 and 1 minute is added to the final timestamp.\n      * date - a date to represent, from 0001-01-01 to 9999-12-31\n      * time - a local time to represent, from 00:00:00 to 23:59:59.999999\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887);\n       2014-12-28 06:30:45.887\n      > SELECT _FUNC_(2019, 6, 30, 23, 59, 60);\n       2019-07-01 00:00:00\n      > SELECT _FUNC_(null, 7, 22, 15, 30, 0);\n       NULL\n      > SELECT _FUNC_(DATE'2014-12-28', TIME'6:30:45.887');\n       2014-12-28 06:30:45.887\n  ", group="datetime_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0005Q;Q\u0001B\u0003\t\u0002I1Q\u0001F\u0003\t\u0002UAQAI\u0001\u0005\u0002\rBQ\u0001J\u0001\u0005B\u0015\n\u0011%T1lKRKW.Z:uC6\u0004h\n\u0016.FqB\u0014Xm]:j_:\u0014U/\u001b7eKJT!AB\u0004\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u0011%\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u0015-\t1a]9m\u0015\taQ\"A\u0003ta\u0006\u00148N\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001\u0001\t\u0003'\u0005i\u0011!\u0002\u0002\"\u001b\u0006\\W\rV5nKN$\u0018-\u001c9O)j+\u0005\u0010\u001d:fgNLwN\u001c\"vS2$WM]\n\u0004\u0003Ya\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g\r\u0005\u0002\u001eA5\taD\u0003\u0002 \u000f\u0005A\u0011M\\1msNL7/\u0003\u0002\"=\t\tR\t\u001f9sKN\u001c\u0018n\u001c8Ck&dG-\u001a:\u0002\rqJg.\u001b;?)\u0005\u0011\u0012!\u00022vS2$Gc\u0001\u0014*mA\u00111cJ\u0005\u0003Q\u0015\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0011\u0015Q3\u00011\u0001,\u0003!1WO\\2OC6,\u0007C\u0001\u00174\u001d\ti\u0013\u0007\u0005\u0002/15\tqF\u0003\u00021#\u00051AH]8pizJ!A\r\r\u0002\rA\u0013X\rZ3g\u0013\t!TG\u0001\u0004TiJLgn\u001a\u0006\u0003eaAQAB\u0002A\u0002]\u00022\u0001O\u001f'\u001d\tI4H\u0004\u0002/u%\t\u0011$\u0003\u0002=1\u00059\u0001/Y2lC\u001e,\u0017B\u0001 @\u0005\r\u0019V-\u001d\u0006\u0003yaAC\"A!E\u000b\u001eC%jS'O!F\u0003\"a\u0005\"\n\u0005\r+!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0002\r\u0006\u0011yK\u0003\u0011!A\u0001zf)\u0016(D?\"JX-\u0019:-A5|g\u000e\u001e5-A\u0011\f\u0017\u0010\f\u0011i_V\u0014H\u0006I7j]2\u00023/Z2*A5\u00023I]3bi\u0016\u0004Cn\\2bY\u0002\"\u0017\r^3.i&lW\r\t4s_6\u0004\u00130Z1sY\u0001jwN\u001c;iY\u0001\"\u0017-\u001f\u0017!Q>,(\u000f\f\u0011nS:d\u0003e]3dA\u0019LW\r\u001c3t]\u0001Je\r\t;iK\u0002\u001awN\u001c4jOV\u0014\u0018\r^5p]\u0002\u00027\u000f]1sW:\u001a\u0018\u000f\u001c\u0018b]NLg&\u001a8bE2,G\r\u0019\u0011jg\u00022\u0017\r\\:fY\u0001\"\b.\u001a\u0011gk:\u001cG/[8oAI,G/\u001e:og\u0002rU\u000b\u0014'!_:\u0004\u0013N\u001c<bY&$\u0007%\u001b8qkR\u001ch\u0006I(uQ\u0016\u0014x/[:fY\u0001JG\u000fI<jY2\u0004C\u000f\u001b:po\u0002\ng\u000eI3se>\u0014\b%\u001b8ti\u0016\fGM\f\u0006\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006\u0006Z1uK2\u0002C/[7fS\u0001j\u0003e\u0011:fCR,\u0007%\u0019\u0011m_\u000e\fG\u000e\t3bi\u0016lC/[7fA\u0019\u0014x.\u001c\u0011eCR,\u0007%\u00198eAQLW.\u001a\u0011gS\u0016dGm\u001d\u0018\u000bA\u0001\u0002\u0003%A\u0005be\u001e,X.\u001a8ug\u0006\n\u0011*AC7\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002\u00130Z1sA5\u0002C\u000f[3!s\u0016\f'\u000f\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0013\u0007\t;pAeJ\u0014(\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016![>tG\u000f\u001b\u0011.AQDW\rI7p]RDWf\u001c4.s\u0016\f'\u000f\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0013\u0007\t\u0015KC:,\u0018M]=*AQ|\u0007%\r\u001a!Q\u0011+7-Z7cKJL#\u0002\t\u0011!A\u0001\u0002#\u0006\t3bs\u0002j\u0003\u0005\u001e5fA\u0011\f\u00170L8g[5|g\u000e\u001e5!i>\u0004#/\u001a9sKN,g\u000e\u001e\u0017!MJ|W\u000eI\u0019!i>\u00043'\r\u0006!A\u0001\u0002\u0003\u0005\t\u0016!Q>,(\u000fI\u0017!i\",\u0007\u0005[8ve6zg-\f3bs\u0002\"x\u000e\t:faJ,7/\u001a8uY\u00012'o\\7!a\u0001\"x\u000e\t\u001a4\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001j\u0017N\u001c\u0011.AQDW\rI7j]V$X-L8g[!|WO\u001d\u0011u_\u0002\u0012X\r\u001d:fg\u0016tG\u000f\f\u0011ge>l\u0007\u0005\r\u0011u_\u0002*\u0014H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011tK\u000e\u0004S\u0006\t;iK\u0002\u001aXmY8oI6zg-L7j]V$X\rI1oI\u0002JGo\u001d\u0011nS\u000e\u0014x.\f4sC\u000e$\u0018n\u001c8!i>\u0004#/\u001a9sKN,g\u000e\u001e\u0017!MJ|WN\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0019!i>\u0004c\u0007\r\u0018!\u0013\u001a\u0004C\u000f[3!g\u0016\u001c\u0007%\u0019:hk6,g\u000e\u001e\u0011fcV\fGn\u001d\u0011u_\u00022\u0004\u0007\f\u0011uQ\u0016\u00043/Z2p]\u0012\u001c\bEZ5fY\u0012\u0004\u0013n\u001d\u0011tKRT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002Co\u001c\u00111A\u0005tG\rI\u0019![&tW\u000f^3!SN\u0004\u0013\r\u001a3fI\u0002\"x\u000e\t;iK\u00022\u0017N\\1mAQLW.Z:uC6\u0004hF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011eCR,\u0007%\f\u0011bA\u0011\fG/\u001a\u0011u_\u0002\u0012X\r\u001d:fg\u0016tG\u000f\f\u0011ge>l\u0007\u0005\r\u00191c5\u0002\u0014'\f\u00192AQ|\u0007%O\u001d:s5\n$'L\u001a2\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"\u0018.\\3![\u0001\n\u0007\u0005\\8dC2\u0004C/[7fAQ|\u0007E]3qe\u0016\u001cXM\u001c;-A\u0019\u0014x.\u001c\u00111ai\u0002\u0004G\u000f\u00191AQ|\u0007EM\u001a;keRT'\u000f\u0018:seJ\u0014(\u000f\u0006!A\u0005AQ\r_1na2,7/I\u0001M\u0003\t-%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b\u001a1cQb\u0003%\r\u001a-AIBD\u0006\t\u001c-AM\u0002D\u0006\t\u001b6]aBt'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\nD'L\u00193[IB\u0004\u0005\r\u001c;gARD'\u000e\u00189q]R\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\r\u00192s1\u0002c\u0007\f\u00114a1\u0002#g\r\u0017!keb\u0003E\u000e\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'M\u001d.a]j\u0003'\r\u00111ai\u0002\u0004G\u000f\u00191\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"rW\u000f\u001c7-A]b\u0003E\r\u001a-AE*D\u0006I\u001a1Y\u0001\u0002\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011O+2c%\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b#B)\u0016;#\u0007M\u00195[E\u0012TF\r\u001d(Y\u0001\"\u0016*T#(mi\u001a\u0004G\u000f\u001b6]aBtgJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014\u0007N\u00172e5\u0012\u0004\b\t\u00197uM\u0002$\bN\u001b/qa:$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0003=\u000ba\u0002Z1uKRLW.Z0gk:\u001c7/A\u0003tS:\u001cW-I\u0001S\u0003\u0015\u0019d\u0006\u000e\u00181Q1\u0001\u0011\tR#H\u0011*[UJ\u0014)R\u0001")
public final class MakeTimestampNTZExpressionBuilder {
    public static Expression build(String funcName, Seq<Expression> expressions) {
        return MakeTimestampNTZExpressionBuilder$.MODULE$.build(funcName, (Seq)expressions);
    }

    public static boolean supportsLambda() {
        return MakeTimestampNTZExpressionBuilder$.MODULE$.supportsLambda();
    }

    public static Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName) {
        return MakeTimestampNTZExpressionBuilder$.MODULE$.rearrange(expectedSignature, providedArguments, functionName);
    }

    public static Option<FunctionSignature> functionSignature() {
        return MakeTimestampNTZExpressionBuilder$.MODULE$.functionSignature();
    }
}

