/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import java.util.Random;
import org.apache.spark.sql.catalyst.QueryPlanningTracker;
import org.apache.spark.sql.catalyst.QueryPlanningTracker$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.AnalysisContext$;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.resolver.AnalyzerBridgeState;
import org.apache.spark.sql.catalyst.analysis.resolver.AnalyzerBridgeState$;
import org.apache.spark.sql.catalyst.analysis.resolver.ExplicitlyUnsupportedResolverFeature;
import org.apache.spark.sql.catalyst.analysis.resolver.HybridAnalyzer$;
import org.apache.spark.sql.catalyst.analysis.resolver.Resolver;
import org.apache.spark.sql.catalyst.analysis.resolver.ResolverGuard;
import org.apache.spark.sql.catalyst.analysis.resolver.ResolverRunner;
import org.apache.spark.sql.catalyst.plans.NormalizePlan$;
import org.apache.spark.sql.catalyst.plans.logical.AnalysisHelper$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u0005a\u0001\u0002\u0014(\u0001YB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"A\u0001\u0006\u0001B\u0001B\u0003%1\n\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011!I\u0007A!A!\u0002\u0013Q\u0007\u0002C9\u0001\u0005\u0003\u0005\u000b\u0011\u0002:\t\u000bU\u0004A\u0011\u0001<\t\u000fy\u0004\u0001\u0019!C\u0005\u007f\"I\u0011Q\u0002\u0001A\u0002\u0013%\u0011q\u0002\u0005\t\u0003+\u0001\u0001\u0015)\u0003\u0002\u0002!A\u0011q\u0003\u0001A\u0002\u0013%q\u0010C\u0005\u0002\u001a\u0001\u0001\r\u0011\"\u0003\u0002\u001c!A\u0011q\u0004\u0001!B\u0013\t\t\u0001C\u0005\u0002\"\u0001\u0011\r\u0011\"\u0003\u0002$!A\u00111\u0006\u0001!\u0002\u0013\t)\u0003C\u0005\u0002.\u0001\u0011\r\u0011\"\u0003\u00020!A\u0011\u0011\t\u0001!\u0002\u0013\t\t\u0004C\u0004\u0002D\u0001!\t!!\u0012\t\r\u0005U\u0003\u0001\"\u0001\u0000\u0011\u0019\t9\u0006\u0001C\u0001\u007f\"9\u0011\u0011\f\u0001\u0005\n\u0005m\u0003bBA7\u0001\u0011%\u0011q\u000e\u0005\b\u0003k\u0002A\u0011BA<\u0011\u001d\ti\b\u0001C\u0005\u0003\u007fBq!!\"\u0001\t\u0013\t9\tC\u0004\u0002\u000e\u0002!I!a$\t\u000f\u0005E\u0005\u0001\"\u0003\u0002\u0014\"A\u0011Q\u0014\u0001\u0005\u00125\ny\nC\u0004\u0002$\u0002!I!!*\b\u000f\u0005-w\u0005#\u0001\u0002N\u001a1ae\nE\u0001\u0003\u001fDa!^\u0010\u0005\u0002\u0005E\u0007bBAj?\u0011\u0005\u0011Q\u001b\u0005\n\u00037|\u0012\u0013!C\u0001\u0003;D\u0011\"a= #\u0003%\t!!>\t\u0013\u0005ex$%A\u0005\u0002\u0005m\b\"CA\u0000?E\u0005I\u0011AAo\u00059A\u0015P\u0019:jI\u0006s\u0017\r\\={KJT!\u0001K\u0015\u0002\u0011I,7o\u001c7wKJT!AK\u0016\u0002\u0011\u0005t\u0017\r\\=tSNT!\u0001L\u0017\u0002\u0011\r\fG/\u00197zgRT!AL\u0018\u0002\u0007M\fHN\u0003\u00021c\u0005)1\u000f]1sW*\u0011!gM\u0001\u0007CB\f7\r[3\u000b\u0003Q\n1a\u001c:h\u0007\u0001\u00192\u0001A\u001c>!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u0019\te.\u001f*fMB\u0011ahP\u0007\u0002W%\u0011\u0001i\u000b\u0002\u000e'Fc5i\u001c8g\u0011\u0016d\u0007/\u001a:\u0002\u001d1,w-Y2z\u0003:\fG.\u001f>feB\u00111\tR\u0007\u0002S%\u0011Q)\u000b\u0002\t\u0003:\fG.\u001f>fe\u0006i!/Z:pYZ,'oR;be\u0012\u0004\"\u0001S%\u000e\u0003\u001dJ!AS\u0014\u0003\u001bI+7o\u001c7wKJ<U/\u0019:e!\tAE*\u0003\u0002NO\tA!+Z:pYZ,'/\u0001\rfqR,g\u000eZ3e%\u0016\u001cx\u000e\\;uS>t7\t[3dWN\u00042\u0001\u0015-\\\u001d\t\tfK\u0004\u0002S+6\t1K\u0003\u0002Uk\u00051AH]8pizJ\u0011AO\u0005\u0003/f\nq\u0001]1dW\u0006<W-\u0003\u0002Z5\n\u00191+Z9\u000b\u0005]K\u0004\u0003\u0002\u001d]=\u001aL!!X\u001d\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA0e\u001b\u0005\u0001'BA1c\u0003\u001dawnZ5dC2T!aY\u0016\u0002\u000bAd\u0017M\\:\n\u0005\u0015\u0004'a\u0003'pO&\u001c\u0017\r\u001c)mC:\u0004\"\u0001O4\n\u0005!L$\u0001B+oSR\fA#\u001a=uK:$W\r\u001a*foJLG/\u001a*vY\u0016\u001c\bc\u0001)YWB\u0019An\u001c0\u000e\u00035T!A\\\u0016\u0002\u000bI,H.Z:\n\u0005Al'\u0001\u0002*vY\u0016\f!&\u001a=q_N,W\t\u001f9mS\u000eLG\u000f\\=V]N,\b\u000f]8si\u0016$'+Z:pYZ,'OR3biV\u0014X\r\u0005\u00029g&\u0011A/\u000f\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q9q\u000f_={wrl\bC\u0001%\u0001\u0011\u0015\tu\u00011\u0001C\u0011\u00151u\u00011\u0001H\u0011\u0015As\u00011\u0001L\u0011\u001dqu\u0001%AA\u0002=Cq![\u0004\u0011\u0002\u0003\u0007!\u000eC\u0004r\u000fA\u0005\t\u0019\u0001:\u00029MLgn\u001a7f!\u0006\u001c8OU3t_2,H/[8o\tV\u0014\u0018\r^5p]V\u0011\u0011\u0011\u0001\t\u0006q\u0005\r\u0011qA\u0005\u0004\u0003\u000bI$AB(qi&|g\u000eE\u00029\u0003\u0013I1!a\u0003:\u0005\u0011auN\\4\u0002AMLgn\u001a7f!\u0006\u001c8OU3t_2,H/[8o\tV\u0014\u0018\r^5p]~#S-\u001d\u000b\u0004M\u0006E\u0001\"CA\n\u0013\u0005\u0005\t\u0019AA\u0001\u0003\rAH%M\u0001\u001eg&tw\r\\3QCN\u001c(+Z:pYV$\u0018n\u001c8EkJ\fG/[8oA\u0005ab-\u001b=fIB{\u0017N\u001c;SKN|G.\u001e;j_:$UO]1uS>t\u0017\u0001\t4jq\u0016$\u0007k\\5oiJ+7o\u001c7vi&|g\u000eR;sCRLwN\\0%KF$2AZA\u000f\u0011%\t\u0019\u0002DA\u0001\u0002\u0004\t\t!A\u000fgSb,G\rU8j]R\u0014Vm]8mkRLwN\u001c#ve\u0006$\u0018n\u001c8!\u00039\u0011Xm]8mm\u0016\u0014(+\u001e8oKJ,\"!!\n\u0011\u0007!\u000b9#C\u0002\u0002*\u001d\u0012aBU3t_24XM\u001d*v]:,'/A\bsKN|GN^3s%Vtg.\u001a:!\u0003M\u0019\u0018-\u001c9mKJ\u000bG/Z$f]\u0016\u0014\u0018\r^8s+\t\t\t\u0004\u0005\u0003\u00024\u0005uRBAA\u001b\u0015\u0011\t9$!\u000f\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003w\tAA[1wC&!\u0011qHA\u001b\u0005\u0019\u0011\u0016M\u001c3p[\u0006!2/Y7qY\u0016\u0014\u0016\r^3HK:,'/\u0019;pe\u0002\nQ!\u00199qYf$RAXA$\u0003\u0017Ba!!\u0013\u0013\u0001\u0004q\u0016\u0001\u00029mC:Dq!!\u0014\u0013\u0001\u0004\ty%A\u0004ue\u0006\u001c7.\u001a:\u0011\u0007y\n\t&C\u0002\u0002T-\u0012A#U;fef\u0004F.\u00198oS:<GK]1dW\u0016\u0014\u0018aH4fiNKgn\u001a7f!\u0006\u001c8OU3t_2,H/[8o\tV\u0014\u0018\r^5p]\u0006yr-\u001a;GSb,G\rU8j]R\u0014Vm]8mkRLwN\u001c#ve\u0006$\u0018n\u001c8\u0002=]LG\u000f\u001b+sC\u000e\\W\rZ!oC2L(0\u001a:Ce&$w-Z*uCR,G\u0003BA/\u0003S\"2AXA0\u0011!\t\t'\u0006CA\u0002\u0005\r\u0014\u0001\u00022pIf\u0004B\u0001OA3=&\u0019\u0011qM\u001d\u0003\u0011q\u0012\u0017P\\1nKzBa!a\u001b\u0016\u0001\u0004\u0011\u0018a\u00023vC2\u0014VO\\\u0001\u0011e\u0016\u001cx\u000e\u001c<f\u0013:$U/\u00197Sk:$RAXA9\u0003gBa!!\u0013\u0017\u0001\u0004q\u0006bBA'-\u0001\u0007\u0011qJ\u0001\u001fe\u0016\u001cx\u000e\u001c<f\u0013:\u001c\u0016N\\4mKB\u000b7o\u001d+f]R\fG/\u001b<fYf$RAXA=\u0003wBa!!\u0013\u0018\u0001\u0004q\u0006bBA'/\u0001\u0007\u0011qJ\u0001\u0014e\u0016\u001cx\u000e\u001c<f\u0013:\u001c\u0016N\\4mKB\u000b7o\u001d\u000b\u0006=\u0006\u0005\u00151\u0011\u0005\u0007\u0003\u0013B\u0002\u0019\u00010\t\u000f\u00055\u0003\u00041\u0001\u0002P\u0005\u0019\"/Z:pYZ,\u0017J\u001c$jq\u0016$\u0007k\\5oiR)a,!#\u0002\f\"1\u0011\u0011J\rA\u0002yCq!!\u0014\u001a\u0001\u0004\ty%\u0001\fdQ\u0016\u001c7\u000eR;bYJ+hnU1na2,'+\u0019;f)\u0005\u0011\u0018\u0001\u0006<bY&$\u0017\r^3M_\u001eL7-\u00197QY\u0006t7\u000fF\u0003g\u0003+\u000bI\n\u0003\u0004\u0002\u0018n\u0001\rAX\u0001\u0011M&DX\r\u001a)pS:$(+Z:vYRDa!a'\u001c\u0001\u0004q\u0016\u0001E:j]\u001edW\rU1tgJ+7/\u001e7u\u00035qwN]7bY&TX\r\u00157b]R\u0019a,!)\t\r\u0005%C\u00041\u0001_\u00039\u0011XmY8sI\u0012+(/\u0019;j_:,B!a*\u00024R!\u0011\u0011VAc!\u001dA\u00141VA\u0004\u0003_K1!!,:\u0005\u0019!V\u000f\u001d7feA!\u0011\u0011WAZ\u0019\u0001!q!!.\u001e\u0005\u0004\t9LA\u0001U#\u0011\tI,a0\u0011\u0007a\nY,C\u0002\u0002>f\u0012qAT8uQ&tw\rE\u00029\u0003\u0003L1!a1:\u0005\r\te.\u001f\u0005\t\u0003\u000flB\u00111\u0001\u0002J\u0006)A\u000f[;oWB)\u0001(!\u001a\u00020\u0006q\u0001*\u001f2sS\u0012\fe.\u00197zu\u0016\u0014\bC\u0001% '\tyr\u0007\u0006\u0002\u0002N\u0006\u0011bM]8n\u0019\u0016<\u0017mY=B]\u0006d\u0017P_3s)\u00159\u0018q[Am\u0011\u0015\t\u0015\u00051\u0001C\u0011\u001d\t\u0018\u0005%AA\u0002I\fAD\u001a:p[2+w-Y2z\u0003:\fG.\u001f>fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002`*\u001a!/!9,\u0005\u0005\r\b\u0003BAs\u0003_l!!a:\u000b\t\u0005%\u00181^\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!<:\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003c\f9OA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TCAA|U\ry\u0015\u0011]\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005u(f\u00016\u0002b\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY\u0002")
public class HybridAnalyzer
implements SQLConfHelper {
    private final Analyzer legacyAnalyzer;
    private final ResolverGuard resolverGuard;
    private final boolean exposeExplicitlyUnsupportedResolverFeature;
    private Option<Object> singlePassResolutionDuration;
    private Option<Object> fixedPointResolutionDuration;
    private final ResolverRunner resolverRunner;
    private final Random sampleRateGenerator;

    public static boolean $lessinit$greater$default$6() {
        return HybridAnalyzer$.MODULE$.$lessinit$greater$default$6();
    }

    public static Seq<Rule<LogicalPlan>> $lessinit$greater$default$5() {
        return HybridAnalyzer$.MODULE$.$lessinit$greater$default$5();
    }

    public static Seq<Function1<LogicalPlan, BoxedUnit>> $lessinit$greater$default$4() {
        return HybridAnalyzer$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean fromLegacyAnalyzer$default$2() {
        return HybridAnalyzer$.MODULE$.fromLegacyAnalyzer$default$2();
    }

    public static HybridAnalyzer fromLegacyAnalyzer(Analyzer legacyAnalyzer, boolean exposeExplicitlyUnsupportedResolverFeature) {
        return HybridAnalyzer$.MODULE$.fromLegacyAnalyzer(legacyAnalyzer, exposeExplicitlyUnsupportedResolverFeature);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    private Option<Object> singlePassResolutionDuration() {
        return this.singlePassResolutionDuration;
    }

    private void singlePassResolutionDuration_$eq(Option<Object> x$1) {
        this.singlePassResolutionDuration = x$1;
    }

    private Option<Object> fixedPointResolutionDuration() {
        return this.fixedPointResolutionDuration;
    }

    private void fixedPointResolutionDuration_$eq(Option<Object> x$1) {
        this.fixedPointResolutionDuration = x$1;
    }

    private ResolverRunner resolverRunner() {
        return this.resolverRunner;
    }

    private Random sampleRateGenerator() {
        return this.sampleRateGenerator;
    }

    public LogicalPlan apply(LogicalPlan plan2, QueryPlanningTracker tracker) {
        boolean passedResolvedGuard = this.resolverGuard.apply(plan2);
        boolean dualRun = BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.ANALYZER_DUAL_RUN_LEGACY_AND_SINGLE_PASS_RESOLVER())) && passedResolvedGuard && this.checkDualRunSampleRate();
        return this.withTrackedAnalyzerBridgeState(dualRun, (Function0<LogicalPlan>)(Function0 & Serializable)() -> {
            if (dualRun) {
                return this.resolveInDualRun(plan2, tracker);
            }
            if (BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.ANALYZER_SINGLE_PASS_RESOLVER_ENABLED()))) {
                return this.resolveInSinglePass(plan2, tracker);
            }
            if (passedResolvedGuard && BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.ANALYZER_SINGLE_PASS_RESOLVER_ENABLED_TENTATIVELY()))) {
                return this.resolveInSinglePassTentatively(plan2, tracker);
            }
            return this.resolveInFixedPoint(plan2, tracker);
        });
    }

    public Option<Object> getSinglePassResolutionDuration() {
        return this.singlePassResolutionDuration();
    }

    public Option<Object> getFixedPointResolutionDuration() {
        return this.fixedPointResolutionDuration();
    }

    private LogicalPlan withTrackedAnalyzerBridgeState(boolean dualRun, Function0<LogicalPlan> body) {
        LogicalPlan logicalPlan;
        boolean bridgeRelations = dualRun && BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.ANALYZER_SINGLE_PASS_RESOLVER_RELATION_BRIDGING_ENABLED()));
        Option<AnalyzerBridgeState> prevSinglePassResolverBridgeState = AnalysisContext$.MODULE$.get().getSinglePassResolverBridgeState();
        AnalysisContext$.MODULE$.get().setSinglePassResolverBridgeState((Option<AnalyzerBridgeState>)(bridgeRelations ? new Some((Object)new AnalyzerBridgeState(AnalyzerBridgeState$.MODULE$.$lessinit$greater$default$1(), AnalyzerBridgeState$.MODULE$.$lessinit$greater$default$2(), AnalyzerBridgeState$.MODULE$.$lessinit$greater$default$3())) : None$.MODULE$));
        try {
            logicalPlan = (LogicalPlan)body.apply();
        }
        finally {
            AnalysisContext$.MODULE$.get().setSinglePassResolverBridgeState(prevSinglePassResolverBridgeState);
        }
        return logicalPlan;
    }

    private LogicalPlan resolveInDualRun(LogicalPlan plan2, QueryPlanningTracker tracker) {
        None$ none$;
        None$ none$2;
        None$ fixedPointException = None$.MODULE$;
        try {
            Tuple2 tuple2 = this.recordDuration((Function0 & Serializable)() -> new Some((Object)this.resolveInFixedPoint(plan2, tracker)));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long resolutionDuration = tuple2._1$mcJ$sp();
            Some result = (Some)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)resolutionDuration), (Object)result);
            long resolutionDuration2 = tuple22._1$mcJ$sp();
            Some result2 = (Some)tuple22._2();
            this.fixedPointResolutionDuration_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)resolutionDuration2)));
            none$2 = result2;
        }
        catch (Throwable e) {
            fixedPointException = new Some((Object)e);
            none$2 = None$.MODULE$;
        }
        None$ fixedPointResult = none$2;
        None$ singlePassException = None$.MODULE$;
        try {
            Tuple2 tuple2 = this.recordDuration((Function0 & Serializable)() -> new Some((Object)this.resolveInSinglePass(plan2, tracker)));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long resolutionDuration = tuple2._1$mcJ$sp();
            Some result = (Some)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToLong((long)resolutionDuration), (Object)result);
            long resolutionDuration3 = tuple23._1$mcJ$sp();
            Some result3 = (Some)tuple23._2();
            this.singlePassResolutionDuration_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)resolutionDuration3)));
            none$ = result3;
        }
        catch (Throwable e) {
            singlePassException = new Some((Object)e);
            none$ = None$.MODULE$;
        }
        None$ singlePassResult = none$;
        None$ none$3 = fixedPointException;
        if (none$3 instanceof Some) {
            Some some = (Some)none$3;
            Throwable fixedPointEx = (Throwable)some.value();
            None$ none$4 = singlePassException;
            if (none$4 instanceof Some) {
                throw fixedPointEx;
            }
            if (None$.MODULE$.equals(none$4)) {
                throw QueryCompilationErrors$.MODULE$.fixedPointFailedSinglePassSucceeded((LogicalPlan)singlePassResult.get(), (Throwable)fixedPointException.get());
            }
            throw new MatchError((Object)none$4);
        }
        if (None$.MODULE$.equals(none$3)) {
            boolean bl = false;
            Some some = null;
            None$ none$5 = singlePassException;
            if (none$5 instanceof Some) {
                bl = true;
                some = (Some)none$5;
                Throwable singlePassEx = (Throwable)some.value();
                if (singlePassEx instanceof ExplicitlyUnsupportedResolverFeature) {
                    ExplicitlyUnsupportedResolverFeature explicitlyUnsupportedResolverFeature = (ExplicitlyUnsupportedResolverFeature)singlePassEx;
                    if (this.exposeExplicitlyUnsupportedResolverFeature) {
                        throw explicitlyUnsupportedResolverFeature;
                    }
                    return (LogicalPlan)fixedPointResult.get();
                }
            }
            if (bl) {
                Throwable singlePassEx = (Throwable)some.value();
                throw singlePassEx;
            }
            if (None$.MODULE$.equals(none$5)) {
                this.validateLogicalPlans((LogicalPlan)fixedPointResult.get(), (LogicalPlan)singlePassResult.get());
                if (BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.ANALYZER_DUAL_RUN_RETURN_SINGLE_PASS_RESULT()))) {
                    return (LogicalPlan)singlePassResult.get();
                }
                return (LogicalPlan)fixedPointResult.get();
            }
            throw new MatchError((Object)none$5);
        }
        throw new MatchError((Object)none$3);
    }

    private LogicalPlan resolveInSinglePassTentatively(LogicalPlan plan2, QueryPlanningTracker tracker) {
        LogicalPlan logicalPlan;
        try {
            logicalPlan = this.resolveInSinglePass(plan2, tracker);
        }
        catch (ExplicitlyUnsupportedResolverFeature explicitlyUnsupportedResolverFeature) {
            logicalPlan = this.resolveInFixedPoint(plan2, tracker);
        }
        return logicalPlan;
    }

    private LogicalPlan resolveInSinglePass(LogicalPlan plan2, QueryPlanningTracker tracker) {
        return this.resolverRunner().resolve(plan2, AnalysisContext$.MODULE$.get().getSinglePassResolverBridgeState(), tracker);
    }

    private LogicalPlan resolveInFixedPoint(LogicalPlan plan2, QueryPlanningTracker tracker) {
        LogicalPlan resolvedPlan = this.legacyAnalyzer.executeAndTrack(plan2, tracker);
        QueryPlanningTracker$.MODULE$.withTracker(tracker, (JFunction0.mcV.sp & Serializable)() -> $this.legacyAnalyzer.checkAnalysis(resolvedPlan));
        return resolvedPlan;
    }

    private boolean checkDualRunSampleRate() {
        return this.sampleRateGenerator().nextDouble() < BoxesRunTime.unboxToDouble((Object)this.conf().getConf(SQLConf$.MODULE$.ANALYZER_DUAL_RUN_SAMPLE_RATE()));
    }

    private void validateLogicalPlans(LogicalPlan fixedPointResult, LogicalPlan singlePassResult) {
        StructType structType = fixedPointResult.schema();
        StructType structType2 = singlePassResult.schema();
        if (structType == null ? structType2 != null : !structType.equals(structType2)) {
            throw QueryCompilationErrors$.MODULE$.hybridAnalyzerOutputSchemaComparisonMismatch(fixedPointResult.schema(), singlePassResult.schema());
        }
        LogicalPlan logicalPlan = this.normalizePlan(fixedPointResult);
        LogicalPlan logicalPlan2 = this.normalizePlan(singlePassResult);
        if (logicalPlan == null ? logicalPlan2 != null : !logicalPlan.equals(logicalPlan2)) {
            throw QueryCompilationErrors$.MODULE$.hybridAnalyzerLogicalPlanComparisonMismatch(fixedPointResult, singlePassResult);
        }
    }

    public LogicalPlan normalizePlan(LogicalPlan plan2) {
        return (LogicalPlan)AnalysisHelper$.MODULE$.allowInvokingTransformsInAnalyzer((Function0 & Serializable)() -> NormalizePlan$.MODULE$.apply(plan2));
    }

    private <T> Tuple2<Object, T> recordDuration(Function0<T> thunk) {
        long start = System.nanoTime();
        Object res = thunk.apply();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)(System.nanoTime() - start)), res);
    }

    public HybridAnalyzer(Analyzer legacyAnalyzer, ResolverGuard resolverGuard, Resolver resolver, Seq<Function1<LogicalPlan, BoxedUnit>> extendedResolutionChecks, Seq<Rule<LogicalPlan>> extendedRewriteRules, boolean exposeExplicitlyUnsupportedResolverFeature) {
        this.legacyAnalyzer = legacyAnalyzer;
        this.resolverGuard = resolverGuard;
        this.exposeExplicitlyUnsupportedResolverFeature = exposeExplicitlyUnsupportedResolverFeature;
        SQLConfHelper.$init$(this);
        this.singlePassResolutionDuration = None$.MODULE$;
        this.fixedPointResolutionDuration = None$.MODULE$;
        this.resolverRunner = new ResolverRunner(resolver, extendedResolutionChecks, extendedRewriteRules);
        this.sampleRateGenerator = new Random();
    }
}

