/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import java.util.ArrayDeque;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.AliasResolution$;
import org.apache.spark.sql.catalyst.analysis.MultiAlias;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAlias;
import org.apache.spark.sql.catalyst.analysis.resolver.AutoGeneratedAliasProvider;
import org.apache.spark.sql.catalyst.analysis.resolver.ExplicitlyUnsupportedResolverFeature;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionIdAssigner;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionResolutionContext;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.NameScopeStack;
import org.apache.spark.sql.catalyst.analysis.resolver.ResolvesExpressionChildren;
import org.apache.spark.sql.catalyst.analysis.resolver.TreeNodeResolver;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.OuterReference;
import org.apache.spark.sql.catalyst.expressions.QuaternaryExpression;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u001d4A\u0001D\u0007\u00019!AA\u0007\u0001B\u0001B\u0003%Q\u0007C\u00039\u0001\u0011\u0005\u0011\bC\u0004=\u0001\t\u0007I\u0011B\u001f\t\r\u0005\u0003\u0001\u0015!\u0003?\u0011\u001d\u0011\u0005A1A\u0005\n\rCaa\u0014\u0001!\u0002\u0013!\u0005b\u0002)\u0001\u0005\u0004%I!\u0015\u0005\u0007+\u0002\u0001\u000b\u0011\u0002*\t\u000bY\u0003A\u0011I,\t\u000bu\u0003A\u0011\u00010\t\u000b\u0011\u0004A\u0011B3\u0003\u001b\u0005c\u0017.Y:SKN|GN^3s\u0015\tqq\"\u0001\u0005sKN|GN^3s\u0015\t\u0001\u0012#\u0001\u0005b]\u0006d\u0017p]5t\u0015\t\u00112#\u0001\u0005dCR\fG._:u\u0015\t!R#A\u0002tc2T!AF\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005aI\u0012AB1qC\u000eDWMC\u0001\u001b\u0003\ry'oZ\u0002\u0001'\u0011\u0001QdI\u0019\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\r\u0005s\u0017PU3g!\u0011!SeJ\u0016\u000e\u00035I!AJ\u0007\u0003!Q\u0013X-\u001a(pI\u0016\u0014Vm]8mm\u0016\u0014\bC\u0001\u0015*\u001b\u0005y\u0011B\u0001\u0016\u0010\u0005=)fN]3t_24X\rZ!mS\u0006\u001c\bC\u0001\u00170\u001b\u0005i#B\u0001\u0018\u0012\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\u0005Aj#AC#yaJ,7o]5p]B\u0011AEM\u0005\u0003g5\u0011!DU3t_24Xm]#yaJ,7o]5p]\u000eC\u0017\u000e\u001c3sK:\f!#\u001a=qe\u0016\u001c8/[8o%\u0016\u001cx\u000e\u001c<feB\u0011AEN\u0005\u0003o5\u0011!#\u0012=qe\u0016\u001c8/[8o%\u0016\u001cx\u000e\u001c<fe\u00061A(\u001b8jiz\"\"AO\u001e\u0011\u0005\u0011\u0002\u0001\"\u0002\u001b\u0003\u0001\u0004)\u0014AB:d_B,7/F\u0001?!\t!s(\u0003\u0002A\u001b\tqa*Y7f'\u000e|\u0007/Z*uC\u000e\\\u0017aB:d_B,7\u000fI\u0001!Kb\u0004(/Z:tS>t'+Z:pYV$\u0018n\u001c8D_:$X\r\u001f;Ti\u0006\u001c7.F\u0001E!\r)%\nT\u0007\u0002\r*\u0011q\tS\u0001\u0005kRLGNC\u0001J\u0003\u0011Q\u0017M^1\n\u0005-3%AC!se\u0006LH)Z9vKB\u0011A%T\u0005\u0003\u001d6\u00111$\u0012=qe\u0016\u001c8/[8o%\u0016\u001cx\u000e\\;uS>t7i\u001c8uKb$\u0018!I3yaJ,7o]5p]J+7o\u001c7vi&|gnQ8oi\u0016DHo\u0015;bG.\u0004\u0013AG1vi><UM\\3sCR,G-\u00117jCN\u0004&o\u001c<jI\u0016\u0014X#\u0001*\u0011\u0005\u0011\u001a\u0016B\u0001+\u000e\u0005i\tU\u000f^8HK:,'/\u0019;fI\u0006c\u0017.Y:Qe>4\u0018\u000eZ3s\u0003m\tW\u000f^8HK:,'/\u0019;fI\u0006c\u0017.Y:Qe>4\u0018\u000eZ3sA\u00059!/Z:pYZ,GC\u0001-\\!\ta\u0013,\u0003\u0002[[\tya*Y7fI\u0016C\bO]3tg&|g\u000eC\u0003]\u0013\u0001\u0007q%A\bv]J,7o\u001c7wK\u0012\fE.[1t\u0003MA\u0017M\u001c3mKJ+7o\u001c7wK\u0012\fE.[1t)\ty&\r\u0005\u0002-A&\u0011\u0011-\f\u0002\u0006\u00032L\u0017m\u001d\u0005\u0006G*\u0001\raX\u0001\u0006C2L\u0017m]\u0001\u000eG>dG.\u00199tK\u0006c\u0017.Y:\u0015\u0005}3\u0007\"B2\f\u0001\u0004y\u0006")
public class AliasResolver
implements TreeNodeResolver<UnresolvedAlias, Expression>,
ResolvesExpressionChildren {
    private final ExpressionResolver expressionResolver;
    private final NameScopeStack scopes;
    private final ArrayDeque<ExpressionResolutionContext> expressionResolutionContextStack;
    private final AutoGeneratedAliasProvider autoGeneratedAliasProvider;

    @Override
    public Expression withResolvedChildren(UnaryExpression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public Expression withResolvedChildren(BinaryExpression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public Expression withResolvedChildren(TernaryExpression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public Expression withResolvedChildren(QuaternaryExpression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public Expression withResolvedChildren(Expression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    private NameScopeStack scopes() {
        return this.scopes;
    }

    private ArrayDeque<ExpressionResolutionContext> expressionResolutionContextStack() {
        return this.expressionResolutionContextStack;
    }

    private AutoGeneratedAliasProvider autoGeneratedAliasProvider() {
        return this.autoGeneratedAliasProvider;
    }

    @Override
    public NamedExpression resolve(UnresolvedAlias unresolvedAlias) {
        return this.scopes().current().lcaRegistry().withNewLcaScope((Function0<Alias>)(Function0 & Serializable)() -> {
            UnresolvedAlias aliasWithResolvedChildren = (UnresolvedAlias)this.withResolvedChildren(unresolvedAlias, (Function1<Expression, Expression>)(Function1 & Serializable)unresolvedExpression -> $this.expressionResolver.resolve((Expression)unresolvedExpression));
            NamedExpression resolvedAlias = (NamedExpression)((Object)AliasResolution$.MODULE$.resolve(aliasWithResolvedChildren));
            NamedExpression namedExpression = resolvedAlias;
            if (namedExpression instanceof MultiAlias) {
                MultiAlias multiAlias = (MultiAlias)namedExpression;
                throw new ExplicitlyUnsupportedResolverFeature("unsupported expression: " + multiAlias.getClass().getName());
            }
            if (namedExpression instanceof Alias) {
                Alias alias = (Alias)namedExpression;
                ExpressionIdAssigner qual$1 = $this.expressionResolver.getExpressionIdAssigner();
                Alias x$1 = alias;
                boolean x$2 = qual$1.mapExpression$default$2();
                boolean x$3 = qual$1.mapExpression$default$3();
                boolean x$4 = qual$1.mapExpression$default$4();
                return qual$1.mapExpression(x$1, x$2, x$3, x$4);
            }
            if (namedExpression instanceof OuterReference) {
                OuterReference outerReference = (OuterReference)namedExpression;
                return this.autoGeneratedAliasProvider().newAlias(outerReference, this.autoGeneratedAliasProvider().newAlias$default$2(), this.autoGeneratedAliasProvider().newAlias$default$3());
            }
            throw new MatchError((Object)namedExpression);
        });
    }

    public Alias handleResolvedAlias(Alias alias) {
        Alias resolvedAlias = this.scopes().current().lcaRegistry().withNewLcaScope((Function0<Alias>)(Function0 & Serializable)() -> {
            Alias aliasWithResolvedChildren = (Alias)this.withResolvedChildren(alias, (Function1<Expression, Expression>)(Function1 & Serializable)unresolvedExpression -> $this.expressionResolver.resolve((Expression)unresolvedExpression));
            ExpressionIdAssigner qual$1 = $this.expressionResolver.getExpressionIdAssigner();
            Alias x$1 = aliasWithResolvedChildren;
            boolean x$2 = this.expressionResolutionContextStack().peek().resolvingGroupingExpressions();
            boolean x$3 = qual$1.mapExpression$default$2();
            boolean x$4 = qual$1.mapExpression$default$3();
            Alias mappedAlias = qual$1.mapExpression(x$1, x$3, x$4, x$2);
            this.scopes().current().availableAliases().add(mappedAlias.exprId());
            return mappedAlias;
        });
        return this.collapseAlias(resolvedAlias);
    }

    private Alias collapseAlias(Alias alias) {
        Expression expression = alias.child();
        if (expression instanceof Alias) {
            Alias alias2 = (Alias)expression;
            None$ metadata = alias.metadata().isEmpty() ? None$.MODULE$ : new Some((Object)alias.metadata());
            return alias.copy(alias2.child(), alias.copy$default$2(), alias.exprId(), alias.qualifier(), (Option<Metadata>)metadata, alias.nonInheritableMetadataKeys());
        }
        return alias;
    }

    public AliasResolver(ExpressionResolver expressionResolver) {
        this.expressionResolver = expressionResolver;
        SQLConfHelper.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        ResolvesExpressionChildren.$init$(this);
        this.scopes = expressionResolver.getNameScopes();
        this.expressionResolutionContextStack = expressionResolver.getExpressionResolutionContextStack();
        this.autoGeneratedAliasProvider = new AutoGeneratedAliasProvider(expressionResolver.getExpressionIdAssigner());
    }
}

