/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.Add$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.Between;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.CheckOverflow;
import org.apache.spark.sql.catalyst.expressions.DatetimeSub;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet$;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Multiply;
import org.apache.spark.sql.catalyst.expressions.Multiply$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PreciseTimestampConversion;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.Subtract$;
import org.apache.spark.sql.catalyst.expressions.TimestampAddInterval;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus$;
import org.apache.spark.sql.catalyst.planning.ExtractEquiJoinKeys$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.EventTimeWatermark$;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.JoinHint;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.control.NonFatal$;

public final class StreamingJoinHelper$
implements PredicateHelper {
    public static final StreamingJoinHelper$ MODULE$ = new StreamingJoinHelper$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        AliasHelper.$init$(MODULE$);
        Logging.$init$((Logging)MODULE$);
        PredicateHelper.$init$(MODULE$);
    }

    @Override
    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$(this, condition);
    }

    @Override
    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan2) {
        return PredicateHelper.findExpressionAndTrackLineageDown$(this, exp, plan2);
    }

    @Override
    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$(this, condition);
    }

    @Override
    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$(this, expressions, op);
    }

    @Override
    public boolean canEvaluate(Expression expr, LogicalPlan plan2) {
        return PredicateHelper.canEvaluate$(this, expr, plan2);
    }

    @Override
    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$(this, expr);
    }

    @Override
    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$(this, condition, outputSet);
    }

    @Override
    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$(this, expr);
    }

    @Override
    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$(this, output, nonNullAttrExprIds);
    }

    @Override
    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$(this, e);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public AttributeMap<Alias> getAliasMap(Project plan2) {
        return AliasHelper.getAliasMap$((AliasHelper)this, plan2);
    }

    @Override
    public AttributeMap<Alias> getAliasMap(Aggregate plan2) {
        return AliasHelper.getAliasMap$((AliasHelper)this, plan2);
    }

    @Override
    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    @Override
    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$(this, expr, aliasMap);
    }

    @Override
    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$(this, expr, aliasMap);
    }

    @Override
    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$(this, e);
    }

    @Override
    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$(this, e);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean isWatermarkInJoinKeys(LogicalPlan plan2) {
        Join join;
        Option<Tuple8<JoinType, Seq<Expression>, Seq<Expression>, Option<Expression>, Option<Expression>, LogicalPlan, LogicalPlan, JoinHint>> option;
        LogicalPlan logicalPlan = plan2;
        if (logicalPlan instanceof Join && !(option = ExtractEquiJoinKeys$.MODULE$.unapply(join = (Join)logicalPlan)).isEmpty()) {
            Seq leftKeys = (Seq)((Tuple8)option.get())._2();
            Seq rightKeys = (Seq)((Tuple8)option.get())._3();
            return ((IterableOnceOps)leftKeys.$plus$plus((IterableOnce)rightKeys)).exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StreamingJoinHelper$.$anonfun$isWatermarkInJoinKeys$1(x0$1)));
        }
        return false;
    }

    public Option<Object> getStateValueWatermark(AttributeSet attributesToFindStateWatermarkFor, AttributeSet attributesWithEventWatermark, Option<Expression> joinCondition, Option<Object> eventWatermark) {
        if (joinCondition.isEmpty() || eventWatermark.isEmpty()) {
            return None$.MODULE$;
        }
        if (!attributesWithEventWatermark.exists((Function1<Attribute, Object>)(Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StreamingJoinHelper$.$anonfun$getStateValueWatermark$1(x$1)))) {
            return None$.MODULE$;
        }
        Seq allStateWatermarks = (Seq)this.splitConjunctivePredicates((Expression)joinCondition.get()).flatMap((Function1 & Serializable)predicate -> {
            Option stateWatermark;
            block10: {
                Expression expression = predicate;
                if (expression instanceof LessThan) {
                    LessThan lessThan = (LessThan)expression;
                    Expression l = lessThan.left();
                    Expression r = lessThan.right();
                    v0 = this.getStateWatermarkSafely$1(l, r, attributesToFindStateWatermarkFor, attributesWithEventWatermark, eventWatermark, joinCondition);
                } else if (expression instanceof LessThanOrEqual) {
                    LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)expression;
                    Expression l = lessThanOrEqual.left();
                    Expression r = lessThanOrEqual.right();
                    v0 = this.getStateWatermarkSafely$1(l, r, attributesToFindStateWatermarkFor, attributesWithEventWatermark, eventWatermark, joinCondition).map((Function1)(JFunction1.mcJJ.sp & Serializable)x$2 -> x$2 - 1L);
                } else if (expression instanceof GreaterThan) {
                    GreaterThan greaterThan = (GreaterThan)expression;
                    Expression l = greaterThan.left();
                    Expression r = greaterThan.right();
                    v0 = this.getStateWatermarkSafely$1(r, l, attributesToFindStateWatermarkFor, attributesWithEventWatermark, eventWatermark, joinCondition);
                } else if (expression instanceof GreaterThanOrEqual) {
                    GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)expression;
                    Expression l = greaterThanOrEqual.left();
                    Expression r = greaterThanOrEqual.right();
                    v0 = this.getStateWatermarkSafely$1(r, l, attributesToFindStateWatermarkFor, attributesWithEventWatermark, eventWatermark, joinCondition).map((Function1)(JFunction1.mcJJ.sp & Serializable)x$3 -> x$3 - 1L);
                } else if (expression instanceof Between) {
                    Between between = (Between)expression;
                    Expression input = between.input();
                    Expression lower = between.lower();
                    Expression upper = between.upper();
                    v0 = this.getStateWatermarkSafely$1(lower, input, attributesToFindStateWatermarkFor, attributesWithEventWatermark, eventWatermark, joinCondition).map((Function1)(JFunction1.mcJJ.sp & Serializable)x$4 -> x$4 - 1L).orElse((Function0 & Serializable)() -> this.getStateWatermarkSafely$1(input, upper, attributesToFindStateWatermarkFor, attributesWithEventWatermark, eventWatermark, joinCondition).map((Function1)(JFunction1.mcJJ.sp & Serializable)x$5 -> x$5 - 1L));
                } else {
                    v0 = stateWatermark = None$.MODULE$;
                }
                if (!stateWatermark.nonEmpty()) break block10;
                MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Condition ", " generated "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.JOIN_CONDITION$.MODULE$, (Object)joinCondition)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"watermark constraint = ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.WATERMARK_CONSTRAINT$.MODULE$, stateWatermark.get())})))));
            }
            return stateWatermark;
        });
        return allStateWatermarks.reduceOption((Function2)(JFunction2.mcJJJ.sp & Serializable)(x, y) -> Math.min(x, y));
    }

    private Option<Object> getStateWatermarkFromLessThenPredicate(Expression leftExpr, Expression rightExpr, AttributeSet attributesToFindStateWatermarkFor, AttributeSet attributesWithEventWatermark, Option<Object> eventWatermark) {
        AttributeSet attributesInCondition = AttributeSet$.MODULE$.apply((Iterable<Expression>)((Iterable)leftExpr.collect(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)A1;
                    return (B1)attributeReference;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                return expression instanceof AttributeReference;
            }
        }).$plus$plus(rightExpr.collect(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)A1;
                    return (B1)attributeReference;
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                return expression instanceof AttributeReference;
            }
        }))));
        if (attributesInCondition.count((Function1<Attribute, Object>)(Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)attributesToFindStateWatermarkFor.contains(elem))) > 1 || attributesInCondition.count((Function1<Attribute, Object>)(Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)attributesWithEventWatermark.contains(elem))) > 1) {
            return None$.MODULE$;
        }
        Subtract allOnLeftExpr = new Subtract(leftExpr, rightExpr, Subtract$.MODULE$.apply$default$3());
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "All on Left:\n" + allOnLeftExpr.treeString(true, allOnLeftExpr.treeString$default$2(), allOnLeftExpr.treeString$default$3(), allOnLeftExpr.treeString$default$4(), allOnLeftExpr.treeString$default$5()) + "\n" + allOnLeftExpr.asCode());
        ExpressionSet terms = ExpressionSet$.MODULE$.apply((IterableOnce<Expression>)this.collectTerms(allOnLeftExpr));
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Terms extracted from join condition:\n\t" + terms.mkString("\n\t"));
        Object constraintTerms = terms.filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)StreamingJoinHelper$.containsAttributeToFindStateConstraintFor$1(e, attributesToFindStateWatermarkFor)));
        if (((ExpressionSet)constraintTerms).size() > 1) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to extract state constraint terms: multiple time terms in condition\\n\\t"}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXPR_TERMS$.MODULE$, (Object)terms.mkString("\n\t"))})))));
            return None$.MODULE$;
        }
        if (((ExpressionSet)constraintTerms).isEmpty()) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Failed to extract state constraint terms: no time terms in condition\n\t" + terms.mkString("\n\t"));
            return None$.MODULE$;
        }
        Expression constraintTerm = (Expression)((ExpressionSet)constraintTerms).head();
        if (!constraintTerm.exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)StreamingJoinHelper$.$anonfun$getStateWatermarkFromLessThenPredicate$8(x$6)))) {
            return None$.MODULE$;
        }
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Constraint term from join condition:\t" + constraintTerm);
        Expression exprWithWatermarkSubstituted = (Expression)((ExpressionSet)terms.$minus(constraintTerm).map((Function1 & Serializable)term -> (Expression)term.transform(new Serializable(attributesWithEventWatermark, eventWatermark){
            private static final long serialVersionUID = 0L;
            private final AttributeSet attributesWithEventWatermark$2;
            private final Option eventWatermark$2;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                A1 A1 = x3;
                if (A1 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)A1;
                    Metadata metadata = attributeReference.metadata();
                    if (this.attributesWithEventWatermark$2.contains(attributeReference) && metadata.contains(EventTimeWatermark$.MODULE$.delayKey())) {
                        return (B1)new Multiply(Literal$.MODULE$.apply(BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToLong((Object)this.eventWatermark$2.get()))), Literal$.MODULE$.apply(BoxesRunTime.boxToDouble((double)1000.0)), Multiply$.MODULE$.apply$default$3());
                    }
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(Expression x3) {
                Expression expression = x3;
                if (expression instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)expression;
                    Metadata metadata = attributeReference.metadata();
                    if (this.attributesWithEventWatermark$2.contains(attributeReference) && metadata.contains(EventTimeWatermark$.MODULE$.delayKey())) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.attributesWithEventWatermark$2 = attributesWithEventWatermark$2;
                this.eventWatermark$2 = eventWatermark$2;
            }
        }))).reduceLeft((Function2 & Serializable)(x$7, x$8) -> new Add((Expression)x$7, (Expression)x$8, Add$.MODULE$.apply$default$3()));
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Final expression to evaluate "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"constraint:\\t", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.WATERMARK_CONSTRAINT$.MODULE$, (Object)exprWithWatermarkSubstituted)})))));
        Double constraintValue = (Double)exprWithWatermarkSubstituted.eval(exprWithWatermarkSubstituted.eval$default$1());
        return new Some((Object)BoxesRunTime.boxToLong((long)((long)(Predef$.MODULE$.Double2double(constraintValue) / 1000.0))));
    }

    private Seq<Expression> collectTerms(Expression exprToCollectFrom) {
        BooleanRef invalid = BooleanRef.create((boolean)false);
        Seq terms = this.collect$1(exprToCollectFrom, false, invalid, exprToCollectFrom);
        if (!invalid.elem) {
            return terms;
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public static final /* synthetic */ boolean $anonfun$isWatermarkInJoinKeys$1(Expression x0$1) {
        Expression expression = x0$1;
        if (expression instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)expression;
            return attributeReference.metadata().contains(EventTimeWatermark$.MODULE$.delayKey());
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$getStateValueWatermark$1(Attribute x$1) {
        return x$1.metadata().contains(EventTimeWatermark$.MODULE$.delayKey());
    }

    private final Option getStateWatermarkSafely$1(Expression l, Expression r, AttributeSet attributesToFindStateWatermarkFor$1, AttributeSet attributesWithEventWatermark$1, Option eventWatermark$1, Option joinCondition$1) {
        None$ none$;
        try {
            none$ = this.getStateWatermarkFromLessThenPredicate(l, r, attributesToFindStateWatermarkFor$1, attributesWithEventWatermark$1, (Option<Object>)eventWatermark$1);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error trying to extract state constraint from condition "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.JOIN_CONDITION$.MODULE$, (Object)joinCondition$1)})))), throwable2);
                none$ = None$.MODULE$;
            }
            throw throwable;
        }
        return none$;
    }

    private static final boolean containsAttributeToFindStateConstraintFor$1(Expression e, AttributeSet attributesToFindStateWatermarkFor$2) {
        return e.collectLeaves().collectFirst((PartialFunction)new Serializable(attributesToFindStateWatermarkFor$2){
            private static final long serialVersionUID = 0L;
            private final AttributeSet attributesToFindStateWatermarkFor$2;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                AttributeReference attributeReference;
                A1 A1 = x1;
                if (A1 instanceof AttributeReference && this.attributesToFindStateWatermarkFor$2.contains(attributeReference = (AttributeReference)A1)) {
                    return (B1)attributeReference;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                AttributeReference attributeReference;
                Expression expression = x1;
                return expression instanceof AttributeReference && this.attributesToFindStateWatermarkFor$2.contains(attributeReference = (AttributeReference)expression);
            }
            {
                this.attributesToFindStateWatermarkFor$2 = attributesToFindStateWatermarkFor$2;
            }
        }).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getStateWatermarkFromLessThenPredicate$8(Expression x$6) {
        return x$6 instanceof UnaryMinus;
    }

    private static final Expression negateIfNeeded$1(Expression expr, boolean minus) {
        if (minus) {
            return new UnaryMinus(expr, UnaryMinus$.MODULE$.apply$default$2());
        }
        return expr;
    }

    private final Seq collect$1(Expression expr, boolean negate, BooleanRef invalid$1, Expression exprToCollectFrom$1) {
        Expression expression;
        block21: {
            while (true) {
                if ((expression = expr) instanceof Add) {
                    Add add = (Add)expression;
                    Expression left = add.left();
                    Expression right = add.right();
                    return (Seq)this.collect$1(left, negate, invalid$1, exprToCollectFrom$1).$plus$plus((IterableOnce)this.collect$1(right, negate, invalid$1, exprToCollectFrom$1));
                }
                if (expression instanceof Subtract) {
                    Subtract subtract = (Subtract)expression;
                    Expression left = subtract.left();
                    Expression right = subtract.right();
                    return (Seq)this.collect$1(left, negate, invalid$1, exprToCollectFrom$1).$plus$plus((IterableOnce)this.collect$1(right, !negate, invalid$1, exprToCollectFrom$1));
                }
                if (expression instanceof TimestampAddInterval) {
                    TimestampAddInterval timestampAddInterval = (TimestampAddInterval)expression;
                    Expression left = timestampAddInterval.start();
                    Expression right = timestampAddInterval.interval();
                    return (Seq)this.collect$1(left, negate, invalid$1, exprToCollectFrom$1).$plus$plus((IterableOnce)this.collect$1(right, negate, invalid$1, exprToCollectFrom$1));
                }
                if (expression instanceof DatetimeSub) {
                    Expression child;
                    DatetimeSub datetimeSub = (DatetimeSub)expression;
                    expr = child = datetimeSub.replacement();
                    continue;
                }
                if (expression instanceof UnaryMinus) {
                    UnaryMinus unaryMinus = (UnaryMinus)expression;
                    Expression child = unaryMinus.child();
                    negate = !negate;
                    expr = child;
                    continue;
                }
                if (expression instanceof CheckOverflow) {
                    Expression child;
                    CheckOverflow checkOverflow = (CheckOverflow)expression;
                    expr = child = checkOverflow.child();
                    continue;
                }
                if (!(expression instanceof Cast)) break block21;
                Cast cast = (Cast)expression;
                Expression child = cast.child();
                DataType dataType = cast.dataType();
                DataType dataType2 = dataType;
                if (!(dataType2 instanceof NumericType ? true : dataType2 instanceof TimestampType)) break;
                expr = child;
            }
            invalid$1.elem = true;
            return (Seq)package$.MODULE$.Seq().empty();
        }
        if (expression instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)expression;
            DataType dataType = attributeReference.dataType();
            DoubleType$ doubleType$ = DoubleType$.MODULE$;
            AttributeReference castedRef = (dataType == null ? doubleType$ != null : !dataType.equals(doubleType$)) ? new Cast(attributeReference, (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()) : attributeReference;
            return new .colon.colon((Object)StreamingJoinHelper$.negateIfNeeded$1(castedRef, negate), (List)Nil$.MODULE$);
        }
        if (expression instanceof Literal) {
            Expression expression2;
            Literal literal = (Literal)expression;
            DataType dataType = literal.dataType();
            if (CalendarIntervalType$.MODULE$.equals(dataType)) {
                CalendarInterval calendarInterval = (CalendarInterval)literal.value();
                if (calendarInterval.months != 0) {
                    invalid$1.elem = true;
                    this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to extract state value watermark from condition "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.JOIN_CONDITION$.MODULE$, (Object)exprToCollectFrom$1)}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"as imprecise intervals like months and years cannot be used for"}))).log((Seq)Nil$.MODULE$)).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"watermark calculation. Use interval in terms of day instead."}))).log((Seq)Nil$.MODULE$))));
                    expression2 = Literal$.MODULE$.apply(BoxesRunTime.boxToDouble((double)0.0));
                } else {
                    expression2 = Literal$.MODULE$.apply(BoxesRunTime.boxToDouble((double)((double)calendarInterval.days * 8.64E10 + (double)calendarInterval.microseconds)));
                }
            } else if (dataType instanceof DayTimeIntervalType) {
                expression2 = Literal$.MODULE$.apply(BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToLong((Object)literal.value())));
            } else if (DoubleType$.MODULE$.equals(dataType)) {
                expression2 = new Multiply(literal, Literal$.MODULE$.apply(BoxesRunTime.boxToDouble((double)1000000.0)), Multiply$.MODULE$.apply$default$3());
            } else if (dataType instanceof NumericType) {
                expression2 = new Multiply(new Cast(literal, (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), Literal$.MODULE$.apply(BoxesRunTime.boxToDouble((double)1000000.0)), Multiply$.MODULE$.apply$default$3());
            } else if (dataType instanceof TimestampType) {
                expression2 = new Multiply(new PreciseTimestampConversion(literal, (DataType)TimestampType$.MODULE$, (DataType)LongType$.MODULE$), Literal$.MODULE$.apply(BoxesRunTime.boxToDouble((double)1000000.0)), Multiply$.MODULE$.apply$default$3());
            } else {
                throw new MatchError((Object)dataType);
            }
            Expression castedLit = expression2;
            return new .colon.colon((Object)StreamingJoinHelper$.negateIfNeeded$1(castedLit, negate), (List)Nil$.MODULE$);
        }
        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to extract state value watermark from condition "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " due to "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.JOIN_CONDITION$.MODULE$, (Object)exprToCollectFrom$1)}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.JOIN_CONDITION_SUB_EXPR$.MODULE$, (Object)expression)})))));
        invalid$1.elem = true;
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private StreamingJoinHelper$() {
    }
}

