/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import java.io.Serializable;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.KubernetesVolumeUtils$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.package$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc!\u0002\u000e\u001c\u0001})\u0003\"\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a7\u0011!9\u0004A!b\u0001\n\u0003A\u0004\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u0011\u001d\u0003!Q1A\u0005\u0002aB\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u0013\u0002\u0011)\u0019!C\u0001\u0015\"AQ\f\u0001B\u0001B\u0003%1\n\u0003\u0005_\u0001\t\u0015\r\u0011\"\u0001`\u0011!\u0019\u0007A!A!\u0002\u0013\u0001\u0007\"\u00023\u0001\t\u0003)\u0007\"\u00027\u0001\t\u0003i\u0007bB9\u0001\u0005\u0004%\t\u0005\u000f\u0005\u0007e\u0002\u0001\u000b\u0011B\u001d\t\u000bM\u0004A\u0011I7\t\u000bQ\u0004A\u0011I7\t\u000bU\u0004A\u0011I7\t\u000bY\u0004A\u0011I7\t\u000b]\u0004A\u0011I7\t\u000ba\u0004A\u0011I=\t\u000f\u00055\u0001\u0001\"\u0011\u0002\u0010!9\u00111\u0003\u0001\u0005\n\u0005UqACA\u00117\u0005\u0005\t\u0012A\u0010\u0002$\u0019I!dGA\u0001\u0012\u0003y\u0012Q\u0005\u0005\u0007I^!\t!!\f\t\u0013\u0005=r#%A\u0005\u0002\u0005E\"AF&vE\u0016\u0014h.\u001a;fg\u0016CXmY;u_J\u001cuN\u001c4\u000b\u0005qi\u0012aA69g*\u0011adH\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005\u0001\n\u0013!B:qCJ\\'B\u0001\u0012$\u0003\u0019\t\u0007/Y2iK*\tA%A\u0002pe\u001e\u001c2\u0001\u0001\u0014+!\t9\u0003&D\u0001\u001c\u0013\tI3D\u0001\bLk\n,'O\\3uKN\u001cuN\u001c4\u0011\u0005-rS\"\u0001\u0017\u000b\u00055z\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005=b#a\u0002'pO\u001eLgnZ\u0001\ngB\f'o[\"p]\u001a\u001c\u0001\u0001\u0005\u00024i5\tq$\u0003\u00026?\tI1\u000b]1sW\u000e{gNZ\u0005\u0003a!\nQ!\u00199q\u0013\u0012,\u0012!\u000f\t\u0003u\rs!aO!\u0011\u0005qzT\"A\u001f\u000b\u0005y\n\u0014A\u0002\u001fs_>$hHC\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u0011u(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\t\u0016\u0013aa\u0015;sS:<'B\u0001\"@\u0003\u0019\t\u0007\u000f]%eA\u0005QQ\r_3dkR|'/\u00133\u0002\u0017\u0015DXmY;u_JLE\rI\u0001\nIJLg/\u001a:Q_\u0012,\u0012a\u0013\t\u0004\u00196{U\"A \n\u00059{$AB(qi&|g\u000e\u0005\u0002Q76\t\u0011K\u0003\u0002S'\u0006)Qn\u001c3fY*\u0011A+V\u0001\u0004CBL'B\u0001,X\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u00031f\u000bqAZ1ce&\u001c\u0007HC\u0001[\u0003\tIw.\u0003\u0002]#\n\u0019\u0001k\u001c3\u0002\u0015\u0011\u0014\u0018N^3s!>$\u0007%A\tsKN|WO]2f!J|g-\u001b7f\u0013\u0012,\u0012\u0001\u0019\t\u0003\u0019\u0006L!AY \u0003\u0007%sG/\u0001\nsKN|WO]2f!J|g-\u001b7f\u0013\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0004gO\"L'n\u001b\t\u0003O\u0001AQ\u0001\r\u0006A\u0002IBQa\u000e\u0006A\u0002eBQa\u0012\u0006A\u0002eBQ!\u0013\u0006A\u0002-CqA\u0018\u0006\u0011\u0002\u0003\u0007\u0001-\u0001\u000bfq\u0016\u001cW\u000f^8s\u001d>$WmU3mK\u000e$xN]\u000b\u0002]B!!h\\\u001d:\u0013\t\u0001XIA\u0002NCB\f!C]3t_V\u00148-\u001a(b[\u0016\u0004&/\u001a4jq\u0006\u0019\"/Z:pkJ\u001cWMT1nKB\u0013XMZ5yA\u00051A.\u00192fYN\f1\"\u001a8wSJ|g.\\3oi\u0006Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0003]\u0019Xm\u0019:fi:\u000bW.Z:U_6{WO\u001c;QCRD7/A\ftK\u000e\u0014X\r^#om:\u000bW.Z:U_.+\u0017PU3gg\u00069ao\u001c7v[\u0016\u001cX#\u0001>\u0011\u000bm\f\t!a\u0002\u000f\u0005qthB\u0001\u001f~\u0013\u0005\u0001\u0015BA@@\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0001\u0002\u0006\t\u00191+Z9\u000b\u0005}|\u0004cA\u0014\u0002\n%\u0019\u00111B\u000e\u0003)-+(-\u001a:oKR,7OV8mk6,7\u000b]3d\u00035\u00198\r[3ek2,'OT1nKV\u0011\u0011\u0011\u0003\t\u0004\u00196K\u0014aE2iK\u000e\\W\t_3dkR|'/\u00128w\u0017\u0016LH\u0003BA\f\u0003;\u00012\u0001TA\r\u0013\r\tYb\u0010\u0002\b\u0005>|G.Z1o\u0011\u0019\ty\"\u0006a\u0001s\u0005\u00191.Z=\u0002--+(-\u001a:oKR,7/\u0012=fGV$xN]\"p]\u001a\u0004\"aJ\f\u0014\u0007]\t9\u0003E\u0002M\u0003SI1!a\u000b@\u0005\u0019\te.\u001f*fMR\u0011\u00111E\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005M\"f\u00011\u00026-\u0012\u0011q\u0007\t\u0005\u0003s\t\u0019%\u0004\u0002\u0002<)!\u0011QHA \u0003%)hn\u00195fG.,GMC\u0002\u0002B}\n!\"\u00198o_R\fG/[8o\u0013\u0011\t)%a\u000f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class KubernetesExecutorConf
extends KubernetesConf
implements Logging {
    private final String appId;
    private final String executorId;
    private final Option<Pod> driverPod;
    private final int resourceProfileId;
    private final String resourceNamePrefix;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static int $lessinit$greater$default$5() {
        return KubernetesExecutorConf$.MODULE$.$lessinit$greater$default$5();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String appId() {
        return this.appId;
    }

    public String executorId() {
        return this.executorId;
    }

    public Option<Pod> driverPod() {
        return this.driverPod;
    }

    public int resourceProfileId() {
        return this.resourceProfileId;
    }

    public scala.collection.immutable.Map<String, String> executorNodeSelector() {
        return KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_EXECUTOR_NODE_SELECTOR_PREFIX());
    }

    @Override
    public String resourceNamePrefix() {
        return this.resourceNamePrefix;
    }

    @Override
    public scala.collection.immutable.Map<String, String> labels() {
        scala.collection.immutable.Map presetLabels = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_VERSION_LABEL()), (Object)package$.MODULE$.SPARK_VERSION()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), (Object)this.executorId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_ID_LABEL()), (Object)this.appId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_NAME_LABEL()), (Object)KubernetesConf$.MODULE$.getAppNameLabel(this.appName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_ROLE_LABEL()), (Object)Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_RESOURCE_PROFILE_ID_LABEL()), (Object)Integer.toString(this.resourceProfileId()))}));
        scala.collection.immutable.Map executorCustomLabels = (scala.collection.immutable.Map)KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_EXECUTOR_LABEL_PREFIX()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new Tuple2((Object)k, (Object)Utils$.MODULE$.substituteAppNExecIds(v, this.appId(), this.executorId()));
            }
            throw new MatchError((Object)tuple2);
        });
        presetLabels.keys().foreach((Function1 & Serializable)key -> {
            Predef$.MODULE$.require(!executorCustomLabels.contains((Object)key), (Function0 & Serializable)() -> "Custom executor labels cannot contain " + key + " as it is reserved for Spark.");
            return BoxedUnit.UNIT;
        });
        return (scala.collection.immutable.Map)executorCustomLabels.$plus$plus((IterableOnce)presetLabels);
    }

    @Override
    public scala.collection.immutable.Map<String, String> environment() {
        return ((IterableOnceOps)super.sparkConf().getExecutorEnv().filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)this.checkExecutorEnvKey((String)p._1())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public scala.collection.immutable.Map<String, String> annotations() {
        return (scala.collection.immutable.Map)KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_EXECUTOR_ANNOTATION_PREFIX()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new Tuple2((Object)k, (Object)Utils$.MODULE$.substituteAppNExecIds(v, this.appId(), this.executorId()));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    @Override
    public scala.collection.immutable.Map<String, String> secretNamesToMountPaths() {
        return KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_EXECUTOR_SECRETS_PREFIX());
    }

    @Override
    public scala.collection.immutable.Map<String, String> secretEnvNamesToKeyRefs() {
        return KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_EXECUTOR_SECRET_KEY_REF_PREFIX());
    }

    @Override
    public Seq<KubernetesVolumeSpec> volumes() {
        return KubernetesVolumeUtils$.MODULE$.parseVolumesWithPrefix(super.sparkConf(), Config$.MODULE$.KUBERNETES_EXECUTOR_VOLUMES_PREFIX());
    }

    @Override
    public Option<String> schedulerName() {
        return Option$.MODULE$.apply(((Option)this.get(Config$.MODULE$.KUBERNETES_EXECUTOR_SCHEDULER_NAME())).getOrElse((Function0 & Serializable)() -> (String)((Option)this.get(Config$.MODULE$.KUBERNETES_SCHEDULER_NAME())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    private boolean checkExecutorEnvKey(String key) {
        Regex executorEnvRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[-._a-zA-Z][-._a-zA-Z0-9]*"));
        if (executorEnvRegex.pattern().matcher(key).matches()) {
            return true;
        }
        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid key: ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CONFIG$.MODULE$, (Object)key)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a valid environment variable name must consist of alphabetic characters, "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"digits, '_', '-', or '.', and must not start with a digit. "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Regex used for validation is '", "'"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTOR_ENV_REGEX$.MODULE$, (Object)executorEnvRegex)})))));
        return false;
    }

    public KubernetesExecutorConf(SparkConf sparkConf, String appId, String executorId, Option<Pod> driverPod, int resourceProfileId) {
        this.appId = appId;
        this.executorId = executorId;
        this.driverPod = driverPod;
        this.resourceProfileId = resourceProfileId;
        super(sparkConf);
        Logging.$init$((Logging)this);
        this.resourceNamePrefix = (String)((Option)this.get(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX())).getOrElse((Function0 & Serializable)() -> KubernetesConf$.MODULE$.getResourceNamePrefix(this.appName()));
    }
}

