/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.util;

import java.util.ArrayList;
import java.util.List;

public class MemoryPageUtils<T> {
    private List<T> dataList;
    private int pageSize;

    public MemoryPageUtils(int pageSize) {
        this.pageSize = pageSize;
        this.dataList = new ArrayList<T>();
    }

    public void addToMemory(T data) {
        this.dataList.add(data);
    }

    public List<T> readFromMemory(int pageNumber) {
        int startIndex = pageNumber * this.pageSize;
        int endIndex = Math.min(startIndex + this.pageSize, this.dataList.size());
        if (startIndex >= this.dataList.size()) {
            return null;
        }
        return this.dataList.subList(startIndex, endIndex);
    }

    public int getPages() {
        return this.dataList.size() / this.pageSize + 1;
    }
}

