/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.pipelines.graph.FlowAnalysisContext;
import org.apache.spark.sql.pipelines.graph.GraphIdentifierManager;
import org.apache.spark.sql.pipelines.graph.GraphIdentifierManager$InternalDatasetIdentifier$;
import org.apache.spark.sql.pipelines.graph.IdentifierHelper$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class GraphIdentifierManager$ {
    public static final GraphIdentifierManager$ MODULE$ = new GraphIdentifierManager$();

    public TableIdentifier parseTableIdentifier(String name, SparkSession spark) {
        return IdentifierHelper$.MODULE$.toTableIdentifier((Seq<String>)spark.sessionState().sqlParser().parseMultipartIdentifier(name));
    }

    public GraphIdentifierManager.DatasetIdentifier parseAndQualifyInputIdentifier(FlowAnalysisContext context, String rawInputName) {
        return this.resolveDatasetReadInsideQueryDefinition(context, rawInputName);
    }

    private GraphIdentifierManager.DatasetIdentifier resolveDatasetReadInsideQueryDefinition(FlowAnalysisContext context, String rawInputName) {
        TableIdentifier inputIdentifier = this.parseTableIdentifier(rawInputName, context.spark());
        if (IdentifierHelper$.MODULE$.isSinglePartIdentifier(inputIdentifier) && GraphIdentifierManager$.isInternalDataset$1(inputIdentifier, context)) {
            return GraphIdentifierManager$InternalDatasetIdentifier$.MODULE$.apply(inputIdentifier);
        }
        if (IdentifierHelper$.MODULE$.isPathIdentifier(context.spark(), inputIdentifier)) {
            return new GraphIdentifierManager.ExternalDatasetIdentifier(inputIdentifier);
        }
        TableIdentifier fullyQualifiedInputIdentifier = IdentifierHelper$.MODULE$.fullyQualifyIdentifier(inputIdentifier, context.queryContext().currentCatalog(), context.queryContext().currentDatabase());
        IdentifierHelper$.MODULE$.assertIsFullyQualifiedForRead(fullyQualifiedInputIdentifier);
        if (GraphIdentifierManager$.isInternalDataset$1(fullyQualifiedInputIdentifier, context)) {
            return GraphIdentifierManager$InternalDatasetIdentifier$.MODULE$.apply(fullyQualifiedInputIdentifier);
        }
        return new GraphIdentifierManager.ExternalDatasetIdentifier(fullyQualifiedInputIdentifier);
    }

    private GraphIdentifierManager.InternalDatasetIdentifier parseAndValidatePipelineDatasetIdentifier(TableIdentifier rawDatasetIdentifier) throws AnalysisException {
        return GraphIdentifierManager$InternalDatasetIdentifier$.MODULE$.apply(rawDatasetIdentifier);
    }

    public GraphIdentifierManager.InternalDatasetIdentifier parseAndQualifyTableIdentifier(TableIdentifier rawTableIdentifier, Option<String> currentCatalog, Option<String> currentDatabase) throws AnalysisException {
        GraphIdentifierManager.InternalDatasetIdentifier pipelineDatasetIdentifier = this.parseAndValidatePipelineDatasetIdentifier(rawTableIdentifier);
        TableIdentifier fullyQualifiedTableIdentifier = IdentifierHelper$.MODULE$.fullyQualifyIdentifier(pipelineDatasetIdentifier.identifier(), currentCatalog, currentDatabase);
        IdentifierHelper$.MODULE$.assertIsFullyQualifiedForCreate(fullyQualifiedTableIdentifier);
        return GraphIdentifierManager$InternalDatasetIdentifier$.MODULE$.apply(fullyQualifiedTableIdentifier);
    }

    public TableIdentifier parseAndValidateTemporaryViewIdentifier(TableIdentifier rawViewIdentifier) throws AnalysisException {
        GraphIdentifierManager.InternalDatasetIdentifier internalDatasetIdentifier = this.parseAndValidatePipelineDatasetIdentifier(rawViewIdentifier);
        if (!IdentifierHelper$.MODULE$.isSinglePartIdentifier(internalDatasetIdentifier.identifier())) {
            throw new AnalysisException("MULTIPART_TEMPORARY_VIEW_NAME_NOT_SUPPORTED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"viewName"), (Object)rawViewIdentifier.unquotedString())})));
        }
        return internalDatasetIdentifier.identifier();
    }

    public TableIdentifier parseAndValidatePersistedViewIdentifier(TableIdentifier rawViewIdentifier, Option<String> currentCatalog, Option<String> currentDatabase) {
        GraphIdentifierManager.InternalDatasetIdentifier internalDatasetIdentifier = this.parseAndValidatePipelineDatasetIdentifier(rawViewIdentifier);
        TableIdentifier fullyQualifiedViewIdentifier = IdentifierHelper$.MODULE$.fullyQualifyIdentifier(internalDatasetIdentifier.identifier(), currentCatalog, currentDatabase);
        IdentifierHelper$.MODULE$.assertIsFullyQualifiedForCreate(fullyQualifiedViewIdentifier);
        return fullyQualifiedViewIdentifier;
    }

    public GraphIdentifierManager.InternalDatasetIdentifier parseAndQualifyFlowIdentifier(TableIdentifier rawFlowIdentifier, Option<String> currentCatalog, Option<String> currentDatabase) throws AnalysisException {
        GraphIdentifierManager.InternalDatasetIdentifier internalDatasetIdentifier = this.parseAndValidatePipelineDatasetIdentifier(rawFlowIdentifier);
        TableIdentifier fullyQualifiedFlowIdentifier = IdentifierHelper$.MODULE$.fullyQualifyIdentifier(internalDatasetIdentifier.identifier(), currentCatalog, currentDatabase);
        IdentifierHelper$.MODULE$.assertIsFullyQualifiedForCreate(fullyQualifiedFlowIdentifier);
        return GraphIdentifierManager$InternalDatasetIdentifier$.MODULE$.apply(fullyQualifiedFlowIdentifier);
    }

    private static final boolean isInternalDataset$1(TableIdentifier identifier, FlowAnalysisContext context$1) {
        return context$1.allInputs().contains((Object)identifier);
    }

    private GraphIdentifierManager$() {
    }
}

