/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.python;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channels;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFiles$;
import org.apache.spark.api.python.PythonUtils$;
import org.apache.spark.api.python.PythonWorker;
import org.apache.spark.api.python.PythonWorkerFactory$;
import org.apache.spark.api.python.PythonWorkerUtils$;
import org.apache.spark.errors.SparkCoreErrors$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.Python$;
import org.apache.spark.security.SocketAuthHelper;
import org.apache.spark.util.RedirectThread;
import org.apache.spark.util.RedirectThread$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.WeakHashMap;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0005\tUc!\u0002\u001f>\u0001\u0005;\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u0011\u0005\u0004!\u0011!Q\u0001\nYC\u0001B\u0019\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\tG\u0002\u0011\t\u0011)A\u0005I\"Aq\r\u0001BC\u0002\u0013\u0005\u0001\u000e\u0003\u0005m\u0001\t\u0005\t\u0015!\u0003j\u0011\u0015i\u0007\u0001\"\u0001o\u0011\u0015i\u0007\u0001\"\u0001w\u0011\u001dY\bA1A\u0005\n!Da\u0001 \u0001!\u0002\u0013I\u0007bB?\u0001\u0005\u0004%IA \u0005\b\u0003\u0017\u0001\u0001\u0015!\u0003\u0000\u0011!\ti\u0001\u0001b\u0001\n\u0013A\u0007bBA\b\u0001\u0001\u0006I!\u001b\u0005\n\u0003#\u0001\u0001\u0019!C\u0005\u0003'A\u0011\"!\n\u0001\u0001\u0004%I!a\n\t\u0011\u0005M\u0002\u0001)Q\u0005\u0003+A\u0011\"!\u0015\u0001\u0005\u0004%\t!a\u0015\t\u0011\u0005\u0005\u0004\u0001)A\u0005\u0003+B\u0011\"a\u0019\u0001\u0001\u0004%I!!\u001a\t\u0013\u00055\u0004\u00011A\u0005\n\u0005=\u0004\u0002CA:\u0001\u0001\u0006K!a\u001a\t\u0013\u0005]\u0004A1A\u0005\n\u0005e\u0004\u0002CAL\u0001\u0001\u0006I!a\u001f\t\u0017\u0005m\u0005\u00011AA\u0002\u0013%\u0011Q\u0014\u0005\f\u0003?\u0003\u0001\u0019!a\u0001\n\u0013\t\t\u000b\u0003\u0006\u0002&\u0002\u0001\r\u0011!Q!\nYC\u0011\"!+\u0001\u0005\u0004%I!a+\t\u0011\u0005M\u0006\u0001)A\u0005\u0003[C\u0011\"a.\u0001\u0001\u0004%I!!/\t\u0013\u0005\u0005\u0007\u00011A\u0005\n\u0005\r\u0007\u0002CAd\u0001\u0001\u0006K!a/\t\u0013\u0005-\u0007A1A\u0005\n\u00055\u0007\u0002CAi\u0001\u0001\u0006I!a4\t\u0013\u0005U\u0007A1A\u0005\n\u0005u\u0005bBAl\u0001\u0001\u0006IA\u0016\u0005\b\u00033\u0004A\u0011AAn\u0011\u001d\tI\u000f\u0001C\u0005\u00037D\u0001\"a;\u0001\t\u0003\t\u0015Q\u001e\u0005\b\u0003g\u0004A\u0011BA{\u0011\u001d\t9\u0010\u0001C\u0005\u0003s4aAa\u0004\u0001\t\tE\u0001BB7+\t\u0003\u0011I\u0002C\u0004\u0003 )\"\t%!>\t\u000f\t\u0005\u0002\u0001\"\u0003\u0002v\"9!1\u0005\u0001\u0005\n\u0005U\bb\u0002B\u0013\u0001\u0011\u0005\u0011Q\u001f\u0005\b\u0005O\u0001A\u0011\u0001B\u0015\u0011\u001d\u0011y\u0003\u0001C\u0001\u0005cAqA!\u000e\u0001\t\u0003\u00119d\u0002\u0005\u0003<uB\t!\u0011B\u001f\r\u001daT\b#\u0001B\u0005\u007fAa!\u001c\u001b\u0005\u0002\t\u0005\u0003\"\u0003B\"i\t\u0007I\u0011AA3\u0011!\u0011)\u0005\u000eQ\u0001\n\u0005\u001d\u0004\"\u0003B$i\t\u0007I\u0011AA]\u0011!\u0011I\u0005\u000eQ\u0001\n\u0005m\u0006B\u0003B&i\t\u0007I\u0011A!\u0003N!A!1\u000b\u001b!\u0002\u0013\u0011yEA\nQsRDwN\\,pe.,'OR1di>\u0014\u0018P\u0003\u0002?\u007f\u00051\u0001/\u001f;i_:T!\u0001Q!\u0002\u0007\u0005\u0004\u0018N\u0003\u0002C\u0007\u0006)1\u000f]1sW*\u0011A)R\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\u000b1a\u001c:h'\r\u0001\u0001J\u0014\t\u0003\u00132k\u0011A\u0013\u0006\u0002\u0017\u0006)1oY1mC&\u0011QJ\u0013\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E\u000b\u0015\u0001C5oi\u0016\u0014h.\u00197\n\u0005M\u0003&a\u0002'pO\u001eLgnZ\u0001\u000baf$\bn\u001c8Fq\u0016\u001c7\u0001\u0001\t\u0003/zs!\u0001\u0017/\u0011\u0005eSU\"\u0001.\u000b\u0005m+\u0016A\u0002\u001fs_>$h(\u0003\u0002^\u0015\u00061\u0001K]3eK\u001aL!a\u00181\u0003\rM#(/\u001b8h\u0015\ti&*\u0001\u0007x_J\\WM]'pIVdW-\u0001\u0007eC\u0016lwN\\'pIVdW-A\u0004f]Z4\u0016M]:\u0011\t]+gKV\u0005\u0003M\u0002\u00141!T1q\u0003A)8/\u001a#bK6|g.\u00128bE2,G-F\u0001j!\tI%.\u0003\u0002l\u0015\n9!i\\8mK\u0006t\u0017!E;tK\u0012\u000bW-\\8o\u000b:\f'\r\\3eA\u00051A(\u001b8jiz\"ba\\9sgR,\bC\u00019\u0001\u001b\u0005i\u0004\"\u0002+\b\u0001\u00041\u0006\"B1\b\u0001\u00041\u0006\"\u00022\b\u0001\u00041\u0006\"B2\b\u0001\u0004!\u0007\"B4\b\u0001\u0004IG#B8xqfT\b\"\u0002+\t\u0001\u00041\u0006\"B1\t\u0001\u00041\u0006\"B2\t\u0001\u0004!\u0007\"B4\t\u0001\u0004I\u0017!C;tK\u0012\u000bW-\\8o\u0003))8/\u001a#bK6|g\u000eI\u0001\u000bCV$\b\u000eS3ma\u0016\u0014X#A@\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002B\u0003!\u0019XmY;sSRL\u0018\u0002BA\u0005\u0003\u0007\u0011\u0001cU8dW\u0016$\u0018)\u001e;i\u0011\u0016d\u0007/\u001a:\u0002\u0017\u0005,H\u000f\u001b%fYB,'\u000fI\u0001\u0011SN,f.\u001b=E_6\f\u0017N\\*pG.\f\u0011#[:V]&DHi\\7bS:\u001cvnY6!\u0003\u0019!\u0017-Z7p]V\u0011\u0011Q\u0003\t\u0005\u0003/\t\t#\u0004\u0002\u0002\u001a)!\u00111DA\u000f\u0003\u0011a\u0017M\\4\u000b\u0005\u0005}\u0011\u0001\u00026bm\u0006LA!a\t\u0002\u001a\t9\u0001K]8dKN\u001c\u0018A\u00033bK6|gn\u0018\u0013fcR!\u0011\u0011FA\u0018!\rI\u00151F\u0005\u0004\u0003[Q%\u0001B+oSRD\u0011\"!\r\u0011\u0003\u0003\u0005\r!!\u0006\u0002\u0007a$\u0013'A\u0004eC\u0016lwN\u001c\u0011)\u000fE\t9$a\u0013\u0002NA!\u0011\u0011HA$\u001b\t\tYD\u0003\u0003\u0002>\u0005}\u0012AC2p]\u000e,(O]3oi*!\u0011\u0011IA\"\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u0003\u000b\nQA[1wCbLA!!\u0013\u0002<\tIq)^1sI\u0016$')_\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003\u001f\nAa]3mM\u0006QA-Y3n_:Dun\u001d;\u0016\u0005\u0005U\u0003\u0003BA,\u0003;j!!!\u0017\u000b\t\u0005m\u0013QD\u0001\u0004]\u0016$\u0018\u0002BA0\u00033\u00121\"\u00138fi\u0006#GM]3tg\u0006YA-Y3n_:Dun\u001d;!\u0003)!\u0017-Z7p]B{'\u000f^\u000b\u0003\u0003O\u00022!SA5\u0013\r\tYG\u0013\u0002\u0004\u0013:$\u0018A\u00043bK6|g\u000eU8si~#S-\u001d\u000b\u0005\u0003S\t\t\bC\u0005\u00022U\t\t\u00111\u0001\u0002h\u0005YA-Y3n_:\u0004vN\u001d;!Q\u001d1\u0012qGA&\u0003\u001b\nQ\u0002Z1f[>twk\u001c:lKJ\u001cXCAA>!!\ti(a\"\u0002\f\u0006EUBAA@\u0015\u0011\t\t)a!\u0002\u000f5,H/\u00192mK*\u0019\u0011Q\u0011&\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\n\u0006}$aC,fC.D\u0015m\u001d5NCB\u00042\u0001]AG\u0013\r\ty)\u0010\u0002\r!f$\bn\u001c8X_J\\WM\u001d\t\u0005\u0003/\t\u0019*\u0003\u0003\u0002\u0016\u0006e!!\u0004)s_\u000e,7o\u001d%b]\u0012dW-\u0001\beC\u0016lwN\\,pe.,'o\u001d\u0011)\u000fa\t9$a\u0013\u0002N\u0005qA-Y3n_:\u001cvnY6QCRDW#\u0001,\u0002%\u0011\fW-\\8o'>\u001c7\u000eU1uQ~#S-\u001d\u000b\u0005\u0003S\t\u0019\u000b\u0003\u0005\u00022i\t\t\u00111\u0001W\u0003=!\u0017-Z7p]N{7m\u001b)bi\"\u0004\u0003fB\u000e\u00028\u0005-\u0013QJ\u0001\fS\u0012dWmV8sW\u0016\u00148/\u0006\u0002\u0002.B1\u0011QPAX\u0003\u0017KA!!-\u0002\u0000\t)\u0011+^3vK\u0006a\u0011\u000e\u001a7f/>\u00148.\u001a:tA!:Q$a\u000e\u0002L\u00055\u0013A\u00047bgR\f5\r^5wSRLhj]\u000b\u0003\u0003w\u00032!SA_\u0013\r\tyL\u0013\u0002\u0005\u0019>tw-\u0001\nmCN$\u0018i\u0019;jm&$\u0018PT:`I\u0015\fH\u0003BA\u0015\u0003\u000bD\u0011\"!\r \u0003\u0003\u0005\r!a/\u0002\u001f1\f7\u000f^!di&4\u0018\u000e^=Og\u0002Bs\u0001IA\u001c\u0003\u0017\ni%A\u0007tS6\u0004H.Z,pe.,'o]\u000b\u0003\u0003\u001f\u0004\u0002\"! \u0002\b\u0006-\u0015QC\u0001\u000fg&l\u0007\u000f\\3X_J\\WM]:!Q\u001d\u0011\u0013qGA&\u0003\u001b\n!\u0002]=uQ>t\u0007+\u0019;i\u0003-\u0001\u0018\u0010\u001e5p]B\u000bG\u000f\u001b\u0011\u0002\r\r\u0014X-\u0019;f)\t\ti\u000eE\u0004J\u0003?\fY)a9\n\u0007\u0005\u0005(J\u0001\u0004UkBdWM\r\t\u0006\u0013\u0006\u0015\u0018\u0011S\u0005\u0004\u0003OT%AB(qi&|g.A\nde\u0016\fG/\u001a+ie>,x\r\u001b#bK6|g.\u0001\nde\u0016\fG/Z*j[BdWmV8sW\u0016\u0014H\u0003BAo\u0003_Da!!=(\u0001\u0004I\u0017\u0001\u00042m_\u000e\\\u0017N\\4N_\u0012,\u0017aC:uCJ$H)Y3n_:$\"!!\u000b\u0002/I,G-\u001b:fGR\u001cFO]3b[N$vn\u0015;eKJ\u0014HCBA\u0015\u0003w\u0014Y\u0001C\u0004\u0002~&\u0002\r!a@\u0002\rM$Hm\\;u!\u0011\u0011\tAa\u0002\u000e\u0005\t\r!\u0002\u0002B\u0003\u0003;\t!![8\n\t\t%!1\u0001\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0004\u0003\u000e%\u0002\r!a@\u0002\rM$H-\u001a:s\u00055iuN\\5u_J$\u0006N]3bIN\u0019!Fa\u0005\u0011\t\u0005]!QC\u0005\u0005\u0005/\tIB\u0001\u0004UQJ,\u0017\r\u001a\u000b\u0003\u00057\u00012A!\b+\u001b\u0005\u0001\u0011a\u0001:v]\u0006\u00112\r\\3b]V\u0004\u0018\n\u001a7f/>\u00148.\u001a:t\u0003)\u0019Ho\u001c9EC\u0016lwN\\\u0001\u0005gR|\u0007/\u0001\u0006ti>\u0004xk\u001c:lKJ$B!!\u000b\u0003,!9!Q\u0006\u0019A\u0002\u0005-\u0015AB<pe.,'/A\u0007sK2,\u0017m]3X_J\\WM\u001d\u000b\u0005\u0003S\u0011\u0019\u0004C\u0004\u0003.E\u0002\r!a#\u0002\u001f%\u001cxk\u001c:lKJ\u001cFo\u001c9qK\u0012$2!\u001bB\u001d\u0011\u001d\u0011iC\ra\u0001\u0003\u0017\u000b1\u0003U=uQ>twk\u001c:lKJ4\u0015m\u0019;pef\u0004\"\u0001\u001d\u001b\u0014\u0005QBEC\u0001B\u001f\u0003]\u0001&kT\"F'N{v+Q%U?RKU*R(V)~k5+\u0001\rQ%>\u001bUiU*`/\u0006KEk\u0018+J\u001b\u0016{U\u000bV0N'\u0002\na#\u0013#M\u000b~;vJU&F%~#\u0016*T#P+R{fjU\u0001\u0018\u0013\u0012cUiX,P%.+%k\u0018+J\u001b\u0016{U\u000bV0O'\u0002\n1\u0003Z3gCVdG\u000fR1f[>tWj\u001c3vY\u0016,\"Aa\u0014\u0011\t\u0005]!\u0011K\u0005\u0004?\u0006e\u0011\u0001\u00063fM\u0006,H\u000e\u001e#bK6|g.T8ek2,\u0007\u0005")
public class PythonWorkerFactory
implements Logging {
    public final String org$apache$spark$api$python$PythonWorkerFactory$$pythonExec;
    private final String workerModule;
    private final String daemonModule;
    private final scala.collection.immutable.Map<String, String> envVars;
    private final boolean useDaemonEnabled;
    private final boolean useDaemon;
    private final SocketAuthHelper authHelper;
    private final boolean isUnixDomainSock;
    @GuardedBy(value="self")
    private Process daemon;
    private final InetAddress daemonHost;
    @GuardedBy(value="self")
    private int daemonPort;
    @GuardedBy(value="self")
    private final WeakHashMap<PythonWorker, ProcessHandle> daemonWorkers;
    @GuardedBy(value="self")
    private String daemonSockPath;
    @GuardedBy(value="self")
    private final Queue<PythonWorker> idleWorkers;
    @GuardedBy(value="self")
    private long org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs;
    @GuardedBy(value="self")
    private final WeakHashMap<PythonWorker, Process> simpleWorkers;
    private final String pythonPath;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static long IDLE_WORKER_TIMEOUT_NS() {
        return PythonWorkerFactory$.MODULE$.IDLE_WORKER_TIMEOUT_NS();
    }

    public static int PROCESS_WAIT_TIMEOUT_MS() {
        return PythonWorkerFactory$.MODULE$.PROCESS_WAIT_TIMEOUT_MS();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean useDaemonEnabled() {
        return this.useDaemonEnabled;
    }

    private boolean useDaemon() {
        return this.useDaemon;
    }

    private SocketAuthHelper authHelper() {
        return this.authHelper;
    }

    private boolean isUnixDomainSock() {
        return this.isUnixDomainSock;
    }

    private Process daemon() {
        return this.daemon;
    }

    private void daemon_$eq(Process x$1) {
        this.daemon = x$1;
    }

    public InetAddress daemonHost() {
        return this.daemonHost;
    }

    private int daemonPort() {
        return this.daemonPort;
    }

    private void daemonPort_$eq(int x$1) {
        this.daemonPort = x$1;
    }

    private WeakHashMap<PythonWorker, ProcessHandle> daemonWorkers() {
        return this.daemonWorkers;
    }

    private String daemonSockPath() {
        return this.daemonSockPath;
    }

    private void daemonSockPath_$eq(String x$1) {
        this.daemonSockPath = x$1;
    }

    private Queue<PythonWorker> idleWorkers() {
        return this.idleWorkers;
    }

    public long org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs() {
        return this.org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs;
    }

    public void org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs_$eq(long x$1) {
        this.org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs = x$1;
    }

    private WeakHashMap<PythonWorker, Process> simpleWorkers() {
        return this.simpleWorkers;
    }

    private String pythonPath() {
        return this.pythonPath;
    }

    public Tuple2<PythonWorker, Option<ProcessHandle>> create() {
        Tuple2<PythonWorker, Option<ProcessHandle>> tuple2;
        block8: {
            Object object = new Object();
            try {
                if (this.useDaemon()) {
                    PythonWorkerFactory pythonWorkerFactory = this;
                    synchronized (pythonWorkerFactory) {
                        while (this.idleWorkers().nonEmpty()) {
                            PythonWorker worker = (PythonWorker)this.idleWorkers().dequeue();
                            this.daemonWorkers().get((Object)worker).foreach((Function1 & Serializable)workerHandle -> {
                                PythonWorkerFactory.$anonfun$create$1(object, worker, workerHandle);
                                return BoxedUnit.UNIT;
                            });
                            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Worker ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.WORKER$.MODULE$, (Object)worker)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"process from idle queue is dead, discarding."}))).log((Seq)Nil$.MODULE$))));
                            this.stopWorker(worker);
                        }
                    }
                    tuple2 = this.createThroughDaemon();
                    break block8;
                }
                tuple2 = this.createSimpleWorker(false);
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    tuple2 = (Tuple2<PythonWorker, Option<ProcessHandle>>)ex.value();
                }
                throw ex;
            }
        }
        return tuple2;
    }

    private Tuple2<PythonWorker, Option<ProcessHandle>> createThroughDaemon() {
        Tuple2 tuple2;
        PythonWorkerFactory pythonWorkerFactory = this;
        synchronized (pythonWorkerFactory) {
            this.startDaemon();
            tuple2 = this.liftedTree1$1();
        }
        return tuple2;
    }

    public Tuple2<PythonWorker, Option<ProcessHandle>> createSimpleWorker(boolean blockingMode) {
        Tuple2 tuple2;
        LazyRef sockPath$lzy = new LazyRef();
        ServerSocketChannel serverSocketChannel = null;
        try {
            String jobArtifactUUID;
            if (this.isUnixDomainSock()) {
                serverSocketChannel = ServerSocketChannel.open(StandardProtocolFamily.UNIX);
                this.sockPath$1(sockPath$lzy).deleteOnExit();
                v0 = serverSocketChannel.bind(UnixDomainSocketAddress.of(this.sockPath$1(sockPath$lzy).getPath()));
            } else {
                serverSocketChannel = ServerSocketChannel.open();
                v0 = serverSocketChannel.bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), 0), 1);
            }
            ProcessBuilder pb = new ProcessBuilder(Arrays.asList((Object[])new String[]{this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec, "-m", this.workerModule}));
            String string = jobArtifactUUID = (String)this.envVars.getOrElse((Object)"SPARK_JOB_ARTIFACT_UUID", (Function0 & Serializable)() -> "default");
            String string2 = "default";
            if (string == null ? string2 != null : !string.equals(string2)) {
                File f = new File(SparkFiles$.MODULE$.getRootDirectory(), jobArtifactUUID);
                f.mkdir();
                v2 = pb.directory(f);
            } else {
                v2 = BoxedUnit.UNIT;
            }
            Map<String, String> workerEnv = pb.environment();
            workerEnv.putAll(CollectionConverters$.MODULE$.MapHasAsJava(this.envVars).asJava());
            workerEnv.put("PYTHONPATH", this.pythonPath());
            workerEnv.put("PYTHONUNBUFFERED", "YES");
            if (this.isUnixDomainSock()) {
                workerEnv.put("PYTHON_WORKER_FACTORY_SOCK_PATH", this.sockPath$1(sockPath$lzy).getPath());
                v3 = workerEnv.put("PYTHON_UNIX_DOMAIN_ENABLED", "True");
            } else {
                workerEnv.put("PYTHON_WORKER_FACTORY_PORT", Integer.toString(serverSocketChannel.socket().getLocalPort()));
                v3 = workerEnv.put("PYTHON_WORKER_FACTORY_SECRET", this.authHelper().secret());
            }
            Object object = Utils$.MODULE$.preferIPv6() ? workerEnv.put("SPARK_PREFER_IPV6", "True") : BoxedUnit.UNIT;
            Process workerProcess = pb.start();
            this.redirectStreamsToStderr(workerProcess.getInputStream(), workerProcess.getErrorStream());
            try {
                serverSocketChannel.configureBlocking(false);
                Selector serverSelector = Selector.open();
                serverSocketChannel.register(serverSelector, 16);
                if (serverSelector.select(10000L) <= 0) {
                    throw new SocketTimeoutException("Timed out while waiting for the Python worker to connect back");
                }
                SocketChannel socketChannel = serverSocketChannel.accept();
                this.authHelper().authClient(socketChannel);
                int pid = new DataInputStream(Channels.newInputStream(socketChannel)).readInt();
                if (pid < 0) {
                    throw new IllegalStateException("Python failed to launch worker with code " + pid);
                }
                Object object2 = !blockingMode ? socketChannel.configureBlocking(false) : BoxedUnit.UNIT;
                PythonWorker worker = new PythonWorker(socketChannel);
                PythonWorkerFactory pythonWorkerFactory = this;
                synchronized (pythonWorkerFactory) {
                    this.simpleWorkers().put((Object)worker, (Object)workerProcess);
                }
                tuple2 = new Tuple2((Object)worker.refresh(), (Object)OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(ProcessHandle.of(pid))));
            }
            catch (Exception e) {
                throw new SparkException("Python worker failed to connect back.", (Throwable)e);
            }
        }
        finally {
            if (serverSocketChannel != null) {
                serverSocketChannel.close();
                if (this.isUnixDomainSock()) {
                    this.sockPath$1(sockPath$lzy).delete();
                }
            }
        }
        return tuple2;
    }

    private synchronized void startDaemon() {
        if (this.daemon() != null) {
            return;
        }
        try {
            String errorMsg;
            String jobArtifactUUID;
            List<Object> command = Arrays.asList((Object[])new String[]{this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec, "-m", this.daemonModule, this.workerModule});
            ProcessBuilder pb = new ProcessBuilder(command);
            String string = jobArtifactUUID = (String)this.envVars.getOrElse((Object)"SPARK_JOB_ARTIFACT_UUID", (Function0 & Serializable)() -> "default");
            String string2 = "default";
            if (string == null ? string2 != null : !string.equals(string2)) {
                File f = new File(SparkFiles$.MODULE$.getRootDirectory(), jobArtifactUUID);
                f.mkdir();
                v1 = pb.directory(f);
            } else {
                v1 = BoxedUnit.UNIT;
            }
            Map<String, String> workerEnv = pb.environment();
            workerEnv.putAll(CollectionConverters$.MODULE$.MapHasAsJava(this.envVars).asJava());
            workerEnv.put("PYTHONPATH", this.pythonPath());
            if (this.isUnixDomainSock()) {
                workerEnv.put("PYTHON_WORKER_FACTORY_SOCK_DIR", (String)((Option)this.authHelper().conf().get(Python$.MODULE$.PYTHON_UNIX_DOMAIN_SOCKET_DIR())).getOrElse((Function0 & Serializable)() -> System.getProperty("java.io.tmpdir")));
                v2 = workerEnv.put("PYTHON_UNIX_DOMAIN_ENABLED", "True");
            } else {
                v2 = workerEnv.put("PYTHON_WORKER_FACTORY_SECRET", this.authHelper().secret());
            }
            Object object = Utils$.MODULE$.preferIPv6() ? workerEnv.put("SPARK_PREFER_IPV6", "True") : BoxedUnit.UNIT;
            workerEnv.put("PYTHONUNBUFFERED", "YES");
            this.daemon_$eq(pb.start());
            DataInputStream in = new DataInputStream(this.daemon().getInputStream());
            try {
                if (this.isUnixDomainSock()) {
                    this.daemonSockPath_$eq(PythonWorkerUtils$.MODULE$.readUTF(in));
                } else {
                    this.daemonPort_$eq(in.readInt());
                }
            }
            catch (EOFException eOFException) {
                if (this.daemon().isAlive()) {
                    throw SparkCoreErrors$.MODULE$.eofExceptionWhileReadPortNumberError(this.daemonModule, SparkCoreErrors$.MODULE$.eofExceptionWhileReadPortNumberError$default$2());
                }
                throw SparkCoreErrors$.MODULE$.eofExceptionWhileReadPortNumberError(this.daemonModule, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.daemon().exitValue())));
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            boolean isMalformedPort = !this.isUnixDomainSock() && (this.daemonPort() < 1 || this.daemonPort() > 65535);
            boolean isMalformedSockPath = this.isUnixDomainSock() && !new File(this.daemonSockPath()).exists();
            String string3 = errorMsg = this.isUnixDomainSock() ? this.daemonSockPath() : StringOps$.MODULE$.format$extension("%s (0x%08x)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.daemonPort()), BoxesRunTime.boxToInteger((int)this.daemonPort())}));
            if (isMalformedPort || isMalformedSockPath) {
                String exceptionMessage = "\n            |Bad data in " + this.daemonModule + "'s standard output. Invalid port number/socket path:\n            |  " + errorMsg + "\n            |Python command to execute the daemon was:\n            |  " + CollectionConverters$.MODULE$.ListHasAsScala(command).asScala().mkString(" ") + "\n            |Check that you don't have any unexpected modules or libraries in\n            |your PYTHONPATH:\n            |  " + this.pythonPath() + "\n            |Also, check if you have a sitecustomize.py module in your python path,\n            |or in your python installation, that is printing to standard output";
                throw new SparkException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(exceptionMessage)));
            }
            this.redirectStreamsToStderr(in, this.daemon().getErrorStream());
        }
        catch (Exception e) {
            String stderr = (String)Option$.MODULE$.apply((Object)this.daemon()).flatMap((Function1 & Serializable)d -> Utils$.MODULE$.getStderr((Process)d, PythonWorkerFactory$.MODULE$.PROCESS_WAIT_TIMEOUT_MS())).getOrElse((Function0 & Serializable)() -> "");
            this.stopDaemon();
            String string = stderr;
            String string4 = "";
            if (string == null ? string4 != null : !string.equals(string4)) {
                String formattedStderr = stderr.replace("\n", "\n  ");
                String errorMessage = "\n              |Error from python worker:\n              |  " + formattedStderr + "\n              |PYTHONPATH was:\n              |  " + this.pythonPath() + "\n              |" + e;
                SparkException wrappedException = new SparkException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(errorMessage)));
                wrappedException.setStackTrace(e.getStackTrace());
                throw wrappedException;
            }
            throw e;
        }
    }

    private void redirectStreamsToStderr(InputStream stdout, InputStream stderr) {
        try {
            new RedirectThread(stdout, System.err, "stdout reader for " + this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec, RedirectThread$.MODULE$.$lessinit$greater$default$4()).start();
            new RedirectThread(stderr, System.err, "stderr reader for " + this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec, RedirectThread$.MODULE$.$lessinit$greater$default$4()).start();
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable)() -> "Exception in redirecting streams", (Throwable)e);
        }
    }

    public void org$apache$spark$api$python$PythonWorkerFactory$$cleanupIdleWorkers() {
        while (this.idleWorkers().nonEmpty()) {
            PythonWorker worker = (PythonWorker)this.idleWorkers().dequeue();
            try {
                worker.stop();
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Failed to stop worker socket", (Throwable)e);
            }
        }
    }

    private synchronized void stopDaemon() {
        if (this.useDaemon()) {
            this.org$apache$spark$api$python$PythonWorkerFactory$$cleanupIdleWorkers();
            if (this.daemon() != null) {
                this.daemon().destroy();
            }
            this.daemon_$eq(null);
            this.daemonPort_$eq(0);
            this.daemonSockPath_$eq(null);
            return;
        }
        this.simpleWorkers().values().foreach((Function1 & Serializable)x$5 -> {
            x$5.destroy();
            return BoxedUnit.UNIT;
        });
    }

    public void stop() {
        this.stopDaemon();
    }

    public void stopWorker(PythonWorker worker) {
        PythonWorkerFactory pythonWorkerFactory = this;
        synchronized (pythonWorkerFactory) {
            if (this.useDaemon()) {
                if (this.daemon() != null) {
                    this.daemonWorkers().get((Object)worker).foreach((Function1 & Serializable)processHandle -> {
                        PythonWorkerFactory.$anonfun$stopWorker$1(this, processHandle);
                        return BoxedUnit.UNIT;
                    });
                }
            } else {
                this.simpleWorkers().get((Object)worker).foreach((Function1 & Serializable)x$6 -> {
                    x$6.destroy();
                    return BoxedUnit.UNIT;
                });
            }
        }
        worker.stop();
    }

    public void releaseWorker(PythonWorker worker) {
        if (this.useDaemon()) {
            PythonWorkerFactory pythonWorkerFactory = this;
            synchronized (pythonWorkerFactory) {
                this.org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs_$eq(System.nanoTime());
                this.idleWorkers().enqueue((Object)worker);
            }
            return;
        }
        try {
            worker.stop();
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Failed to close worker", (Throwable)e);
        }
    }

    public boolean isWorkerStopped(PythonWorker worker) {
        Predef$.MODULE$.assert(!this.useDaemon(), (Function0 & Serializable)() -> "isWorkerStopped() is not supported for daemon mode");
        return this.simpleWorkers().get((Object)worker).exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)PythonWorkerFactory.$anonfun$isWorkerStopped$2(x$7)));
    }

    public static final /* synthetic */ void $anonfun$create$1(Object nonLocalReturnKey1$1, PythonWorker worker$1, ProcessHandle workerHandle) {
        if (workerHandle.isAlive()) {
            try {
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Tuple2((Object)worker$1.refresh(), (Object)new Some((Object)workerHandle)));
            }
            catch (CancelledKeyException cancelledKeyException) {
                return;
            }
        }
    }

    private final Tuple2 createWorker$1() {
        SocketChannel socketChannel = this.isUnixDomainSock() ? SocketChannel.open(UnixDomainSocketAddress.of(this.daemonSockPath())) : SocketChannel.open(new InetSocketAddress(this.daemonHost(), this.daemonPort()));
        int pid = new DataInputStream(Channels.newInputStream(socketChannel)).readInt();
        if (pid < 0) {
            throw new IllegalStateException("Python daemon failed to launch worker with code " + pid);
        }
        ProcessHandle processHandle = ProcessHandle.of(pid).orElseThrow(() -> new IllegalStateException("Python daemon failed to launch worker."));
        this.authHelper().authToServer(socketChannel);
        socketChannel.configureBlocking(false);
        PythonWorker worker = new PythonWorker(socketChannel);
        this.daemonWorkers().put((Object)worker, (Object)processHandle);
        return new Tuple2((Object)worker.refresh(), (Object)new Some((Object)processHandle));
    }

    private final /* synthetic */ Tuple2 liftedTree1$1() {
        Tuple2 tuple2;
        try {
            tuple2 = this.createWorker$1();
        }
        catch (SocketException exc) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Failed to open socket to Python daemon:", (Throwable)exc);
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Assuming that daemon unexpectedly quit, attempting to restart");
            this.stopDaemon();
            this.startDaemon();
            tuple2 = this.createWorker$1();
        }
        return tuple2;
    }

    private final /* synthetic */ File sockPath$lzycompute$1(LazyRef sockPath$lzy$1) {
        File file;
        LazyRef lazyRef = sockPath$lzy$1;
        synchronized (lazyRef) {
            file = sockPath$lzy$1.initialized() ? (File)sockPath$lzy$1.value() : (File)sockPath$lzy$1.initialize((Object)new File((String)((Option)this.authHelper().conf().get(Python$.MODULE$.PYTHON_UNIX_DOMAIN_SOCKET_DIR())).getOrElse((Function0 & Serializable)() -> System.getProperty("java.io.tmpdir")), "." + UUID.randomUUID() + ".sock"));
        }
        return file;
    }

    private final File sockPath$1(LazyRef sockPath$lzy$1) {
        if (sockPath$lzy$1.initialized()) {
            return (File)sockPath$lzy$1.value();
        }
        return this.sockPath$lzycompute$1(sockPath$lzy$1);
    }

    public static final /* synthetic */ void $anonfun$stopWorker$1(PythonWorkerFactory $this, ProcessHandle processHandle) {
        DataOutputStream output = new DataOutputStream($this.daemon().getOutputStream());
        output.writeInt((int)processHandle.pid());
        output.flush();
        $this.daemon().getOutputStream().flush();
    }

    public static final /* synthetic */ boolean $anonfun$isWorkerStopped$2(Process x$7) {
        return !x$7.isAlive();
    }

    public PythonWorkerFactory(String pythonExec, String workerModule, String daemonModule, scala.collection.immutable.Map<String, String> envVars, boolean useDaemonEnabled) {
        this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec = pythonExec;
        this.workerModule = workerModule;
        this.daemonModule = daemonModule;
        this.envVars = envVars;
        this.useDaemonEnabled = useDaemonEnabled;
        Logging.$init$((Logging)this);
        this.useDaemon = !System.getProperty("os.name").startsWith("Windows") && useDaemonEnabled;
        this.authHelper = new SocketAuthHelper(SparkEnv$.MODULE$.get().conf());
        this.isUnixDomainSock = BoxesRunTime.unboxToBoolean((Object)this.authHelper().conf().get(Python$.MODULE$.PYTHON_UNIX_DOMAIN_SOCKET_ENABLED()));
        this.daemon = null;
        this.daemonHost = InetAddress.getLoopbackAddress();
        this.daemonPort = 0;
        this.daemonWorkers = new WeakHashMap();
        this.idleWorkers = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        this.org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs = 0L;
        new MonitorThread().start();
        this.simpleWorkers = new WeakHashMap();
        this.pythonPath = PythonUtils$.MODULE$.mergePythonPaths((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{PythonUtils$.MODULE$.sparkPythonPath(), (String)envVars.getOrElse((Object)"PYTHONPATH", (Function0 & Serializable)() -> ""), (String)package$.MODULE$.env().getOrElse((Object)"PYTHONPATH", (Function0 & Serializable)() -> "")}));
    }

    public PythonWorkerFactory(String pythonExec, String workerModule, scala.collection.immutable.Map<String, String> envVars, boolean useDaemonEnabled) {
        this(pythonExec, workerModule, PythonWorkerFactory$.MODULE$.defaultDaemonModule(), envVars, useDaemonEnabled);
    }

    private class MonitorThread
    extends Thread {
        @Override
        public void run() {
            while (true) {
                PythonWorkerFactory pythonWorkerFactory = this.org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer();
                synchronized (pythonWorkerFactory) {
                    if (PythonWorkerFactory$.MODULE$.IDLE_WORKER_TIMEOUT_NS() < System.nanoTime() - this.org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer().org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs()) {
                        this.org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer().org$apache$spark$api$python$PythonWorkerFactory$$cleanupIdleWorkers();
                        this.org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer().org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs_$eq(System.nanoTime());
                    }
                }
                Thread.sleep(10000L);
            }
        }

        public /* synthetic */ PythonWorkerFactory org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer() {
            return PythonWorkerFactory.this;
        }

        public MonitorThread() {
            if (PythonWorkerFactory.this == null) {
                throw null;
            }
            super("Idle Worker Monitor for " + PythonWorkerFactory.this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec);
            this.setDaemon(true);
        }
    }
}

