/*
 * Decompiled with CFR 0.152.
 */
package spire.math.poly;

import algebra.ring.Semiring;
import cats.kernel.Eq;
import java.io.Serializable;
import java.math.BigDecimal;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.math.BigInt;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichDouble$;
import spire.math.Interval;
import spire.math.Polynomial;
import spire.math.Polynomial$;
import spire.math.Rational;
import spire.math.Rational$;
import spire.math.SafeLong$;
import spire.math.package$;
import spire.math.poly.RootIsolator;
import spire.math.poly.Term;
import spire.std.package$bigDecimal$;
import spire.std.package$bigInt$;

public final class Roots$ {
    public static final Roots$ MODULE$ = new Roots$();

    public final <A> Vector<Interval<Rational>> isolateRoots(Polynomial<A> poly, RootIsolator<A> isolator) {
        return isolator.isolateRoots(poly);
    }

    public final Polynomial<BigInt> removeFractions(Polynomial<Rational> poly) {
        Rational[] coeffs = (Rational[])poly.coeffsArray((Semiring<Rational>)Rational$.MODULE$.RationalAlgebra());
        BigInt factors = (BigInt)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])coeffs), (Object)scala.package$.MODULE$.BigInt().apply(1), (Function2 & Serializable)(acc, coeff) -> {
            BigInt d = coeff.denominator().toBigInt();
            return acc.$times(d.$div(acc.gcd(d)));
        });
        BigInt[] zCoeffs = (BigInt[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])coeffs), (Function1 & Serializable)n -> n.numerator().$times(SafeLong$.MODULE$.apply(factors).$div(n.denominator())).toBigInt(), ClassTag$.MODULE$.apply(BigInt.class));
        return Polynomial$.MODULE$.dense(zCoeffs, package$bigInt$.MODULE$.BigIntAlgebra(), (Eq)package$bigInt$.MODULE$.BigIntAlgebra(), ClassTag$.MODULE$.apply(BigInt.class));
    }

    public final Polynomial<BigInt> removeDecimal(Polynomial<scala.math.BigDecimal> poly) {
        Polynomial<BigInt> polynomial;
        Polynomial<scala.math.BigDecimal> polynomial2 = poly;
        Polynomial<scala.math.BigDecimal> polynomial3 = Polynomial$.MODULE$.zero((Eq)package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), ClassTag$.MODULE$.apply(scala.math.BigDecimal.class));
        if (!(polynomial2 != null ? !((Object)polynomial2).equals(polynomial3) : polynomial3 != null)) {
            polynomial = Polynomial$.MODULE$.zero((Eq)package$bigInt$.MODULE$.BigIntAlgebra(), package$bigInt$.MODULE$.BigIntAlgebra(), ClassTag$.MODULE$.apply(BigInt.class));
        } else {
            List terms = poly.terms((Semiring<scala.math.BigDecimal>)package$bigDecimal$.MODULE$.BigDecimalAlgebra(), (Eq<scala.math.BigDecimal>)((Eq)package$bigDecimal$.MODULE$.BigDecimalAlgebra())).map((Function1 & Serializable)x0$1 -> {
                Term term = x0$1;
                if (term == null) {
                    throw new MatchError((Object)term);
                }
                scala.math.BigDecimal c = (scala.math.BigDecimal)term.coeff();
                int e = term.exp();
                Term<BigDecimal> term2 = new Term<BigDecimal>(c.bigDecimal().stripTrailingZeros(), e);
                return term2;
            });
            int maxScale = BoxesRunTime.unboxToInt((Object)terms.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Roots$.$anonfun$removeDecimal$2(x$1))).max((Ordering)Ordering.Int$.MODULE$));
            polynomial = Polynomial$.MODULE$.apply(terms.map((Function1 & Serializable)x0$2 -> {
                Term term = x0$2;
                if (term == null) {
                    throw new MatchError((Object)term);
                }
                BigDecimal c = (BigDecimal)term.coeff();
                int e = term.exp();
                BigInt c0 = scala.package$.MODULE$.BigInt().apply(c.movePointRight(maxScale).unscaledValue());
                Term<BigInt> term2 = new Term<BigInt>(c0, e);
                return term2;
            }), package$bigInt$.MODULE$.BigIntAlgebra(), (Eq)package$bigInt$.MODULE$.BigIntAlgebra(), ClassTag$.MODULE$.apply(BigInt.class));
        }
        return polynomial;
    }

    public final int upperBound(Polynomial<BigInt> p) {
        int lgLastCoeff = p.maxOrderTermCoeff((Semiring<BigInt>)package$bigInt$.MODULE$.BigIntAlgebra()).abs().bitLength();
        int n = p.degree();
        DoubleRef maxBound = DoubleRef.create((double)Double.NEGATIVE_INFINITY);
        p.foreachNonZero((Function2 & Serializable)(k, coeff) -> {
            Roots$.$anonfun$upperBound$1(n, lgLastCoeff, maxBound, BoxesRunTime.unboxToInt((Object)k), coeff);
            return BoxedUnit.UNIT;
        }, (Semiring<BigInt>)package$bigInt$.MODULE$.BigIntAlgebra(), (Eq<BigInt>)((Eq)package$bigInt$.MODULE$.BigIntAlgebra()));
        if (!RichDouble$.MODULE$.isValidInt$extension(Predef$.MODULE$.doubleWrapper(maxBound.elem))) {
            throw new ArithmeticException("bound too large");
        }
        return (int)maxBound.elem;
    }

    public int lowerBound(Polynomial<BigInt> p) {
        return -this.upperBound(p.reciprocal((Semiring<BigInt>)package$bigInt$.MODULE$.BigIntAlgebra(), (Eq<BigInt>)((Eq)package$bigInt$.MODULE$.BigIntAlgebra())));
    }

    public static final /* synthetic */ int $anonfun$removeDecimal$2(Term x$1) {
        return ((BigDecimal)x$1.coeff()).scale();
    }

    public static final /* synthetic */ void $anonfun$upperBound$1(int n$1, int lgLastCoeff$1, DoubleRef maxBound$1, int k, BigInt coeff) {
        block0: {
            if (k == n$1) break block0;
            int i = n$1 - k;
            int bound = (coeff.abs().bitLength() - lgLastCoeff$1 + 1) / i + 2;
            maxBound$1.elem = package$.MODULE$.max(maxBound$1.elem, (double)bound);
        }
    }

    private Roots$() {
    }
}

