/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import org.apache.spark.annotation.DeveloperApi;

@DeveloperApi
public interface ViewChange {
    public static ViewChange setProperty(String property, String value) {
        return new SetProperty(property, value);
    }

    public static ViewChange removeProperty(String property) {
        return new RemoveProperty(property);
    }

    public static final class RemoveProperty
    implements ViewChange {
        private final String property;

        private RemoveProperty(String property) {
            this.property = property;
        }

        public String property() {
            return this.property;
        }
    }

    public static final class SetProperty
    implements ViewChange {
        private final String property;
        private final String value;

        private SetProperty(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public String property() {
            return this.property;
        }

        public String value() {
            return this.value;
        }
    }
}

