/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.JsonObjectKeys$;
import org.apache.spark.sql.catalyst.expressions.SharedFactory$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(json_object) - Returns all the keys of the outermost JSON object as an array.", arguments="\n    Arguments:\n      * json_object - A JSON object. If a valid JSON object is given, all the keys of the outermost\n          object will be returned as an array. If it is any other valid JSON string, an invalid JSON\n          string or an empty string, the function returns null.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('{}');\n        []\n      > SELECT _FUNC_('{\"key\": \"value\"}');\n        [\"key\"]\n      > SELECT _FUNC_('{\"f1\":\"abc\",\"f2\":{\"f3\":\"a\", \"f4\":\"b\"}}');\n        [\"f1\",\"f2\"]\n  ", group="json_funcs", since="3.1.0")
@ScalaSignature(bytes="\u0006\u0005\u0005Uh\u0001B\u000e\u001d\u0001&B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\")q\n\u0001C\u0001!\")1\u000b\u0001C!)\")a\f\u0001C!?\")\u0001\r\u0001C!C\")Q\r\u0001C!M\")q\u000e\u0001C!a\")!\u0010\u0001C\u0005w\"9\u00111\u0005\u0001\u0005R\u0005\u0015\u0002\"CA\u0016\u0001\u0005\u0005I\u0011AA\u0017\u0011%\t\t\u0004AI\u0001\n\u0003\t\u0019\u0004C\u0005\u0002J\u0001\t\t\u0011\"\u0011\u0002L!I\u00111\f\u0001\u0002\u0002\u0013\u0005\u0011Q\f\u0005\n\u0003K\u0002\u0011\u0011!C\u0001\u0003OB\u0011\"!\u001c\u0001\u0003\u0003%\t%a\u001c\t\u0013\u0005u\u0004!!A\u0005\u0002\u0005}\u0004\"CAB\u0001\u0005\u0005I\u0011IAC\u0011%\tI\tAA\u0001\n\u0003\nYiB\u0005\u00026r\t\t\u0011#\u0001\u00028\u001aA1\u0004HA\u0001\u0012\u0003\tI\f\u0003\u0004P+\u0011\u0005\u0011\u0011\u001b\u0005\n\u0003',\u0012\u0011!C#\u0003+D\u0011\"a6\u0016\u0003\u0003%\t)!7\t\u0013\u0005uW#!A\u0005\u0002\u0006}\u0007\"CAv+\u0005\u0005I\u0011BAw\u00059Q5o\u001c8PE*,7\r^&fsNT!!\b\u0010\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003?\u0001\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003C\t\n1a]9m\u0015\t\u0019C%A\u0003ta\u0006\u00148N\u0003\u0002&M\u00051\u0011\r]1dQ\u0016T\u0011aJ\u0001\u0004_J<7\u0001A\n\u0007\u0001)rCgN\u001f\u0011\u0005-bS\"\u0001\u000f\n\u00055b\"aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005Eb\u0012aB2pI\u0016<WM\\\u0005\u0003gA\u0012qbQ8eK\u001e,gNR1mY\n\f7m\u001b\t\u0003WUJ!A\u000e\u000f\u0003#\u0015C\b/Z2ug&s\u0007/\u001e;UsB,7\u000f\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014HA\u0004Qe>$Wo\u0019;\u0011\u0005y2eBA E\u001d\t\u00015)D\u0001B\u0015\t\u0011\u0005&\u0001\u0004=e>|GOP\u0005\u0002u%\u0011Q)O\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0005J\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Fs\u0005)1\r[5mIV\t1\n\u0005\u0002,\u0019&\u0011Q\n\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003#J\u0003\"a\u000b\u0001\t\u000b%\u001b\u0001\u0019A&\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001V!\rqd\u000bW\u0005\u0003/\"\u00131aU3r!\tIF,D\u0001[\u0015\tY\u0006%A\u0003usB,7/\u0003\u0002^5\nAA)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\u0005A\u0016\u0001\u00038vY2\f'\r\\3\u0016\u0003\t\u0004\"\u0001O2\n\u0005\u0011L$a\u0002\"p_2,\u0017M\\\u0001\u000baJ,G\u000f^=OC6,W#A4\u0011\u0005!dgBA5k!\t\u0001\u0015(\u0003\u0002ls\u00051\u0001K]3eK\u001aL!!\u001c8\u0003\rM#(/\u001b8h\u0015\tY\u0017(\u0001\u0003fm\u0006dGCA9u!\tA$/\u0003\u0002ts\t\u0019\u0011I\\=\t\u000fUD\u0001\u0013!a\u0001m\u0006)\u0011N\u001c9viB\u0011q\u000f_\u0007\u0002=%\u0011\u0011P\b\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0006hKRT5o\u001c8LKf\u001cH#\u0002?\u0002\u0006\u0005\u0005\u0002cA?\u0002\u00025\taP\u0003\u0002\u0000=\u0005!Q\u000f^5m\u0013\r\t\u0019A \u0002\u0011\u000f\u0016tWM]5d\u0003J\u0014\u0018-\u001f#bi\u0006Dq!a\u0002\n\u0001\u0004\tI!\u0001\u0004qCJ\u001cXM\u001d\t\u0005\u0003\u0017\ti\"\u0004\u0002\u0002\u000e)!\u0011qBA\t\u0003\u0011\u0019wN]3\u000b\t\u0005M\u0011QC\u0001\bU\u0006\u001c7n]8o\u0015\u0011\t9\"!\u0007\u0002\u0013\u0019\f7\u000f^3sq6d'BAA\u000e\u0003\r\u0019w.\\\u0005\u0005\u0003?\tiA\u0001\u0006Kg>t\u0007+\u0019:tKJDQ!^\u0005A\u0002Y\fAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dGcA)\u0002(!1\u0011\u0011\u0006\u0006A\u0002-\u000b\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0005G>\u0004\u0018\u0010F\u0002R\u0003_Aq!S\u0006\u0011\u0002\u0003\u00071*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005U\"fA&\u00028-\u0012\u0011\u0011\b\t\u0005\u0003w\t)%\u0004\u0002\u0002>)!\u0011qHA!\u0003%)hn\u00195fG.,GMC\u0002\u0002De\n!\"\u00198o_R\fG/[8o\u0013\u0011\t9%!\u0010\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u001b\u0002B!a\u0014\u0002Z5\u0011\u0011\u0011\u000b\u0006\u0005\u0003'\n)&\u0001\u0003mC:<'BAA,\u0003\u0011Q\u0017M^1\n\u00075\f\t&\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002`A\u0019\u0001(!\u0019\n\u0007\u0005\r\u0014HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002r\u0003SB\u0011\"a\u001b\u0010\u0003\u0003\u0005\r!a\u0018\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\bE\u0003\u0002t\u0005e\u0014/\u0004\u0002\u0002v)\u0019\u0011qO\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002|\u0005U$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2AYAA\u0011!\tY'EA\u0001\u0002\u0004\t\u0018A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!\u0014\u0002\b\"I\u00111\u000e\n\u0002\u0002\u0003\u0007\u0011qL\u0001\u0007KF,\u0018\r\\:\u0015\u0007\t\fi\t\u0003\u0005\u0002lM\t\t\u00111\u0001rQ]\u0001\u0011\u0011SAL\u00033\u000bi*a(\u0002$\u0006\u0015\u0016\u0011VAV\u0003_\u000b\t\fE\u0002,\u0003'K1!!&\u001d\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a'\u0002)~3UKT\"`Q)\u001cxN\\0pE*,7\r^\u0015![\u0001\u0012V\r^;s]N\u0004\u0013\r\u001c7!i\",\u0007e[3zg\u0002zg\r\t;iK\u0002zW\u000f^3s[>\u001cH\u000f\t&T\u001f:\u0003sN\u00196fGR\u0004\u0013m\u001d\u0011b]\u0002\n'O]1z]\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003C\u000b!q\u0007\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+A)\u001cxN\\0pE*,7\r\u001e\u0011.A\u0005\u0003#jU(OA=\u0014'.Z2u]\u0001Je\rI1!m\u0006d\u0017\u000e\u001a\u0011K'>s\u0005e\u001c2kK\u000e$\b%[:!O&4XM\u001c\u0017!C2d\u0007\u0005\u001e5fA-,\u0017p\u001d\u0011pM\u0002\"\b.\u001a\u0011pkR,'/\\8ti*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I8cU\u0016\u001cG\u000fI<jY2\u0004#-\u001a\u0011sKR,(O\\3eA\u0005\u001c\b%\u00198!CJ\u0014\u0018-\u001f\u0018!\u0013\u001a\u0004\u0013\u000e\u001e\u0011jg\u0002\ng.\u001f\u0011pi\",'\u000f\t<bY&$\u0007ES*P\u001d\u0002\u001aHO]5oO2\u0002\u0013M\u001c\u0011j]Z\fG.\u001b3!\u0015N{eJ\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AM$(/\u001b8hA=\u0014\b%\u00198!K6\u0004H/\u001f\u0011tiJLgn\u001a\u0017!i\",\u0007EZ;oGRLwN\u001c\u0011sKR,(O\\:!]VdGN\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002(\u0006\t\u0019J\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(wv<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!7vS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ>#W\u0016L(E\u000f\u0011#m\u0006dW/\u001a\u0012~O%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005I.#W\u0016L(%\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)Om\u0014c-\r\u0012;E\u0005\u00147M\t\u0017#MJ\u0012#h\u001f\u0012gg\tR$%\u0019\u0012-A\t2GG\t\u001e#E\njXpJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001Z&EZ\u0019#Y\t2'GI/\u000bA\u0001\nQa\u001a:pkB\f#!!,\u0002\u0015)\u001cxN\\0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u00024\u0006)1GL\u0019/a\u0005q!j]8o\u001f\nTWm\u0019;LKf\u001c\bCA\u0016\u0016'\u0015)\u00121XAd!\u0019\ti,a1L#6\u0011\u0011q\u0018\u0006\u0004\u0003\u0003L\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003\u000b\fyLA\tBEN$(/Y2u\rVt7\r^5p]F\u0002B!!3\u0002P6\u0011\u00111\u001a\u0006\u0005\u0003\u001b\f)&\u0001\u0002j_&\u0019q)a3\u0015\u0005\u0005]\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u00055\u0013!B1qa2LHcA)\u0002\\\")\u0011\n\u0007a\u0001\u0017\u00069QO\\1qa2LH\u0003BAq\u0003O\u0004B\u0001OAr\u0017&\u0019\u0011Q]\u001d\u0003\r=\u0003H/[8o\u0011!\tI/GA\u0001\u0002\u0004\t\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011q\u001e\t\u0005\u0003\u001f\n\t0\u0003\u0003\u0002t\u0006E#AB(cU\u0016\u001cG\u000f")
public class JsonObjectKeys
extends UnaryExpression
implements CodegenFallback,
ExpectsInputTypes,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(JsonObjectKeys x$0) {
        return JsonObjectKeys$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<JsonObjectKeys, A> g) {
        return JsonObjectKeys$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, JsonObjectKeys> compose(Function1<A$, Expression> g) {
        return JsonObjectKeys$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$);
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "json_object_keys";
    }

    @Override
    public Object eval(InternalRow input) {
        Object object;
        Object object2 = new Object();
        try {
            UTF8String json = (UTF8String)this.child().eval(input);
            if (json == null) {
                return null;
            }
            try {
                object = Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> CreateJacksonParser$.MODULE$.utf8String(SharedFactory$.MODULE$.jsonFactory(), json), (Function1 & Serializable)parser -> {
                    block3: {
                        block2: {
                            if (parser.nextToken() == null) break block2;
                            JsonToken jsonToken = parser.currentToken();
                            JsonToken jsonToken2 = JsonToken.START_OBJECT;
                            if (!(jsonToken == null ? jsonToken2 != null : !jsonToken.equals(jsonToken2))) break block3;
                        }
                        throw new NonLocalReturnControl(object2, null);
                    }
                    return this.getJsonKeys((JsonParser)parser, input);
                });
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                boolean bl = throwable2 instanceof JsonProcessingException ? true : throwable2 instanceof IOException;
                if (!bl) {
                    throw throwable;
                }
                Object var2_7 = null;
                object = var2_7;
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    private GenericArrayData getJsonKeys(JsonParser parser, InternalRow input) {
        ArrayBuffer arrayBufferOfKeys = ArrayBuffer$.MODULE$.empty();
        while (parser.nextValue() != null && parser.currentName() != null) {
            arrayBufferOfKeys.$plus$eq((Object)UTF8String.fromString((String)parser.getCurrentName()));
            parser.skipChildren();
        }
        return new GenericArrayData(arrayBufferOfKeys.toArray(ClassTag$.MODULE$.apply(UTF8String.class)));
    }

    @Override
    public JsonObjectKeys withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public JsonObjectKeys copy(Expression child) {
        return new JsonObjectKeys(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "JsonObjectKeys";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JsonObjectKeys;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JsonObjectKeys)) return false;
        boolean bl = true;
        if (!bl) return false;
        JsonObjectKeys jsonObjectKeys = (JsonObjectKeys)x$1;
        Expression expression = this.child();
        Expression expression2 = jsonObjectKeys.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!jsonObjectKeys.canEqual(this)) return false;
        return true;
    }

    public JsonObjectKeys(Expression child) {
        this.child = child;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

