/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesEmptyDirVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesHostPathVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesNFSVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesPVCVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpecificConf;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class KubernetesVolumeUtils$ {
    public static final KubernetesVolumeUtils$ MODULE$ = new KubernetesVolumeUtils$();

    public Seq<KubernetesVolumeSpec> parseVolumesWithPrefix(SparkConf sparkConf, String prefix) {
        Map properties = Predef$.MODULE$.wrapRefArray((Object[])sparkConf.getAllWithPrefix(prefix)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return ((IterableOnceOps)this.getVolumeTypesAndNames((Map<String, String>)properties).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String volumeType = (String)tuple2._1();
            String volumeName = (String)tuple2._2();
            String pathKey = new StringBuilder(2).append(volumeType).append(".").append(volumeName).append(".").append(Config$.MODULE$.KUBERNETES_VOLUMES_MOUNT_PATH_KEY()).toString();
            String readOnlyKey = new StringBuilder(2).append(volumeType).append(".").append(volumeName).append(".").append(Config$.MODULE$.KUBERNETES_VOLUMES_MOUNT_READONLY_KEY()).toString();
            String subPathKey = new StringBuilder(2).append(volumeType).append(".").append(volumeName).append(".").append(Config$.MODULE$.KUBERNETES_VOLUMES_MOUNT_SUBPATH_KEY()).toString();
            KubernetesVolumeSpec kubernetesVolumeSpec = new KubernetesVolumeSpec(volumeName, (String)properties.apply((Object)pathKey), (String)properties.getOrElse((Object)subPathKey, (Function0 & Serializable)() -> ""), properties.get((Object)readOnlyKey).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$1)))), MODULE$.parseVolumeSpecificConf((Map<String, String>)properties, volumeType, volumeName));
            return kubernetesVolumeSpec;
        })).toSeq();
    }

    private Set<Tuple2<String, String>> getVolumeTypesAndNames(Map<String, String> properties) {
        return ((IterableOnceOps)properties.keys().flatMap((Function1 & Serializable)k -> {
            List list = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(k), '.')).toList();
            if (!(list instanceof .colon.colon)) return None$.MODULE$;
            .colon.colon colon2 = (.colon.colon)list;
            String tpe = (String)colon2.head();
            List list2 = colon2.next$access$1();
            if (!(list2 instanceof .colon.colon)) return None$.MODULE$;
            .colon.colon colon3 = (.colon.colon)list2;
            String name = (String)colon3.head();
            return new Some((Object)new Tuple2((Object)tpe, (Object)name));
        })).toSet();
    }

    private KubernetesVolumeSpecificConf parseVolumeSpecificConf(Map<String, String> options, String volumeType, String volumeName) {
        Product product;
        String string = volumeType;
        String string2 = Config$.MODULE$.KUBERNETES_VOLUMES_HOSTPATH_TYPE();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            String pathKey = new StringBuilder(2).append(volumeType).append(".").append(volumeName).append(".").append(Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_PATH_KEY()).toString();
            this.verifyOptionKey(options, pathKey, Config$.MODULE$.KUBERNETES_VOLUMES_HOSTPATH_TYPE());
            product = new KubernetesHostPathVolumeConf((String)options.apply((Object)pathKey));
        } else {
            String string4 = Config$.MODULE$.KUBERNETES_VOLUMES_PVC_TYPE();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                String claimNameKey = new StringBuilder(2).append(volumeType).append(".").append(volumeName).append(".").append(Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_CLAIM_NAME_KEY()).toString();
                String storageClassKey = new StringBuilder(2).append(volumeType).append(".").append(volumeName).append(".").append(Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_CLAIM_STORAGE_CLASS_KEY()).toString();
                String sizeLimitKey = new StringBuilder(2).append(volumeType).append(".").append(volumeName).append(".").append(Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_SIZE_LIMIT_KEY()).toString();
                this.verifyOptionKey(options, claimNameKey, Config$.MODULE$.KUBERNETES_VOLUMES_PVC_TYPE());
                product = new KubernetesPVCVolumeConf((String)options.apply((Object)claimNameKey), (Option<String>)options.get((Object)storageClassKey), (Option<String>)options.get((Object)sizeLimitKey));
            } else {
                String string6 = Config$.MODULE$.KUBERNETES_VOLUMES_EMPTYDIR_TYPE();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    String mediumKey = new StringBuilder(2).append(volumeType).append(".").append(volumeName).append(".").append(Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_MEDIUM_KEY()).toString();
                    String sizeLimitKey = new StringBuilder(2).append(volumeType).append(".").append(volumeName).append(".").append(Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_SIZE_LIMIT_KEY()).toString();
                    product = new KubernetesEmptyDirVolumeConf((Option<String>)options.get((Object)mediumKey), (Option<String>)options.get((Object)sizeLimitKey));
                } else {
                    String string8 = Config$.MODULE$.KUBERNETES_VOLUMES_NFS_TYPE();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        String pathKey = new StringBuilder(2).append(volumeType).append(".").append(volumeName).append(".").append(Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_PATH_KEY()).toString();
                        String serverKey = new StringBuilder(2).append(volumeType).append(".").append(volumeName).append(".").append(Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_SERVER_KEY()).toString();
                        this.verifyOptionKey(options, pathKey, Config$.MODULE$.KUBERNETES_VOLUMES_NFS_TYPE());
                        this.verifyOptionKey(options, serverKey, Config$.MODULE$.KUBERNETES_VOLUMES_NFS_TYPE());
                        product = new KubernetesNFSVolumeConf((String)options.apply((Object)pathKey), (String)options.apply((Object)serverKey));
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(42).append("Kubernetes Volume type `").append(volumeType).append("` is not supported").toString());
                    }
                }
            }
        }
        return product;
    }

    private void verifyOptionKey(Map<String, String> options, String key, String msg) {
        if (!options.isDefinedAt((Object)key)) {
            throw new NoSuchElementException(new StringBuilder(0).append(key).append(new StringBuilder(17).append(" is required for ").append(msg).toString()).toString());
        }
    }

    private KubernetesVolumeUtils$() {
    }
}

