/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.scheduler.ExecutorFailuresInTaskSet;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.SparkListenerExecutorBlacklistedForStage;
import org.apache.spark.scheduler.SparkListenerExecutorExcludedForStage;
import org.apache.spark.scheduler.SparkListenerNodeBlacklistedForStage;
import org.apache.spark.scheduler.SparkListenerNodeExcludedForStage;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005}d!B\u0014)\u0001!\u0002\u0004\u0002C\u001f\u0001\u0005\u000b\u0007I\u0011B \t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0001C\u0001\"\u0012\u0001\u0003\u0006\u0004%\tA\u0012\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u000f\"AA\n\u0001BC\u0002\u0013\u0005Q\n\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003O\u0011!\u0011\u0006A!b\u0001\n\u0003i\u0005\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011Q\u0003!Q1A\u0005\u0002UC\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\u0006;\u0002!\tA\u0018\u0005\bK\u0002\u0011\r\u0011\"\u0003N\u0011\u00191\u0007\u0001)A\u0005\u001d\"9q\r\u0001b\u0001\n\u0013i\u0005B\u00025\u0001A\u0003%a\nC\u0004j\u0001\t\u0007I\u0011B'\t\r)\u0004\u0001\u0015!\u0003O\u0011\u001dY\u0007A1A\u0005\n5Ca\u0001\u001c\u0001!\u0002\u0013q\u0005bB7\u0001\u0005\u0004%\tA\u001c\u0005\b\u0003\u0017\u0001\u0001\u0015!\u0003p\u0011%\ti\u0001\u0001b\u0001\n\u0013\ty\u0001\u0003\u0005\u0002\u001a\u0001\u0001\u000b\u0011BA\t\u0011%\tY\u0002\u0001b\u0001\n\u0013\ti\u0002\u0003\u0005\u0002$\u0001\u0001\u000b\u0011BA\u0010\u0011%\t)\u0003\u0001b\u0001\n\u0013\t9\u0003\u0003\u0005\u0002*\u0001\u0001\u000b\u0011BA\n\u0011%\tY\u0003\u0001b\u0001\n\u0013\t9\u0003\u0003\u0005\u0002.\u0001\u0001\u000b\u0011BA\n\u0011%\ty\u0003\u0001a\u0001\n\u0013\t\t\u0004C\u0005\u00024\u0001\u0001\r\u0011\"\u0003\u00026!9\u0011\u0011\t\u0001!B\u00139\bbBA\"\u0001\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\t9\u0006\u0001C\u0001\u00033Bq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0004\u0002h\u0001!\t!!\u001b\t\u0011\u00055\u0004\u0001\"\u0001)\u0003_\u0012!\u0003V1tWN+G/\u0012=dYV$W\r\\5ti*\u0011\u0011FK\u0001\ng\u000eDW\rZ;mKJT!a\u000b\u0017\u0002\u000bM\u0004\u0018M]6\u000b\u00055r\u0013AB1qC\u000eDWMC\u00010\u0003\ry'oZ\n\u0004\u0001E:\u0004C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$AB!osJ+g\r\u0005\u00029w5\t\u0011H\u0003\u0002;U\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002=s\t9Aj\\4hS:<\u0017a\u00037jgR,g.\u001a:CkN\u001c\u0001!F\u0001A!\t\t%)D\u0001)\u0013\t\u0019\u0005FA\bMSZ,G*[:uK:,'OQ;t\u00031a\u0017n\u001d;f]\u0016\u0014()^:!\u0003\u0011\u0019wN\u001c4\u0016\u0003\u001d\u0003\"\u0001S%\u000e\u0003)J!A\u0013\u0016\u0003\u0013M\u0003\u0018M]6D_:4\u0017!B2p]\u001a\u0004\u0013aB:uC\u001e,\u0017\nZ\u000b\u0002\u001dB\u0011!gT\u0005\u0003!N\u00121!\u00138u\u0003!\u0019H/Y4f\u0013\u0012\u0004\u0013AD:uC\u001e,\u0017\t\u001e;f[B$\u0018\nZ\u0001\u0010gR\fw-Z!ui\u0016l\u0007\u000f^%eA\u0005)1\r\\8dWV\ta\u000b\u0005\u0002X56\t\u0001L\u0003\u0002ZU\u0005!Q\u000f^5m\u0013\tY\u0006LA\u0003DY>\u001c7.\u0001\u0004dY>\u001c7\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\r}\u0003\u0017MY2e!\t\t\u0005\u0001C\u0003>\u0017\u0001\u0007\u0001\tC\u0003F\u0017\u0001\u0007q\tC\u0003M\u0017\u0001\u0007a\nC\u0003S\u0017\u0001\u0007a\nC\u0003U\u0017\u0001\u0007a+\u0001\u0010N\u0003b{F+Q*L?\u0006#F+R'Q)N{\u0006+\u0012*`\u000bb+5)\u0016+P%\u0006yR*\u0011-`)\u0006\u001b6jX!U)\u0016k\u0005\u000bV*`!\u0016\u0013v,\u0012-F\u0007V#vJ\u0015\u0011\u000255\u000b\u0005l\u0018+B'.{\u0016\t\u0016+F\u001bB#6k\u0018)F%~su\nR#\u000275\u000b\u0005l\u0018+B'.{\u0016\t\u0016+F\u001bB#6k\u0018)F%~su\nR#!\u0003mi\u0015\tW0G\u0003&cUKU#T?B+%kX#Y\u000b\u000e{6\u000bV!H\u000b\u0006aR*\u0011-`\r\u0006KE*\u0016*F'~\u0003VIU0F1\u0016\u001bul\u0015+B\u000f\u0016\u0003\u0013AH'B1~3\u0015)\u0013'F\t~+\u0005,R\"`!\u0016\u0013vLT(E\u000b~\u001bF+Q$F\u0003}i\u0015\tW0G\u0003&cU\tR0F1\u0016\u001bu\fU#S?:{E)R0T)\u0006;U\tI\u0001\u000fKb,7\rV8GC&dWO]3t+\u0005y\u0007#\u00029vo\u0006\u0015Q\"A9\u000b\u0005I\u001c\u0018aB7vi\u0006\u0014G.\u001a\u0006\u0003iN\n!bY8mY\u0016\u001cG/[8o\u0013\t1\u0018OA\u0004ICNDW*\u00199\u0011\u0005a|hBA=~!\tQ8'D\u0001|\u0015\tah(\u0001\u0004=e>|GOP\u0005\u0003}N\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0001\u0003\u0007\u0011aa\u0015;sS:<'B\u0001@4!\r\t\u0015qA\u0005\u0004\u0003\u0013A#!G#yK\u000e,Ho\u001c:GC&dWO]3t\u0013:$\u0016m]6TKR\fq\"\u001a=fGR{g)Y5mkJ,7\u000fI\u0001\u0018]>$W\rV8Fq\u0016\u001c7oV5uQ\u001a\u000b\u0017\u000e\\;sKN,\"!!\u0005\u0011\u000bA,x/a\u0005\u0011\tA\f)b^\u0005\u0004\u0003/\t(a\u0002%bg\"\u001cV\r^\u0001\u0019]>$W\rV8Fq\u0016\u001c7oV5uQ\u001a\u000b\u0017\u000e\\;sKN\u0004\u0013!\u00078pI\u0016$v.\u0012=dYV$W\r\u001a+bg.Le\u000eZ3yKN,\"!a\b\u0011\u000bA,x/!\t\u0011\tA\f)BT\u0001\u001b]>$W\rV8Fq\u000edW\u000fZ3e)\u0006\u001c8.\u00138eKb,7\u000fI\u0001\u000eKb\u001cG.\u001e3fI\u0016CXmY:\u0016\u0005\u0005M\u0011AD3yG2,H-\u001a3Fq\u0016\u001c7\u000fI\u0001\u000eKb\u001cG.\u001e3fI:{G-Z:\u0002\u001d\u0015D8\r\\;eK\u0012tu\u000eZ3tA\u0005\u0019B.\u0019;fgR4\u0015-\u001b7ve\u0016\u0014V-Y:p]V\tq/A\fmCR,7\u000f\u001e$bS2,(/\u001a*fCN|gn\u0018\u0013fcR!\u0011qGA\u001f!\r\u0011\u0014\u0011H\u0005\u0004\u0003w\u0019$\u0001B+oSRD\u0001\"a\u0010 \u0003\u0003\u0005\ra^\u0001\u0004q\u0012\n\u0014\u0001\u00067bi\u0016\u001cHOR1jYV\u0014XMU3bg>t\u0007%\u0001\fhKRd\u0015\r^3ti\u001a\u000b\u0017\u000e\\;sKJ+\u0017m]8o\u0003eI7/\u0012=fGV$xN]#yG2,H-\u001a3G_J$\u0016m]6\u0015\r\u0005%\u0013qJA*!\r\u0011\u00141J\u0005\u0004\u0003\u001b\u001a$a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003#\u0012\u0003\u0019A<\u0002\u0015\u0015DXmY;u_JLE\r\u0003\u0004\u0002V\t\u0002\rAT\u0001\u0006S:$W\r_\u0001\u0016SNtu\u000eZ3Fq\u000edW\u000fZ3e\r>\u0014H+Y:l)\u0019\tI%a\u0017\u0002`!1\u0011QL\u0012A\u0002]\fAA\\8eK\"1\u0011QK\u0012A\u00029\u000bA$[:Fq\u0016\u001cW\u000f^8s\u000bb\u001cG.\u001e3fI\u001a{'\u000fV1tWN+G\u000f\u0006\u0003\u0002J\u0005\u0015\u0004BBA)I\u0001\u0007q/\u0001\rjg:{G-Z#yG2,H-\u001a3G_J$\u0016m]6TKR$B!!\u0013\u0002l!1\u0011QL\u0013A\u0002]\f1$\u001e9eCR,W\t_2mk\u0012,GMR8s\r\u0006LG.\u001a3UCN\\GCCA\u001c\u0003c\n)(!\u001f\u0002|!1\u00111\u000f\u0014A\u0002]\fA\u0001[8ti\"1\u0011q\u000f\u0014A\u0002]\fA!\u001a=fG\"1\u0011Q\u000b\u0014A\u00029Ca!! '\u0001\u00049\u0018!\u00044bS2,(/\u001a*fCN|g\u000e")
public class TaskSetExcludelist
implements Logging {
    private final LiveListenerBus listenerBus;
    private final SparkConf conf;
    private final int stageId;
    private final int stageAttemptId;
    private final Clock clock;
    private final int MAX_TASK_ATTEMPTS_PER_EXECUTOR;
    private final int MAX_TASK_ATTEMPTS_PER_NODE;
    private final int MAX_FAILURES_PER_EXEC_STAGE;
    private final int MAX_FAILED_EXEC_PER_NODE_STAGE;
    private final HashMap<String, ExecutorFailuresInTaskSet> execToFailures;
    private final HashMap<String, HashSet<String>> nodeToExecsWithFailures;
    private final HashMap<String, HashSet<Object>> nodeToExcludedTaskIndexes;
    private final HashSet<String> excludedExecs;
    private final HashSet<String> excludedNodes;
    private String latestFailureReason;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private LiveListenerBus listenerBus() {
        return this.listenerBus;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public int stageId() {
        return this.stageId;
    }

    public int stageAttemptId() {
        return this.stageAttemptId;
    }

    public Clock clock() {
        return this.clock;
    }

    private int MAX_TASK_ATTEMPTS_PER_EXECUTOR() {
        return this.MAX_TASK_ATTEMPTS_PER_EXECUTOR;
    }

    private int MAX_TASK_ATTEMPTS_PER_NODE() {
        return this.MAX_TASK_ATTEMPTS_PER_NODE;
    }

    private int MAX_FAILURES_PER_EXEC_STAGE() {
        return this.MAX_FAILURES_PER_EXEC_STAGE;
    }

    private int MAX_FAILED_EXEC_PER_NODE_STAGE() {
        return this.MAX_FAILED_EXEC_PER_NODE_STAGE;
    }

    public HashMap<String, ExecutorFailuresInTaskSet> execToFailures() {
        return this.execToFailures;
    }

    private HashMap<String, HashSet<String>> nodeToExecsWithFailures() {
        return this.nodeToExecsWithFailures;
    }

    private HashMap<String, HashSet<Object>> nodeToExcludedTaskIndexes() {
        return this.nodeToExcludedTaskIndexes;
    }

    private HashSet<String> excludedExecs() {
        return this.excludedExecs;
    }

    private HashSet<String> excludedNodes() {
        return this.excludedNodes;
    }

    private String latestFailureReason() {
        return this.latestFailureReason;
    }

    private void latestFailureReason_$eq(String x$1) {
        this.latestFailureReason = x$1;
    }

    public String getLatestFailureReason() {
        return this.latestFailureReason();
    }

    public boolean isExecutorExcludedForTask(String executorId, int index) {
        return this.execToFailures().get((Object)executorId).exists((Function1 & Serializable)execFailures -> BoxesRunTime.boxToBoolean((boolean)TaskSetExcludelist.$anonfun$isExecutorExcludedForTask$1(this, index, execFailures)));
    }

    public boolean isNodeExcludedForTask(String node, int index) {
        return this.nodeToExcludedTaskIndexes().get((Object)node).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains((Object)BoxesRunTime.boxToInteger((int)index))));
    }

    public boolean isExecutorExcludedForTaskSet(String executorId) {
        return this.excludedExecs().contains((Object)executorId);
    }

    public boolean isNodeExcludedForTaskSet(String node) {
        return this.excludedNodes().contains((Object)node);
    }

    public void updateExcludedForFailedTask(String host, String exec2, int index, String failureReason) {
        block1: {
            this.latestFailureReason_$eq(failureReason);
            ExecutorFailuresInTaskSet execFailures = (ExecutorFailuresInTaskSet)this.execToFailures().getOrElseUpdate((Object)exec2, (Function0 & Serializable)() -> new ExecutorFailuresInTaskSet(host));
            execFailures.updateWithFailure(index, this.clock().getTimeMillis());
            HashSet execsWithFailuresOnNode = (HashSet)this.nodeToExecsWithFailures().getOrElseUpdate((Object)host, (Function0 & Serializable)() -> new HashSet());
            execsWithFailuresOnNode.$plus$eq((Object)exec2);
            int failuresOnHost = BoxesRunTime.unboxToInt((Object)execsWithFailuresOnNode.iterator().flatMap((Function1 & Serializable)exec -> this.execToFailures().get(exec).map((Function1 & Serializable)failures -> BoxesRunTime.boxToInteger((int)failures.getNumTaskFailures(index)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            Object object = failuresOnHost >= this.MAX_TASK_ATTEMPTS_PER_NODE() ? ((Growable)this.nodeToExcludedTaskIndexes().getOrElseUpdate((Object)host, (Function0 & Serializable)() -> new HashSet())).$plus$eq((Object)BoxesRunTime.boxToInteger((int)index)) : BoxedUnit.UNIT;
            int numFailures = execFailures.numUniqueTasksWithFailures();
            if (numFailures < this.MAX_FAILURES_PER_EXEC_STAGE() || !this.excludedExecs().add((Object)exec2)) break block1;
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Excluding executor ").append(exec2).append(" for stage ").append(this.stageId()).toString());
            HashSet excludedExecutorsOnNode = (HashSet)execsWithFailuresOnNode.intersect(this.excludedExecs());
            long now = this.clock().getTimeMillis();
            this.listenerBus().post(new SparkListenerExecutorBlacklistedForStage(now, exec2, numFailures, this.stageId(), this.stageAttemptId()));
            this.listenerBus().post(new SparkListenerExecutorExcludedForStage(now, exec2, numFailures, this.stageId(), this.stageAttemptId()));
            int numFailExec = excludedExecutorsOnNode.size();
            if (numFailExec >= this.MAX_FAILED_EXEC_PER_NODE_STAGE() && this.excludedNodes().add((Object)host)) {
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(21).append("Excluding ").append(host).append(" for stage ").append(this.stageId()).toString());
                this.listenerBus().post(new SparkListenerNodeBlacklistedForStage(now, host, numFailExec, this.stageId(), this.stageAttemptId()));
                this.listenerBus().post(new SparkListenerNodeExcludedForStage(now, host, numFailExec, this.stageId(), this.stageAttemptId()));
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$isExecutorExcludedForTask$1(TaskSetExcludelist $this, int index$1, ExecutorFailuresInTaskSet execFailures) {
        return execFailures.getNumTaskFailures(index$1) >= $this.MAX_TASK_ATTEMPTS_PER_EXECUTOR();
    }

    public TaskSetExcludelist(LiveListenerBus listenerBus, SparkConf conf, int stageId, int stageAttemptId, Clock clock) {
        this.listenerBus = listenerBus;
        this.conf = conf;
        this.stageId = stageId;
        this.stageAttemptId = stageAttemptId;
        this.clock = clock;
        Logging.$init$((Logging)this);
        this.MAX_TASK_ATTEMPTS_PER_EXECUTOR = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.MAX_TASK_ATTEMPTS_PER_EXECUTOR()));
        this.MAX_TASK_ATTEMPTS_PER_NODE = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.MAX_TASK_ATTEMPTS_PER_NODE()));
        this.MAX_FAILURES_PER_EXEC_STAGE = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.MAX_FAILURES_PER_EXEC_STAGE()));
        this.MAX_FAILED_EXEC_PER_NODE_STAGE = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.MAX_FAILED_EXEC_PER_NODE_STAGE()));
        this.execToFailures = new HashMap();
        this.nodeToExecsWithFailures = new HashMap();
        this.nodeToExcludedTaskIndexes = new HashMap();
        this.excludedExecs = new HashSet();
        this.excludedNodes = new HashSet();
        this.latestFailureReason = null;
    }
}

