/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.worker;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.config.Worker$;
import org.apache.spark.util.IntParam$;
import org.apache.spark.util.MemoryParam$;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005eb!B\u0011#\u0001\tb\u0003\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\t\u0011\r\u0003!\u0011!Q\u0001\n\u0011CQ\u0001\u0013\u0001\u0005\u0002%CqA\u0014\u0001A\u0002\u0013\u0005q\nC\u0004Q\u0001\u0001\u0007I\u0011A)\t\r]\u0003\u0001\u0015)\u00039\u0011\u001dA\u0006\u00011A\u0005\u0002eCq!\u0018\u0001A\u0002\u0013\u0005a\f\u0003\u0004a\u0001\u0001\u0006KA\u0017\u0005\bC\u0002\u0001\r\u0011\"\u0001Z\u0011\u001d\u0011\u0007\u00011A\u0005\u0002\rDa!\u001a\u0001!B\u0013Q\u0006b\u00024\u0001\u0001\u0004%\t!\u0017\u0005\bO\u0002\u0001\r\u0011\"\u0001i\u0011\u0019Q\u0007\u0001)Q\u00055\"91\u000e\u0001a\u0001\n\u0003I\u0006b\u00027\u0001\u0001\u0004%\t!\u001c\u0005\u0007_\u0002\u0001\u000b\u0015\u0002.\t\u000fA\u0004\u0001\u0019!C\u0001c\"9!\u000f\u0001a\u0001\n\u0003\u0019\bBB;\u0001A\u0003&Q\u0007C\u0004w\u0001\u0001\u0007I\u0011A(\t\u000f]\u0004\u0001\u0019!C\u0001q\"1!\u0010\u0001Q!\naBqa\u001f\u0001A\u0002\u0013\u0005q\nC\u0004}\u0001\u0001\u0007I\u0011A?\t\r}\u0004\u0001\u0015)\u00039\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007Aq!a\n\u0001\t\u0003\tI\u0003C\u0004\u00020\u0001!\t!!\r\t\u000f\u0005M\u0002\u0001\"\u0001\u00022!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\"aD,pe.,'/\u0011:hk6,g\u000e^:\u000b\u0005\r\"\u0013AB<pe.,'O\u0003\u0002&M\u00051A-\u001a9m_fT!a\n\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005%R\u0013AB1qC\u000eDWMC\u0001,\u0003\ry'oZ\n\u0003\u00015\u0002\"AL\u0019\u000e\u0003=R\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\u0012a!\u00118z%\u00164\u0017\u0001B1sON\u001c\u0001\u0001E\u0002/maJ!aN\u0018\u0003\u000b\u0005\u0013(/Y=\u0011\u0005e\u0002eB\u0001\u001e?!\tYt&D\u0001=\u0015\tiD'\u0001\u0004=e>|GOP\u0005\u0003\u007f=\na\u0001\u0015:fI\u00164\u0017BA!C\u0005\u0019\u0019FO]5oO*\u0011qhL\u0001\u0005G>tg\r\u0005\u0002F\r6\ta%\u0003\u0002HM\tI1\u000b]1sW\u000e{gNZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007)cU\n\u0005\u0002L\u00015\t!\u0005C\u00034\u0007\u0001\u0007Q\u0007C\u0003D\u0007\u0001\u0007A)\u0001\u0003i_N$X#\u0001\u001d\u0002\u0011!|7\u000f^0%KF$\"AU+\u0011\u00059\u001a\u0016B\u0001+0\u0005\u0011)f.\u001b;\t\u000fY+\u0011\u0011!a\u0001q\u0005\u0019\u0001\u0010J\u0019\u0002\u000b!|7\u000f\u001e\u0011\u0002\tA|'\u000f^\u000b\u00025B\u0011afW\u0005\u00039>\u00121!\u00138u\u0003!\u0001xN\u001d;`I\u0015\fHC\u0001*`\u0011\u001d1\u0006\"!AA\u0002i\u000bQ\u0001]8si\u0002\n\u0011b^3c+&\u0004vN\u001d;\u0002\u001b],'-V5Q_J$x\fJ3r)\t\u0011F\rC\u0004W\u0017\u0005\u0005\t\u0019\u0001.\u0002\u0015],'-V5Q_J$\b%A\u0003d_J,7/A\u0005d_J,7o\u0018\u0013fcR\u0011!+\u001b\u0005\b-:\t\t\u00111\u0001[\u0003\u0019\u0019wN]3tA\u00051Q.Z7pef\f!\"\\3n_JLx\fJ3r)\t\u0011f\u000eC\u0004W#\u0005\u0005\t\u0019\u0001.\u0002\u000f5,Wn\u001c:zA\u00059Q.Y:uKJ\u001cX#A\u001b\u0002\u00175\f7\u000f^3sg~#S-\u001d\u000b\u0003%RDqA\u0016\u000b\u0002\u0002\u0003\u0007Q'\u0001\u0005nCN$XM]:!\u0003\u001d9xN]6ESJ\f1b^8sW\u0012K'o\u0018\u0013fcR\u0011!+\u001f\u0005\b-^\t\t\u00111\u00019\u0003!9xN]6ESJ\u0004\u0013A\u00049s_B,'\u000f^5fg\u001aKG.Z\u0001\u0013aJ|\u0007/\u001a:uS\u0016\u001ch)\u001b7f?\u0012*\u0017\u000f\u0006\u0002S}\"9aKGA\u0001\u0002\u0004A\u0014a\u00049s_B,'\u000f^5fg\u001aKG.\u001a\u0011\u0002\u000bA\f'o]3\u0015\u0007I\u000b)\u0001\u0003\u000449\u0001\u0007\u0011q\u0001\t\u0006\u0003\u0013\t\u0019\u0002\u000f\b\u0005\u0003\u0017\tyAD\u0002<\u0003\u001bI\u0011\u0001M\u0005\u0004\u0003#y\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003+\t9B\u0001\u0003MSN$(bAA\t_!\u001aA$a\u0007\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\t0\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003K\tyBA\u0004uC&d'/Z2\u0002#A\u0014\u0018N\u001c;Vg\u0006<W-\u00118e\u000bbLG\u000fF\u0002S\u0003WAa!!\f\u001e\u0001\u0004Q\u0016\u0001C3ySR\u001cu\u000eZ3\u0002#%tg-\u001a:EK\u001a\fW\u000f\u001c;D_J,7\u000fF\u0001[\u0003IIgNZ3s\t\u00164\u0017-\u001e7u\u001b\u0016lwN]=\u0002#\rDWmY6X_J\\WM]'f[>\u0014\u0018\u0010F\u0001S\u0001")
public class WorkerArguments {
    private String host = Utils$.MODULE$.localHostName();
    private int port = 0;
    private int webUiPort = 8081;
    private int cores = this.inferDefaultCores();
    private int memory = this.inferDefaultMemory();
    private String[] masters = null;
    private String workDir = null;
    private String propertiesFile = null;

    public String host() {
        return this.host;
    }

    public void host_$eq(String x$1) {
        this.host = x$1;
    }

    public int port() {
        return this.port;
    }

    public void port_$eq(int x$1) {
        this.port = x$1;
    }

    public int webUiPort() {
        return this.webUiPort;
    }

    public void webUiPort_$eq(int x$1) {
        this.webUiPort = x$1;
    }

    public int cores() {
        return this.cores;
    }

    public void cores_$eq(int x$1) {
        this.cores = x$1;
    }

    public int memory() {
        return this.memory;
    }

    public void memory_$eq(int x$1) {
        this.memory = x$1;
    }

    public String[] masters() {
        return this.masters;
    }

    public void masters_$eq(String[] x$1) {
        this.masters = x$1;
    }

    public String workDir() {
        return this.workDir;
    }

    public void workDir_$eq(String x$1) {
        this.workDir = x$1;
    }

    public String propertiesFile() {
        return this.propertiesFile;
    }

    public void propertiesFile_$eq(String x$1) {
        this.propertiesFile = x$1;
    }

    private void parse(List<String> args) {
        block27: {
            List list;
            while (true) {
                String string;
                boolean bl = false;
                .colon.colon colon2 = null;
                list = args;
                if (list instanceof .colon.colon) {
                    bl = true;
                    colon2 = (.colon.colon)list;
                    String string2 = (String)colon2.head();
                    List list2 = colon2.next$access$1();
                    boolean bl2 = "--ip".equals(string2) ? true : "-i".equals(string2);
                    if (bl2 && list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        String value = (String)colon3.head();
                        List tail = colon3.next$access$1();
                        Utils$.MODULE$.checkHost(value);
                        this.host_$eq(value);
                        args = tail;
                        continue;
                    }
                }
                if (bl) {
                    String string3 = (String)colon2.head();
                    List list3 = colon2.next$access$1();
                    boolean bl3 = "--host".equals(string3) ? true : "-h".equals(string3);
                    if (bl3 && list3 instanceof .colon.colon) {
                        .colon.colon colon4 = (.colon.colon)list3;
                        String value = (String)colon4.head();
                        List tail = colon4.next$access$1();
                        Utils$.MODULE$.checkHost(value);
                        this.host_$eq(value);
                        args = tail;
                        continue;
                    }
                }
                if (bl) {
                    String string4 = (String)colon2.head();
                    List list4 = colon2.next$access$1();
                    boolean bl4 = "--port".equals(string4) ? true : "-p".equals(string4);
                    if (bl4 && list4 instanceof .colon.colon) {
                        Option<Object> option;
                        .colon.colon colon5 = (.colon.colon)list4;
                        String string5 = (String)colon5.head();
                        List tail = colon5.next$access$1();
                        if (string5 != null && !(option = IntParam$.MODULE$.unapply(string5)).isEmpty()) {
                            int value = BoxesRunTime.unboxToInt((Object)option.get());
                            this.port_$eq(value);
                            args = tail;
                            continue;
                        }
                    }
                }
                if (bl) {
                    String string6 = (String)colon2.head();
                    List list5 = colon2.next$access$1();
                    boolean bl5 = "--cores".equals(string6) ? true : "-c".equals(string6);
                    if (bl5 && list5 instanceof .colon.colon) {
                        Option<Object> option;
                        .colon.colon colon6 = (.colon.colon)list5;
                        String string7 = (String)colon6.head();
                        List tail = colon6.next$access$1();
                        if (string7 != null && !(option = IntParam$.MODULE$.unapply(string7)).isEmpty()) {
                            int value = BoxesRunTime.unboxToInt((Object)option.get());
                            this.cores_$eq(value);
                            args = tail;
                            continue;
                        }
                    }
                }
                if (bl) {
                    String string8 = (String)colon2.head();
                    List list6 = colon2.next$access$1();
                    boolean bl6 = "--memory".equals(string8) ? true : "-m".equals(string8);
                    if (bl6 && list6 instanceof .colon.colon) {
                        Option<Object> option;
                        .colon.colon colon7 = (.colon.colon)list6;
                        String string9 = (String)colon7.head();
                        List tail = colon7.next$access$1();
                        if (string9 != null && !(option = MemoryParam$.MODULE$.unapply(string9)).isEmpty()) {
                            int value = BoxesRunTime.unboxToInt((Object)option.get());
                            this.memory_$eq(value);
                            args = tail;
                            continue;
                        }
                    }
                }
                if (bl) {
                    String string10 = (String)colon2.head();
                    List list7 = colon2.next$access$1();
                    boolean bl7 = "--work-dir".equals(string10) ? true : "-d".equals(string10);
                    if (bl7 && list7 instanceof .colon.colon) {
                        .colon.colon colon8 = (.colon.colon)list7;
                        String value = (String)colon8.head();
                        List tail = colon8.next$access$1();
                        this.workDir_$eq(value);
                        args = tail;
                        continue;
                    }
                }
                if (bl) {
                    String string11 = (String)colon2.head();
                    List list8 = colon2.next$access$1();
                    if ("--webui-port".equals(string11) && list8 instanceof .colon.colon) {
                        Option<Object> option;
                        .colon.colon colon9 = (.colon.colon)list8;
                        String string12 = (String)colon9.head();
                        List tail = colon9.next$access$1();
                        if (string12 != null && !(option = IntParam$.MODULE$.unapply(string12)).isEmpty()) {
                            int value = BoxesRunTime.unboxToInt((Object)option.get());
                            this.webUiPort_$eq(value);
                            args = tail;
                            continue;
                        }
                    }
                }
                if (bl) {
                    String string13 = (String)colon2.head();
                    List list9 = colon2.next$access$1();
                    if ("--properties-file".equals(string13) && list9 instanceof .colon.colon) {
                        .colon.colon colon10 = (.colon.colon)list9;
                        String value = (String)colon10.head();
                        List tail = colon10.next$access$1();
                        this.propertiesFile_$eq(value);
                        args = tail;
                        continue;
                    }
                }
                if (bl && "--help".equals(string = (String)colon2.head())) {
                    this.printUsageAndExit(0);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block27;
                }
                if (!bl) break;
                String value = (String)colon2.head();
                List tail = colon2.next$access$1();
                if (this.masters() != null) {
                    this.printUsageAndExit(1);
                }
                this.masters_$eq(Utils$.MODULE$.parseStandaloneMasterUrls(value));
                args = tail;
            }
            Nil$ nil$ = scala.package$.MODULE$.Nil();
            List list10 = list;
            if (!(nil$ != null ? !nil$.equals(list10) : list10 != null)) {
                BoxedUnit boxedUnit;
                if (this.masters() == null) {
                    this.printUsageAndExit(1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                this.printUsageAndExit(1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void printUsageAndExit(int exitCode) {
        System.err.println("Usage: Worker [options] <master>\n\nMaster must be a URL of the form spark://hostname:port\n\nOptions:\n  -c CORES, --cores CORES  Number of cores to use\n  -m MEM, --memory MEM     Amount of memory to use (e.g. 1000M, 2G)\n  -d DIR, --work-dir DIR   Directory to run apps in (default: SPARK_HOME/work)\n  -i HOST, --ip IP         Hostname to listen on (deprecated, please use --host or -h)\n  -h HOST, --host HOST     Hostname to listen on\n  -p PORT, --port PORT     Port to listen on (default: random)\n  --webui-port PORT        Port for web UI (default: 8081)\n  --properties-file FILE   Path to a custom Spark properties file.\n                           Default is conf/spark-defaults.conf.");
        System.exit(exitCode);
    }

    public int inferDefaultCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    public int inferDefaultMemory() {
        int totalMb;
        block3: {
            boolean ibmVendor = System.getProperty("java.vendor").contains("IBM");
            totalMb = 0;
            try {
                OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
                if (ibmVendor) {
                    Class<?> beanClass = Class.forName("com.ibm.lang.management.OperatingSystemMXBean");
                    Method method = beanClass.getDeclaredMethod("getTotalPhysicalMemory", new Class[0]);
                    totalMb = (int)(BoxesRunTime.unboxToLong((Object)method.invoke((Object)bean, new Object[0])) / 1024L / 1024L);
                    break block3;
                }
                Class<?> beanClass = Class.forName("com.sun.management.OperatingSystemMXBean");
                Method method = beanClass.getDeclaredMethod("getTotalPhysicalMemorySize", new Class[0]);
                totalMb = (int)(BoxesRunTime.unboxToLong((Object)method.invoke((Object)bean, new Object[0])) / 1024L / 1024L);
            }
            catch (Exception e) {
                totalMb = 2048;
                System.out.println(new StringBuilder(46).append("Failed to get total physical memory. Using ").append(totalMb).append(" MB").toString());
            }
        }
        return package$.MODULE$.max(totalMb - 1024, Utils$.MODULE$.DEFAULT_DRIVER_MEM_MB());
    }

    public void checkWorkerMemory() {
        if (this.memory() <= 0) {
            String message = "Memory is below 1MB, or missing a M/G at the end of the memory specification?";
            throw new IllegalStateException(message);
        }
    }

    public WorkerArguments(String[] args, SparkConf conf) {
        if (System.getenv("SPARK_WORKER_PORT") != null) {
            this.port_$eq(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(System.getenv("SPARK_WORKER_PORT"))));
        }
        if (System.getenv("SPARK_WORKER_CORES") != null) {
            this.cores_$eq(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(System.getenv("SPARK_WORKER_CORES"))));
        }
        if (conf.getenv("SPARK_WORKER_MEMORY") != null) {
            this.memory_$eq(Utils$.MODULE$.memoryStringToMb(conf.getenv("SPARK_WORKER_MEMORY")));
        }
        if (System.getenv("SPARK_WORKER_WEBUI_PORT") != null) {
            this.webUiPort_$eq(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(System.getenv("SPARK_WORKER_WEBUI_PORT"))));
        }
        if (System.getenv("SPARK_WORKER_DIR") != null) {
            this.workDir_$eq(System.getenv("SPARK_WORKER_DIR"));
        }
        this.parse((List<String>)Predef$.MODULE$.wrapRefArray((Object[])args).toList());
        this.propertiesFile_$eq(Utils$.MODULE$.loadDefaultSparkProperties(conf, this.propertiesFile()));
        ((Option)conf.get(Worker$.MODULE$.WORKER_UI_PORT())).foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> this.webUiPort_$eq(x$1));
        this.checkWorkerMemory();
    }
}

