/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.FileContextBasedCheckpointFileManager;
import org.apache.spark.sql.execution.streaming.FileSystemBasedCheckpointFileManager;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;

public final class CheckpointFileManager$
implements Logging {
    public static final CheckpointFileManager$ MODULE$ = new CheckpointFileManager$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public CheckpointFileManager create(Path path, Configuration hadoopConf) {
        Logging logging;
        String fileManagerClass = hadoopConf.get(SQLConf$.MODULE$.STREAMING_CHECKPOINT_FILE_MANAGER_CLASS().parent().key());
        if (fileManagerClass != null) {
            return (CheckpointFileManager)Utils$.MODULE$.classForName(fileManagerClass, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getConstructor(Path.class, Configuration.class).newInstance(path, hadoopConf);
        }
        try {
            logging = new FileContextBasedCheckpointFileManager(path, hadoopConf);
        }
        catch (UnsupportedFileSystemException e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(84).append("Could not use FileContext API for managing Structured Streaming checkpoint files at ").append(new StringBuilder(77).append(path).append(". Using FileSystem API instead for managing log files. If the implementation ").toString()).append("of FileSystem.rename() is not atomic, then the correctness and fault-tolerance of").append("your Structured Streaming is not guaranteed.").toString());
            logging = new FileSystemBasedCheckpointFileManager(path, hadoopConf);
        }
        return logging;
    }

    public Path org$apache$spark$sql$execution$streaming$CheckpointFileManager$$generateTempPath(Path path) {
        TaskContext tc = TaskContext$.MODULE$.get();
        String tid = tc != null ? new StringBuilder(4).append(".TID").append(tc.taskAttemptId()).toString() : "";
        return new Path(path.getParent(), new StringBuilder(6).append(".").append(path.getName()).append(".").append(UUID.randomUUID()).append(tid).append(".tmp").toString());
    }

    private CheckpointFileManager$() {
    }
}

