/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import java.io.InterruptedIOException;
import java.io.Serializable;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.yarn.Client;
import org.apache.spark.deploy.yarn.ClientArguments;
import org.apache.spark.deploy.yarn.YarnAppReport;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.SchedulerBackendUtils$;
import org.apache.spark.scheduler.cluster.YarnSchedulerBackend;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da!\u0002\f\u0018\u0001m\t\u0003\u0002\u0003\u000e\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\t\u0011E\u0002!\u0011!Q\u0001\nIBQA\u000e\u0001\u0005\u0002]Bqa\u000f\u0001A\u0002\u0013%A\bC\u0004F\u0001\u0001\u0007I\u0011\u0002$\t\r=\u0003\u0001\u0015)\u0003>\u0011\u001d\u0001\u0006\u00011A\u0005\nECqa\u001b\u0001A\u0002\u0013%A\u000e\u0003\u0004o\u0001\u0001\u0006KA\u0015\u0005\u0006_\u0002!\t%\u001b\u0005\u0006a\u0002!I!\u001b\u0004\u0005)\u0002!Q\u000bC\u00037\u0019\u0011\u0005a\fC\u0004`\u0019\u0001\u0007I\u0011\u00021\t\u000f\u0011d\u0001\u0019!C\u0005K\"1q\r\u0004Q!\n\u0005DQ\u0001\u001b\u0007\u0005B%DQA\u001b\u0007\u0005\u0002%DQ!\u001d\u0001\u0005\nyCQA\u001d\u0001\u0005BMDQ!\u001f\u0001\u0005Ri\u0014!$W1s]\u000ec\u0017.\u001a8u'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012T!\u0001G\r\u0002\u000f\rdWo\u001d;fe*\u0011!dG\u0001\ng\u000eDW\rZ;mKJT!\u0001H\u000f\u0002\u000bM\u0004\u0018M]6\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\n\u0004\u0001\t2\u0003CA\u0012%\u001b\u00059\u0012BA\u0013\u0018\u0005QI\u0016M\u001d8TG\",G-\u001e7fe\n\u000b7m[3oIB\u0011qEK\u0007\u0002Q)\u0011\u0011fG\u0001\tS:$XM\u001d8bY&\u00111\u0006\u000b\u0002\b\u0019><w-\u001b8h\u0007\u0001\u0001\"AL\u0018\u000e\u0003eI!\u0001M\r\u0003#Q\u000b7o[*dQ\u0016$W\u000f\\3s\u00136\u0004H.\u0001\u0002tGB\u00111\u0007N\u0007\u00027%\u0011Qg\u0007\u0002\r'B\f'o[\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007aJ$\b\u0005\u0002$\u0001!)!d\u0001a\u0001[!)\u0011g\u0001a\u0001e\u000511\r\\5f]R,\u0012!\u0010\t\u0003}\rk\u0011a\u0010\u0006\u0003\u0001\u0006\u000bA!_1s]*\u0011!iG\u0001\u0007I\u0016\u0004Hn\\=\n\u0005\u0011{$AB\"mS\u0016tG/\u0001\u0006dY&,g\u000e^0%KF$\"aR'\u0011\u0005![U\"A%\u000b\u0003)\u000bQa]2bY\u0006L!\u0001T%\u0003\tUs\u0017\u000e\u001e\u0005\b\u001d\u0016\t\t\u00111\u0001>\u0003\rAH%M\u0001\bG2LWM\u001c;!\u00035iwN\\5u_J$\u0006N]3bIV\t!\u000b\u0005\u0002T\u00195\t\u0001AA\u0007N_:LGo\u001c:UQJ,\u0017\rZ\n\u0003\u0019Y\u0003\"a\u0016/\u000e\u0003aS!!\u0017.\u0002\t1\fgn\u001a\u0006\u00027\u0006!!.\u0019<b\u0013\ti\u0006L\u0001\u0004UQJ,\u0017\r\u001a\u000b\u0002%\u0006q\u0011\r\u001c7po&sG/\u001a:skB$X#A1\u0011\u0005!\u0013\u0017BA2J\u0005\u001d\u0011un\u001c7fC:\f!#\u00197m_^Le\u000e^3seV\u0004Ho\u0018\u0013fcR\u0011qI\u001a\u0005\b\u001d>\t\t\u00111\u0001b\u0003=\tG\u000e\\8x\u0013:$XM\u001d:vaR\u0004\u0013a\u0001:v]R\tq)A\u0006ti>\u0004Xj\u001c8ji>\u0014\u0018!E7p]&$xN\u001d+ie\u0016\fGm\u0018\u0013fcR\u0011q)\u001c\u0005\b\u001d\"\t\t\u00111\u0001S\u00039iwN\\5u_J$\u0006N]3bI\u0002\nQa\u001d;beR\f!c^1ji\u001a{'/\u00119qY&\u001c\u0017\r^5p]\u00069\u0012m]=oG6{g.\u001b;pe\u0006\u0003\b\u000f\\5dCRLwN\\\u0001\u0005gR|\u0007\u000f\u0006\u0002Hi\")Q\u000f\u0006a\u0001m\u0006AQ\r_5u\u0007>$W\r\u0005\u0002Io&\u0011\u00010\u0013\u0002\u0004\u0013:$\u0018AF;qI\u0006$X\rR3mK\u001e\fG/[8o)>\\WM\\:\u0015\u0005\u001d[\b\"\u0002?\u0016\u0001\u0004i\u0018A\u0002;pW\u0016t7\u000f\u0005\u0003I}\u0006\u0005\u0011BA@J\u0005\u0015\t%O]1z!\rA\u00151A\u0005\u0004\u0003\u000bI%\u0001\u0002\"zi\u0016\u0004")
public class YarnClientSchedulerBackend
extends YarnSchedulerBackend {
    public final SparkContext org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$sc;
    private Client org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client;
    private MonitorThread monitorThread;

    public Client org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client() {
        return this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client;
    }

    private void client_$eq(Client x$1) {
        this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client = x$1;
    }

    private MonitorThread monitorThread() {
        return this.monitorThread;
    }

    private void monitorThread_$eq(MonitorThread x$1) {
        this.monitorThread = x$1;
    }

    public void start() {
        super.start();
        String driverHost = (String)this.conf().get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_HOST_ADDRESS());
        int driverPort = BoxesRunTime.unboxToInt((Object)this.conf().get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_PORT()));
        String hostport = new StringBuilder(1).append(driverHost).append(":").append(driverPort).toString();
        this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$sc.ui().foreach((Function1 & Serializable)ui -> this.conf().set(package$.MODULE$.DRIVER_APP_UI_ADDRESS(), (Object)ui.webUrl()));
        ArrayBuffer argsArrayBuf = new ArrayBuffer();
        argsArrayBuf.$plus$eq((Object)"--arg", (Object)hostport, (Seq)Nil$.MODULE$);
        this.logDebug((Function0 & Serializable)() -> new StringBuilder(29).append("ClientArguments called with: ").append(argsArrayBuf.mkString(" ")).toString());
        ClientArguments args = new ClientArguments((String[])argsArrayBuf.toArray(ClassTag$.MODULE$.apply(String.class)));
        this.totalExpectedExecutors_$eq(SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber(this.conf(), SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber$default$2()));
        this.client_$eq(new Client(args, this.conf(), this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$sc.env().rpcEnv()));
        this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client().submitApplication();
        this.bindToYarn(this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client().getApplicationId(), (Option<ApplicationAttemptId>)None$.MODULE$);
        this.waitForApplication();
        this.monitorThread_$eq(this.asyncMonitorApplication());
        this.monitorThread().start();
        this.startBindings();
    }

    private void waitForApplication() {
        block10: {
            YarnApplicationState state;
            block9: {
                String string;
                Option diags;
                block8: {
                    long monitorInterval = BoxesRunTime.unboxToLong((Object)this.conf().get(package$.MODULE$.CLIENT_LAUNCH_MONITOR_INTERVAL()));
                    Predef$.MODULE$.assert(this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client() != null && this.appId().isDefined(), (Function0 & Serializable)() -> "Application has not been submitted yet!");
                    Client qual$1 = this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client();
                    boolean x$1 = true;
                    long x$2 = monitorInterval;
                    boolean x$3 = qual$1.monitorApplication$default$2();
                    YarnAppReport yarnAppReport = qual$1.monitorApplication(true, x$3, x$2);
                    if (yarnAppReport == null) {
                        throw new MatchError((Object)yarnAppReport);
                    }
                    YarnApplicationState state2 = yarnAppReport.appState();
                    Option<String> diags2 = yarnAppReport.diagnostics();
                    Tuple2 tuple2 = new Tuple2((Object)state2, diags2);
                    Tuple2 tuple22 = tuple2;
                    state = (YarnApplicationState)tuple22._1();
                    diags = (Option)tuple22._2();
                    YarnApplicationState yarnApplicationState = state;
                    YarnApplicationState yarnApplicationState2 = YarnApplicationState.FINISHED;
                    if (!(yarnApplicationState == null ? yarnApplicationState2 != null : !yarnApplicationState.equals(yarnApplicationState2))) break block8;
                    YarnApplicationState yarnApplicationState3 = state;
                    YarnApplicationState yarnApplicationState4 = YarnApplicationState.FAILED;
                    if (!(yarnApplicationState3 == null ? yarnApplicationState4 != null : !yarnApplicationState3.equals(yarnApplicationState4))) break block8;
                    YarnApplicationState yarnApplicationState5 = state;
                    YarnApplicationState yarnApplicationState6 = YarnApplicationState.KILLED;
                    if (yarnApplicationState5 != null ? !yarnApplicationState5.equals(yarnApplicationState6) : yarnApplicationState6 != null) break block9;
                }
                String genericMessage = "The YARN application has already ended! It might have been killed or the Application Master may have failed to start. Check the YARN application logs for more details.";
                Option option = diags;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String msg = (String)some.value();
                    this.logError((Function0 & Serializable)() -> genericMessage);
                    string = msg;
                } else if (None$.MODULE$.equals(option)) {
                    string = genericMessage;
                } else {
                    throw new MatchError((Object)option);
                }
                String exceptionMsg = string;
                throw new SparkException(exceptionMsg);
            }
            YarnApplicationState yarnApplicationState = state;
            YarnApplicationState yarnApplicationState7 = YarnApplicationState.RUNNING;
            if (yarnApplicationState != null ? !yarnApplicationState.equals(yarnApplicationState7) : yarnApplicationState7 != null) break block10;
            this.logInfo((Function0 & Serializable)() -> new StringBuilder(33).append("Application ").append(this.appId().get()).append(" has started running.").toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private MonitorThread asyncMonitorApplication() {
        void var1_1;
        Predef$.MODULE$.assert(this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client() != null && this.appId().isDefined(), (Function0 & Serializable)() -> "Application has not been submitted yet!");
        MonitorThread t = new MonitorThread();
        t.setName("YARN application state monitor");
        t.setDaemon(true);
        return var1_1;
    }

    public void stop(int exitCode) {
        Predef$.MODULE$.assert(this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client() != null, (Function0 & Serializable)() -> "Attempted to stop this scheduler before starting it!");
        this.yarnSchedulerEndpoint().signalDriverStop(exitCode);
        if (this.monitorThread() != null) {
            this.monitorThread().stopMonitor();
        }
        this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client().reportLauncherState(SparkAppHandle.State.FINISHED);
        super.stop();
        this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client().stop();
        this.logInfo((Function0 & Serializable)() -> "YARN client scheduler backend Stopped");
    }

    public void updateDelegationTokens(byte[] tokens) {
        super.updateDelegationTokens(tokens);
        this.amEndpoint().foreach((Function1 & Serializable)x$3 -> {
            x$3.send((Object)new CoarseGrainedClusterMessages.UpdateDelegationTokens(tokens));
            return BoxedUnit.UNIT;
        });
    }

    public YarnClientSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc) {
        this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$sc = sc;
        super(scheduler, sc);
        this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client = null;
        this.monitorThread = null;
    }

    private class MonitorThread
    extends Thread {
        private boolean allowInterrupt;

        private boolean allowInterrupt() {
            return this.allowInterrupt;
        }

        private void allowInterrupt_$eq(boolean x$1) {
            this.allowInterrupt = x$1;
        }

        @Override
        public void run() {
            try {
                Client qual$1 = this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$MonitorThread$$$outer().org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client();
                boolean x$1 = false;
                boolean x$2 = qual$1.monitorApplication$default$1();
                long x$3 = qual$1.monitorApplication$default$3();
                YarnAppReport yarnAppReport = qual$1.monitorApplication(x$2, false, x$3);
                if (yarnAppReport == null) {
                    throw new MatchError((Object)yarnAppReport);
                }
                FinalApplicationStatus state = yarnAppReport.finalState();
                Option<String> diags = yarnAppReport.diagnostics();
                Tuple2 tuple2 = new Tuple2((Object)state, diags);
                Tuple2 tuple22 = tuple2;
                FinalApplicationStatus state2 = (FinalApplicationStatus)tuple22._1();
                Option diags2 = (Option)tuple22._2();
                this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$MonitorThread$$$outer().logError((Function0 & Serializable)() -> new StringBuilder(49).append(new StringBuilder(54).append("YARN application has exited unexpectedly with state ").append(state2).append("! ").toString()).append("Check the YARN application logs for more details.").toString());
                diags2.foreach((Function1 & Serializable)err -> {
                    MonitorThread.$anonfun$run$2(this, err);
                    return BoxedUnit.UNIT;
                });
                this.allowInterrupt_$eq(false);
                this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$MonitorThread$$$outer().org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$sc.stop();
                FinalApplicationStatus finalApplicationStatus = state2;
                boolean bl = FinalApplicationStatus.FAILED.equals(finalApplicationStatus) ? true : FinalApplicationStatus.KILLED.equals(finalApplicationStatus);
                if (bl && BoxesRunTime.unboxToBoolean((Object)this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$MonitorThread$$$outer().conf().get(package$.MODULE$.AM_CLIENT_MODE_EXIT_ON_ERROR()))) {
                    this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$MonitorThread$$$outer().logWarning((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(41).append("ApplicationMaster finished with status ").append(state2).append(", ").toString()).append("SparkContext should exit with code 1.").toString());
                    System.exit(1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                boolean bl = throwable2 instanceof InterruptedException ? true : throwable2 instanceof InterruptedIOException;
                if (bl) {
                    this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$MonitorThread$$$outer().logInfo((Function0 & Serializable)() -> "Interrupting monitor thread");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
        }

        public void stopMonitor() {
            block0: {
                if (!this.allowInterrupt()) break block0;
                this.interrupt();
            }
        }

        public /* synthetic */ YarnClientSchedulerBackend org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$MonitorThread$$$outer() {
            return YarnClientSchedulerBackend.this;
        }

        public static final /* synthetic */ void $anonfun$run$2(MonitorThread $this, String err) {
            $this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$MonitorThread$$$outer().logError((Function0 & Serializable)() -> new StringBuilder(21).append("Diagnostics message: ").append(err).toString());
        }

        public MonitorThread() {
            if (YarnClientSchedulerBackend.this == null) {
                throw null;
            }
            this.allowInterrupt = true;
        }
    }
}

