/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.mesos;

import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.mesos.MesosClusterDispatcher$;
import org.apache.spark.deploy.mesos.MesosClusterDispatcherArguments;
import org.apache.spark.deploy.mesos.config.package$;
import org.apache.spark.deploy.mesos.ui.MesosClusterUI;
import org.apache.spark.deploy.rest.mesos.MesosRestServer;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Deploy$;
import org.apache.spark.scheduler.cluster.mesos.BlackHoleMesosClusterPersistenceEngineFactory;
import org.apache.spark.scheduler.cluster.mesos.MesosClusterPersistenceEngineFactory;
import org.apache.spark.scheduler.cluster.mesos.MesosClusterScheduler;
import org.apache.spark.scheduler.cluster.mesos.ZookeeperMesosClusterPersistenceEngineFactory;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ub!B\r\u001b\u0001i!\u0003\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\t\u0011]\u0002!\u0011!Q\u0001\naBQ\u0001\u0010\u0001\u0005\u0002uBq!\u0011\u0001C\u0002\u0013%!\t\u0003\u0004O\u0001\u0001\u0006Ia\u0011\u0005\b\u001f\u0002\u0011\r\u0011\"\u0003Q\u0011\u0019A\u0006\u0001)A\u0005#\"9\u0011\f\u0001b\u0001\n\u0013Q\u0006B\u00023\u0001A\u0003%1\fC\u0004b\u0001\t\u0007I\u0011B3\t\r%\u0004\u0001\u0015!\u0003g\u0011\u001dQ\u0007A1A\u0005\n-Daa\u001d\u0001!\u0002\u0013a\u0007b\u0002;\u0001\u0005\u0004%I!\u001e\u0005\u0007y\u0002\u0001\u000b\u0011\u0002<\t\u000fu\u0004!\u0019!C\u0005}\"9\u0011q\u0002\u0001!\u0002\u0013y\bbBA\t\u0001\u0011\u0005\u00111\u0003\u0005\b\u00037\u0001A\u0011AA\n\u0011\u001d\ti\u0002\u0001C\u0001\u0003'9\u0001\"a\b\u001b\u0011\u0003Q\u0012\u0011\u0005\u0004\b3iA\tAGA\u0012\u0011\u0019ad\u0003\"\u0001\u00020!9\u0011\u0011\u0007\f\u0005B\u0005M\"AF'fg>\u001c8\t\\;ti\u0016\u0014H)[:qCR\u001c\u0007.\u001a:\u000b\u0005ma\u0012!B7fg>\u001c(BA\u000f\u001f\u0003\u0019!W\r\u001d7ps*\u0011q\u0004I\u0001\u0006gB\f'o\u001b\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014xmE\u0002\u0001K-\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012a!\u00118z%\u00164\u0007C\u0001\u00170\u001b\u0005i#B\u0001\u0018\u001f\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0019.\u0005\u001daunZ4j]\u001e\fA!\u0019:hg\u000e\u0001\u0001C\u0001\u001b6\u001b\u0005Q\u0012B\u0001\u001c\u001b\u0005}iUm]8t\u00072,8\u000f^3s\t&\u001c\b/\u0019;dQ\u0016\u0014\u0018I]4v[\u0016tGo]\u0001\u0005G>tg\r\u0005\u0002:u5\ta$\u0003\u0002<=\tI1\u000b]1sW\u000e{gNZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007yz\u0004\t\u0005\u00025\u0001!)\u0011g\u0001a\u0001g!)qg\u0001a\u0001q\u0005i\u0001/\u001e2mS\u000e\fE\r\u001a:fgN,\u0012a\u0011\t\u0003\t.s!!R%\u0011\u0005\u0019;S\"A$\u000b\u0005!\u0013\u0014A\u0002\u001fs_>$h(\u0003\u0002KO\u00051\u0001K]3eK\u001aL!\u0001T'\u0003\rM#(/\u001b8h\u0015\tQu%\u0001\bqk\nd\u0017nY!eIJ,7o\u001d\u0011\u0002\u0019I,7m\u001c<feflu\u000eZ3\u0016\u0003E\u0003\"AU,\u000e\u0003MS!\u0001V+\u0002\t1\fgn\u001a\u0006\u0002-\u0006!!.\u0019<b\u0013\ta5+A\u0007sK\u000e|g/\u001a:z\u001b>$W\rI\u0001\u000eK:<\u0017N\\3GC\u000e$xN]=\u0016\u0003m\u0003\"\u0001\u00182\u000e\u0003uS!a\u00070\u000b\u0005}\u0003\u0017aB2mkN$XM\u001d\u0006\u0003Cz\t\u0011b]2iK\u0012,H.\u001a:\n\u0005\rl&\u0001J'fg>\u001c8\t\\;ti\u0016\u0014\b+\u001a:tSN$XM\\2f\u000b:<\u0017N\\3GC\u000e$xN]=\u0002\u001d\u0015tw-\u001b8f\r\u0006\u001cGo\u001c:zAU\ta\r\u0005\u0002]O&\u0011\u0001.\u0018\u0002\u0016\u001b\u0016\u001cxn]\"mkN$XM]*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\u0007g\u0016\u0014h/\u001a:\u0016\u00031\u0004\"!\\9\u000e\u00039T!aG8\u000b\u0005Ad\u0012\u0001\u0002:fgRL!A\u001d8\u0003\u001f5+7o\\:SKN$8+\u001a:wKJ\fqa]3sm\u0016\u0014\b%A\u0003xK\n,\u0016.F\u0001w!\t9(0D\u0001y\u0015\tI($\u0001\u0002vS&\u00111\u0010\u001f\u0002\u000f\u001b\u0016\u001cxn]\"mkN$XM]+J\u0003\u00199XMY+jA\u0005i1\u000f[;uI><h\u000eT1uG\",\u0012a \t\u0005\u0003\u0003\tY!\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003\u0013)\u0016\u0001B;uS2LA!!\u0004\u0002\u0004\tq1i\\;oi\u0012{wO\u001c'bi\u000eD\u0017AD:ikR$wn\u001e8MCR\u001c\u0007\u000eI\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003+\u00012AJA\f\u0013\r\tIb\n\u0002\u0005+:LG/A\u0007bo\u0006LGo\u00155vi\u0012|wO\\\u0001\u0005gR|\u0007/\u0001\fNKN|7o\u00117vgR,'\u000fR5ta\u0006$8\r[3s!\t!dcE\u0003\u0017K-\n)\u0003\u0005\u0003\u0002(\u0005-RBAA\u0015\u0015\r\tIAH\u0005\u0005\u0003[\tIC\u0001\tD_6l\u0017M\u001c3MS:,W\u000b^5mgR\u0011\u0011\u0011E\u0001\u0005[\u0006Lg\u000e\u0006\u0003\u0002\u0016\u0005U\u0002BB\u0019\u0019\u0001\u0004\t9\u0004\u0005\u0003'\u0003s\u0019\u0015bAA\u001eO\t)\u0011I\u001d:bs\u0002")
public class MesosClusterDispatcher
implements Logging {
    private final MesosClusterDispatcherArguments args;
    private final SparkConf conf;
    private final String publicAddress;
    private final String recoveryMode;
    private final MesosClusterPersistenceEngineFactory engineFactory;
    private final MesosClusterScheduler scheduler;
    private final MesosRestServer server;
    private final MesosClusterUI webUi;
    private final CountDownLatch shutdownLatch;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void main(String[] args) {
        MesosClusterDispatcher$.MODULE$.main(args);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String publicAddress() {
        return this.publicAddress;
    }

    private String recoveryMode() {
        return this.recoveryMode;
    }

    private MesosClusterPersistenceEngineFactory engineFactory() {
        return this.engineFactory;
    }

    private MesosClusterScheduler scheduler() {
        return this.scheduler;
    }

    private MesosRestServer server() {
        return this.server;
    }

    private MesosClusterUI webUi() {
        return this.webUi;
    }

    private CountDownLatch shutdownLatch() {
        return this.shutdownLatch;
    }

    public void start() {
        this.webUi().bind();
        this.scheduler().frameworkUrl_$eq((String)((Option)this.conf.get(package$.MODULE$.DISPATCHER_WEBUI_URL())).getOrElse((Function0 & Serializable)() -> this.webUi().activeWebUiUrl()));
        this.scheduler().start();
        this.server().start();
    }

    public void awaitShutdown() {
        this.shutdownLatch().await();
    }

    public void stop() {
        this.webUi().stop();
        this.server().stop();
        this.scheduler().stop();
        this.shutdownLatch().countDown();
    }

    public MesosClusterDispatcher(MesosClusterDispatcherArguments args, SparkConf conf) {
        MesosClusterPersistenceEngineFactory mesosClusterPersistenceEngineFactory;
        block4: {
            this.args = args;
            this.conf = conf;
            Logging.$init$((Logging)this);
            String authKey = SecurityManager$.MODULE$.SPARK_AUTH_SECRET_CONF();
            Predef$.MODULE$.require(conf.getOption(authKey).isEmpty(), (Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(76).append("The MesosClusterDispatcher does not support authentication via ").append(authKey).append(".  It is not ").toString()).append("currently possible to run jobs in cluster mode with authentication on.").toString());
            this.publicAddress = (String)Option$.MODULE$.apply((Object)conf.getenv("SPARK_PUBLIC_DNS")).getOrElse((Function0 & Serializable)() -> $this.args.host());
            this.recoveryMode = ((String)conf.get(Deploy$.MODULE$.RECOVERY_MODE())).toUpperCase(Locale.ROOT);
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Recovery mode in Mesos dispatcher set to: ").append(this.recoveryMode()).toString());
            String string = this.recoveryMode();
            switch (string == null ? 0 : string.hashCode()) {
                case 2402104: {
                    if (!"NONE".equals(string)) break;
                    mesosClusterPersistenceEngineFactory = new BlackHoleMesosClusterPersistenceEngineFactory();
                    break block4;
                }
                case 92309292: {
                    if (!"ZOOKEEPER".equals(string)) break;
                    mesosClusterPersistenceEngineFactory = new ZookeeperMesosClusterPersistenceEngineFactory(conf);
                    break block4;
                }
            }
            throw new IllegalArgumentException(new StringBuilder(27).append("Unsupported recovery mode: ").append(this.recoveryMode()).toString());
        }
        this.engineFactory = mesosClusterPersistenceEngineFactory;
        this.scheduler = new MesosClusterScheduler(this.engineFactory(), conf);
        this.server = new MesosRestServer(args.host(), args.port(), conf, this.scheduler());
        this.webUi = new MesosClusterUI(new SecurityManager(conf, SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), args.webUiPort(), conf, this.publicAddress(), this.scheduler());
        this.shutdownLatch = new CountDownLatch(1);
    }
}

