/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import breeze.stats.distributions.Rand;
import breeze.stats.distributions.StudentsT;
import java.io.Serializable;
import org.apache.spark.ml.regression.LinearRegressionModel;
import org.apache.spark.mllib.evaluation.RegressionMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\u0005%e\u0001\u0002\u0013&\u0001AB\u0001b\u0011\u0001\u0003\u0006\u0004%\t\u0001\u0012\u0005\t+\u0002\u0011\t\u0011)A\u0005\u000b\"A!\f\u0001BC\u0002\u0013\u00051\f\u0003\u0005e\u0001\t\u0005\t\u0015!\u0003]\u0011!)\u0007A!b\u0001\n\u0003Y\u0006\u0002\u00034\u0001\u0005\u0003\u0005\u000b\u0011\u0002/\t\u0011\u001d\u0004!Q1A\u0005\u0002mC\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\tS\u0002\u0011)\u0019!C\u0005U\"Aq\u000e\u0001B\u0001B\u0003%1\u000e\u0003\u0005q\u0001\t\u0015\r\u0011\"\u0003r\u0011!A\bA!A!\u0002\u0013\u0011\bBB=\u0001\t\u0003)#\u0010C\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0003\u0002\b!A\u0011\u0011\u0004\u0001!\u0002\u0013\tI\u0001C\u0005\u0002\u001e\u0001\u0011\r\u0011\"\u0001\u0002 !9\u00111\u0007\u0001!\u0002\u0013)\b\"CA\u001c\u0001\t\u0007I\u0011AA\u0010\u0011\u001d\tY\u0004\u0001Q\u0001\nUD\u0011\"a\u0010\u0001\u0005\u0004%\t!a\b\t\u000f\u0005\r\u0003\u0001)A\u0005k\"I\u0011q\t\u0001C\u0002\u0013\u0005\u0011q\u0004\u0005\b\u0003\u0017\u0002\u0001\u0015!\u0003v\u0011%\ty\u0005\u0001b\u0001\n\u0003\ty\u0002C\u0004\u0002T\u0001\u0001\u000b\u0011B;\t\u0013\u0005]\u0003A1A\u0005\u0002\u0005}\u0001bBA0\u0001\u0001\u0006I!\u001e\u0005\n\u0003G\u0002\u0001R1A\u0005\u0002\u0011C!\"!\u001b\u0001\u0011\u000b\u0007I\u0011AA6\u0011%\t\u0019\b\u0001b\u0001\n\u0003\tY\u0007\u0003\u0005\u0002|\u0001\u0001\u000b\u0011BA7\u0011%\ty\b\u0001EC\u0002\u0013\u0005\u0011\u000fC\u0005\u0002\u0002\u0002A)\u0019!C\u0001c\"I\u00111\u0011\u0001\t\u0006\u0004%\t!\u001d\u0005\n\u0003\u000b\u0003\u0001R1A\u0005\u0002E\u0014q\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8Tk6l\u0017M]=\u000b\u0005\u0019:\u0013A\u0003:fOJ,7o]5p]*\u0011\u0001&K\u0001\u0003[2T!AK\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u00051j\u0013AB1qC\u000eDWMC\u0001/\u0003\ry'oZ\u0002\u0001'\r\u0001\u0011g\u000e\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005a\u0002eBA\u001d?\u001d\tQT(D\u0001<\u0015\tat&\u0001\u0004=e>|GOP\u0005\u0002i%\u0011qhM\u0001\ba\u0006\u001c7.Y4f\u0013\t\t%I\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002@g\u0005Y\u0001O]3eS\u000e$\u0018n\u001c8t+\u0005)\u0005C\u0001$S\u001d\t9\u0005K\u0004\u0002I\u001d:\u0011\u0011*\u0014\b\u0003\u00152s!AO&\n\u00039J!\u0001L\u0017\n\u0005)Z\u0013BA(*\u0003\r\u0019\u0018\u000f\\\u0005\u0003\u007fES!aT\u0015\n\u0005M#&!\u0003#bi\u00064%/Y7f\u0015\ty\u0014+\u0001\u0007qe\u0016$\u0017n\u0019;j_:\u001c\b\u0005\u000b\u0002\u0003/B\u0011!\u0007W\u0005\u00033N\u0012\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u001bA\u0014X\rZ5di&|gnQ8m+\u0005a\u0006CA/b\u001d\tqv\f\u0005\u0002;g%\u0011\u0001mM\u0001\u0007!J,G-\u001a4\n\u0005\t\u001c'AB*ue&twM\u0003\u0002ag\u0005q\u0001O]3eS\u000e$\u0018n\u001c8D_2\u0004\u0013\u0001\u00037bE\u0016d7i\u001c7\u0002\u00131\f'-\u001a7D_2\u0004\u0013a\u00034fCR,(/Z:D_2\fABZ3biV\u0014Xm]\"pY\u0002\nA\u0002\u001d:jm\u0006$X-T8eK2,\u0012a\u001b\t\u0003Y6l\u0011!J\u0005\u0003]\u0016\u0012Q\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8N_\u0012,G.A\u0007qe&4\u0018\r^3N_\u0012,G\u000eI\u0001\fI&\fw-\u00138w\u0003R<\u0016)F\u0001s!\r\u00114/^\u0005\u0003iN\u0012Q!\u0011:sCf\u0004\"A\r<\n\u0005]\u001c$A\u0002#pk\ndW-\u0001\u0007eS\u0006<\u0017J\u001c<Bi^\u000b\u0005%\u0001\u0004=S:LGO\u0010\u000b\nwrlhp`A\u0001\u0003\u0007\u0001\"\u0001\u001c\u0001\t\u000b\rk\u0001\u0019A#\t\u000bik\u0001\u0019\u0001/\t\u000b\u0015l\u0001\u0019\u0001/\t\u000b\u001dl\u0001\u0019\u0001/\t\u000b%l\u0001\u0019A6\t\u000bAl\u0001\u0019\u0001:\u0002\u000f5,GO]5dgV\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\t)\"\u0004\u0002\u0002\u000e)!\u0011qBA\t\u0003))g/\u00197vCRLwN\u001c\u0006\u0004\u0003'I\u0013!B7mY&\u0014\u0017\u0002BA\f\u0003\u001b\u0011\u0011CU3he\u0016\u001c8/[8o\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0003FA\bX\u0003E)\u0007\u0010\u001d7bS:,GMV1sS\u0006t7-Z\u000b\u0002k\"*\u0001#a\t\u00020A!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*%\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti#a\n\u0003\u000bMKgnY3\"\u0005\u0005E\u0012!B\u0019/k9\u0002\u0014AE3ya2\f\u0017N\\3e-\u0006\u0014\u0018.\u00198dK\u0002BS!EA\u0012\u0003_\t\u0011#\\3b]\u0006\u00137o\u001c7vi\u0016,%O]8sQ\u0015\u0011\u00121EA\u0018\u0003IiW-\u00198BEN|G.\u001e;f\u000bJ\u0014xN\u001d\u0011)\u000bM\t\u0019#a\f\u0002!5,\u0017M\\*rk\u0006\u0014X\rZ#se>\u0014\b&\u0002\u000b\u0002$\u0005=\u0012!E7fC:\u001c\u0016/^1sK\u0012,%O]8sA!*Q#a\t\u00020\u0005!\"o\\8u\u001b\u0016\fgnU9vCJ,G-\u0012:s_JDSAFA\u0012\u0003_\tQC]8pi6+\u0017M\\*rk\u0006\u0014X\rZ#se>\u0014\b\u0005K\u0003\u0018\u0003G\ty#\u0001\u0002se!*\u0001$a\t\u00020\u0005\u0019!O\r\u0011)\u000be\t\u0019#a\f\u0002\u000bI\u0014\u0014\r\u001a6)\u000bi\t\u0019#a\u0017\"\u0005\u0005u\u0013!\u0002\u001a/g9\u0002\u0014A\u0002:3C\u0012T\u0007\u0005K\u0003\u001c\u0003G\tY&A\u0005sKNLG-^1mg\"\u0012Ad\u0016\u0015\u00069\u0005\r\u0012qF\u0001\r]Vl\u0017J\\:uC:\u001cWm]\u000b\u0003\u0003[\u00022AMA8\u0013\r\t\th\r\u0002\u0005\u0019>tw-\u0001\teK\u001e\u0014X-Z:PM\u001a\u0013X-\u001a3p[\"*a$a\t\u0002x\u0005\u0012\u0011\u0011P\u0001\u0006e9\u0012d\u0006M\u0001\u0012I\u0016<'/Z3t\u001f\u001a4%/Z3e_6\u0004\u0003&B\u0010\u0002$\u0005]\u0014!\u00053fm&\fgnY3SKNLG-^1mg\u0006I2m\\3gM&\u001c\u0017.\u001a8u'R\fg\u000eZ1sI\u0016\u0013(o\u001c:t\u0003\u001d!h+\u00197vKN\fq\u0001\u001d,bYV,7\u000fK\u0003\u0001\u0003G\ty\u0003")
public class LinearRegressionSummary
implements Serializable {
    private transient Dataset<Row> residuals;
    private long numInstances;
    private double[] devianceResiduals;
    private double[] coefficientStandardErrors;
    private double[] tValues;
    private double[] pValues;
    private final transient Dataset<Row> predictions;
    private final String predictionCol;
    private final String labelCol;
    private final String featuresCol;
    private final LinearRegressionModel privateModel;
    private final double[] diagInvAtWA;
    private final transient RegressionMetrics metrics;
    private final double explainedVariance;
    private final double meanAbsoluteError;
    private final double meanSquaredError;
    private final double rootMeanSquaredError;
    private final double r2;
    private final double r2adj;
    private final long degreesOfFreedom;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public Dataset<Row> predictions() {
        return this.predictions;
    }

    public String predictionCol() {
        return this.predictionCol;
    }

    public String labelCol() {
        return this.labelCol;
    }

    public String featuresCol() {
        return this.featuresCol;
    }

    private LinearRegressionModel privateModel() {
        return this.privateModel;
    }

    private double[] diagInvAtWA() {
        return this.diagInvAtWA;
    }

    private RegressionMetrics metrics() {
        return this.metrics;
    }

    public double explainedVariance() {
        return this.explainedVariance;
    }

    public double meanAbsoluteError() {
        return this.meanAbsoluteError;
    }

    public double meanSquaredError() {
        return this.meanSquaredError;
    }

    public double rootMeanSquaredError() {
        return this.rootMeanSquaredError;
    }

    public double r2() {
        return this.r2;
    }

    public double r2adj() {
        return this.r2adj;
    }

    private Dataset<Row> residuals$lzycompute() {
        LinearRegressionSummary linearRegressionSummary = this;
        synchronized (linearRegressionSummary) {
            if (!this.bitmap$trans$0) {
                UserDefinedFunction t = functions$.MODULE$.udf((Function2)(JFunction2.mcDDD.sp & Serializable)(pred, label) -> label - pred, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
                this.residuals = this.predictions().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{t.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.predictionCol()), functions$.MODULE$.col(this.labelCol())})).as("residuals")}));
                this.bitmap$trans$0 = true;
            }
        }
        return this.residuals;
    }

    public Dataset<Row> residuals() {
        return !this.bitmap$trans$0 ? this.residuals$lzycompute() : this.residuals;
    }

    private long numInstances$lzycompute() {
        LinearRegressionSummary linearRegressionSummary = this;
        synchronized (linearRegressionSummary) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.numInstances = this.metrics().count();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.numInstances;
    }

    public long numInstances() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.numInstances$lzycompute() : this.numInstances;
    }

    public long degreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    private double[] devianceResiduals$lzycompute() {
        LinearRegressionSummary linearRegressionSummary = this;
        synchronized (linearRegressionSummary) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Column weighted = !this.privateModel().isDefined(this.privateModel().weightCol()) || this.privateModel().getWeightCol().isEmpty() ? functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0)) : functions$.MODULE$.sqrt(functions$.MODULE$.col(this.privateModel().getWeightCol()));
                Row dr = (Row)this.predictions().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.privateModel().getLabelCol()).minus((Object)functions$.MODULE$.col(this.privateModel().getPredictionCol())).multiply((Object)weighted).as("weightedResiduals")})).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.min(functions$.MODULE$.col("weightedResiduals")).as("min"), functions$.MODULE$.max(functions$.MODULE$.col("weightedResiduals")).as("max")})).first();
                this.devianceResiduals = new double[]{dr.getDouble(0), dr.getDouble(1)};
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.devianceResiduals;
    }

    public double[] devianceResiduals() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.devianceResiduals$lzycompute() : this.devianceResiduals;
    }

    private double[] coefficientStandardErrors$lzycompute() {
        LinearRegressionSummary linearRegressionSummary = this;
        synchronized (linearRegressionSummary) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                double d;
                if (this.diagInvAtWA().length == 1 && this.diagInvAtWA()[0] == 0.0) {
                    throw new UnsupportedOperationException("No Std. Error of coefficients available for this LinearRegressionModel");
                }
                if (!this.privateModel().isDefined(this.privateModel().weightCol()) || this.privateModel().getWeightCol().isEmpty()) {
                    d = this.meanSquaredError() * (double)this.numInstances();
                } else {
                    UserDefinedFunction t = functions$.MODULE$.udf((Function3 & Serializable)(pred, label, weight) -> BoxesRunTime.boxToDouble((double)LinearRegressionSummary.$anonfun$coefficientStandardErrors$1(BoxesRunTime.unboxToDouble((Object)pred), BoxesRunTime.unboxToDouble((Object)label), BoxesRunTime.unboxToDouble((Object)weight))), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
                    d = ((Row)this.predictions().select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{t.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.privateModel().getPredictionCol()), functions$.MODULE$.col(this.privateModel().getLabelCol()), functions$.MODULE$.col(this.privateModel().getWeightCol())})).as("wse")})).agg(functions$.MODULE$.sum(functions$.MODULE$.col("wse")), (Seq)Nil$.MODULE$).first()).getDouble(0);
                }
                double rss = d;
                double sigma2 = rss / (double)this.degreesOfFreedom();
                this.coefficientStandardErrors = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(this.diagInvAtWA()), (Function1)(JFunction1.mcDD.sp & Serializable)x$12 -> x$12 * sigma2, (ClassTag)ClassTag$.MODULE$.Double())), (Function1)(JFunction1.mcDD.sp & Serializable)x -> scala.math.package$.MODULE$.sqrt(x), (ClassTag)ClassTag$.MODULE$.Double());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.coefficientStandardErrors;
    }

    public double[] coefficientStandardErrors() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.coefficientStandardErrors$lzycompute() : this.coefficientStandardErrors;
    }

    private double[] tValues$lzycompute() {
        LinearRegressionSummary linearRegressionSummary = this;
        synchronized (linearRegressionSummary) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                if (this.diagInvAtWA().length == 1 && this.diagInvAtWA()[0] == 0.0) {
                    throw new UnsupportedOperationException("No t-statistic available for this LinearRegressionModel");
                }
                double[] estimate = this.privateModel().getFitIntercept() ? (double[])Array$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new double[][]{this.privateModel().coefficients().toArray(), {this.privateModel().intercept()}}), (ClassTag)ClassTag$.MODULE$.Double()) : this.privateModel().coefficients().toArray();
                this.tValues = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.doubleArrayOps(estimate), (IterableOnce)Predef$.MODULE$.wrapDoubleArray(this.coefficientStandardErrors()))), (Function1 & Serializable)x -> BoxesRunTime.boxToDouble((double)LinearRegressionSummary.$anonfun$tValues$1(x)), (ClassTag)ClassTag$.MODULE$.Double());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.tValues;
    }

    public double[] tValues() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.tValues$lzycompute() : this.tValues;
    }

    private double[] pValues$lzycompute() {
        LinearRegressionSummary linearRegressionSummary = this;
        synchronized (linearRegressionSummary) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                if (this.diagInvAtWA().length == 1 && this.diagInvAtWA()[0] == 0.0) {
                    throw new UnsupportedOperationException("No p-value available for this LinearRegressionModel");
                }
                this.pValues = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(this.tValues()), (Function1)(JFunction1.mcDD.sp & Serializable)x -> 2.0 * (1.0 - new StudentsT((double)this.degreesOfFreedom(), Rand.FixedSeed$.MODULE$.randBasis()).cdf(scala.math.package$.MODULE$.abs(x))), (ClassTag)ClassTag$.MODULE$.Double());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.pValues;
    }

    public double[] pValues() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.pValues$lzycompute() : this.pValues;
    }

    public static final /* synthetic */ double $anonfun$coefficientStandardErrors$1(double pred, double label, double weight) {
        return scala.math.package$.MODULE$.pow(label - pred, 2.0) * weight;
    }

    public static final /* synthetic */ double $anonfun$tValues$1(Tuple2 x) {
        return x._1$mcD$sp() / x._2$mcD$sp();
    }

    public LinearRegressionSummary(Dataset<Row> predictions, String predictionCol, String labelCol, String featuresCol, LinearRegressionModel privateModel, double[] diagInvAtWA) {
        this.predictions = predictions;
        this.predictionCol = predictionCol;
        this.labelCol = labelCol;
        this.featuresCol = featuresCol;
        this.privateModel = privateModel;
        this.diagInvAtWA = diagInvAtWA;
        Column weightCol = !privateModel.isDefined(privateModel.weightCol()) || privateModel.getWeightCol().isEmpty() ? functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0)) : functions$.MODULE$.col(privateModel.getWeightCol()).cast((DataType)DoubleType$.MODULE$);
        this.metrics = new RegressionMetrics((RDD<? extends Product>)predictions.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(predictionCol), functions$.MODULE$.col(labelCol).cast((DataType)DoubleType$.MODULE$), weightCol})).rdd().map((Function1 & Serializable)x0$1 -> {
            double d;
            double d2;
            Object weight;
            block3: {
                Row row;
                block2: {
                    Some some;
                    row = x0$1;
                    if (row == null || (some = Row$.MODULE$.unapplySeq(row)).isEmpty() || some.get() == null || ((SeqOps)some.get()).lengthCompare(3) != 0) break block2;
                    Object pred = ((SeqOps)some.get()).apply(0);
                    Object label = ((SeqOps)some.get()).apply(1);
                    weight = ((SeqOps)some.get()).apply(2);
                    if (!(pred instanceof Double)) break block2;
                    d2 = BoxesRunTime.unboxToDouble((Object)pred);
                    if (!(label instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)label);
                    if (weight instanceof Double) break block3;
                }
                throw new MatchError((Object)row);
            }
            double d3 = BoxesRunTime.unboxToDouble((Object)weight);
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)d2), (Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d3));
            return tuple3;
        }, ClassTag$.MODULE$.apply(Product.class)), !privateModel.getFitIntercept());
        this.explainedVariance = this.metrics().explainedVariance();
        this.meanAbsoluteError = this.metrics().meanAbsoluteError();
        this.meanSquaredError = this.metrics().meanSquaredError();
        this.rootMeanSquaredError = this.metrics().rootMeanSquaredError();
        this.r2 = this.metrics().r2();
        int interceptDOF = privateModel.getFitIntercept() ? 1 : 0;
        this.r2adj = 1.0 - (1.0 - this.r2()) * (double)(this.numInstances() - (long)interceptDOF) / (double)(this.numInstances() - (long)privateModel.coefficients().size() - (long)interceptDOF);
        this.degreesOfFreedom = privateModel.getFitIntercept() ? this.numInstances() - (long)privateModel.coefficients().size() - 1L : this.numInstances() - (long)privateModel.coefficients().size();
    }
}

