/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.starter.login.models;

import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.auth.core.spi.AuthenticationHandler;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;

@Model(adaptables={SlingJakartaHttpServletRequest.class})
public class Login {
    @SlingObject
    protected SlingJakartaHttpServletRequest request;

    public String getResource() {
        return this.request.getParameter("resource");
    }

    public String getReason() {
        String reason = null;
        String jReasonCode = this.request.getParameter("j_reason_code");
        if (jReasonCode != null && !jReasonCode.isEmpty()) {
            AuthenticationHandler.FAILURE_REASON_CODES reasonCode;
            try {
                reasonCode = AuthenticationHandler.FAILURE_REASON_CODES.valueOf((String)jReasonCode);
            }
            catch (IllegalArgumentException iae) {
                reasonCode = AuthenticationHandler.FAILURE_REASON_CODES.UNKNOWN;
            }
            switch (reasonCode) {
                case ACCOUNT_LOCKED: {
                    reason = "Account is locked";
                    break;
                }
                case ACCOUNT_NOT_FOUND: {
                    reason = "Account was not found";
                    break;
                }
                case PASSWORD_EXPIRED: {
                    reason = "Password expired";
                    break;
                }
                case PASSWORD_EXPIRED_AND_NEW_PASSWORD_IN_HISTORY: {
                    reason = "Password expired and new password found in password history";
                    break;
                }
                default: {
                    reason = "User name and password do not match";
                }
            }
        }
        return reason;
    }
}

