/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.testing.jcr;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.naming.NamingException;
import junit.framework.TestCase;
import org.apache.sling.commons.testing.jcr.RepositoryProvider;
import org.apache.sling.jcr.api.SlingRepository;

public class RepositoryTestBase
extends TestCase {
    protected Node testRoot;
    protected Session session;
    private int counter;

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.session != null) {
            this.session.logout();
        }
    }

    protected Session getSession() throws RepositoryException, NamingException {
        if (this.session == null) {
            this.session = this.getRepository().loginAdministrative(null);
        }
        return this.session;
    }

    protected Node getTestRootNode() throws RepositoryException, NamingException {
        if (this.testRoot == null) {
            Node root = this.getSession().getRootNode();
            Node classRoot = root.addNode(((Object)((Object)this)).getClass().getSimpleName());
            this.testRoot = classRoot.addNode(System.currentTimeMillis() + "_" + ++this.counter);
        }
        return this.testRoot;
    }

    protected SlingRepository getRepository() throws RepositoryException, NamingException {
        return RepositoryProvider.instance().getRepository();
    }
}

