/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.nacos.v2;

import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.common.remote.client.RpcClient;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.plugin.nacos.v2.NacosRequestOpt;

public class ClientHandleServerRequestInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        String peer = this.getPeer(objInst);
        NacosRequestOpt.getHandler(allArguments[0].getClass()).ifPresent(o -> o.buildRequestSpanInfo((Request)allArguments[0], peer));
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (ContextManager.isActive()) {
            ContextManager.stopSpan();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        if (ContextManager.isActive()) {
            ContextManager.activeSpan().log(t);
        }
    }

    private String getPeer(EnhancedInstance objInst) {
        Object dynamicField = objInst.getSkyWalkingDynamicField();
        if (dynamicField instanceof RpcClient.ServerInfo) {
            RpcClient.ServerInfo serverInfo = (RpcClient.ServerInfo)dynamicField;
            return serverInfo.getAddress();
        }
        return "no peer";
    }
}

