/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.esjob;

import com.dangdang.ddframe.job.executor.ShardingContexts;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.AbstractTag;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class JobExecutorInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final AbstractTag<String> TAG_ITEM = Tags.ofKey((String)"item");
    private static final AbstractTag<String> TAG_TASK_ID = Tags.ofKey((String)"taskId");
    private static final AbstractTag<String> TAG_SHARDING_TOTAL_COUNT = Tags.ofKey((String)"shardingTotalCount");
    private static final AbstractTag<String> TAG_SHARDING_ITEM_PARAMETERS = Tags.ofKey((String)"shardingItemParameters");

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        ShardingContexts shardingContexts = (ShardingContexts)allArguments[0];
        Integer item = (Integer)allArguments[1];
        String operateName = ComponentsDefine.ELASTIC_JOB.getName() + "/" + shardingContexts.getJobName();
        AbstractSpan span = ContextManager.createLocalSpan((String)operateName);
        span.setComponent((Component)ComponentsDefine.ELASTIC_JOB);
        Tags.LOGIC_ENDPOINT.set(span, "{\"logic-span\":true}");
        span.tag(TAG_ITEM, item == null ? "" : String.valueOf(item));
        span.tag(TAG_TASK_ID, shardingContexts.getTaskId());
        span.tag(TAG_SHARDING_TOTAL_COUNT, Integer.toString(shardingContexts.getShardingTotalCount()));
        span.tag(TAG_SHARDING_ITEM_PARAMETERS, shardingContexts.getShardingItemParameters() == null ? "" : shardingContexts.getShardingItemParameters().toString());
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

