/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jedis.v4;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Optional;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.StringTag;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.jedis.v4.ConnectionInformation;
import org.apache.skywalking.apm.plugin.jedis.v4.JedisPluginConfig;
import org.apache.skywalking.apm.util.StringUtil;
import redis.clients.jedis.args.Rawable;
import redis.clients.jedis.args.RawableFactory;

public abstract class AbstractConnectionInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final String UNKNOWN = "unknown";
    private static final String CACHE_TYPE = "Redis";
    private static final StringTag TAG_ARGS = new StringTag("actual_target");

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        Iterator<Rawable> iterator = this.getCommands(allArguments);
        String protocolCommand = null;
        if (iterator.hasNext()) {
            protocolCommand = iterator.next().toString();
        }
        String cmd = protocolCommand == null ? UNKNOWN : protocolCommand.toLowerCase();
        ConnectionInformation connectionData = (ConnectionInformation)objInst.getSkyWalkingDynamicField();
        String peer = StringUtil.isBlank((String)connectionData.getClusterNodes()) ? connectionData.getActualTarget() : connectionData.getClusterNodes();
        AbstractSpan span = ContextManager.createExitSpan((String)("Jedis/" + cmd), (String)peer);
        span.setComponent((Component)ComponentsDefine.JEDIS);
        this.readKeyIfNecessary(iterator).ifPresent(key -> Tags.CACHE_KEY.set(span, key));
        Tags.CACHE_CMD.set(span, cmd);
        Tags.CACHE_TYPE.set(span, CACHE_TYPE);
        TAG_ARGS.set(span, connectionData.getActualTarget());
        this.parseOperation(cmd).ifPresent(op -> Tags.CACHE_OP.set(span, op));
        SpanLayer.asCache((AbstractSpan)span);
    }

    private Optional<String> readKeyIfNecessary(Iterator<Rawable> iterator) {
        Rawable rawable;
        if (JedisPluginConfig.Plugin.Jedis.TRACE_REDIS_PARAMETERS && iterator.hasNext() && (rawable = iterator.next()) instanceof RawableFactory.RawString) {
            String cut = StringUtil.cut((String)new String(rawable.getRaw()), (int)JedisPluginConfig.Plugin.Jedis.REDIS_PARAMETER_MAX_LENGTH);
            return Optional.of(cut);
        }
        return Optional.empty();
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        AbstractSpan span = ContextManager.activeSpan().log(t).errorOccurred();
        ContextManager.stopSpan((AbstractSpan)span);
    }

    private Optional<String> parseOperation(String cmd) {
        if (JedisPluginConfig.Plugin.Jedis.OPERATION_MAPPING_READ.contains(cmd)) {
            return Optional.of("read");
        }
        if (JedisPluginConfig.Plugin.Jedis.OPERATION_MAPPING_WRITE.contains(cmd)) {
            return Optional.of("write");
        }
        return Optional.empty();
    }

    protected abstract Iterator<Rawable> getCommands(Object[] var1);
}

