/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.hystrix.v1;

import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixObservableCollapser;
import com.netflix.hystrix.HystrixObservableCommand;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.plugin.hystrix.v1.EnhanceRequireObjectCache;

public class HystrixCommandConstructorInterceptor
implements InstanceConstructorInterceptor {
    public static final String OPERATION_NAME_PREFIX = "Hystrix/";

    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) {
        String commandIdentify = "";
        if (HystrixCommand.class.isAssignableFrom(objInst.getClass())) {
            HystrixCommand hystrixCommand = (HystrixCommand)objInst;
            commandIdentify = hystrixCommand.getCommandKey().name();
        } else if (HystrixCollapser.class.isAssignableFrom(objInst.getClass())) {
            HystrixCollapser hystrixCollapser = (HystrixCollapser)objInst;
            commandIdentify = hystrixCollapser.getCollapserKey().name();
        } else if (HystrixObservableCollapser.class.isAssignableFrom(objInst.getClass())) {
            HystrixObservableCollapser hystrixObservableCollapser = (HystrixObservableCollapser)objInst;
            commandIdentify = hystrixObservableCollapser.getCollapserKey().name();
        } else if (HystrixObservableCommand.class.isAssignableFrom(objInst.getClass())) {
            HystrixObservableCommand hystrixObservableCommand = (HystrixObservableCommand)objInst;
            commandIdentify = hystrixObservableCommand.getCommandKey().name();
        }
        objInst.setSkyWalkingDynamicField((Object)new EnhanceRequireObjectCache(OPERATION_NAME_PREFIX + commandIdentify));
    }
}

