/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.guava.cache;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.guava.cache.GuavaCacheOperationConvertor;

public class GuavaCacheAllInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        String methodName = method.getName();
        AbstractSpan span = ContextManager.createLocalSpan((String)("GuavaCache/" + methodName));
        span.setComponent((Component)ComponentsDefine.GUAVA_CACHE);
        SpanLayer.asCache((AbstractSpan)span);
        Tags.CACHE_TYPE.set(span, "GuavaCache");
        Tags.CACHE_CMD.set(span, methodName);
        if (allArguments != null && allArguments.length > 0 && allArguments[0] instanceof String) {
            Tags.CACHE_KEY.set(span, allArguments[0].toString());
        }
        GuavaCacheOperationConvertor.parseOperation(methodName).ifPresent(op -> Tags.CACHE_OP.set(span, op));
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

