/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.io.grpc.netty;

import org.apache.skywalking.apm.dependencies.com.google.common.base.Preconditions;
import org.apache.skywalking.apm.dependencies.io.grpc.ChannelCredentials;
import org.apache.skywalking.apm.dependencies.io.grpc.ExperimentalApi;
import org.apache.skywalking.apm.dependencies.io.grpc.netty.GrpcSslContexts;
import org.apache.skywalking.apm.dependencies.io.grpc.netty.NettyChannelCredentials;
import org.apache.skywalking.apm.dependencies.io.grpc.netty.ProtocolNegotiators;
import org.apache.skywalking.apm.dependencies.io.netty.handler.ssl.SslContext;

@ExperimentalApi(value="There is no plan to make this API stable, given transport API instability")
public final class NettySslContextChannelCredentials {
    private NettySslContextChannelCredentials() {
    }

    public static ChannelCredentials create(SslContext sslContext) {
        Preconditions.checkArgument(sslContext.isClient(), "Server SSL context can not be used for client channel");
        GrpcSslContexts.ensureAlpnAndH2Enabled(sslContext.applicationProtocolNegotiator());
        return NettyChannelCredentials.create(ProtocolNegotiators.tlsClientFactory(sslContext));
    }
}

