/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.util;

import java.lang.reflect.Method;

public class MethodUtil {
    public static String generateOperationName(Method method) {
        StringBuilder operationName = new StringBuilder(method.getDeclaringClass().getName() + "." + method.getName() + "(");
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            operationName.append(parameterTypes[i].getName());
            if (i >= parameterTypes.length - 1) continue;
            operationName.append(",");
        }
        operationName.append(")");
        return operationName.toString();
    }

    public static boolean isMethodExist(ClassLoader classLoader, String className, String methodName, String ... parameterTypes) {
        try {
            Method[] declaredMethods;
            Class<?> clazz = Class.forName(className, true, classLoader);
            if (parameterTypes == null || parameterTypes.length == 0) {
                clazz.getDeclaredMethod(methodName, new Class[0]);
                return true;
            }
            for (Method declaredMethod : declaredMethods = clazz.getDeclaredMethods()) {
                if (!declaredMethod.getName().equals(methodName) || !MethodUtil.isParameterTypesEquals(declaredMethod.getParameterTypes(), parameterTypes)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean isParameterTypesEquals(Class<?>[] parameterTypeClazz, String[] parameterTypeString) {
        if (parameterTypeClazz == null) {
            return false;
        }
        if (parameterTypeClazz.length != parameterTypeString.length) {
            return false;
        }
        for (int i = 0; i < parameterTypeClazz.length; ++i) {
            if (parameterTypeClazz[i].getName().equals(parameterTypeString[i])) continue;
            return false;
        }
        return true;
    }
}

