/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.match;

import java.util.Objects;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.annotation.AnnotationList;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.annotation.AnnotationSource;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.method.MethodDescription;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.method.MethodList;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.method.ParameterDescription;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.method.ParameterList;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.type.TypeDefinition;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.type.TypeDescription;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.type.TypeList;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.CollectionItemMatcher;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.ElementMatcher;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.ElementMatchers;

@HashCodeAndEqualsPlugin.Enhance
public class MethodInheritanceAnnotationMatcher<T extends MethodDescription>
extends ElementMatcher.Junction.AbstractBase<T> {
    private final ElementMatcher<? super AnnotationList> matcher;

    public MethodInheritanceAnnotationMatcher(ElementMatcher<? super AnnotationList> matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean matches(T target) {
        if (this.matcher.matches(target.getDeclaredAnnotations())) {
            return true;
        }
        String name = target.getName();
        ParameterList<?> parameters = target.getParameters();
        TypeDefinition declaringType = target.getDeclaringType();
        return this.recursiveMatches(declaringType, name, parameters);
    }

    private boolean recursiveMatches(TypeDefinition typeDefinition, String methodName, ParameterList<?> parameters) {
        TypeList.Generic interfaces = typeDefinition.getInterfaces();
        for (TypeDescription.Generic implInterface : interfaces) {
            if (this.recursiveMatches(implInterface, methodName, parameters)) {
                return true;
            }
            MethodList<MethodDescription.InGenericShape> declaredMethods = implInterface.getDeclaredMethods();
            for (MethodDescription methodDescription : declaredMethods) {
                if (!Objects.equals(methodDescription.getName(), methodName) || !this.parameterEquals(parameters, methodDescription.getParameters())) continue;
                return this.matcher.matches(methodDescription.getDeclaredAnnotations());
            }
        }
        return false;
    }

    private boolean parameterEquals(ParameterList<?> source, ParameterList<?> impl) {
        if (source.size() != impl.size()) {
            return false;
        }
        for (int i = 0; i < source.size(); ++i) {
            if (Objects.equals(((ParameterDescription)source.get(i)).getType(), ((ParameterDescription)impl.get(i)).getType())) continue;
            return false;
        }
        return true;
    }

    public static <T extends AnnotationSource> ElementMatcher.Junction<T> byMethodInheritanceAnnotationMatcher(ElementMatcher<? super TypeDescription> matcher) {
        return new MethodInheritanceAnnotationMatcher<T>(new CollectionItemMatcher(ElementMatchers.annotationType(matcher)));
    }

    public String toString() {
        return "MethodInheritanceAnnotationMatcher(" + this.matcher + ')';
    }
}

