/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.PluginDefine;
import org.apache.skywalking.apm.agent.core.plugin.PluginSelector;
import org.apache.skywalking.apm.agent.core.plugin.exception.IllegalPluginDefineException;

public enum PluginCfg {
    INSTANCE;

    private static final ILog LOGGER;
    private List<PluginDefine> pluginClassList = new ArrayList<PluginDefine>();
    private PluginSelector pluginSelector = new PluginSelector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load(InputStream input) throws IOException {
        try {
            String pluginDefine;
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            while ((pluginDefine = reader.readLine()) != null) {
                try {
                    if (pluginDefine.trim().length() == 0 || pluginDefine.startsWith("#")) continue;
                    PluginDefine plugin = PluginDefine.build(pluginDefine);
                    this.pluginClassList.add(plugin);
                }
                catch (IllegalPluginDefineException e) {
                    LOGGER.error(e, "Failed to format plugin({}) define.", pluginDefine);
                }
            }
        }
        finally {
            input.close();
        }
    }

    public List<PluginDefine> getPluginClassList() {
        this.pluginClassList = this.pluginSelector.select(this.pluginClassList);
        return this.pluginClassList;
    }

    static {
        LOGGER = LogManager.getLogger(PluginCfg.class);
    }
}

