/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.jvm;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.util.CollectionUtil;
import org.apache.skywalking.apm.dependencies.com.google.gson.Gson;
import org.apache.skywalking.apm.dependencies.com.google.gson.GsonBuilder;
import org.apache.skywalking.apm.network.common.v3.KeyStringValuePair;

public class LoadedLibraryCollector {
    private static final ILog LOGGER = LogManager.getLogger(LoadedLibraryCollector.class);
    private static final String JAR_SEPARATOR = "!";
    private static Set<ClassLoader> CURRENT_URL_CLASSLOADER_SET = new HashSet<ClassLoader>();
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private static int CURRENT_URL_CLASSLOADER_SET_MAX_SIZE = 50;

    public static void registerURLClassLoader(ClassLoader classLoader) {
        if (CURRENT_URL_CLASSLOADER_SET.size() < CURRENT_URL_CLASSLOADER_SET_MAX_SIZE && classLoader instanceof URLClassLoader) {
            CURRENT_URL_CLASSLOADER_SET.add(classLoader);
        }
    }

    public static List<KeyStringValuePair> buildJVMInfo() {
        ArrayList<KeyStringValuePair> jvmInfo = new ArrayList<KeyStringValuePair>();
        jvmInfo.add(KeyStringValuePair.newBuilder().setKey("Start Time").setValue(LoadedLibraryCollector.getVmStartTime()).build());
        jvmInfo.add(KeyStringValuePair.newBuilder().setKey("JVM Arguments").setValue(GSON.toJson(LoadedLibraryCollector.getVmArgs())).build());
        List<String> libJarNames = LoadedLibraryCollector.getLibJarNames();
        jvmInfo.add(KeyStringValuePair.newBuilder().setKey("Jar Dependencies").setValue(GSON.toJson(libJarNames)).build());
        return jvmInfo;
    }

    private static String getVmStartTime() {
        long startTime = ManagementFactory.getRuntimeMXBean().getStartTime();
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(startTime));
    }

    private static List<String> getVmArgs() {
        List<String> vmArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
        ArrayList<String> sortedVmArgs = new ArrayList<String>(vmArgs);
        Collections.sort(sortedVmArgs);
        return sortedVmArgs;
    }

    private static List<String> getLibJarNames() {
        List<URL> classLoaderUrls = LoadedLibraryCollector.loadClassLoaderUrls();
        return LoadedLibraryCollector.extractLibJarNamesFromURLs(classLoaderUrls);
    }

    private static List<URL> loadClassLoaderUrls() {
        ArrayList<URL> classLoaderUrls = new ArrayList<URL>();
        for (ClassLoader classLoader : CURRENT_URL_CLASSLOADER_SET) {
            try {
                URLClassLoader webappClassLoader = (URLClassLoader)classLoader;
                URL[] urls = webappClassLoader.getURLs();
                classLoaderUrls.addAll(Arrays.asList(urls));
            }
            catch (Exception e) {
                LOGGER.warn("Load classloader urls exception: {}", e.getMessage());
            }
        }
        return classLoaderUrls;
    }

    private static List<String> extractLibJarNamesFromURLs(List<URL> urls) {
        HashSet<String> libJarNames = new HashSet<String>();
        for (URL url : urls) {
            try {
                String libJarName = LoadedLibraryCollector.extractLibJarName(url);
                if (!libJarName.endsWith(".jar")) continue;
                libJarNames.add(libJarName);
            }
            catch (Exception e) {
                LOGGER.warn("Extracting library name exception: {}", e.getMessage());
            }
        }
        ArrayList<String> sortedLibJarNames = new ArrayList<String>(libJarNames.size());
        if (!CollectionUtil.isEmpty(libJarNames)) {
            sortedLibJarNames.addAll(libJarNames);
            Collections.sort(sortedLibJarNames);
        }
        return sortedLibJarNames;
    }

    private static String extractLibJarName(URL url) {
        String protocol = url.getProtocol();
        if (protocol.equals("file")) {
            return LoadedLibraryCollector.extractNameFromFile(url.toString());
        }
        if (protocol.equals("jar")) {
            return LoadedLibraryCollector.extractNameFromJar(url.toString());
        }
        return "";
    }

    private static String extractNameFromFile(String fileUri) {
        int lastIndexOfSeparator = fileUri.lastIndexOf(File.separator);
        if (lastIndexOfSeparator < 0) {
            return fileUri;
        }
        return fileUri.substring(lastIndexOfSeparator + 1);
    }

    private static String extractNameFromJar(String jarUri) {
        String uri = jarUri.substring(0, jarUri.lastIndexOf(JAR_SEPARATOR));
        return LoadedLibraryCollector.extractNameFromFile(uri);
    }
}

