/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context.util;

import java.util.Objects;
import org.apache.skywalking.apm.agent.core.context.tag.AbstractTag;
import org.apache.skywalking.apm.network.common.v3.KeyStringValuePair;

public class TagValuePair {
    private AbstractTag key;
    private String value;

    public TagValuePair(AbstractTag tag, String value) {
        this.key = tag;
        this.value = value;
    }

    public AbstractTag getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public KeyStringValuePair transform() {
        KeyStringValuePair.Builder keyValueBuilder = KeyStringValuePair.newBuilder();
        keyValueBuilder.setKey(this.key.key());
        if (this.value != null) {
            keyValueBuilder.setValue(this.value);
        }
        return keyValueBuilder.build();
    }

    public boolean sameWith(AbstractTag tag) {
        return this.key.isCanOverwrite() && this.key.getId() == tag.getId();
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TagValuePair)) {
            return false;
        }
        TagValuePair that = (TagValuePair)o;
        return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getValue(), that.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.getKey(), this.getValue());
    }
}

