/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.conf.dynamic.watcher;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.conf.dynamic.AgentConfigChangeWatcher;
import org.apache.skywalking.apm.agent.core.context.ContextManagerExtendService;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;

public class IgnoreSuffixPatternsWatcher
extends AgentConfigChangeWatcher {
    private static final ILog LOGGER = LogManager.getLogger(IgnoreSuffixPatternsWatcher.class);
    private final AtomicReference<String> ignoreSuffixPatterns = new AtomicReference<String>(this.getDefaultValue());
    private final ContextManagerExtendService contextManagerExtendService;

    public IgnoreSuffixPatternsWatcher(String propertyKey, ContextManagerExtendService contextManagerExtendService) {
        super(propertyKey);
        this.contextManagerExtendService = contextManagerExtendService;
    }

    private void activeSetting(String config) {
        if (LOGGER.isDebugEnable()) {
            LOGGER.debug("Updating using new static config: {}", config);
        }
        this.ignoreSuffixPatterns.set(config);
        this.contextManagerExtendService.handleIgnoreSuffixPatternsChanged();
    }

    @Override
    public void notify(AgentConfigChangeWatcher.ConfigChangeEvent value) {
        if (AgentConfigChangeWatcher.EventType.DELETE.equals((Object)value.getEventType())) {
            this.activeSetting(this.getDefaultValue());
        } else {
            this.activeSetting(value.getNewValue());
        }
    }

    @Override
    public String value() {
        return this.ignoreSuffixPatterns.get();
    }

    private String getDefaultValue() {
        return Config.Agent.IGNORE_SUFFIX;
    }

    public String getIgnoreSuffixPatterns() {
        return this.ignoreSuffixPatterns.get();
    }
}

