/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.kotlin.coroutine;

import kotlin.coroutines.AbstractCoroutineContextElement;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.ThreadContextElement;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.jetbrains.annotations.NotNull;

public class TracingCoroutineContext
extends AbstractCoroutineContextElement
implements ThreadContextElement<AbstractSpan> {
    private static final String COROUTINE_OPERATION = "Kotlin/Coroutine";
    private static final ILog LOG = LogManager.getLogger(TracingCoroutineContext.class);
    private final ContextSnapshot snapshot;

    public TracingCoroutineContext(ContextSnapshot snapshot) {
        super((CoroutineContext.Key)Key.INSTANCE);
        this.snapshot = snapshot;
    }

    public void restoreThreadContext(@NotNull CoroutineContext coroutineContext, AbstractSpan span) {
        if (ContextManager.isActive() && span != null) {
            ContextManager.stopSpan((AbstractSpan)span);
        }
    }

    public AbstractSpan updateThreadContext(@NotNull CoroutineContext coroutineContext) {
        if (this.snapshot != null) {
            if (ContextManager.isActive()) {
                if (!this.snapshot.isFromCurrent()) {
                    LOG.warn("Kotlin coroutine has been dispatched to a dirty thread which with active span: {}.", new Object[]{ContextManager.getGlobalTraceId()});
                }
                return null;
            }
            AbstractSpan span = ContextManager.createLocalSpan((String)COROUTINE_OPERATION);
            span.setComponent((Component)ComponentsDefine.KT_COROUTINE);
            ContextManager.continued((ContextSnapshot)this.snapshot);
            return span;
        }
        return null;
    }

    private static class Key
    implements CoroutineContext.Key<TracingCoroutineContext> {
        public static final Key INSTANCE = new Key();

        private Key() {
        }
    }
}

